// market.cpp
// Implementation of a stock market

#include <assert.h>
#include "market.h"


CStockMarket::CStockMarket() {
	nStocks=0;

	INFO_MSG(("StockMarket::Market is up\n"));	
}

CStockMarket::~CStockMarket() {
	for (int i=0;i <nStocks;i++)
		delete stocks[i];

	INFO_MSG(("StockMarket::Market is down\n"));	
}


int CStockMarket::addStock(const char *sName, int nMin, int nMax, int nInit,
													 tTrend &trend, tStability &stability) {
	INFO_MSG(("StockMarket::Adding a new stock (#%d) %s to market\n",++nStocks, sName));

	CStock *pStock = new CStock(sName,nMin,nMax,nInit);
	pStock->setTrend(trend);
	pStock->setStability(stability);

	return stocks.Add(pStock);	
}

void CStockMarket::nextDay() {
	INFO_MSG(("StockMarket::A new day in the market\n"));
	INFO_MSG(("StockMarket::-----------------------\n"));

	for (int i=0;i <nStocks;i++)
		stocks[i]->nextDay();
}

void CStockMarket::restart() {
	INFO_MSG(("StockMarket::Restarting the market\n"));
	for (int i=0;i <nStocks;i++)
		stocks[i]->restart();
}

int CStockMarket::getStockValue(int id) const {
	assert(id >=0 && id <=nStocks);

	if (id==0) return 0;
	else return stocks[id -1]->getValue();
}

int CStockMarket::getStockMin(int id) const {
	assert(id >=0 && id <=nStocks);

	if (id==0) return 0;
	else return stocks[id -1]->getMin();
}

int CStockMarket::getStockMax(int id) const {
	assert(id >=0 && id <=nStocks);

	if (id==0) return 0;
	else return stocks[id -1]->getMax();
}

char *CStockMarket::getStockName(int id) const {
	assert(id >=0 && id <=nStocks);

	if (id==0) return 0;
	else return stocks[id -1]->getName();
}

tMoney CStockMarket::commission(eMarketAction action, tMoney nAmount) {
	if (action==Buy)		// TBD: Define commision
		return float(0.1 +float(nAmount *0.01));				
		//return 0;
  else	
		return 0.;
}