// interface.h
// Interface classes of the model module

#ifndef _INTERFACE_H
#define _INTERFACE_H

#include <afx.h>
#include <stdio.h>
#include "common.h"


// This class implements the basic action given to the model. The action
// includes a stock code inwhich to invest, and the percentage of the
// total portfolio that should be invested.

class CAction : public CObject {
friend class CTuple;
public:
	DECLARE_SERIAL(CAction)
    
  CAction() : nStock(0), nPercentage(1.) {}
	CAction(tStock nStock, float nPercentage =1.) 
		{CAction::nStock=nStock; CAction::nPercentage=nPercentage;}
	CAction(CAction &a);

	// Operator Methods
	CAction &operator=(CAction &a); 	
	int operator==(CAction &a); 	
	int operator!=(CAction &a); 	

	// Serialization
	void Serialize(CArchive& archive);

	// Debug Methods
	void display(FILE *fOut);

	tStock nStock;
	float nPercentage;
};


// This class implements the 

class CState : public CObject {
friend class CTuple;
public:
	DECLARE_SERIAL(CState)
    
  CState() : nStock(0), nPercentage(1.), nValue(0.) {nStocksCount=0;}
	CState(tStock nStock, float nPercentage, tMoney nValue) 
		{CState::nStock=nStock; CState::nPercentage=nPercentage;
		 CState::nValue=nValue; nStocksCount=0;}
	CState(CState &s);

	// Operator Methods
	CState &operator=(CState &s); 	
	int operator==(CState &s); 	

	// Accessor Methods
	void setStockValue(int id, int nValue)
		{stocksValue[id -1]=nValue;
		 if (nStocksCount <id) nStocksCount=id;}
	
	// Serialization
	void Serialize(CArchive& archive);

	// Debug Methods
	void display(FILE *fOut);


	int stocksValue[MAX_STOCKS];
	tStock nStock;
	float nPercentage;
	tMoney nValue;

private:
	int nStocksCount;
};


// This class implements the 

class CTuple : public CObject {
public:
	DECLARE_SERIAL(CTuple)
    
	CTuple() {}		
	CTuple(CState &S, CAction &A) {	CTuple::S=S; CTuple::A=A;}
	CTuple(CTuple &t) {S=t.S; A=t.A;}

	// Operator Methods
	CTuple &operator=(CTuple &t); 		

	// Serialization
	void Serialize(CArchive& archive);

	// Hashing
	unsigned int hash();

	CState S;
	CAction A;	

private:
	int pack();

	char packedData[sizeof(CState) +sizeof(CAction)];
};




#endif 
