// intrerface.cpp
// Implementation of interface classes of the model module

#include "interface.h"

IMPLEMENT_SERIAL(CAction,CObject,1)
IMPLEMENT_SERIAL(CState,CObject,1)
IMPLEMENT_SERIAL(CTuple,CObject,1)


////////////////// CAction //////////////////

CAction::CAction(CAction &a) {	  
	nStock=a.nStock;
	nPercentage=a.nPercentage;	
}

CAction &CAction::operator=(CAction &a) {	
	nStock=a.nStock;
	nPercentage=a.nPercentage;	

	return *this;
}

int CAction::operator==(CAction &a) {
	return (nStock==a.nStock && nPercentage==a.nPercentage);	
}

int CAction::operator!=(CAction &a) {
	return (nStock!=a.nStock || nPercentage!=a.nPercentage);	
}


void CAction::Serialize(CArchive& archive) {
  // Call base class function first
	CObject::Serialize(archive);

  // Do the stuff for our specific class
  if(archive.IsStoring())
    archive << nStock << nPercentage;
  else
		archive >> nStock >> nPercentage;
}

void CAction::display(FILE *fOut) {
	if (!fOut) return;

	fprintf(fOut,"<");
	fprintf(fOut,"%d,%f",nStock,nPercentage);	
	fprintf(fOut,">");
}

////////////////// CState //////////////////

CState::CState(CState &s) {
	nStocksCount=s.nStocksCount;
	for (int i=0;i <nStocksCount;i++)
		stocksValue[i]=s.stocksValue[i];
  
	nStock=s.nStock;
	nPercentage=s.nPercentage;
	nValue=s.nValue;
}

CState &CState::operator=(CState &s) {	
	nStocksCount=s.nStocksCount;
	for (int i=0;i <nStocksCount;i++)
		stocksValue[i]=s.stocksValue[i];
  
	nStock=s.nStock;
	nPercentage=s.nPercentage;
	nValue=s.nValue;

	return *this;
}

int CState::operator==(CState &s) {
	if (nStocksCount!=s.nStocksCount) return 0;
	for (int i=0;i <nStocksCount;i++)
		if (stocksValue[i]!=s.stocksValue[i]) return 0;
  
	return (nStock==s.nStock && nPercentage==s.nPercentage && nValue==s.nValue);
}

void CState::Serialize(CArchive& archive) {
  // Call base class function first
	CObject::Serialize(archive);

  // Do the stuff for our specific class
  if(archive.IsStoring()) {
		archive << nStocksCount;
		for (int i=0;i <nStocksCount;i++)
      archive << stocksValue[i];

    archive << nStock << nPercentage << nValue;
	}
  else {
		archive >> nStocksCount;
		for (int i=0;i <nStocksCount;i++)
      archive >> stocksValue[i];

		archive >> nStock >> nPercentage >> nValue;
	}
}

void CState::display(FILE *fOut) {
	if (!fOut) return;

	fprintf(fOut,"<[");
	for (int i=0;i <nStocksCount -1;i++)
		fprintf(fOut,"%d,",stocksValue[i]);
	fprintf(fOut,"%d",stocksValue[nStocksCount -1]);    
	fprintf(fOut,"],%d,%f,%f",nStock,nPercentage,nValue);	
	fprintf(fOut,">");
}

////////////////// CTuple //////////////////

CTuple &CTuple::operator=(CTuple &t) {	
	S=t.S;
	A=t.A;	

	return *this;
}

void CTuple::Serialize(CArchive& archive) {
  // Call base class function first
	CObject::Serialize(archive);

  // Do the stuff for our specific class
  S.Serialize(archive);
	A.Serialize(archive);  
}

unsigned int CTuple::hash() {
	//We will handle the object as a packed string of characters	
	int nSize = pack(), nCount = 0;
	char *s = packedData;
	unsigned int r = 0;

	while (nCount <nSize) {
		r^=*s;
		r<<=1;
		s++; nCount++;
	}
	
	return r;
}

int CTuple::pack() {
	memset(packedData,'\0',sizeof(packedData));
	char *p = packedData;

	// Pack the state
	memcpy(p,&S.nStocksCount,sizeof(int));
  p+=sizeof(int);
	for (int i=0;i <S.nStocksCount;i++) {
		memcpy(p,&S.stocksValue[i],sizeof(int));
		p+=sizeof(int);
	}
	memcpy(p,&S.nStock,sizeof(tStock));
  p+=sizeof(tStock);
	memcpy(p,&S.nPercentage,sizeof(float));
  p+=sizeof(float);
	memcpy(p,&S.nValue,sizeof(tMoney));
  p+=sizeof(tMoney);

	// Pack the action    
	memcpy(p,&A.nStock,sizeof(tStock));
  p+=sizeof(tStock);
	memcpy(p,&A.nPercentage,sizeof(float));
  p+=sizeof(float);
	
	return p -packedData;
}

