// policy.h
// Interface of a policy table

#ifndef _POLICY_H
#define _POLICY_H

#include <stdio.h>
#include "common.h"
#include "interface.h"


// Definitions of helper function needed by the map data structure

void AFXAPI ConstructElements(CTuple* pElements, int nCount);
inline BOOL AFXAPI CompareElements(CTuple *pElement1, CTuple *pElement2);
void AFXAPI SerializeElements(CArchive &ar, CTuple *pElements, int nCount);
inline UINT AFXAPI HashKey(CTuple &key);


// This class implements

class CPolicy {
public:
	CPolicy(double nInit =0.);
	~CPolicy();

	void reset();

	// Table Access Methods
	void set(CState &S, CAction &A, double nValue) 
		{ tuplesValue.SetAt(CTuple(S,A),nValue); }		  
	double get(CState &S, CAction &A)
		{	double nValue;
			if (tuplesValue.Lookup(CTuple(S,A),nValue)==0) return nInitValue;		
			else return nValue; }

	void increaseVisits(CState &S, CAction &A)
		{ long nVisits = getVisits(S,A);
		  tuplesVisits.SetAt(CTuple(S,A),nVisits +1);	}
	long getVisits(CState &S, CAction &A)
		{	long nVisits;
			if (tuplesVisits.Lookup(CTuple(S,A),nVisits)==0) return 0;		
			else return nVisits; }	

	// Serialization Methods
	bool save(const char *sFileName);
	bool load(const char *sFileName);

	void display(FILE *fOut) const;
			
private:
	CMap<CTuple,CTuple &,double,double> tuplesValue;		
  CMap<CTuple,CTuple &,long,long> tuplesVisits;

	double nInitValue;
};

#endif 
