// policy.cpp
// Implementation of a policy table

#include "policy.h"


// Definitions of helper function needed by the map data structure
//////////////////////////////////////////////////////////////////

void AFXAPI ConstructElements(CTuple* pElements, int nCount) {
	for (int i=0;i <nCount;i++,pElements++)  
		// Call CTuple default constructor directly
    new (pElements)CTuple;
}

inline BOOL AFXAPI CompareElements(CTuple *pElement1, CTuple *pElement2) {
	return (pElement1->S==pElement2->S &&
		      pElement1->A==pElement2->A);
}

void AFXAPI SerializeElements(CArchive &ar, CTuple *pElements, int nCount) {
  for (int i=0;i <nCount;i++,pElements++)
		// Serialize each CTuple object
    pElements->Serialize(ar);
}

inline UINT AFXAPI HashKey(CTuple &key) {
	return key.hash();	
}


// Implementation of CPolicy
////////////////////////////

CPolicy::CPolicy(double nInit) : nInitValue(nInit) {
	tuplesValue.RemoveAll();
	tuplesVisits.RemoveAll();

	INFO_MSG(("Policy::Created a new policy with init value of %f\n",nInitValue));	
}

CPolicy::~CPolicy() {
	reset();

	INFO_MSG(("Policy::Deleted policy\n"));	
}


void CPolicy::reset() {
  tuplesValue.RemoveAll();
	tuplesVisits.RemoveAll();

	INFO_MSG(("Policy::Policy was reseted\n"));	
}


bool CPolicy::save(const char *sFileName) {
	CFile file;	
	if (!file.Open(sFileName,CFile::modeCreate | CFile::modeWrite)) return false;

	CArchive archive(&file,CArchive::store);
	
	tuplesValue.Serialize(archive);
	tuplesVisits.Serialize(archive);

	archive.Close();
	file.Close();

	INFO_MSG(("Policy::Policy was saved to file %s\n",sFileName));	
	return true;
}

bool CPolicy::load(const char *sFileName) {
	reset();

	CFile file;	
	if (!file.Open(sFileName,CFile::modeRead)) return false;

	CArchive archive(&file,CArchive::load);
	
	tuplesValue.Serialize(archive);
	tuplesVisits.Serialize(archive);

	archive.Close();
	file.Close();

	INFO_MSG(("Policy::Policy was loaded from file %s\n",sFileName));	
	return true;
}


void CPolicy::display(FILE *fOut) const {
	POSITION pos = tuplesValue.GetStartPosition();
	CTuple Q;
	double nValue;
	long nVisits;

	if (pos)
	  do {
	    tuplesValue.GetNextAssoc(pos,Q,nValue);
		  fprintf(fOut,"<");
			Q.S.display(fOut);
			fprintf(fOut,",");
			Q.A.display(fOut);
			fprintf(fOut,">, %f>",nValue);

			if (tuplesVisits.Lookup(Q,nVisits)==0)
				fprintf(fOut,"\t[0]\n");
			else fprintf(fOut,"\t[%ld]\n",nVisits);
		} while (pos!=NULL);
}
			
