// system.h
// system startup and all macros of global variables.

#ifndef _SYSTEM_H
#define _SYSTEM_H

#define MAX_NAME		256			


class CRandomGenerator;
class CModel;
class COptimizer;

class CSystem {
public:
	CSystem(const char *sSystemName) {init(sSystemName);}  
  ~CSystem() {shutdown();}

	bool isSystemUp() const {return bSystemUp;}

  CRandomGenerator	*pGlobalRandomGenerator;	
	CModel						*pGlobalModel;	
	COptimizer				*pGlobalOptimizer;	

	char sGlobalSystemName[MAX_NAME];  

private:
	void init(const char *sSystemName);
	void shutdown();

	// Initialization status
	bool bSystemUp;
};


extern CSystem *pSystem;


#define SYSTEM_GENERATOR (pSystem->pGlobalRandomGenerator)
#define SYSTEM_MODEL		 (pSystem->pGlobalModel)
#define SYSTEM_OPTIMIZER (pSystem->pGlobalOptimizer)

#define SYSTEM_NAME	 (pSystem->sGlobalSystemName)

#endif 
