// system.cpp

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "log.h"
#include "random.h"
#include "model.h"
#include "optimize.h"
#include "system.h"

CSystem* pSystem;


// Implementation of methods of CSystem
///////////////////////////////////////

void CSystem::init(const char *sSystemName) {
	bSystemUp=false;
	//LOG_INIT("log.txt");		  
	srand(time(0));

	pGlobalRandomGenerator  =0;
	pGlobalModel						=0;
	pGlobalOptimizer				=0;
	
  pSystem =this;			
  strncpy(sGlobalSystemName,sSystemName,MAX_NAME);       

  // Notice that it is important that the model will be created 
	// before the optimizer is created
	pGlobalRandomGenerator = new CRandomGenerator();	

	pGlobalModel					 = new CModel(sSystemName);	
	if (!pGlobalModel->isModelUp()) return;

	pGlobalOptimizer			 = new COptimizer();	
	
	bSystemUp=true;	
}


void CSystem::shutdown() {
	bSystemUp=false;

	delete pGlobalOptimizer;				pGlobalOptimizer=0;
	delete pGlobalModel;						pGlobalModel=0;
	delete pGlobalRandomGenerator;	pGlobalRandomGenerator=0;	
	
  pSystem=0; 
	LOG_CLOSE();		
}