// random.h
// Interface of a random number generator

#ifndef _RANDOM_H
#define _RANDOM_H

#define PI 3.141592654


// This class implements a random numbers generator. The generator is
// capable of generating random numbers drawn from either Uniform or Poisson 
// distributions. It is also capable to simulate a bernoulii trial.
// Most of the code for this class was adapted from the book "Numerical 
// Recipies in C: The Art of Scientific Computing", Cambridge University 
// Press)

class CRandomGenerator {
public:
	CRandomGenerator();
	~CRandomGenerator();

	double uniform()				{return flat(&nIdumUniform);}
	long poisson(float xm)	{return poisson(xm,&nIdumPossion);}	
	bool bernoulli(float s) {return bernoulli(s,&nIdumBernoulli);}

private:
	double gammln(double xx);
	double flat(int *idum);

	long poisson(float xm, int *idum);	
	bool bernoulli(float s, int *idum);

	int nIdumUniform, nIdumPossion, nIdumBernoulli;
};

#endif 
