// log.h

#ifndef _LOG_H
#define _LOG_H

#include <stdarg.h>
#include <stdio.h>

class CLog {
public:
	static void logInit_func(char *sLogName = 0);
	static void logClose_func();
	static void logMsg_func(const char *fmt, ...);

	static FILE *fLog;
};

#ifdef DEBUG
  #define DEBUG_MSG(x) CLog::logMsg_func x
#else 
  #define DEBUG_MSG(x)
#endif

#define INFO_MSG(x) CLog::logMsg_func x
#define ERROR_MSG(x) CLog::logMsg_func x
#define LOG_INIT(x) CLog::logInit_func(x)
#define LOG_CLOSE() CLog::logClose_func()

#endif
