************US SIC-4 INDUSTRY BY YEAR UNCERTAINTY MEASURES*****************
* This file runs some basic regression of output, sales, employment and investment on industry-by-year uncertainty measures.
* It is designed simply to show users what this data is and provide some basic descriptive correlations.

* The uncert_tfp and uncert_sales uncertainty data comes from the Census via "Really Uncertain Business Cycles", 2013, by  Nick Bloom, Max Floetotto, Nir Jaimovich, Itay Saporta-Eksten & Stephen Terry)
* The uncert_ret, uncert_tret and uncert_iret comes from CRSP, again via the "Really Uncetain Business Cycles" paper. These measure:
*	uncert_ret : the standard deviation of monthly firm stock returns within an industry year
*	uncert_tret: the average within-year standard deviation of monthly firm stock returns within each industry (the time component of uncert_ret)
*	uncert_iret: the standard-deviation of the average yearly return for each firm within an industry year (the cross-sectional component of uncert_ret)

* Notes: 
* 1) This uncertainty data is slightly different from the paper version for disclosure reasons (some of our Census samples were too small so we had to smooth).
* 2) BECAUSE OF THE CHANGE TO NAICS IN 1997 THE 1996 DATA IS TOO HIGH (THE SWITHC TO NAICS INTRODUCED AN UPWARD BIAS OF ABOUT 5%
* 3) The output data comes from the Becker, Gray Marvakov NBER industry data  http://www.nber.org/data/nberces5809.html 

* The data was produced by Itay Saporta-Eksten and Nick Bloom October 2013
* Any questions please contact: isaporta@stanford.edu or nbloom@stanford.edu  


********************************************************************************************************************************************************************************************************
***Below we just run some basic checks of the data to confirm at the industry level output and uncertainty are generally negatively correlated
********************************************************************************************************************************************************************************************************
set more off

***************************
*** Industry (SIC4) census uncertainty measures have a strong predictive power for hiring, output, investment and other industry by year factors
***************************

* Creating some basic measures
cap log using RUBC,replace t
u RUBC,replace
tsset sic year
gen rvship=vship/piship
gen rvadd=vadd/piship
gen drvship=2*(f1.rvship-rvship)/(f1.rvship+rvship)
gen drvadd=2*(f1.rvadd-rvadd)/(f1.rvadd+rvadd)
gen demp=2*(f1.emp-emp)/(f1.emp+emp)
gen i_k=f1.invest/(equip+plant)
gen linvest=log(invest)
qui tab year, gen(yy)

*Could easily use all these uncertainty measures in logs (rather than levels) and also clean on outliers (e.g. windorize at top and bottom 0.1%)
*We do not do this here, but here are these variables for experimentation (results look generally similar)
foreach var in uncert_tfp uncert_sales uncert_tret uncert_iret uncert_ret {
gen l`var'=log(`var')
egen pbottom`var'=pctile(`var'),p(0.1)
egen ptop`var'=pctile(`var'),p(99.9)
gen win_`var'=`var'*(`var'>pbottom`var')*(`var'<ptop`var'|`var'==.)+pbottom`var'*(`var'<=pbottom`var')+ptop`var'*(`var'>=ptop`var'&`var'~=.)
}

* Showing our SD of TFP innovations uncertainty measure is negatively correlated wtih employement (in a variety of specifications, simple to general)
reg demp uncert_tfp
reg demp uncert_tfp ,cluster(sic)
areg demp uncert_tfp,ab(sic) cluster(sic)
areg demp uncert_tfp yy*,ab(sic) cluster(sic)
areg demp uncert_tfp yy* [aw=indobs],ab(sic) cluster(sic)

* Showing our SD of TFP innovations uncertainty measure is negatively correlated with other measures like value-added and investment
areg drvship uncert_tfp yy* [aw=indobs],a(sic) cluster(sic) 
areg drvadd uncert_tfp yy* [aw=indobs],a(sic) cluster(sic) 
areg linvest uncert_tfp yy* [aw=indobs],a(sic) cluster(sic) 
areg i_k uncert_tfp yy* [aw=indobs],a(sic) cluster(sic) 

* Showing our SD of sales growth uncertainty measure is negatively correlated wtih employement (in a variety of specifications, simple to general)
reg demp uncert_sales
reg demp uncert_sales,cluster(sic)
areg demp uncert_sales,ab(sic) cluster(sic)
areg demp uncert_sales yy*,ab(sic) cluster(sic)
areg demp uncert_sales yy* [aw=indobs],ab(sic) cluster(sic)

* Showing our SD of sales growth uncertainty measure is negatively correlated with other measures like value-added and investment
areg drvship uncert_sales yy* [aw=indobs],a(sic) cluster(sic) 
areg drvadd uncert_sales yy* [aw=indobs],a(sic) cluster(sic) 
areg linvest uncert_sales yy* [aw=indobs],a(sic) cluster(sic) 
areg i_k uncert_sales yy* [aw=indobs],a(sic) cluster(sic) 

*****************
*Showing our CRSP stock-returns uncertainty measures are correlated with the Census uncertainty measures
*****************
pwcorr uncert*,sig

areg uncert_tfp uncert_ret yy* [aw=indobs],a(sic) cluster(sic) 
areg uncert_tfp uncert_tret yy* [aw=indobs],a(sic) cluster(sic) 
areg uncert_tfp uncert_iret yy* [aw=indobs],a(sic) cluster(sic) 

areg uncert_sales uncert_ret yy* [aw=indobs],a(sic) cluster(sic) 
areg uncert_sales uncert_tret yy* [aw=indobs],a(sic) cluster(sic) 
areg uncert_sales uncert_iret yy* [aw=indobs],a(sic) cluster(sic) 


*****************
*Showing the CRSP measure have a good fit for investment but not for the other variables 
*****************

* CRSP-total   - other measures
areg demp uncert_ret yy* ,a(sic) cluster(sic) 
areg drvship uncert_ret yy* ,a(sic) cluster(sic) 
areg drvadd uncert_ret yy* ,a(sic) cluster(sic) 
areg linvest uncert_ret yy* ,a(sic) cluster(sic) 
areg i_k uncert_ret yy* ,a(sic) cluster(sic) 

* CRSP-ind   - other measures
areg demp uncert_iret yy* ,a(sic) cluster(sic) 
areg drvship uncert_iret yy* ,a(sic) cluster(sic) 
areg drvadd uncert_iret yy* ,a(sic) cluster(sic) 
areg linvest uncert_iret yy* ,a(sic) cluster(sic) 
areg i_k uncert_iret yy* ,a(sic) cluster(sic) 

* CRSP-time   - other measures
areg demp uncert_tret yy* ,a(sic) cluster(sic) 
areg drvship uncert_tret yy* ,a(sic) cluster(sic) 
areg drvadd uncert_tret yy* ,a(sic) cluster(sic) 
areg linvest uncert_tret yy* ,a(sic) cluster(sic) 
areg i_k uncert_tret yy* ,a(sic) cluster(sic) 


cap log close

	

	
