clear all
set more off
set mem 2000m

*=============================================================
* Regressions with census data (Table 1 and Appendix Table 1)
*=============================================================
u data_table1_census, clear

*** The number of micro observations is the same for all columns with 25+ years plants
foreach y in 2 25 38 {
	foreach var of varlist sk_e_ltfp_`y'y kr_e_ltfp_`y'y iqr_e_ltfp_`y'y iqr_drtvs_`y'y {
		gen obs_`var'= obs_sd_e_ltfp_`y'y
	}
}
gen obs_iqr_e_ltfp_f_25y= obs_sd_e_ltfp_25y


*** We generate census year dummy
tsset year
gen census=(year==1972|year==1977|year==1982|year==1987|year==1992|year==1997|year==2002|year==2007)

cap postclose table1_census
postfile table1_census str32 lhs_var corr_gdp p_corr_gdp mean beta se   obs micro_obs using "table1_census", replace

*** Note: the formula for the p value of corr is from Stata reference manual [R] p.329 (since pwcorr has no return list)

*** Table 1, columns 1-5
foreach var in sd_e_ltfp_25 sk_e_ltfp_25 kr_e_ltfp_25 iqr_e_ltfp_25 iqr_drtvs_25 {
	reg `var' recession year census l1.census l2.census l3.census, rob
	local `var'_b = _b[recession]
	local `var'_se = _se[recession]
	local `var'_tstat = _b[recession]/_se[recession]
	local trend_b = _b[year]
	local trend_se = _se[year]
	local trend_tstat = _b[year]/_se[year]
	su obs_`var' 
	local obs = e(N)
	local obsm = r(mean) 
	reg `var'
	local `var'_mean = _b[_cons]
	corr `var' gdp_growth
	local corr_gdp = r(rho)
	local p_corr_gdp=2*ttail(r(N)-2,abs(r(rho))*sqrt(r(N)-2)/sqrt(1-r(rho)^2))
	post table1_census ("`var'_dt") (`corr_gdp') (`p_corr_gdp') (``var'_mean') (``var'_b') (``var'_se')  (`obs') (`obsm')
}

postclose table1_census

*** Appendix Table 1, all columns
cap postclose tableA1
postfile tableA1 str32 lhs_var corr_gdp p_corr_gdp mean beta se   obs micro_obs using "tableA1", replace

foreach var in sd_e_ltfp_2y sk_e_ltfp_2y kr_e_ltfp_2y iqr_e_ltfp_2y iqr_drtvs_2y /// 
			   sd_e_ltfp_38y sk_e_ltfp_38y kr_e_ltfp_38y iqr_e_ltfp_38y iqr_drtvs_38y {
	reg `var' recession year census l1.census l2.census l3.census, rob
	local `var'_b = _b[recession]
	local `var'_se = _se[recession]
	local `var'_tstat = _b[recession]/_se[recession]
	local trend_b = _b[year]
	local trend_se = _se[year]
	local trend_tstat = _b[year]/_se[year]
	su obs_`var' 
	local obs = e(N)
	local obsm = r(mean) 
	reg `var'
	local `var'_mean = _b[_cons]
	corr `var' gdp_growth
	local corr_gdp = r(rho)
	local p_corr_gdp=2*ttail(r(N)-2,abs(r(rho))*sqrt(r(N)-2)/sqrt(1-r(rho)^2))
	post tableA1 ("`var'_dt") (`corr_gdp') (`p_corr_gdp') (``var'_mean') (``var'_b') (``var'_se')  (`obs') (`obsm')
}

postclose tableA1

u tableA1, clear

ren lhs_var _varname
ren beta beta_recession
ren se se_recession

order _var beta_recession se_recession mean corr_gdp p_corr_gdp obs micro_obs
xpose, varname clear
order _var

outsheet using "tableA1.csv", replace comma

*==============================
* Regressions with CRSP data
*============================== 
/* 	Note: The data in data_table1_sales data_table1_ret and data_table1_ipg are already sampled and collapsed to the monthly or quarterly level. 
	CRSP and Compustat data are available through WRDS and IP data is available through the FRB website (see appendix for details.) the 
	programs are available upon request. 
   */ 
   
*** Table1, column 8
u data_table1_sales, clear

cap postclose table1_col6
postfile table1_col6 str32 lhs_var corr_gdp p_corr_gdp mean beta se   obs micro_obs using table1_col6, replace

tsset date
reg iqr_dfsaley recession date, rob
local iqr_dfsaley_b = _b[recession]
local iqr_dfsaley_se = _se[recession]
local iqr_dfsaley_tstat = _b[recession]/_se[recession]
local trend_b = _b[date]
local trend_se = _se[date]
local trend_tstat = _b[date]/_se[date]
reg iqr_dfsaley
local iqr_dfsaley_mean = _b[_cons]
su micro_obs
local obs = e(N)
local obsm = r(mean) 
corr iqr_dfsaley gdp_growth
local corr_gdp = r(rho) 
local p_corr_gdp=2*ttail(r(N)-2,abs(r(rho))*sqrt(r(N)-2)/sqrt(1-r(rho)^2))

post table1_col6 ("iqr_dfsaley") (`corr_gdp') (`p_corr_gdp') (`iqr_dfsaley_mean') (`iqr_dfsaley_b') (`iqr_dfsaley_se')  (`obs') (`obsm')
postclose table1_col6

*=================================
* Regressions with Compustat data
*=================================
*** Table1, column 7
u data_table1_ret, clear

tsset date
cap postclose table1_col7
postfile table1_col7 str32 lhs_var corr_gdp p_corr_gdp mean beta se   obs micro_obs using table1_col7, replace

reg iqr_ret recession date, rob
local iqr_ret_b = _b[recession]
local iqr_ret_se = _se[recession]
local iqr_ret_tstat = _b[recession]/_se[recession]
local trend_b = _b[date]
local trend_se = _se[date]
local trend_tstat = _b[date]/_se[date]
reg iqr_ret
local iqr_ret_mean = _b[_cons]
su micro_obs
local obs = e(N)
local obsm = r(mean) 
corr mq_iqr_ret gdp_growth if tag==1
local corr_gdp = r(rho) 
local p_corr_gdp=2*ttail(r(N)-2,abs(r(rho))*sqrt(r(N)-2)/sqrt(1-r(rho)^2))

post table1_col7 ("iqr_ret") (`corr_gdp') (`p_corr_gdp') (`iqr_ret_mean') (`iqr_ret_b') (`iqr_ret_se')  (`obs') (`obsm')
postclose table1_col7

*** Table1, column 7a 
u data_table1_ret, clear

tsset date
cap postclose table1_col7
postfile table1_col7 str32 lhs_var corr_gdp p_corr_gdp mean beta se   obs micro_obs using table1_col7a, replace

reg iqr_e_ret recession date, rob
local iqr_ret_b = _b[recession]
local iqr_ret_se = _se[recession]
local iqr_ret_tstat = _b[recession]/_se[recession]
local trend_b = _b[date]
local trend_se = _se[date]
local trend_tstat = _b[date]/_se[date]
reg iqr_ret
local iqr_ret_mean = _b[_cons]
su micro_obs
local obs = e(N)
local obsm = r(mean) 
corr mq_iqr_ret gdp_growth if tag==1
local corr_gdp = r(rho) 
local p_corr_gdp=2*ttail(r(N)-2,abs(r(rho))*sqrt(r(N)-2)/sqrt(1-r(rho)^2))

post table1_col7 ("iqr_ret") (`corr_gdp') (`p_corr_gdp') (`iqr_ret_mean') (`iqr_ret_b') (`iqr_ret_se')  (`obs') (`obsm')
postclose table1_col7


*=================================
* Regressions with FRB data
*=================================
*** Table1, column 9
u data_table1_ipg, clear

tsset date
cap postclose table1_col8
postfile table1_col8 str32 lhs_var corr_gdp p_corr_gdp mean beta se   obs micro_obs using table1_col8, replace

reg iqr_gip recession date, rob
local iqr_gip_b = _b[recession]
local iqr_gip_se = _se[recession]
local iqr_gip_tstat = _b[recession]/_se[recession]
local trend_b = _b[date]
local trend_se = _se[date]
local trend_tstat = _b[date]/_se[date]
reg iqr_gip
local iqr_gip_mean = _b[_cons]
su micro_obs
local obs = e(N)
local obsm = r(mean) 
corr mq_iqr_gip gdp_growth if tag==1
local corr_gdp = r(rho) 
local p_corr_gdp=2*ttail(r(N)-2,abs(r(rho))*sqrt(r(N)-2)/sqrt(1-r(rho)^2))

post table1_col8 ("iqr_gip") (`corr_gdp') (`p_corr_gdp') (`iqr_gip_mean') (`iqr_gip_b') (`iqr_gip_se')  (`obs') (`obsm')
postclose table1_col8


*===============================
* Generate one table for Table 1
*===============================
u table1_census, clear
append using table1_col6
append using table1_col7
append using table1_col8
ren lhs_var _varname
ren beta beta_recession
ren se se_recession

order _var beta_recession se_recession mean corr_gdp p_corr_gdp obs micro_obs
xpose, varname clear
order _var

outsheet using "table1.csv", replace comma

*================
* Generate FN 7
*================
u data_table1_census, clear
tsset year
cap log close
log using FN7, replace t
foreach var in sd_e_ltfp_25 sk_e_ltfp_25 kr_e_ltfp_25 {
	reg `var' recession, rob
}
log close

*================
* Generate FN 9 
*================
/* The following is running the regression for FN 9, in the order they show up in the FN 
   (Note that some of the reported numbers in the footnote are directly from Appendix Table 1) */
u data_table1_census, clear
tsset year
gen census=(year==1972|year==1977|year==1982|year==1987|year==1992|year==1997|year==2002|year==2007)

cap log close
log using FN9, replace t
foreach var of varlist  iqr_demp_25y iqr_e_ltfp_ibi_25y iqr_e_ltfp_sty_25y iqr_e_ltfp_f_25y {
	reg `var' recession year census l1.census l2.census l3.census, rob
}
log close


*=========================
* Generate Figures 3, 4 and Appendix F1
*=========================
u data_table1_census, clear

tsset year
gen census=(year==1972|year==1977|year==1982|year==1987|year==1992|year==1997|year==2002|year==2007)
gen f1_census=f1.census
replace f1_census=0 if year==2010 
/*
* Detrend and remove census spikes iqr_e_ltfp_25y
reg iqr_e_ltfp_25y year census
predict det_iqr_e_ltfp_25y , r
su iqr_e_ltfp_25y 
replace det_iqr_e_ltfp_25y =det_iqr_e_ltfp_25y +r(mean)
*/
* Detrend and remove census spikes - all iqr measures
foreach var in iqr_e_ltfp_25y iqr_e_ltfp_a iqr_e_ltfp_b iqr_e_ltfp_c {
	reg `var' year census
	predict det_`var', r
	su `var'
	replace det_`var'=det_`var'+r(mean)
}


* Detrend and remove census spikes (lead) rank_corr_ltfp_25y
reg  rank_corr_ltfp_25y year f1_census
predict detc_rank_corr_ltfp_25y , r
su  rank_corr_ltfp_25y 
replace detc_rank_corr_ltfp_25y =detc_`var' +r(mean)

*** This is smoothing the huge spike of 1996, which is generated by the big change from SIC to NAICS in 1997 (our measure are always t to t+1)
label var det_iqr_e_ltfp_25y "iqr(tfp shock)"
label var detc_rank_corr_ltfp_25y "TFP rank correlation"

* Creat Figure 3
gen low=0
#delimit;
twoway 	(rbar recession low year, color(ebg) c(l) yaxis(3) ysc(off ax(3)) barwidth(1))
		(scatter gdp_growth year if year>1971, c(l) ms(p) lwidth(medthick) lp(-) yaxis(2) ysc(alt ax(2)) color(black) ylabel(-4(2)8, axis(2)))
		(scatter det_iqr_e_ltfp_25y year if year!=1996 & year>1971, c(l) lwidth(medthick)  ms(p) yaxis(1) color(red)),
		legend(off) xtitle("") graphregion(color(white))  ytitle("") ytitle("",axis(2));
#delimit cr
drop low

graph export "figure3.png", as(png) width(1200) replace


* Creat Figure A1
gen low=0
#delimit;
twoway 	(rbar recession low year, color(ebg) c(l) yaxis(3) ysc(off ax(3)) barwidth(1))
		(scatter gdp_growth year if year>1971, c(l) ms(p) lwidth(medthick) lp(-) yaxis(2) ysc(alt ax(2)) color(black) ylabel(-4(2)8, axis(2)))
		(scatter detc_rank_corr_ltfp_25y year if year!=1996 & year>1971, c(l) lwidth(medthick)  ms(p) yaxis(1) color(red)),
		legend(off) xtitle("") graphregion(color(white))  ytitle("") ytitle("",axis(2));
#delimit cr
drop low

graph export "figureA1.png", as(png) width(1200) replace

* Creat Figure 4
label var det_iqr_e_ltfp_25y "Baseline"
label var det_iqr_e_ltfp_a "Add polynomials in TFP"
label var det_iqr_e_ltfp_b "Add investment"
label var det_iqr_e_ltfp_c "Add emp, sales and materials"

gen low=0
#delimit;
twoway 	(rbar recession low year, color(ebg) c(l) yaxis(2) ysc(alt off ax(2)) barwidth(1))
		(scatter det_* year if year!=1996 & year>1971, c(l l l l) lwidth(medthick medthick medthick medthick)  ms(p p p p) yaxis(1) ysc(alt) color(red blue green black) lp(solid - -. _)),
		xtitle("") graphregion(color(white))  ytitle("") 
		legend(order(2 3 4 5) position(10) ring(0));
#delimit cr
drop low

graph export "figure4.png", as(png) width(1200) replace


*** Cleaning temp files
foreach name in census col6 col7 col8 {
	erase table1_`name'.dta 
}
erase tableA1.dta
