#######
#read_RUBC_ge.R
#
#This R program processes the output from RUBC_ge.f90 and displays it.
#The impulse responses are computed using the simulation differencing 
#method of Koop, et al. (1996).
#
#"Really Uncertain Business Cycles"
#Nick Bloom, Max Floetotto, Nir Jaimovich, Itay Saporta-Eksten, Stephen J. Terry
#
#This Version: Oct 3, 2016
#######
rm(list=ls())
library(matlab)
library(foreign)
library(GA)

lwidnum=2
doIRF=1
doPOL = 0
doDIST = 1
doDenHaanIRF = 0
doClearAnalysis = 0

#read in constants
MATLABconstants = scan('MATLABconstants.txt')
znum = MATLABconstants[1]
knum = MATLABconstants[2]
lnum = MATLABconstants[3]
anum = MATLABconstants[4]
snum = MATLABconstants[5]
kbarnum = MATLABconstants[6]
numper = MATLABconstants[7]
numdiscard = MATLABconstants[8]
numendog = MATLABconstants[9]
numexog = MATLABconstants[10]
numfcst = MATLABconstants[11]
numstates = MATLABconstants[12]
deltak = MATLABconstants[13]
deltan = MATLABconstants[14]
numsimIRF = MATLABconstants[15]
lengthIRF = MATLABconstants[16]
shockperIRF = MATLABconstants[17]
numdiscIRF = MATLABconstants[18]
shocklengthIRF = MATLABconstants[19]
singleshock = MATLABconstants[20]

#determine samples
sample = (numdiscard + 1 ):(numper-1)
samplemin1 = (numdiscard):(numper-2)

#read in stuff
a0 = scan('a0.txt')
z0 = scan('z0.txt')
l0 = scan('l0.txt')
k0 = scan('k0.txt')
kbar0 = scan('kbar0.txt')
endog_key = read.table('endog_key.txt')
exog_key = read.table('exog_key.txt')
endog_pos = read.table('endog_pos.txt')
exog_pos = read.table('exog_pos.txt')


#process endog_key and exog_key


#read in unconditional simulation data
asimpos = scan('asimpos.txt'); 
ssimpos = scan('ssimpos.txt')
Ysim = scan('Ysim.txt')
Csim = scan('Csim.txt')
Ksim = scan('Ksim.txt')
Lsim = scan('Lsim.txt')
Hsim = scan('Hsim.txt')
Isim = scan('Isim.txt')
ACksim = scan('ACksim.txt')
AClsim = scan('AClsim.txt')
pfcstsim = scan('pfcstsim.txt')
Kfcstsim = scan('Kfcstsim.txt')
psim = scan('psim.txt')
piterstoresim = scan('piterstoresim.txt')
TOPksim = scan('TOPksim.txt')
TOPlsim = scan('TOPlsim.txt')
BOTksim = scan('BOTksim.txt')
BOTlsim = scan('BOTlsim.txt')
KDenHaanfcst= scan('KDenHaanfcst.txt')
pDenHaanfcst= scan('pDenHaanfcst.txt')

#restrict unconditional simulation arrays to plot sample
asimpos=asimpos[sample]
ssimpos=ssimpos[sample]
Ysim = Ysim[sample]
Csim = Csim[sample]
Kmin1sim = Ksim[samplemin1]
Ksim = Ksim[sample]
Lmin1sim = Lsim[samplemin1]
Lsim = Lsim[sample]
Hsim = Hsim[sample]
Isim = Isim[sample]
ACksim = ACksim[sample]
AClsim = AClsim[sample]
pfcstsim = pfcstsim[sample]
Kfcstsim = Kfcstsim[sample]
psim = psim[sample]
piterstoresim = piterstoresim[sample]
pDenHaanfcst = pDenHaanfcst[sample]
KDenHaanfcst = KDenHaanfcst[sample]

#define error series
perrorsim = abs(log(1/psim)-log(Csim))
pfcsterrorsim = abs(log(pfcstsim)-log(psim))
Kfcsterrorsim = abs(log(Kfcstsim)-log(Ksim))

cat('Mean % clearing error = ',100*mean(perrorsim),'.','\n')
cat('Max % clearing error = ',100*max(perrorsim),'.','\n')

#plot the unconditional simulation
pdf(file="PRICEITERS.pdf")
plot(sample,piterstoresim,type="l",xlab="Period",ylab="# Iters",
     main = "Price Iterations",lwd=lwidnum)
dev.off()

pdf(file="PCLEARINGERROR.pdf")
plot(sample,100*perrorsim,type="l",xlab="Period",ylab="% Clearing Error",
     main = "Price Clearing Error",lwd=lwidnum)
dev.off()
pdf(file="PFCSTERROR.pdf")
plot(sample,100*pfcsterrorsim,type="l",xlab="Period",ylab="% Fcst Error",
     main = "Price Fcst Error",lwd=lwidnum)
dev.off()
pdf(file="KFCSTERROR.pdf")
plot(sample,100*Kfcsterrorsim,type="l",xlab="Period",ylab="% Fcst Error",
     main = "Capital Fcst Error",lwd=lwidnum)
dev.off()

pdf(file="SIMSERIES.pdf")
par(mfrow=c(4,2))
plot(sample,log(a0[asimpos]),type="l",xlab="Period",main="Agg Prod",ylab="Log",lwd=lwidnum);
plot(sample,ssimpos,type="l",xlab="Period",main="Uncertainty",ylab="Log",lwd=lwidnum)
plot(sample,log(Ysim),type="l",xlab="Period",main="Output",ylab="Log",lwd=lwidnum)
plot(sample,log(Ksim),type="l",xlab="Period",main="Capital",ylab="Log",lwd=lwidnum)
plot(sample,log(Lsim),type="l",xlab="Period",main="Labor",ylab="Log",lwd=lwidnum)
plot(sample,log(psim),type="l",xlab="Period",main="Price",ylab="Log",lwd=lwidnum)
plot(sample,Isim/Ksim,type="l",xlab="Period",main="Investment",ylab="I/K",lwd=lwidnum)
plot(sample,Hsim/Lmin1sim,type="l",xlab="Period",main="Hiring",ylab="H/L_{-1}",lwd=lwidnum)
dev.off()


pdf(file="SIMBOUNDS.pdf")
par(mfrow=c(2,2))
plot(sample,TOPksim[sample],type="l",xlab='Period',main="Top of k",
     ylab="Weight at Bound", ylim=c(0,1),lwd=lwidnum)
plot(sample,BOTksim[sample],type="l",xlab='Period',main="Bottom of k",
     ylab="Weight at Bound", ylim=c(0,1),lwd=lwidnum)
plot(sample,TOPlsim[sample],type="l",xlab='Period',main="Top of l_{-1}",
     ylab="Weight at Bound",ylim=c(0,1),lwd=lwidnum)
plot(sample,BOTlsim[sample],type="l",xlab='Period',main="Bottom of l_{-1}",
     ylab="Weight at Bound",ylim=c(0,1),lwd=lwidnum)
dev.off()

#fcst vs actual prices
pdf(file="PFCSTANDSIM.pdf")
plot(sample,log(psim),type="l",xlab="Period",main="Price Fcsts",ylab="Log",col=1,lwd=lwidnum)
lines(sample,log(pfcstsim),col=2,lwd=lwidnum)
legend("bottomright",c("Actual","Forecast"),bty="n",lwd=lwidnum,col=c(1,2))
dev.off()

pdf(file="KFCSTANDSIM.pdf")
plot(sample,log(Ksim),type="l",xlab="Period",main="Capital Fcsts",ylab="Log",col=1,lwd=lwidnum)
lines(sample,log(Kfcstsim),col=2,lwd=lwidnum)
legend("bottomleft",c("Actual","Forecast"),bty="n",lwd=lwidnum,col=c(1,2))
dev.off()

#Den Haan fcst vs. Actual Series
pdf(file="PDENHAANFCSTANDSIM.pdf")
plot(sample,log(psim),type="l",xlab="Period",main="Price Fundamental Accuracy Plot",ylab="Log",col=1,lwd=lwidnum)
lines(sample,pDenHaanfcst,col=2,lwd=lwidnum)
legend("bottomright",c("Actual","Den Haan Fcst"),bty="n",lwd=lwidnum,col=c(1,2))
dev.off()

pdf(file="KDENHAANFCSTANDSIM.pdf")
plot(sample,log(Ksim),type="l",xlab="Period",main="Capital Fundamental Accuracy Plot",ylab="Log",col=1,lwd=lwidnum)
lines(sample,KDenHaanfcst,col=2,lwd=lwidnum)
legend("bottomleft",c("Actual","Den Haan Fcst"),bty="n",lwd=lwidnum,col=c(1,2))
dev.off()

#fcst rules plots for K and price
pdf(file="FCSTRULEREGS.pdf")
par(mfrow=c(5,2))
plotsamp = asimpos==1 & ssimpos==1
plot(log(Ksim[plotsamp]),log(psim[plotsamp]),main = "A = 1, S = 1",xlab = "Log K",ylab="Log P")
abline(lm(log(psim[plotsamp])~log(Ksim[plotsamp])),col=2)

plotsamp = asimpos==1 & ssimpos==2
plot(log(Ksim[plotsamp]),log(psim[plotsamp]),main = "A = 1, S = 2",xlab = "Log K",ylab="Log P")
abline(lm(log(psim[plotsamp])~log(Ksim[plotsamp])),col=2)

plotsamp = asimpos==2 & ssimpos==1
plot(log(Ksim[plotsamp]),log(psim[plotsamp]),main = "A = 2, S = 1",xlab = "Log K",ylab="Log P")
abline(lm(log(psim[plotsamp])~log(Ksim[plotsamp])),col=2)

plotsamp = asimpos==2 & ssimpos==2
plot(log(Ksim[plotsamp]),log(psim[plotsamp]),main = "A = 2, S = 2",xlab = "Log K",ylab="Log P")
abline(lm(log(psim[plotsamp])~log(Ksim[plotsamp])),col=2)

plotsamp = asimpos==3 & ssimpos==1
plot(log(Ksim[plotsamp]),log(psim[plotsamp]),main = "A = 3, S = 1",xlab = "Log K",ylab="Log P")
abline(lm(log(psim[plotsamp])~log(Ksim[plotsamp])),col=2)

plotsamp = asimpos==3 & ssimpos==2
plot(log(Ksim[plotsamp]),log(psim[plotsamp]),main = "A = 3, S = 2",xlab = "Log K",ylab="Log P")
abline(lm(log(psim[plotsamp])~log(Ksim[plotsamp])),col=2)

plotsamp = asimpos==4 & ssimpos==1
plot(log(Ksim[plotsamp]),log(psim[plotsamp]),main = "A = 4, S = 1",xlab = "Log K",ylab="Log P")
abline(lm(log(psim[plotsamp])~log(Ksim[plotsamp])),col=2)

plotsamp = asimpos==4 & ssimpos==2
plot(log(Ksim[plotsamp]),log(psim[plotsamp]),main = "A = 4, S = 2",xlab = "Log K",ylab="Log P")
abline(lm(log(psim[plotsamp])~log(Ksim[plotsamp])),col=2)

plotsamp = asimpos==5 & ssimpos==1
plot(log(Ksim[plotsamp]),log(psim[plotsamp]),main = "A = 5, S = 1",xlab = "Log K",ylab="Log P")
abline(lm(log(psim[plotsamp])~log(Ksim[plotsamp])),col=2)

plotsamp = asimpos==5 & ssimpos==2
plot(log(Ksim[plotsamp]),log(psim[plotsamp]),main = "A = 5, S = 2",xlab = "Log K",ylab="Log P")
abline(lm(log(psim[plotsamp])~log(Ksim[plotsamp])),col=2)
dev.off()

####POLICY GRAPHS AND SIMULATION
if (doPOL==1){

cat('processing values and policies','\n')  
  
#read in calues/policies
Vvec = scan('V.txt')  
polmatvec = scan('polmat.txt')

#initialize the storage
V=zeros(numendog,numexog,numfcst)
polmat=V
kprime_key = V
lpol_key = V

#read in the value function and policy array
ct = 0
for (endogct in 1:numendog){
for (exogct in 1:numexog){
for (fcstct in 1:numfcst){
  ct = ct+1
  if (mod(ct,50000)==1){cat('done with ',100*ct/(numendog*numexog*numfcst),'%.','\n')}
  V[endogct,exogct,fcstct] = Vvec[ct]
  polmat[endogct,exogct,fcstct]=polmatvec[ct]    
  polstar = polmatvec[ct]
  kprime_key[endogct,exogct,fcstct] = endog_key[polstar,1]
  lpol_key[endogct,exogct,fcstct] = endog_key[polstar,2]
}  
}
}

#at which point will you plot the policies?
act = 3
zct = 3
lmin1ct = floor(lnum/2)
kct = floor(knum/2)
fcstct = 5

#determine the high and low unc exog states
exogct = (zct-1)*anum*snum + (act-1)*snum + 1; #low unc
exogcthigh = exogct +1; #high unc

#extract endogenous indexes (labind holds capital fixed, vice-versa)
labind = endog_key[,1]==k0[kct]
capind = endog_key[,2]==l0[lmin1ct]

#convert x-axis to productivity/state
labaxis = log((a0[act]*z0[zct])/l0)
capaxis = log((a0[act]*z0[zct])/k0)

#low unc investment rate
ivec = kprime_key[capind,exogct,fcstct] - (1-deltak)*k0
ivec = 100*ivec/k0

#high unc investment rate
ivechigh = kprime_key[capind,exogcthigh,fcstct] - (1-deltak)*k0
ivechigh = 100*ivechigh/k0

#low unc hiring rate
hvec = lpol_key[labind,exogct,fcstct] - (1-deltan)*l0
hvec = 100*hvec/l0

#high unc hiring rate
hvechigh = lpol_key[labind,exogcthigh,fcstct] - (1-deltan)*l0
hvechigh = 100*hvechigh/l0

#create the plot of values and policies
pdf(file="VALPOLFUNS.PDF")
par(mfrow=c(2,2))
#labor first
plot(labaxis,hvec,type="l",col=1,lwd=lwidnum,main="Hiring Rate",ylab ="100 (h/l_{-1})",xlab="log(zA/l_{-1})")
lines(labaxis,hvechigh,col=2,lwd=lwidnum)
ymin = 0.99*min(c(log(V[labind,exogct,fcstct]),log(V[labind,exogcthigh,fcstct])))
ymax = 1.01*max(c(log(V[labind,exogct,fcstct]),log(V[labind,exogcthigh,fcstct])))
plot(labaxis,log(V[labind,exogct,fcstct]),type="l",col=1,lwd=lwidnum,main="Firm Value",
     ylim=c(ymin,ymax),xlab="log(zA/l_{-1})")
lines(labaxis,log(V[labind,exogcthigh,fcstct]),col=2,lwd=lwidnum)

#then capital
plot(capaxis,ivec,type="l",col=1,lwd=lwidnum,main="Investment Rate",ylab = "100 (i/k)",xlab="log(zA/k)")
lines(capaxis,ivechigh,col=2,lwd=lwidnum)
ymin = 0.99*min(c(log(V[capind,exogct,fcstct]),log(V[capind,exogcthigh,fcstct])))
ymax = 1.01*max(c(log(V[capind,exogct,fcstct]),log(V[capind,exogcthigh,fcstct])))
plot(capaxis,log(V[capind,exogct,fcstct]),type="l",col=1,lwd=lwidnum,main="Firm Value",
     ylim=c(ymin,ymax),ylab = "Log",xlab="log(zA/k)")
lines(capaxis,log(V[capind,exogcthigh,fcstct]),col=2,lwd=lwidnum)
dev.off()

} #doPOL

####Plot the unconditional distributions
if (doDIST==1){
cat('Reading in the simulation dist.')  
distzklvec = scan('distzkl.txt')
distzkl=zeros(znum,knum,lnum,numper)  

cat('Processing the simulation dist.')
totnum = znum*numendog*numper

ct=0
for (zct in 1:znum){
  for (endogct in 1:numendog){
    for (t in 1:numper){
      ct=ct+1
      if (mod(ct,500000)==1){cat('Done with ',100*ct/totnum,'%','\n')}
      kct = endog_pos[endogct,1]
      lmin1ct = endog_pos[endogct,2]
      distzkl[zct,kct,lmin1ct,t]=distzklvec[ct]
    }
  }
}

Ktop = zeros(numper,1)
Kbot = Ktop
Ltop = Ktop
Lbot = Ktop
for (t in (1:numper)){
  Kbot[t]=sum(sum(distzkl[,1,,1]))
  Ktop[t]=sum(sum(distzkl[,knum,,1]))
  Lbot[t]=sum(sum(distzkl[,,1,t]))
  Ltop[t]=sum(sum(distzkl[,,lnum,t]))
}

par(mfrow=c(2,2))
plot(sample,Ktop[sample],type="l",xlab='Period',main="Top of k",
     ylab="Weight at Bound", ylim=c(0,1),lwd=lwidnum)
plot(sample,Kbot[sample],type="l",xlab='Period',main="Bottom of k",
     ylab="Weight at Bound", ylim=c(0,1),lwd=lwidnum)
plot(sample,Ltop[sample],type="l",xlab='Period',main="Top of l_{-1}",
     ylab="Weight at Bound",ylim=c(0,1),lwd=lwidnum)
plot(sample,Lbot[sample],type="l",xlab='Period',main="Bottom of l_{-1}",
     ylab="Weight at Bound",ylim=c(0,1),lwd=lwidnum)

#extract first and last periods of the simulation
firstper = numdiscard+1;
lastper = numper-1;


#plot dist at first point
for (zct in 1:znum){
  zstr = as.character(round(z0[zct],digits=3))
  capaxis = -log(a0[asimpos[1]]*z0[zct]/k0)
  labaxis = -log(a0[asimpos[1]]*z0[zct]/l0)
  persp3D(capaxis,labaxis,distzkl[zct,,,firstper]/sum(sum(distzkl[zct,,,firstper])),color.palette=jet.colors,
          phi=40,theta=160,xlab="-log(Az/k)",ylab="-log(Az/l_{-1})",zlab = "Weight",main=paste("First Period, Idio Prod = ",zstr,sep=""))
}


sumdist =  zeros(knum,lnum)
for (kct in 1:knum){
  for (lmin1ct in 1:lnum){
    sumdist[kct,lmin1ct]=sum(distzkl[,kct,lmin1ct,firstper])
    
  }
}
pdf(file="FIRSTPERDIST.pdf")
persp3D(log(k0),log(l0),sumdist,phi=40,theta=40,xlab="log(k)",ylab="log(l_{-1})",zlab="Weight",
        main="First Period, Total Dist")
dev.off()

#plot dist at last point
for (zct in 1:znum){
  zstr = as.character(round(z0[zct],digits=3))
  capaxis = -log(a0[asimpos[length(asimpos)]]*z0[zct]/k0)
  labaxis = -log(a0[asimpos[length(asimpos)]]*z0[zct]/l0)
  persp3D(capaxis,labaxis,distzkl[zct,,,lastper]/sum(sum(distzkl[zct,,,lastper])),color.palette=jet.colors,
          phi=40,theta=160,xlab="-log(Az/k)",ylab="-log(Az/l_{-1})",zlab = "Weight",main=paste("Last Period, Idio Prod = ",zstr,sep=""))
}

sumdist =  zeros(knum,lnum)
for (kct in 1:knum){
  for (lmin1ct in 1:lnum){
    sumdist[kct,lmin1ct]=sum(distzkl[,kct,lmin1ct,lastper])
    
  }
}
pdf(file="LASTPERDIST.pdf")
persp3D(log(k0),log(l0),sumdist,phi=40,theta=40,xlab="log(k)",ylab="log(l_{-1})",zlab="Weight",
        main="Last Period, Total Dist")
dev.off()


if (doClearAnalysis==1){
clearerrorsim = log(1/psim)-log(Csim)

#badsamp = 335:345
badsamp = 1160:1170
#badsamp = 1805:1814
bad.frame = data.frame(cbind(badsamp,clearerrorsim[badsamp],asimpos[badsamp],ssimpos[badsamp],
      log(Ksim[badsamp]),KDenHaanfcst[badsamp]-log(Ksim[badsamp]),log(Kfcstsim[badsamp])-log(Ksim[badsamp]),
                             log(psim[badsamp]),pDenHaanfcst[badsamp]-log(psim[badsamp]),
                             log(pfcstsim[badsamp])-log(psim[badsamp])))
colnames(bad.frame)=c("t","clear error","A","S","log(K)","log(KDH)-log(K)","log(Kfcst)-log(K)","log(p)","log(pDH)-log(p)","log(pfcst)-log(p)")
bad.frame

for (t in badsamp[1]:badsamp[length(badsamp)]){

sumdist =  zeros(knum,lnum)
for (kct in 1:knum){
  for (lmin1ct in 1:lnum){
    sumdist[kct,lmin1ct]=sum(distzkl[,kct,lmin1ct,t])
    
  }
}

persp3D(log(k0),log(l0),sumdist,phi=70,theta=40,xlab="log(k)",ylab="log(l_{-1})",zlab="Weight",
        main=paste(paste("Period ",as.character(t))," , Total Dist"))
}


}

}

###IRF PROCESSING AND SIMULATION
if (doIRF==1){
  
#read in the IRF simulation data
asimposIRF = scan('asimposIRF.txt')
ssimposIRF = scan('ssimposIRF.txt')
YsimIRF = scan('YsimIRF.txt')
CsimIRF = scan('CsimIRF.txt')
KsimIRF = scan('KsimIRF.txt')
LsimIRF = scan('LsimIRF.txt')
HsimIRF = scan('HsimIRF.txt')
IsimIRF = scan('IsimIRF.txt')
ACksimIRF = scan('ACksimIRF.txt')
AClsimIRF = scan('AClsimIRF.txt')
pfcstsimIRF = scan('pfcstsimIRF.txt')
KfcstsimIRF = scan('KfcstsimIRF.txt')
psimIRF = scan('psimIRF.txt')
piterstoresimIRF = scan('piterstoresimIRF.txt')

#create the IRF storage arrays
amatIRF = array(0,dim=c(lengthIRF,numsimIRF,2))
smatIRF = amatIRF
YmatIRF = amatIRF
CmatIRF = amatIRF
KmatIRF = amatIRF
LmatIRF = amatIRF
HmatIRF = amatIRF
ImatIRF = amatIRF
ACkmatIRF = amatIRF
AClmatIRF = amatIRF
pfcstmatIRF = amatIRF
KfcstmatIRF = amatIRF
pmatIRF = amatIRF
piterstorematIRF = amatIRF

#read data into the storage arrays
ct=0
for (verct in (1:2)){
for (econct in 1:numsimIRF){
  for (t in 1:lengthIRF){
    ct=ct+1
    amatIRF[t,econct,verct] = a0[asimposIRF[ct]]
    smatIRF[t,econct,verct] = ssimposIRF[ct]
    YmatIRF[t,econct,verct] = YsimIRF[ct]
    CmatIRF[t,econct,verct] = 1/psimIRF[ct]
    KmatIRF[t,econct,verct] = KsimIRF[ct]
    LmatIRF[t,econct,verct] = LsimIRF[ct]
    ImatIRF[t,econct,verct] = IsimIRF[ct]
    HmatIRF[t,econct,verct] = HsimIRF[ct]
    ACkmatIRF[t,econct,verct] = ACksimIRF[ct]
    AClmatIRF[t,econct,verct] = AClsimIRF[ct]
    pfcstmatIRF[t,econct,verct] = pfcstsimIRF[ct]
    KfcstmatIRF[t,econct,verct] = KfcstsimIRF[ct]
    pmatIRF[t,econct,verct] = psimIRF[ct]
}
}
}


#create the IRFs
if (singleshock==1) {relper = shockperIRF-1}

Yirf = array(0,dim=c(lengthIRF))
sirf = Yirf
airf = Yirf
Cirf = Yirf
Kirf = Yirf
Lirf = Yirf
Iirf = Yirf
Hirf = Yirf
ACkirf= Yirf
AClirf = Yirf
pfcstirf = Yirf
Kfcstirf = Yirf
pirf = Yirf

for (t in 1:lengthIRF){
  sirf[t] = 100*(mean(smatIRF[t,,2])-mean(smatIRF[t,,1]))
  airf[t] = 100*(mean(log(amatIRF[t,,2]))-mean(log(amatIRF[t,,1])))
  Yirf[t] = 100*(mean(log(YmatIRF[t,,2]))-mean(log(YmatIRF[t,,1])))
  Cirf[t] = 100*(mean(log(CmatIRF[t,,2]))-mean(log(CmatIRF[t,,1])))
  Kirf[t] = 100*(mean(log(KmatIRF[t,,2]))-mean(log(KmatIRF[t,,1])))
  Lirf[t] = 100*(mean(log(LmatIRF[t,,2]))-mean(log(LmatIRF[t,,1])))
  Iirf[t] = 100*(log(mean(ImatIRF[t,,2]))-log(mean(ImatIRF[t,,1])))
  Hirf[t] = 100*(mean(log(HmatIRF[t,,2]))-mean(log(HmatIRF[t,,1])))
  ACkirf[t] = 100*(mean(log(ACkmatIRF[t,,2]))-mean(log(ACkmatIRF[t,,1])))
  AClirf[t] = 100*(mean(log(AClmatIRF[t,,2]))-mean(log(AClmatIRF[t,,1])))
  pfcstirf[t] = 100*(mean(log(pfcstmatIRF[t,,2]))-mean(log(pfcstmatIRF[t,,1])))
  Kfcstirf[t] = 100*(mean(log(KfcstmatIRF[t,,2]))-mean(log(KfcstmatIRF[t,,1])))
  pirf[t] = 100*(mean(log(pmatIRF[t,,2]))-mean(log(pmatIRF[t,,1])))

}

IRFsamp = (relper-2):(relper+10)

pdf(file="GE_IRF_SHORT.pdf")
par(mfrow = c(4,2))
plot(IRFsamp,Yirf[IRFsamp],type="l",main="Y IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Yirf[IRFsamp],pch=3)
plot(IRFsamp,Kirf[IRFsamp],type="l",main="K IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Kirf[IRFsamp],pch=3)
plot(IRFsamp,Lirf[IRFsamp],type="l",main="L IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Lirf[IRFsamp],pch=3)
plot(IRFsamp,Iirf[IRFsamp],type="l",main="I IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Iirf[IRFsamp],pch=3)
plot(IRFsamp,Hirf[IRFsamp],type="l",main="H IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Hirf[IRFsamp],pch=3)
plot(IRFsamp,pirf[IRFsamp],type="l",main="P IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,pirf[IRFsamp],pch=3)
plot(IRFsamp,Cirf[IRFsamp],type="l",main="C IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Cirf[IRFsamp],pch=3)
plot(IRFsamp,sirf[IRFsamp],type="l",main="S IRF",xlab = "Period",ylab = "",lwd=lwidnum)
points(IRFsamp,sirf[IRFsamp],pch=3)
dev.off()

IRFsamp = 30:(lengthIRF-1)

pdf(file="GE_IRF_LONG.pdf")
par(mfrow = c(4,2))
plot(IRFsamp,Yirf[IRFsamp],type="l",main="Y IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Yirf[IRFsamp],pch=3)
plot(IRFsamp,Kirf[IRFsamp],type="l",main="K IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Kirf[IRFsamp],pch=3)
plot(IRFsamp,Lirf[IRFsamp],type="l",main="L IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Lirf[IRFsamp],pch=3)
plot(IRFsamp,Iirf[IRFsamp],type="l",main="I IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Iirf[IRFsamp],pch=3)
plot(IRFsamp,Hirf[IRFsamp],type="l",main="H IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Hirf[IRFsamp],pch=3)
plot(IRFsamp,pirf[IRFsamp],type="l",main="P IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,pirf[IRFsamp],pch=3)
plot(IRFsamp,Cirf[IRFsamp],type="l",main="C IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Cirf[IRFsamp],pch=3)
plot(IRFsamp,sirf[IRFsamp],type="l",main="S IRF",xlab = "Period",ylab = "",lwd=lwidnum)
points(IRFsamp,sirf[IRFsamp],pch=3)
dev.off()

IRFframe = data.frame(cbind(IRFsamp,Yirf[IRFsamp],Kirf[IRFsamp],
                            Lirf[IRFsamp],Iirf[IRFsamp],Hirf[IRFsamp],pirf[IRFsamp],Cirf[IRFsamp],sirf[IRFsamp],pfcstirf[IRFsamp]))
colnames(IRFframe)=c("Period","Y","K","L","I","H","p","C","s","pfcst")

write.csv(IRFframe,file="IRF.csv",row.names=FALSE)

}

#the Den Haan fcst-rule implied IRF
if (doDenHaanIRF==1){

#read in the coefficients
pcoeffstorevec = read.table('pcoeffstore.txt')
kcoeffstorevec = read.table('kcoeffstore.txt')

maxGEit = 50

#find how long it took to converge
convergedct = which(pcoeffstorevec[,1]==0)[1]-1
convergedit = convergedct/(anum*snum)

pcoeff = zeros(anum,snum,2)
kcoeff = zeros(anum,snum,2)

ct = 0
GEct=convergedit
  for (act in 1:anum){
    for (sct in 1:snum){
      ct = (GEct-1)*anum*snum + (act-1)*snum + sct
      pcoeff[act,sct,1]=pcoeffstorevec[ct,1]
      pcoeff[act,sct,2]=pcoeffstorevec[ct,2]
      kcoeff[act,sct,1]=kcoeffstorevec[ct,1]
      kcoeff[act,sct,2]=kcoeffstorevec[ct,2]
    }
  }


stper = IRFsamp[1]-1
  
logpmatDHIRF=zeros(lengthIRF,numsimIRF)
logKmatDHIRF=logpmatDHIRF

logKmatDHIRF[stper,] = log(KmatIRF[stper,])

for (t in (stper+1):(lengthIRF-1)){
  for (econct in 1:numsimIRF){
   
    #last period a and s positions
    act = amatIRF[t-1,econct]
    sct = smatIRF[t-1,econct]
    
    #insert this period's capital forecast
    logKmatDHIRF[t,econct] = kcoeff[act,sct,1] + kcoeff[act,sct,2]*logKmatDHIRF[t-1,econct]
    
    #this period a and s positions
    act = amatIRF[t,econct]
    sct = smatIRF[t,econct]
    
    #insert p forecast
    logpmatDHIRF[t,econct] = pcoeff[act,sct,1] + pcoeff[act,sct,2]*logKmatDHIRF[t,econct]
    
    
  }
}

#now, average across econ

logKDHIRF=zeros(lengthIRF,1)
logpDHIRF=zeros(lengthIRF,1)

for (t in 1:lengthIRF){
logKDHIRF[t] = mean(logKmatDHIRF[t,])
logpDHIRF[t] = mean(logpmatDHIRF[t,])
}

logKDHIRF = 100*(logKDHIRF - logKDHIRF[relper])
logpDHIRF = 100*(logpDHIRF - logpDHIRF[relper])

IRFsamp = (relper-2):(relper+10)

plot(IRFsamp,Kirf[IRFsamp],type="l",lwd=lwidnum,col=1,main="Capital Den Haan Fcst IRF",
     xlab="Period",ylab="%",ylim=c(-1.5,0.5))
points(IRFsamp,Kirf[IRFsamp],pch=3,col=1)
lines(IRFsamp,logKDHIRF[IRFsamp],col=2,lwd=lwidnum)
points(IRFsamp,logKDHIRF[IRFsamp],pch=3,col=2)
legend("bottomright",c("Actual","DH Forecast"),bty="n",lwd=lwidnum,col=c(1,2))


plot(IRFsamp,pirf[IRFsamp],type="l",lwd=lwidnum,col=1,main="Price Den Haan Fcst IRF",
     xlab="Period",ylab="%",ylim=c(-1.5,1.5))
points(IRFsamp,pirf[IRFsamp],pch=3,col=1)
lines(IRFsamp,logpDHIRF[IRFsamp],col=2,lwd=lwidnum)
points(IRFsamp,logpDHIRF[IRFsamp],pch=3,col=2)
legend("bottomright",c("Actual","DH Forecast"),bty="n",lwd=lwidnum,col=c(1,2))


}



save(file="read_RUBC_ge.rda",list=ls())
