%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%read_Brock_Mirman.m
%
%This program processes the output from RUBC_Brock_Mirman.f90 and displays it.

%"Really Uncertain Business Cycles"
%Nick Bloom, Max Floetotto, Nir Jaimovich, Itay Saporta-Eksten, Stephen J. Terry
%
%This Version: Nov 23, 2014
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
close all; clear all; clc;

constants = importdata('constants.txt');
anum = constants(1);
knum = constants(2);
beta = constants(3);
deltak = constants(4);
alpha = constants(5);
numper = constants(6);
numsimIRF = constants(7);
lengthIRF = constants(8);
shockperIRF = constants(9);

kss  = alpha^(1/(1-alpha)) * ((1/beta)-(1-deltak))^(1/(alpha-1));

a0 = importdata('a0.txt');
k0 = importdata('k0.txt');
pr_mat_a = importdata('pr_mat_a.txt');
adist = importdata('adist.txt');
kdist = importdata('kdist.txt');

kprimevec = importdata('kprime.txt');
Vvec = importdata('V.txt');
distvec = importdata('dist.txt');

kprime = zeros(anum,knum);
V=kprime;
dist=kprime;

ct=0;
for act=1:anum;
    for kct=1:knum;
        ct=ct+1;
        kprime(act,kct) = kprimevec(ct);
        V(act,kct) = Vvec(ct);
        dist(act,kct) = distvec(ct);
    end;
end;

figure;
plot(k0,V');
title('V')

figure;
plot(k0,k0(kprime)'); hold on;
plot(k0,k0,'k')
title('Kprime')

figure;
plot(k0,dist');
title('Dist')

figure;
subplot(2,1,1);
plot(a0,adist); title('adist')
subplot(2,1,2);
plot(k0,kdist); title('kdist')

asimpos = importdata('asimpos.txt');
asim = importdata('asim.txt');
Ksimpos = importdata('Ksimpos.txt');
Ksim = importdata('Ksim.txt');
Csim = importdata('Csim.txt');
Ysim = importdata('Ysim.txt');
Isim = importdata('Isim.txt');

%now, read in IRF
asimposIRFvec = importdata('asimposIRF.txt');
KsimposIRFvec = importdata('KsimposIRF.txt');
asimIRFvec = importdata('asimIRF.txt');
KsimIRFvec = importdata('KsimIRF.txt');
IsimIRFvec = importdata('IsimIRF.txt');
YsimIRFvec = importdata('YsimIRF.txt');
CsimIRFvec = importdata('CsimIRF.txt');

asimIRF = zeros(numsimIRF,lengthIRF);
KsimIRF = asimIRF;
IsimIRF = asimIRF;
YsimIRF = asimIRF;
CsimIRF = asimIRF;

ct=0;
for simct=1:numsimIRF;
    for t=1:lengthIRF;
        ct=ct+1;
        asimIRF(simct,t) = asimIRFvec(ct);
        KsimIRF(simct,t) = KsimIRFvec(ct);
        IsimIRF(simct,t) = IsimIRFvec(ct);
        YsimIRF(simct,t) = YsimIRFvec(ct);
        CsimIRF(simct,t) = CsimIRFvec(ct);
    end;
end;

aIRF = log(mean(asimIRF,1))';
KIRF = log(mean(KsimIRF,1))';
IIRF = log(mean(IsimIRF,1))';
YIRF = log(mean(YsimIRF,1))';
CIRF = log(mean(CsimIRF,1))';
 
aIRF = 100*(aIRF-aIRF(shockperIRF-1));
KIRF = 100*(KIRF-KIRF(shockperIRF-1));
IIRF = 100*(IIRF-IIRF(shockperIRF-1));
YIRF = 100*(YIRF-YIRF(shockperIRF-1));
CIRF = 100*(CIRF-CIRF(shockperIRF-1));

IRFsamp = (shockperIRF-2):(shockperIRF+15);

lwidnum=1.5;
figure;
subplot(2,3,1);
plot(IRFsamp,aIRF(IRFsamp),'r',IRFsamp,0*IRFsamp,'k','LineWidth',lwidnum); title('A')
axis([IRFsamp(1) IRFsamp(end) -2.0 2.0])

subplot(2,3,2);
plot(IRFsamp,KIRF(IRFsamp),'r',IRFsamp,0*IRFsamp,'k','LineWidth',lwidnum); title('K')
axis([IRFsamp(1) IRFsamp(end) -11.0 2])

subplot(2,3,3);
plot(IRFsamp,YIRF(IRFsamp),'r',IRFsamp,0*IRFsamp,'k','LineWidth',lwidnum); title('Y')
axis([IRFsamp(1) IRFsamp(end) -6.0 2])

subplot(2,3,4);
plot(IRFsamp,CIRF(IRFsamp),'r',IRFsamp,0*IRFsamp,'k','LineWidth',lwidnum); title('C')
axis([IRFsamp(1) IRFsamp(end) -6.0 2])

subplot(2,3,5);
plot(IRFsamp,IIRF(IRFsamp),'r',IRFsamp,0*IRFsamp,'k','LineWidth',lwidnum); title('I')
axis([IRFsamp(1) IRFsamp(end) -2 4])
saveas(gcf,'IRFcapdestruct.pdf')

IRFdata = [aIRF YIRF KIRF IIRF CIRF];
csvwrite('IRF.csv',IRFdata);
