%%%%%%
%SE_compute.m
%
%This program computes the standard errors of the SMM point estimates
%based on the baseline GE model. It relies on a numerical Jacobian of the
%SMM objective computed ahead of time, as well as the estimated covariance
%matrix of the moments from the data computed ahead of time.
%
%"Really Uncertain Business Cycles"
%Nick Bloom, Max Floetotto, Nir Jaimovich, Itay Saporta-Eksten, Stephen J. Terry
%
%This Version: Dec 9, 2013
%%%%%%%
close all; clear all; clc;
diary SE_RESULTS.txt;

Amat = importdata('Amat.txt'); %approximated numerical jacobian of the objective
Amat = reshape(Amat,8,6);

SIGMA = importdata('SIGMA.txt'); %estimated covariance matrix of the moments

%SMM point estimates
thetahat = [ 1.6060678164419682; 
 			 4.1365844523734641; 
 			 0.94296716663676217;
 			 0.025857201385718384; 
 			 0.050752106584379765; 
 			 0.0066771142154949305];

%moments from the data
macrodatamom = [3.3559317 , 0.7556358 , 0.8259057 , 0.8787079];
microdatamom = [39.2774376, 4.8941042 , 1.1627580 , 0.7465530];

%parameters based on data lenght and governing SMM variance inflation
T = 38;
inflation = 1 + 38/1124;

%weighting matrix
momvec = [macrodatamom' ;microdatamom'];
momvec2 = momvec.^2;
W = diag(1./momvec2);

%construct asymptotic covariance matrix of the estimates based on standard SMM formulas
OUTmat = inv( Amat' * W * Amat );
OMEGA = OUTmat * Amat' * W * SIGMA * W * Amat * OUTmat;
OMEGA = inflation * OMEGA;

%compute standard errors based on the asymptotic covariance matrix
se = sqrt(diag(OMEGA)/T) ;

tstats = thetahat ./ se;
disp('Parameter Estimates (SE)')
[thetahat se]

diary off;