function MACROMOM(numper,numdiscard)
%%%%%%
%MACROMOM.m
%
%This program takes as direct inputs dimensions for the unconditional 
%simulation of the model, as well as indirect inputs consisting of
%the simulated aggregate TFP series from that model. The program returns
%the moments of the implied standard-deviations from estimates of a
%GARCH(1,1) model on dTFP of the simulated data, where returning is simply
%writing the output to "Sigmas.txt" and "MACROMOM.txt".
%
%"Really Uncertain Business Cycles"
%Nick Bloom, Max Floetotto, Nir Jaimovich, Itay Saporta-Eksten, Stephen J. Terry
%
%This Version: Nov 27, 2013
%%%%%%%

%clear previous files if they exist
delete MACROMOM.txt; delete Sigmas.txt;

%read in the aggregate TFP and BC data from the unconditional simulation
TFPsim = importdata('TFPsim.txt');

%discard burn-in periods and construct differences
TFP = TFPsim((numdiscard+1):(numper-1));
dTFP = TFP(2:end) - TFP(1:(end-1));
dTFP = 400*dTFP;

%set up the GARCH estimation and perform the estimation
spec=garchset('P',1,'Q',1);
[Coeff,Errors,LLF,Innovations,Sigmas,Summary]=garchfit(spec,dTFP);

%compute the macro moments
MACROMOM = zeros(4,1);
MACROMOM(1) = mean(Sigmas);
MACROMOM(2) = std(Sigmas);
MACROMOM(3) = skewness(Sigmas);
MACROMOM(4) = corr(Sigmas(2:end),Sigmas(1:(end-1)));

Sigmas_str = ['Sigmas.txt'];
MACROMOM_str = ['MACROMOM.txt'];

save(Sigmas_str,'Sigmas','-ascii');
save(MACROMOM_str,'MACROMOM','-ascii');

end