%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% moments_data.m
% Produces RUBC micro and macro uncertainty series from Fernald data
% and Census cleared data. The resulting series are fed into R code 
% to compute a bootstrapped covariance matrix and moment estimates.
%
%"Really Uncertain Business Cycles"
%Nick Bloom, Max Floetotto, Nir Jaimovich, Itay Saporta-Eksten, Stephen J. Terry
%
%This Version: Dec 28, 2013
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
close all; clear all; clc;

dTFPdata = xlsread('dTFP.xls');

%GARCH estimation
spec=garchset('P',1,'Q',1);
[Coeff,Errors,LLF,Innovations,Sigmas,Summary]=garchfit(spec,dTFPdata);

save('MACRODATA.txt','Sigmas','-ascii');

%read in micro data
IQR = xlsread('IQR.xls');
IQR = 100*IQR;

save('MICRODATA.txt','IQR','-ascii');