%%%%%%
%read_RUBC_pe.m
%
%This program reads simulation data and displays figures associated with the 
%simulation of the PE version of the RUBC model.
%
%"Really Uncertain Business Cycles"
%Nick Bloom, Max Floetotto,Nir Jaimovich, Itay Saporta-Eksten, Stephen J. Terry
%
%This Version: Sep 26, 2013
%%%%%%
close all; clear all; clc;

%parameters for the graphs - these are the only values set in this 
%program and not in the Fortran program
lwidnum = 1.5;
IRFpreper = 4;
IRFpostper = 12;

%read in constants
MATLABconstants = importdata('MATLABconstants.txt');
znum = MATLABconstants(1);
knum = MATLABconstants(2);
lnum = MATLABconstants(3);
anum = MATLABconstants(4);
snum = MATLABconstants(5);
numper = MATLABconstants(6);
numdiscard = MATLABconstants(7);
numendog = MATLABconstants(8);
numexog = MATLABconstants(9);
numstates = MATLABconstants(10);
deltak = MATLABconstants(11);
deltan = MATLABconstants(12);
numsimIRF = MATLABconstants(13);
lengthIRF = MATLABconstants(14);
shockperIRF = MATLABconstants(15);
numdiscIRF = MATLABconstants(16);

%sample for plotting unconditional simulation
sample = (numdiscard+1):(numper-1);

%read in some arrays
a0 = importdata('a0.txt');
z0 = importdata('z0.txt');
l0 = importdata('l0.txt');
k0 = importdata('k0.txt');
endog_key = importdata('endog_key.txt');
exog_key = importdata('exog_key.txt');

%read in some vectorized arrays
Vvec = importdata('V.txt');
polmatvec = importdata('polmat.txt');
kprime_keyvec = importdata('kprime_key.txt');
lpol_keyvec = importdata('lpol_key.txt');

%process vectorized arrays
strlist={'V','polmat','kprime_key','lpol_key'};
for strct=1:length(strlist);
    eval([strlist{strct} '= zeros(numendog,numexog);'])
    count=0;
    for endogct=1:numendog; for exogct=1:numexog;
        count=count+1;
        eval([strlist{strct} '(endogct,exogct) = ' strlist{strct} 'vec(count);']);
    end; end; 
end;

%read in unconditional simulated data
asimpos = importdata('asimpos.txt');
ssimpos = importdata('ssimpos.txt');
Ysim = importdata('Ysim.txt');
Ksim = importdata('Ksim.txt');
Lsim = importdata('Lsim.txt');
Isim = importdata('Isim.txt');
Hsim = importdata('Hsim.txt');
ACksim = importdata('ACksim.txt');
AClsim = importdata('AClsim.txt');
TOPksim = importdata('TOPksim.txt');
TOPlsim = importdata('TOPlsim.txt');
BOTksim = importdata('BOTksim.txt');
BOTlsim = importdata('BOTlsim.txt');
ADJksim = importdata('ADJksim.txt');
ADJlsim = importdata('ADJlsim.txt');

%read in the simulated data for the IRF
asimposIRF = importdata('asimposIRF.txt');
ssimposIRF = importdata('ssimposIRF.txt');
YsimIRF = importdata('YsimIRF.txt');
KsimIRF = importdata('KsimIRF.txt');
LsimIRF = importdata('LsimIRF.txt');
IsimIRF = importdata('IsimIRF.txt');
HsimIRF = importdata('HsimIRF.txt');
ACksimIRF = importdata('ACksimIRF.txt');
AClsimIRF = importdata('AClsimIRF.txt');
ADJksimIRF = importdata('ADJksimIRF.txt');
ADJlsimIRF = importdata('ADJlsimIRF.txt');

%%%%%plots of unconditional simulation

%main series
figure; 
subplot(3,2,1); hold on; 
plot(sample,a0(asimpos(sample)),'k','LineWidth',lwidnum); 
title('Sim A'); 
xlabel('Period');
ylabel('Grid Pt');
axis([sample(1) sample(end) 0.95 1.05])

subplot(3,2,2); hold on; 
plot(sample,ssimpos(sample),'k','LineWidth',lwidnum); 
title('Sim Unc'); 
xlabel('Period');
ylabel('Grid Pt');
axis([sample(1) sample(end) 0 snum+1])

subplot(3,2,3); hold on; 
plot(sample,log(Ysim(sample)),'k','LineWidth',lwidnum); 
title('Sim Y'); 
xlabel('Period');
ylabel('Log')
axis([sample(1) sample(end) -Inf Inf])

subplot(3,2,4); hold on; 
plot(sample,Isim(sample)./Ksim(sample),'k','LineWidth',lwidnum); 
title('I'); 
xlabel('Period');
ylabel('I/K')
axis([sample(1) sample(end) -Inf Inf])

subplot(3,2,5); hold on; 
plot(sample,Hsim(sample)./Lsim(sample),'k','LineWidth',lwidnum); 
title('H'); 
xlabel('Period');
ylabel('H/L')
axis([sample(1) sample(end) -Inf Inf])

subplot(3,2,6); hold on;
plot(sample,ADJksim(sample),'k',sample,ADJlsim(sample),'r','LineWidth',lwidnum); 
title('Adjustment')
ylabel('Fraction Adjusting')
xlabel('Period')
legend('Capital','Labor','Location','NorthEast')
legend boxoff
axis([sample(1) sample(end) 0.0 1.0])
saveas(gcf,'SimSeries.pdf')

%fraction at bounds series
figure; 
subplot(2,2,1); hold on;
plot(sample,TOPksim(sample),'k','LineWidth',lwidnum);
title('Top Capital')
ylabel('% Hitting Bound')
xlabel('Period')
axis([sample(1) sample(end) 0 1])

subplot(2,2,2); hold on;
plot(sample,BOTksim(sample),'k','LineWidth',lwidnum);
title('Bottom Capital')
ylabel('% Hitting Bound')
xlabel('Period')
axis([sample(1) sample(end) 0 1])

subplot(2,2,3); hold on;
plot(sample,TOPlsim(sample),'k','LineWidth',lwidnum);
title('Top Labor')
ylabel('% Hitting Bound')
xlabel('Period')
axis([sample(1) sample(end) 0 1])

subplot(2,2,4); hold on;
plot(sample,BOTlsim(sample),'k','LineWidth',lwidnum);
title('Bottom Labor')
ylabel('% Hitting Bound')
xlabel('Period')
axis([sample(1) sample(end) 0 1])
saveas(gcf,'SimBounds.pdf')

%compute and plot the IRFs

%reshaping the IRF data
strlist={'Y','K','L','I','H','ACk','ACl','ADJk','ADJl'};
for strct=1:length(strlist);
    eval([strlist{strct} 'simIRF = reshape(' strlist{strct} 'simIRF,lengthIRF,numsimIRF);'])
    eval([strlist{strct} 'simIRF = ' strlist{strct} 'simIRF(:,(numdiscIRF+1):numsimIRF);'])
end;

AsimIRF = reshape(a0(asimposIRF),lengthIRF,numsimIRF);
SsimIRF = reshape(ssimposIRF,lengthIRF,numsimIRF);

%computing the IRFs

relper = shockperIRF-1;

%output, capital, labor
Yirf = mean(YsimIRF,2); Yirf = 100*log(Yirf/Yirf(relper));
Kirf = mean(KsimIRF,2); Kirf = 100*log(Kirf/Kirf(relper));
Lirf = mean(LsimIRF,2); Lirf = 100*log(Lirf/Lirf(relper));
Airf = mean(AsimIRF,2); Airf = 100*log(Airf/Airf(relper));
Iirf = mean(IsimIRF,2); Iirf = 100*log(Iirf/Iirf(relper));
Hirf = mean(HsimIRF,2); Hirf = 100*log(Hirf/Hirf(relper));

%adjustment probabilities & unc
ADJkirf = mean(ADJksimIRF,2);
ADJlirf = mean(ADJlsimIRF,2);
Sirf = mean(SsimIRF,2); Sirf = Sirf - Sirf(relper);

%now, graph the IRF
IRFsample = (shockperIRF-IRFpreper):(shockperIRF+IRFpostper);
IRFaxis = IRFsample - (shockperIRF-1);

%Y,K,L,S
figure;

subplot(2,2,1); hold on;
plot(IRFsample,Yirf(IRFsample),'k-x','LineWidth',lwidnum)
axis([IRFsample(1) IRFsample(end) -7.5 7.5])
title('Output')
xlabel('Period')
ylabel('% Dev from Pre-Shock')

subplot(2,2,2); hold on;
plot(IRFsample,Kirf(IRFsample),'k-x','LineWidth',lwidnum)
axis([IRFsample(1) IRFsample(end) -7.5 7.5])
title('Capital')
xlabel('Period')
ylabel('% Dev from Pre-Shock')

subplot(2,2,3); hold on;
plot(IRFsample,Lirf(IRFsample),'k-x','LineWidth',lwidnum)
axis([IRFsample(1) IRFsample(end) -7.5 7.5])
title('Labor')
xlabel('Period')
ylabel('% Dev from Pre-Shock')

subplot(2,2,4); hold on;
plot(IRFsample,Sirf(IRFsample),'k-x','LineWidth',lwidnum)
axis([IRFsample(1) IRFsample(end) 0 3])
title('Uncertainty')
xlabel('Period')
ylabel('1 = Low, 2 = High')
saveas(gcf,'IRF1.pdf')

%I,H,ADJk,ADJl
figure;

subplot(2,2,1); hold on;
plot(IRFsample,Iirf(IRFsample),'k-x','LineWidth',lwidnum)
axis([IRFsample(1) IRFsample(end) -Inf Inf])
title('Investment Rate')
xlabel('Period')
ylabel('% Dev from Pre-Shock')

subplot(2,2,2); hold on;
plot(IRFsample,Hirf(IRFsample),'k-x','LineWidth',lwidnum)
axis([IRFsample(1) IRFsample(end) -Inf Inf])
title('Hiring Rate')
xlabel('Period')
ylabel('% Dev from Pre-Shock')

subplot(2,2,3); hold on;
plot(IRFsample,ADJkirf(IRFsample),'k-x','LineWidth',lwidnum)
axis([IRFsample(1) IRFsample(end) 0 0.25])
title('Capital Adjustment')
xlabel('Period')
ylabel('Fraction Investing')

subplot(2,2,4); hold on;
plot(IRFsample,ADJlirf(IRFsample),'k-x','LineWidth',lwidnum)
axis([IRFsample(1) IRFsample(end) 0 0.25])
title('Labor Adjustment')
xlabel('Period')
ylabel('Fraction Hiring')

saveas(gcf,'IRF2.pdf')

IRFsample = (30:(lengthIRF-1))';
IRFdata = [Yirf(IRFsample) Kirf(IRFsample) Lirf(IRFsample) Iirf(IRFsample) Hirf(IRFsample) 0*Hirf(IRFsample) 0*Hirf(IRFsample) Sirf(IRFsample) 0*Hirf(IRFsample)];

xlswrite('IRFdata.xls',IRFdata)