#######
#compile_script.sh
#
#This Bash script compiles the base library and the main code for the PE RUBC model.
#
#"Really Uncertain Business Cycles"
#Nick Bloom, Max Floetotto, Nir Jaimovich, Itay Saporta-Eksten, Stephen J. Terry
#
#This Version: Oct 1, 2013
#######

FCFLAGS="-O3 -fopenmp -m64"
PROJNAME=RUBC_pe
COMP=gfortran

echo "Removing old files."

rm base_lib.o ${PROJNAME}.o

echo "Compiling the base module."

${COMP} ${FCFLAGS} -c -o base_lib.o base_lib.f90

echo "Compiling the main program."

${COMP} ${FCFLAGS} -c -o ${PROJNAME}.o -I . ${PROJNAME}.f90

echo "Creating the executable."

${COMP} ${FCFLAGS} base_lib.o ${PROJNAME}.o -o ${PROJNAME}.exe