#######
#read_RUBC_ge.R
#
#This R program processes the output from RUBC_ge.f90 and displays it.

#"Really Uncertain Business Cycles"
#Nick Bloom, Max Floetotto, Nir Jaimovich, Itay Saporta-Eksten, Stephen J. Terry
#
#This Version: Dec 13, 2016
#######
rm(list=ls())
library(matlab)
library(foreign)
library(GA)

lwidnum=2
doIRF=1

#read in constants
MATLABconstants = scan('MATLABconstants.txt')
znum = MATLABconstants[1]
knum = MATLABconstants[2]
lnum = MATLABconstants[3]
anum = MATLABconstants[4]
snum = MATLABconstants[5]
kbarnum = MATLABconstants[6]
numper = MATLABconstants[7]
numdiscard = MATLABconstants[8]
numendog = MATLABconstants[9]
numexog = MATLABconstants[10]
numfcst = MATLABconstants[11]
numstates = MATLABconstants[12]
deltak = MATLABconstants[13]
deltan = MATLABconstants[14]
numsimIRF = MATLABconstants[15]
lengthIRF = MATLABconstants[16]
shockperIRF = MATLABconstants[17]
numdiscIRF = MATLABconstants[18]
shocklengthIRF = MATLABconstants[19]
singleshock = MATLABconstants[20]

#determine samples
sample = (numdiscard + 1 ):(numper-1)
samplemin1 = (numdiscard):(numper-2)

#read in stuff
a0 = scan('a0.txt')
z0 = scan('z0.txt')
l0 = scan('l0.txt')
k0 = scan('k0.txt')
kbar0 = scan('kbar0.txt')
endog_key = read.table('endog_key.txt')
exog_key = read.table('exog_key.txt')
endog_pos = read.table('endog_pos.txt')
exog_pos = read.table('exog_pos.txt')


#process endog_key and exog_key


#read in unconditional simulation data
asimpos = scan('asimpos.txt'); 
ssimpos = scan('ssimpos.txt')
Ysim = scan('Ysim.txt')
Csim = scan('Csim.txt')
Ksim = scan('Ksim.txt')
Lsim = scan('Lsim.txt')
Hsim = scan('Hsim.txt')
Isim = scan('Isim.txt')
ACksim = scan('ACksim.txt')
AClsim = scan('AClsim.txt')
pfcstsim = scan('pfcstsim.txt')
Kfcstsim = scan('Kfcstsim.txt')
psim = scan('psim.txt')
piterstoresim = scan('piterstoresim.txt')
TOPksim = scan('TOPksim.txt')
TOPlsim = scan('TOPlsim.txt')
BOTksim = scan('BOTksim.txt')
BOTlsim = scan('BOTlsim.txt')
KDenHaanfcst= scan('KDenHaanfcst.txt')
pDenHaanfcst= scan('pDenHaanfcst.txt')

#restrict unconditional simulation arrays to plot sample
asimpos=asimpos[sample]
ssimpos=ssimpos[sample]
Ysim = Ysim[sample]
Csim = Csim[sample]
Kmin1sim = Ksim[samplemin1]
Ksim = Ksim[sample]
Lmin1sim = Lsim[samplemin1]
Lsim = Lsim[sample]
Hsim = Hsim[sample]
Isim = Isim[sample]
ACksim = ACksim[sample]
AClsim = AClsim[sample]
pfcstsim = pfcstsim[sample]
Kfcstsim = Kfcstsim[sample]
psim = psim[sample]
piterstoresim = piterstoresim[sample]
pDenHaanfcst = pDenHaanfcst[sample]
KDenHaanfcst = KDenHaanfcst[sample]

#define error series
perrorsim = abs(log(1/psim)-log(Csim))
perrorsimraw = -log(1/psim)+log(Csim)
pfcsterrorsim = abs(log(pfcstsim)-log(psim))
Kfcsterrorsim = abs(log(Kfcstsim)-log(Ksim))

cat('Mean % clearing error = ',100*mean(perrorsim),'.','\n')
cat('Max % clearing error = ',100*max(perrorsim),'.','\n')

pdf(file="SIMSERIES.pdf")
par(mfrow=c(4,2))
plot(sample,log(a0[asimpos]),type="l",xlab="Period",main="Agg Prod",ylab="Log",lwd=lwidnum);
plot(sample,ssimpos,type="l",xlab="Period",main="Uncertainty",ylab="Log",lwd=lwidnum)
plot(sample,log(Ysim),type="l",xlab="Period",main="Output",ylab="Log",lwd=lwidnum)
plot(sample,log(Ksim),type="l",xlab="Period",main="Capital",ylab="Log",lwd=lwidnum)
plot(sample,log(Lsim),type="l",xlab="Period",main="Labor",ylab="Log",lwd=lwidnum)
plot(sample,log(psim),type="l",xlab="Period",main="Price",ylab="Log",lwd=lwidnum)
plot(sample,Isim/Ksim,type="l",xlab="Period",main="Investment",ylab="I/K",lwd=lwidnum)
plot(sample,Hsim/Lmin1sim,type="l",xlab="Period",main="Hiring",ylab="H/L_{-1}",lwd=lwidnum)
dev.off()

###IRF PROCESSING AND SIMULATION
if (doIRF==1){
  
#read in the IRF simulation data
asimposIRF = scan('asimposIRF.txt')
ssimposIRF = scan('ssimposIRF.txt')
YsimIRF = scan('YsimIRF.txt')
CsimIRF = scan('CsimIRF.txt')
KsimIRF = scan('KsimIRF.txt')
LsimIRF = scan('LsimIRF.txt')
HsimIRF = scan('HsimIRF.txt')
IsimIRF = scan('IsimIRF.txt')
ACksimIRF = scan('ACksimIRF.txt')
AClsimIRF = scan('AClsimIRF.txt')
pfcstsimIRF = scan('pfcstsimIRF.txt')
KfcstsimIRF = scan('KfcstsimIRF.txt')
psimIRF = scan('psimIRF.txt')
piterstoresimIRF = scan('piterstoresimIRF.txt')

#create the IRF storage arrays
amatIRF = array(0,dim=c(lengthIRF,numsimIRF))
smatIRF = amatIRF
YmatIRF = amatIRF
CmatIRF = amatIRF
KmatIRF = amatIRF
LmatIRF = amatIRF
HmatIRF = amatIRF
ImatIRF = amatIRF
ACkmatIRF = amatIRF
AClmatIRF = amatIRF
pfcstmatIRF = amatIRF
KfcstmatIRF = amatIRF
pmatIRF = amatIRF
piterstorematIRF = amatIRF

#read data into the storage arrays
ct=0
for (econct in 1:numsimIRF){
  for (t in 1:lengthIRF){
    ct=ct+1
    amatIRF[t,econct] = asimposIRF[ct]
    smatIRF[t,econct] = ssimposIRF[ct]
    YmatIRF[t,econct] = YsimIRF[ct]
    CmatIRF[t,econct] = 1/psimIRF[ct]
    KmatIRF[t,econct] = KsimIRF[ct]
    LmatIRF[t,econct] = LsimIRF[ct]
    ImatIRF[t,econct] = IsimIRF[ct]
    HmatIRF[t,econct] = HsimIRF[ct]
    ACkmatIRF[t,econct] = ACksimIRF[ct]
    AClmatIRF[t,econct] = AClsimIRF[ct]
    pfcstmatIRF[t,econct] = pfcstsimIRF[ct]
    KfcstmatIRF[t,econct] = KfcstsimIRF[ct]
    pmatIRF[t,econct] = psimIRF[ct]
  }
}


#create the IRFs
if (singleshock==0) {relper = shockperIRF+shocklengthIRF}

if (singleshock==1) {relper = shockperIRF-1}

Yirf = array(0,dim=c(lengthIRF))
sirf = Yirf
airf = Yirf
Cirf = Yirf
Kirf = Yirf
Lirf = Yirf
Iirf = Yirf
Hirf = Yirf
ACkirf= Yirf
AClirf = Yirf
pfcstirf = Yirf
Kfcstirf = Yirf
pirf = Yirf

for (t in 1:lengthIRF){
  sirf[t] = mean(smatIRF[t,])
  airf[t] = mean(amatIRF[t,])
  Yirf[t] = mean(YmatIRF[t,])
  Cirf[t] = mean(CmatIRF[t,])
  Kirf[t] = mean(KmatIRF[t,])
  
  Lirf[t] = mean(LmatIRF[t,])
  Iirf[t] = mean(ImatIRF[t,])
  Hirf[t] = mean(HmatIRF[t,])
  ACkirf[t] = mean(ACkmatIRF[t,])
  AClirf[t] = mean(AClmatIRF[t,])
  pfcstirf[t] = mean(pfcstmatIRF[t,])
  Kfcstirf[t] = mean(KfcstmatIRF[t,])
  pirf[t] = mean(pmatIRF[t,])

}
sirf = sirf-sirf[relper]
airf = 100*log(airf/airf[relper])
Yirf = 100*log(Yirf/Yirf[relper])
Cirf = 100*log(Cirf/Cirf[relper])
Kirf = 100*log(Kirf/Kirf[relper])
Lirf = 100*log(Lirf/Lirf[relper])
Iirf = 100*log(Iirf/Iirf[relper])
Hirf = 100*log(Hirf/Hirf[relper])
pirf = 100*log(pirf/pirf[relper])
pfcstirf = 100*log(pfcstirf/pfcstirf[relper])
Kfcstirf = 100*log(Kfcstirf/Kfcstirf[relper])

IRFsamp = (relper-2):(relper+10)

pdf(file="GE_IRF_SHORT.pdf")
par(mfrow = c(4,2))
plot(IRFsamp,Yirf[IRFsamp],type="l",main="Y IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Yirf[IRFsamp],pch=3)
plot(IRFsamp,Kirf[IRFsamp],type="l",main="K IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Kirf[IRFsamp],pch=3)
plot(IRFsamp,Lirf[IRFsamp],type="l",main="L IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Lirf[IRFsamp],pch=3)
plot(IRFsamp,Iirf[IRFsamp],type="l",main="I IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Iirf[IRFsamp],pch=3)
plot(IRFsamp,Hirf[IRFsamp],type="l",main="H IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Hirf[IRFsamp],pch=3)
plot(IRFsamp,pirf[IRFsamp],type="l",main="P IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,pirf[IRFsamp],pch=3)
plot(IRFsamp,Cirf[IRFsamp],type="l",main="C IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Cirf[IRFsamp],pch=3)
plot(IRFsamp,sirf[IRFsamp],type="l",main="S IRF",xlab = "Period",ylab = "",lwd=lwidnum)
points(IRFsamp,sirf[IRFsamp],pch=3)
dev.off()

IRFsamp = 30:(lengthIRF-1)

pdf(file="GE_IRF_LONG.pdf")
par(mfrow = c(4,2))
plot(IRFsamp,Yirf[IRFsamp],type="l",main="Y IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Yirf[IRFsamp],pch=3)
plot(IRFsamp,Kirf[IRFsamp],type="l",main="K IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Kirf[IRFsamp],pch=3)
plot(IRFsamp,Lirf[IRFsamp],type="l",main="L IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Lirf[IRFsamp],pch=3)
plot(IRFsamp,Iirf[IRFsamp],type="l",main="I IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Iirf[IRFsamp],pch=3)
plot(IRFsamp,Hirf[IRFsamp],type="l",main="H IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Hirf[IRFsamp],pch=3)
plot(IRFsamp,pirf[IRFsamp],type="l",main="P IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,pirf[IRFsamp],pch=3)
plot(IRFsamp,Cirf[IRFsamp],type="l",main="C IRF",xlab = "Period",ylab = "100 Log",lwd=lwidnum)
points(IRFsamp,Cirf[IRFsamp],pch=3)
plot(IRFsamp,sirf[IRFsamp],type="l",main="S IRF",xlab = "Period",ylab = "",lwd=lwidnum)
points(IRFsamp,sirf[IRFsamp],pch=3)
dev.off()

IRFframe = data.frame(cbind(IRFsamp,Yirf[IRFsamp],Kirf[IRFsamp],
                            Lirf[IRFsamp],Iirf[IRFsamp],Hirf[IRFsamp],pirf[IRFsamp],Cirf[IRFsamp],sirf[IRFsamp],pfcstirf[IRFsamp]))
colnames(IRFframe)=c("Period","Y","K","L","I","H","p","C","s","pfcst")

write.csv(IRFframe,file="IRF.csv",row.names=FALSE)

}

save(file="read_RUBC_ge.rda",list=ls())
