/* This file generates the tables which get reported in the Web Appendix.
   Note that this file cannot be run using simply the datasets provided for the replication of other parts of the paper.
   The raw data files for March and the monthly CPS need to be downloaded and the do files which clean and create  
   datasets need to be run first in order to run this file */


***************************
*** Web Appendix Tables ***
***************************
clear all
cd "$output"


*** Mobility reasons 2006
u year serial weight state migrate1 own empstat whymove using "$output\cps_data", clear

keep if empstat<30 & migrate1>0 & migrate1!=. 		/* 	We only work with the individuals in the labor force. 
													Migrate>0 is not binding. migrate!=. is missing for some years
													(last of them is 1995) */ 
* Distribution of moves by reason for move *
gen own = 1
replace own = 2 if   ownershp>10
egen MOVED = sum(weight) if migrate1>1, by(year own)
egen MOVED_REASON = sum(weight) if migrate1>1,by(year own  whymove)
egen MOVED_INTERCOUNTY = sum(weight) if migrate1>3, by(year own)
egen MOVED_REASON_INTERCOUNTY = sum(weight) if migrate1>3,by(year own  whymove)
egen MOVED_INTRACOUNTY = sum(weight) if migrate1==3, by(year own)
egen MOVED_REASON_INTRACOUNTY = sum(weight) if migrate1==3,by(year own  whymove)
egen MOVED_INTERSTATE = sum(weight) if migrate1>4, by(year own)
egen MOVED_REASON_INTERSTATE = sum(weight) if migrate1>4,by(year own  whymove)
gen sh_moved_reason = MOVED_REASON/MOVED
gen sh_moved_reason_intercounty = MOVED_REASON_INTERCOUNTY/MOVED_INTERCOUNTY
gen sh_moved_reason_intracounty = MOVED_REASON_INTRACOUNTY/MOVED_INTRACOUNTY
gen sh_moved_reason_interstate = MOVED_REASON_INTERSTATE/MOVED_INTERSTATE
tabout whymove own if year==2006 using "$results\whymove.csv", c(mean sh_moved_reason) style(csv) sum format(4) replace
tabout whymove own if year==2006 using "$results\whymove.csv", c(mean sh_moved_reason_intercounty) style(csv) sum format(4) append
tabout whymove own if year==2006 using "$results\whymove.csv", c(mean sh_moved_reason_intracounty) style(csv) sum format(4) append
tabout whymove own if year==2006 using "$results\whymove.csv", c(mean sh_moved_reason_interstate) style(csv) sum format(4) append

*** Mobility for job over time
u data_for_accounting.dta, clear
replace year=year-1
tsset year
gen P_M_OWN = M_OWN/l1.OWN				/* Note that need to devide by the population of owners at t-1, since moving is from t-1 to t */ 
gen P_MJ_given_M_OWN = M_OWN_J/M_OWN	/* Beta from before */ 
gen P_M_RENT = M_RENT/l1.RENT				/* Note that need to devide by the population of owners at t-1, since moving is from t-1 to t */ 
gen P_MJ_given_M_RENT = M_RENT_J/M_RENT
gen P_M_OWN_U = 2*P_M_OWN				/* Unemployment boost is 2 */ 
label var P_M_RENT "Moving Rate (t to t+1) - Renters"
label var P_M_OWN "Moving Rate (t to t+1) - Owners"
label var P_MJ_given_M_RENT "Job mobility out of mobility (t to t+1) - renters"
label var P_MJ_given_M_OWN "Job mobility out of mobility  (t to t+1) - owners"
label var P_M_OWN_U "Moving Rate (t to t+1) - Unemployed Owners"

keep if year>=2005
keep P_* year

order  year P_M_OWN P_M_OWN_U P_M_RENT P_MJ_given_M_OWN P_MJ_given_M_RENT

outsheet year P_M_OWN P_M_OWN_U P_M_RENT using "$results\annex_table_m.csv", replace comma			/* Table 1 */
outsheet year P_MJ_given_M_OWN P_MJ_given_M_RENT using "$results\annex_table_mj.csv", replace comma	/* Table 2 */ 

su P_MJ_given_M_OWN P_MJ_given_M_RENT



******************************************************************
* Unemployed mobility to total mobility for homeowners from PSID *
******************************************************************

u psid_variables, clear

tsset person year
gen l1_unemployed = l1.unemployed if year<=96
replace l1_unemployed = l2.unemployed if year>96
gen l1_own = l1.own if year<=96
replace l1_own = l2.own if year>96
gen l1_in_lf = l1.in_lf if year<=96
replace l1_in_lf = l2.in_lf if year>96

egen double moved_own_temp 	= sum(weight) if moved==1 & l1_own==1 & l1_in_lf==1, by(year)
egen double moved_rent_temp = sum(weight) if moved==1 & l1_own==0 & l1_in_lf==1, by(year)

egen double own_lf_temp 	= sum(weight) if moved!=. & l1_own==1 & l1_in_lf==1, by(year)
egen double rent_lf_temp 	= sum(weight) if moved!=. & l1_own==0 & l1_in_lf==1, by(year)

egen double moved_own_unemp_temp = sum(weight) if moved==1 & l1_own==1 & l1_unemployed==1, by(year)
egen double moved_rent_unemp_temp= sum(weight) if moved==1 & l1_own==0 & l1_unemployed==1, by(year)

egen double own_unemp_temp 		= sum(weight) if moved!=.& l1_own==1 & l1_unemployed==1, by(year)
egen double rent_unemp_temp 	= sum(weight) if moved!=.& l1_own==0 & l1_unemployed==1, by(year)

egen double moved_own_job_temp 		= sum(weight) if moved_job==1 & l1_own==1 & l1_in_lf==1, by(year)
egen double moved_own_prod_temp		= sum(weight) if moved_prod==1 & l1_own==1 & l1_in_lf==1, by(year)
egen double moved_own_unemp_job_temp 	= sum(weight) if moved_job==1 & l1_own==1 & l1_in_lf==1 & l1_unemployed==1, by(year)
egen double moved_own_unemp_prod_temp 	= sum(weight) if moved_prod==1 & l1_own==1 & l1_in_lf==1 & l1_unemployed==1, by(year)

foreach var in 	moved_own own_lf moved_own_job moved_own_unemp own_unemp moved_own_prod moved_own_unemp_job /// 
				moved_own_unemp_prod moved_rent rent_lf moved_rent_unemp rent_unemp {
	egen `var' = max(`var'_temp), by(year)
}

egen double moved_own_unemp_job_allyears 	= sum(weight) if moved_job==1 & l1_own==1 & l1_in_lf==1 & l1_unemployed==1
egen double moved_own_unemp_prod_allyears 	= sum(weight) if moved_prod==1 & l1_own==1 & l1_in_lf==1 & l1_unemployed==1
egen double moved_own_unemp_allyears	= sum(weight) if moved==1 & l1_own==1 & l1_unemployed==1

gen mob_rate_all = moved_own/own_lf
gen mob_rate_unemp = moved_own_unemp/own_unemp

gen mob_rate_all_rent = moved_rent/rent_lf
gen mob_rate_unemp_rent = moved_rent_unemp/rent_unemp

gen ratio_mob = mob_rate_unemp/mob_rate_all
gen ratio_mob_rent = mob_rate_unemp_rent/mob_rate_all_rent

gen ratio_mob_job = moved_own_job/moved_own
gen ratio_mob_prod = moved_own_prod/moved_own
gen ratio_mob_job_unemp = moved_own_unemp_job/moved_own_unemp
gen ratio_mob_prod_unemp = moved_own_unemp_prod/moved_own_unemp

gen ratio_mob_job_unemp_allyears = moved_own_unemp_job_allyears/moved_own_unemp_allyears
gen ratio_mob_prod_unemp_allyears = moved_own_unemp_prod_allyears/moved_own_unemp_allyears


*** The two numbers used in the paper: 


* First, the max of the ratio mob_rate_unemp/mob_rate_all over the last 20 years
*tab year if year>=90, su(ratio_mob)
tab year, su(ratio_mob)
tab year, su(ratio_mob_rent)
tabout year if year>1980 using "$results\mob_ratio_PSID.csv", c(mean ratio_mob mean ratio_mob_rent) style(csv) sum format(4) replace

cd "$do"


  
clear all
set mem 2500m
set more off
cd "$output"



*==========================================================================*
* Compare var(U_TOTAL) from regressions to GVF based estimates from BLS	   *
*==========================================================================*

u cps_panel_2007_2012_C if year==2007, clear

* Only keeping basic CPS *
drop if weight==.
drop *3

egen uuid = group(uid yyyymm)

gen byte unemp=(empst==3|empst==4)

* Allocating individual to a different group by state if MSA is not reported
gen msa = gtcbsa
gen state = gestcen 
replace msa = state if msa==0

*** Prepare the population matrix for the scaling of unemployment of homeowners
preserve
egen double sweight = sum(weight), missing by(yyyymm)
egen tag=tag(yyyymm)
keep if tag==1
sort yyyymm
mkmat sweight
restore

*** Keep only the relevant variables
keep uuid uid huid msa yyyymm weight unemp

levelsof yyyymm, local(yyyymm)
foreach val in `yyyymm' {
	gen byte ym`val'=yyyymm==`val'
}

egen geocluster=group(msa yyyymm)
egen clusterint=group(huid geocluster) /* Interacted Clusters */
save debug, replace



reg unemp ym* [pw=weight], noc cluster(huid)
matrix c1=e(V)
reg unemp ym* [pw=weight], noc cluster(geocluster)
matrix c2=e(V)
reg unemp ym* [pw=weight], noc cluster(clusterint)
matrix c12=e(V)
reg unemp ym* [pw=weight], noc
matrix c_diag=e(V)

matrix V=c1+c2-c12

*** Transform the matrix to a matrix in levels
matrix A = sweight
matrix AA = diag(A)

/*
* verification: Compare to M_OWN_J/monthly_avg_OWN in the accounting data files
matlist AA*e(b)'
*/

*** No Clustering ***
matrix U_big_cov_diag = AA*c_diag*AA
clear
svmat double U_big_cov_diag
save U_big_cov_diag, replace


*** HH across time only ***
matrix U_big_cov_hh = AA*c1*AA
clear
svmat double U_big_cov_hh
save U_big_cov_hh, replace

*** HH across time and MSA within ***
matrix U_big_cov_hh_msa = AA*V*AA
clear
svmat double U_big_cov_hh_msa
save U_big_cov_hh_msa, replace


**** Std Errors based on a,b parameters from BLS ***

use "$output\data_for_accounting_monthly", clear

keep if date>=tm(2007m3)&date<=tm(2007m12)
keep date monthly_U
/* These parameters are taken from Table 1-D, row entitled "Unemployed" for total, from the paper titled Employment and Earnings, February 2006 */
gen a = -0.0000164
gen b = 3095.55
gen double var_bls = a*monthly_U^2 + b*monthly_U

mkmat var_bls
matrix U_var_bls = diag(var_bls)
clear
svmat U_var_bls
save U_big_cov_bls, replace



** Comparing different estimates **

local rows_no = rowsof(U_big_cov_hh_msa)
matrix vec_var = J(`rows_no',4,0)
forvalues i = 1(1)`rows_no' {
	matrix vec_var[`i',1] = sqrt(U_big_cov_diag[`i',`i'])
	matrix vec_var[`i',2]= sqrt(U_big_cov_hh[`i',`i'])
	matrix vec_var[`i',3]= sqrt(U_big_cov_hh_msa[`i',`i'])
	matrix vec_var[`i',4]= sqrt(U_var_bls[`i',`i'])
}
matrix colnames vec_var  = NoClust HH HH_MSA BLS
clear
svmat vec_var, names(col)
gen hh_msa_bls =  HH_MSA/ BLS-1
su hh_msa_bls
gen hh_bls =  HH/ BLS-1
su hh_bls
gen diag_bls =   NoClust/ BLS-1
su diag_bls

