/* The first part of this do file can be run using only the datasets provided with the code.
   For the second part, raw microdata will have to be downloaded. See the accompanying readme file for more details  */ 

********************************************************
*** 1. Replicating the Results Reported in the paper ***
*** Only uses datasets provided with the code        ***
********************************************************

clear all

global results_name "results"						/* Name for the results folder. The code generates the folder */ 

global do "C:\Users\Siddharth\Documents\My Dropbox\Mobility\accounting exercise\RED_macro_submission\RNR2\RED_Replication"
global output "$do\output"
global results "$output\\$results_name"
global graphs "$output\\$results_name"

cap mkdir "$results"

cd "$do" 

adopath + "$do"


/* The following 2 do-files can be run using the datasets provided with this code. 
	The do files need to be placed in the directory which the global "do"  points to.
	The datasets provided need to be placed in a directory which the global "output" points to.
	*/

/* This file generates results reported in table 1 and 2 in the paper as well as all the other counterfactual results reported in the text. 
   It calls the auxilliary file accounting_HO */ 
do accounting_params

/* This file generates the figure in the paper, and also generates all the other statistics reported throughout the text */
do figures_and_misc





****************************************************************************************
*** 2. Generating the datasets which are provided along with the code from microdata ***
****************************************************************************************

/* In order to generate the datasets which have been provided with the code using raw microdata, the files below need to be run.
   Before doing this, the raw microdata will have to be downloaded. See the accompanying readme file for more details 
   */
   
global march_cps_data "Check readme for path assignment"
global cpsm "Check readme for path assignment"
global cpsdf "Check readme for path assignment"
global nber_march "Check readme for path assignment"
global repwt "Check readme for path assignment"
global psid "Check readme for path assignment"

cd "$do" 

adopath + "$do"

/* Prepares CPS */
do read_dataferret				/* Reads in the monthly data downloaded from dataferret and creates monthly stata datasets (cps_basic_`y'_`m'_df) as well as 1 large dataset (dataferret_2006_2012) with all the months */
do merge_nber_dataferret		/* Combines all the monthly NBER datasets into 1 dataset and also merges in the dataferret file to create 1 file called "cpsm_2006_2012.dta."  */
do cps_march_variables			/* Cleans the IPUMS dataset and saves it at a datset called "cps_data.dta" */
do cps_march_nber_read			/* Cleans the March supplement files from NBER and merges all the years to create 1 dataset called "cps_data_nber.dta" */
do cps_match_mobility			/* Matches contiguous months of the March CPS to generate a mobility variable based on non-matches. The dataset saved is called "cpsm_2006_2012_matched" */

/* Read PSID */ 
do read_psid
do psid_variables
do psid_mobility

/* Prepare file for Standard Errors */
do repweight_replications		/* Computes the March CPS variables used in the paper for all 160 replicate weights and stores results in different rep directories. */
do match_for_se_C				/* Generates a matched panel for the CPS and stores it as "cps_panel_2007_2012_C.dta" */
do clustered_regression			/* Generates the covariance matrix for the level of unemployed homeowners which is used in the Delta method */

/* Accounting Exercise */
do accounting_prepare_predictions		/* Prepares the predicted series of unemployment in recessions (regressions with trends) */ 
do accounting_March_prepare_data		/* Prepares the aggregated measures from the March CPS */ 
do accounting_March_prepare_5states   	/* Prepares the aggregated measures from the March CPS for the high LTV states */ 
do accounting_renter_reweight			/* Prepares a file with mobility for renters adjusted for demographics */ 
do accounting_monthly_prepare_data		/* Prepares the aggregated measures from the monthly CPS */ 
do accounting_matched_prepare_data		/* Prepares the aggregated measures from the matched monthly CPS */ 
do cov_mobility							/* Prepares covariance matrices for SE calculations */
do figures_and_misc_gen_data			/* Genrates data which gets used by the do file "figures_and_misc" */

do web_appendix_tables					/* Generates the tables in the web appendix */
