/* Bootstrap replication for Standard Errors using CPS REPWEIGTS */

/*  Note:
    ====
	This file calculates all the March supplements parts of the paper 160 times using
	the 160 REPWEIGHT variables provided by the CPS. 
	A seperate file (cov_mobility.do) then uses these 160 replications to calculate the variances of mobility measures which get used in the delta method.
 	The files that need to be run again for the replication standard errors:
	(1) accounting_March_prepare_data
	(2) accounting_March_prepare_data_Nevada
	(3) accounting_renter_reweight
	
	The rest of the files are monthly, or using mostly older data than 2005, so cannot use the REPWEIGHT.
	
*/

*===============================================
* Break the large repwt file to 160 small files
*===============================================
/* Need to run that only once. The advantage is that later reading the small files is much faster */ 

clear all
set mem 2g
set more off
cd "$output"


forvalues w=1/160 {
	u year serial pernum repwtp`w' using "$repwt\repwt", clear
	sort year serial pernum
	save "$repwt\repwt`w'", replace 
}


*================================================================================================================
* Generate the replicated data as input for the accounting exercise (about 7 minutes per rep on i7 with 8gb RAM)
*================================================================================================================

set more off
forvalues rep=1/160 {
	global output_true = "$output"
	global results_true = "$results"

	cd "$output_true"

	u cps_data if year>=2005, clear
	sort year serial pernum
	merge year serial pernum using "$repwt\repwt`rep'"
	drop _m

	replace weight=repwtp`rep'
	drop repwtp`rep'

	cap mkdir "$output\rep`rep'"
	save "$output\rep`rep'\cps_data", replace

	
	*** Note: Changing the definition of the output directory for the do files to work on the rep directory without changing them
	global output="$do\output\rep`rep'"
	global results="$do\output\rep`rep'\results"

	do "$do\accounting_March_prepare_data"
	do "$do\accounting_renter_reweight_se"
	erase "$output\data4reweight.dta"
	erase "$output\cps_data.dta"
	
	
	*** Note: Changing the definition of the output directory back
	global output="$output_true"
	global results="$results_true"
}

cd "$do"
