/* Read PSID and constructs the panel 

	Read PSID Individual file and transform to a panel 
	
	The data file generated is called psid_panel.dta. It has variables related to identifiers, ownerhip, moving, employment status. */

clear all
set mem 500m
cd "$output"
u "$psid\psid_data", clear

* Person Number
ren ER30002 person_number

* ID
local y=1968
foreach var in 	ER30001 ER30020 ER30043 ER30067 ER30091 ER30117 ER30138 ER30160 ER30188 ER30217 ///
				ER30246 ER30283 ER30313 ER30343 ER30373 ER30399 ER30429 ER30463 ER30498 ER30535 ///
				ER30570 ER30606 ER30642 ER30689 ER30733 ER30806 ER33101 ER33201 ER33301 ER33401 {	
	ren `var' id`y'
	local y=`y'+1
}

local y=1999
foreach var in 	ER33501 ER33601 ER33701 ER33801 ER33901 ER34001 {
		ren `var' id`y'
local y=`y'+2				
}

* Individual Weight
/* 	Note:
	(1) we are using longitudinal weights.
	(2) up to 1989 there is just single weight to choose from
	(3) for 1990-1993 we use the core weight, following the convention of dropping the Latino sample
	(4) for 1994-1996 we use the core weight again (there is no longer Latino sample for these years).
	(5) for 1997 on, we use the core/imm individual weights.
*/

local y=1968
foreach var in 	ER30019 ER30042 ER30066 ER30090 ER30116 ER30137 ER30159 ER30187 ER30216 ER30245 ///
				ER30282 ER30312 ER30342 ER30372 ER30398 ER30428 ER30462 ER30497 ER30534 ER30569 ///
				ER30605 ER30641 ER30686 ER30730 ER30803 ER30864 ER33119 ER33275 ER33318 ER33430 {	
	ren `var' weight`y'
	local y=`y'+1
}

local y=1999
foreach var in 	ER33546 ER33637 ER33740 ER33848 ER33950 ER34045 {
		ren `var' weight`y'
local y=`y'+2				
}

* Sequence number
local y=1969
foreach var in 		 	ER30021 ER30044 ER30068 ER30092 ER30118 ER30139 ER30161 ER30189 ER30218 ///
				ER30247 ER30284 ER30314 ER30344 ER30374 ER30400 ER30430 ER30464 ER30499 ER30536 ///
				ER30571 ER30607 ER30643 ER30690 ER30734 ER30807 ER33102 ER33202 ER33302 ER33402 {	
	ren `var' sequence`y'
	local y=`y'+1
}

local y=1999
foreach var in 	ER33502 ER33602 ER33702 ER33802 ER33902 ER34002 {
		ren `var' sequence`y'
local y=`y'+2				
}

* Relation to Head
local y=1968
foreach var in 	ER30003 ER30022 ER30045 ER30069 ER30093 ER30119 ER30140 ER30162 ER30190 ER30219 /// 
				ER30248 ER30285 ER30315 ER30345 ER30375 ER30401 ER30431 ER30465 ER30500 ER30537 ///
				ER30572 ER30608 ER30644 ER30691 ER30735 ER30808 ER33103 ER33203 ER33303 ER33403 {	
	ren `var' relation_head`y'
	local y=`y'+1
}

local y=1999
foreach var in 	ER33503 ER33603 ER33703 ER33803 ER33903 ER34003 {
		ren `var' relation_head`y'
local y=`y'+2				
}

* Home ownership
local y=1968
foreach var in 	V103 	V593 	V1264 	V1967 	V2566 	V3108 	V3522 	V3939 	V4450 	V5364 	/// 
				V5864 	V6479 	V7084 	V7675 	V8364 	V8974 	V10437 	V11618 	V13023 	V14126  ///
				V15140 	V16641 	V18072 	V19372 	V20672 	V22427 	ER2032 	ER5031 	ER7031 	ER10035 {	
	ren `var' own`y'
	local y=`y'+1
}

local y=1999
foreach var in 	ER13040 ER17043 ER21042 ER25028 ER36028 ER42029 {
		ren `var' own`y'
local y=`y'+2				
}

* Employment Status - This is in the individual file only from 1979. 
/* I THINK THAT WAS NOT COLLECTED FOR WIFE BEFORE 1979 (DIDN'T HAVE IT IN MY OLD FILES EITHER */

local y=1979
foreach var in 	ER30293 ER30323 ER30353 ER30382 ER30411 ER30441 ER30474 ER30509 ER30545 ER30580 ///
				ER30616 ER30653 ER30699 ER30744 ER30816 ER33111 ER33211 ER33311 ER33411 {	
	ren `var' empst`y'
	local y=`y'+1
}

local y=1999
foreach var in 	ER33512 ER33612 ER33712 ER33813 ER33913 ER34016 {
		ren `var' empst`y'
local y=`y'+2				
}

* Mobility - Did move?
local y=1969
foreach var in 	V603 	V1274 	V1979 	V2577 	V3110 	V3524 	V3941 	V4452 	V5366 	V5866 		///
				V6484  	V7089 	V7700 	V8369 	V8999 	V10447 	V11628 	V13037 	V14140 	V15148 	 	///
				V16649 	V18087 	V19387 	V20687 	V22441 	ER2062 	ER5061 	ER7155 	ER10072 {	
	ren `var' moved`y'
	local y=`y'+1
}

local y=1999
foreach var in 	ER13077 ER17088 ER21117 ER25098 ER36103 ER42132 {
		ren `var' moved`y'
local y=`y'+2				
}

* Mobility - Why moved? single mention
local y=1969
foreach var in 	V604 	V1275 	V1980 	V2578 	V3111 	V3525 	V3943 	V4454 	V5368 	V5868 	///
				V6486	V7091 	V7702 	V8370 	V9001 	V10449 	V11630 	V13039 	V14142 	V15150 	///
				V16651 	V18089	V19389 	V20689 	V22444 {	
	ren `var' whymoved`y'
	local y=`y'+1
}

* Mobility - Why moved? multiple mentions: 1
local y=1994
foreach var in 	ER2065 	ER5064 	ER7158 ER10075 {	
	ren `var' whymoved_1st`y'
	local y=`y'+1
}

local y=1999
foreach var in 	ER13080 ER17091 ER21120 ER25101 ER36106 ER42135 {
		ren `var' whymoved_1st`y'
local y=`y'+2				
}

* Mobility - Why moved? multiple mentions: 2
local y=1994
foreach var in 	ER2066 	ER5065 	ER7159 ER10076 {	
	ren `var' whymoved_2nd`y'
	local y=`y'+1
}

local y=1999
foreach var in 	ER13081 ER17092  {
		ren `var' whymoved_2nd`y'
local y=`y'+2				
}

* Mobility - Why moved? multiple mentions: 3
local y=1994
foreach var in 	ER2067 	ER5066 	ER7160 ER10077 {	
	ren `var' whymoved_3rd`y'
	local y=`y'+1
}

local y=1999
foreach var in 	ER13082 ER17093  {
		ren `var' whymoved_3rd`y'
local y=`y'+2				
}

* Mobility - Why moved? multiple mentions: 4
local y=1997
foreach var in 	ER10078 ER13083 ER17094  {
		ren `var' whymoved_4th`y'
local y=`y'+2				
}

drop V* ER*

gen double person = 1000*id1968 + person_number
reshape long id weight relation_head empst own moved whymoved whymoved_1st whymoved_2nd whymoved_3rd whymoved_4th sequence, i(person) j(year)

keep if weight>0

save psid_panel, replace
	
cd "$do"
