/* This file reads the homeownership variable form DataFarret CPS Monthly Data. 
   It also keeps the variables which are required for matching that to NBER files as the NBER files had ownership status missing for some years.
   
   The minimum variables needed from dataferret are hryear4, hrmonth, hrhhid, hrhhid2, occurnum, hetenure.
   
	The main datafile created is called dataferret_2006_2012.dta
	It has all the observation for all months starting January 2006  and ending
	March 2012.
   
   */

clear all
set more off
set memory 2g
cd "$output"

*** Labels
#delimit;
label define FM4X
-2  "Not in universe"
-1  "Not in Universe"
1  "Owned Or Being Bought By A Hh Member"
2  "Rented for cash"
3  "Occupied without payment of cash rent"
,replace;

label define FM7X
1  "January"
2  "February"
3  "March"
4  "April"
5  "May"
6  "June"
7  "July"
8  "August"
9  "September"
10  "October"
11  "November"
12  "December"
,replace;

#delimit cr

forvalues i=1/75 {
	insheet using "$cpsdf/cps_basic (`i').asc", clear
	local y = hryear4-2000
	local m = hrmonth
	sort hrhhid hrhhid2 occurnum 	/* The sorting as these files will be used fot match_rate_based_mobility */

	label variable hrhhid ""
	label variable hrhhid2 ""
	label variable occurnum " "
	label variable yyyymm " "
	label variable hetenure "household-own/rent living quarters"
	label variable hryear4 "household-4 digit year of interview"
	label variable hrmonth "household-month of interview"
	label values hetenure FM4X
	label values hrmonth FM7X
	
	drop yyyymm
	order hryear4 hrmonth

	foreach var of  varlist hetenure {
		ren `var' df_`var'
	}
	
	save cps_basic_`y'_`m'_df, replace
}

u cps_basic_6_1_df, clear
forvalues m=2/12 {
	append using "cps_basic_6_`m'_df"
}

forvalues y=7/11 {
	forvalues m=1/12 {
		append using "cps_basic_`y'_`m'_df"
	}
}

forvalues m=1/3 {
	append using "cps_basic_12_`m'_df"
}


*** Prepare for merge

sort hryear4 hrmonth hrhhid hrhhid2 occurnum  
save dataferret_2006_2012, replace

cd "$do"

