/* This file generates and recodes the variables that we need from the PSID

	The datafile generated is called psid_variables.dta */ 

clear all
set mem 500m
cd "$output"

u psid_panel, clear

*** Home ownership
ren own own_o
gen 	own = 1 if own_o==1
replace own = 0 if own_o==5

drop own_o

*** Mobility
ren moved moved_o
gen 	moved = 1 if moved_o==1
replace	moved = 0 if moved_o==5

drop moved_o

*** Why moved question
replace whymoved	= whymoved_1st if whymoved==.

gen moved_job 		= (whymoved==1 | whymoved_1st==1 | whymoved_2nd==1 | whymoved_3rd==1 | whymoved_4th==1) & year>=1975
gen moved_near 		= (whymoved==2 | whymoved_1st==2 | whymoved_2nd==2 | whymoved_3rd==2 | whymoved_4th==2) & year>=1975
egen moved_prod		= rmax(moved_job moved_near)
replace moved_prod	= 1 if whymoved==1 & year<1975
drop moved_near
drop whymove*

label var moved_job "moved house due to job change or transfer" 
label var moved_prod "moved house due to job change or getting nearer to work" 

*** Employment Status
gen unemployed 	= empst==3
gen in_lf		= empst==1 | empst==2 | empst==3

drop empst

keep person year own weight moved moved_job moved_prod unemployed in_lf

save psid_variables, replace

cd "$do"
