/* Generates and displays the statistics from the PSID that get used in the paper (unemployment boost, average unemployed homeowner mobility )
	*/ 

cd "$output"
clear all
set more off
cap log close

*** Annual mobility rates
u psid_variables, clear

tsset person year
gen l1_unemployed = l1.unemployed if year<=96
replace l1_unemployed = l2.unemployed if year>96

tsset person year
gen l1_own = l1.own if year<=96
replace l1_own = l2.own if year>96
gen l1_in_lf = l1.in_lf if year<=96
replace l1_in_lf = l2.in_lf if year>96

egen double moved_own_temp 	= sum(weight) if moved==1 & l1_own==1 & l1_in_lf==1, by(year)
egen double moved_rent_temp = sum(weight) if moved==1 & l1_own==0 & l1_in_lf==1, by(year)

egen double own_lf_temp 	= sum(weight) if moved!=. & l1_own==1 & l1_in_lf==1, by(year)
egen double rent_lf_temp 	= sum(weight) if moved!=. & l1_own==0 & l1_in_lf==1, by(year)

egen double moved_own_unemp_temp = sum(weight) if moved==1 & l1_own==1 & l1_unemployed==1, by(year)
egen double moved_rent_unemp_temp= sum(weight) if moved==1 & l1_own==0 & l1_unemployed==1, by(year)

egen double own_unemp_temp 		= sum(weight) if moved!=.& l1_own==1 & l1_unemployed==1, by(year)
egen double rent_unemp_temp 	= sum(weight) if moved!=.& l1_own==0 & l1_unemployed==1, by(year)

egen double moved_own_job_temp 		= sum(weight) if moved_job==1 & l1_own==1 & l1_in_lf==1, by(year)
egen double moved_own_prod_temp		= sum(weight) if moved_prod==1 & l1_own==1 & l1_in_lf==1, by(year)
egen double moved_own_unemp_job_temp 	= sum(weight) if moved_job==1 & l1_own==1 & l1_in_lf==1 & l1_unemployed==1, by(year)
egen double moved_own_unemp_prod_temp 	= sum(weight) if moved_prod==1 & l1_own==1 & l1_in_lf==1 & l1_unemployed==1, by(year)

foreach var in 	moved_own own_lf moved_own_job moved_own_unemp own_unemp moved_own_prod moved_own_unemp_job /// 
				moved_own_unemp_prod moved_rent rent_lf moved_rent_unemp rent_unemp {
	egen `var' = max(`var'_temp), by(year)
}

egen double moved_own_unemp_job_allyears 	= sum(weight) if moved_job==1 & l1_own==1 & l1_in_lf==1 & l1_unemployed==1
egen double moved_own_unemp_prod_allyears 	= sum(weight) if moved_prod==1 & l1_own==1 & l1_in_lf==1 & l1_unemployed==1
egen double moved_own_unemp_allyears	= sum(weight) if moved==1 & l1_own==1 & l1_unemployed==1

gen mob_rate_all = moved_own/own_lf
gen mob_rate_unemp = moved_own_unemp/own_unemp

gen mob_rate_all_rent = moved_rent/rent_lf
gen mob_rate_unemp_rent = moved_rent_unemp/rent_unemp

gen ratio_mob = mob_rate_unemp/mob_rate_all
gen ratio_mob_rent = mob_rate_unemp_rent/mob_rate_all_rent

gen ratio_mob_job = moved_own_job/moved_own
gen ratio_mob_prod = moved_own_prod/moved_own
gen ratio_mob_job_unemp = moved_own_unemp_job/moved_own_unemp
gen ratio_mob_prod_unemp = moved_own_unemp_prod/moved_own_unemp

gen ratio_mob_job_unemp_allyears = moved_own_unemp_job_allyears/moved_own_unemp_allyears
gen ratio_mob_prod_unemp_allyears = moved_own_unemp_prod_allyears/moved_own_unemp_allyears



**************************************
*** The numbers used in the paper: ***
**************************************

* First, the max of the ratio mob_rate_unemp/mob_rate_all over the last 20 years
tab year, su(ratio_mob)
tab year, su(ratio_mob_rent)
egen tag_year=tag(year) if ratio_mob_job_unemp!=.

* Calculate the average over the 5 highest years
gsort -ratio_mob
gen rank_ho = 1 if tag==1
replace rank_ho = sum(rank_ho) if tag==1
su ratio_mob if tag==1
su ratio_mob if rank_ho<=5

gsort -ratio_mob_rent
gen rank_re = 1 if tag==1
replace rank_re = sum(rank_re) if tag==1
su ratio_mob_rent if tag==1
su ratio_mob_rent if rank_re<=5



* Second, the average of the ratio moved_own_unemp_job/moved_own_unemp over the last 20 years
su ratio_mob_prod_unemp if tag_year==1		/* THIS IS MISSING YEARS FOR SOME REASON */
su ratio_mob_prod_unemp_allyears		/* THIS IS MISSING YEARS FOR SOME REASON */

cd "$do"

