/* This file reads relevant variables from NBER monthly files and merges the DataFarret homeownership 
   varibale with NBER cps.
   
	The main datafile created is called cpsm_2006_2012.dta
	It has all the observation for all months starting January 2006  and ending
	March 2012.
	This file has the variables  regarding geographical location, employment status, demographics, time, identifiers, and weight.
	
	It also creates separate monthly files for each month with the above variables. The monthy
	files are called cps_basic_yy_mm.dta and get used in the matching process. 
	*/

clear all
set memory 2g
set more off
cd "$output"

* Prepare NBER dataset
foreach yy in 06 07 08 09 10 11 {
	foreach mm in 01 02 03 04 05 06 07 08 09 10 11 12 {
		u "$cpsm/cpsb`yy'`mm'.dta", clear
		keep hryear4 hrmonth hrhhid hrhhid2 pulineno hrmis occurnum peage ptdtrace pesex pemlr pruntype prunedur prwntjob hrintsta pwcmpwgt gtcbsa gtco gestcen
		keep if hrintsta==1
		ren pemlr empst
		ren pruntype unemp_reason
		ren prunedur unemp_dur
		ren peage age
		ren ptdtrace race
		ren prwntjob wantjob
		ren pesex sex
		ren pwcmpwgt weight
		destring  hrhhid  hrhhid2 occurnum, replace
		local y = `yy'
		local m = `mm'
		save cpsb_`y'_`m'.dta, replace
	}
}

foreach yy in 12 {
	foreach mm in 01 02 03 {
		u "$cpsm/cpsb`yy'`mm'.dta", clear
		keep hryear4 hrmonth hrhhid hrhhid2 pulineno hrmis occurnum peage ptdtrace pesex pemlr pruntype prunedur prwntjob hrintsta pwcmpwgt gtcbsa gtco gestcen
		keep if hrintsta==1
		ren pemlr empst
		ren pruntype unemp_reason
		ren prunedur unemp_dur
		ren peage age
		ren ptdtrace race
		ren prwntjob wantjob
		ren pesex sex
		ren pwcmpwgt weight
		destring  hrhhid  hrhhid2 occurnum, replace
		local y = `yy'
		local m = `mm'
		save cpsb_`y'_`m'.dta, replace
	}
}

u "cpsb_6_1.dta", clear
forvalues yy=6/6 {
	forvalues mm=2/12 {
		append using "cpsb_`yy'_`mm'.dta"
	}
}

forvalues yy=7/11 {
	forvalues mm=1/12 {
		append using "cpsb_`yy'_`mm'.dta"
	}
}

forvalues yy=12/12 {
	forvalues mm=1/3 {
		append using "cpsb_`yy'_`mm'.dta"
	}
}

sort hryear4 hrmonth hrhhid hrhhid2 occurnum 
merge hryear4 hrmonth hrhhid hrhhid2 occurnum using dataferret_2006_2012
tab hryear4 _merge
drop _m

* Prepare variables
ren hryear4 year
ren hrmonth month
ren df_hetenure own

save cpsm_2006_2012, replace

cd "$do"
