/* 	This file matches for each year and month, the next month basic CPS. 
	It then uses the match rate to generate a new mobility variable which 
	would later be used to calcaulte 4 series of mobility rate. (Note that as in 
	Madrigan and Lefgren, this would dramaticlly overstate mobility, but should 
	be informative about the dynamics).
	The series we construct:
	(1) Mobility for employed homeowners
	(2) Mobility for unemployed homeowners
	(3) Mobility for employed renters
	(4) Mobility for unemployed renters

	Note that the matching is done using the criteria S|R|A
	
	The main datafile genrated is cpsm_2006_2012_matched.dta
	
*/	

clear all
set more off
set mem 2g
cd "$output" 

forvalues y=6/11 {
	forvalues m=1/12 {
		if `m'<12 {
			local mm = `m'+1
			local yy = `y' 
		}
		else {
			local mm = 1
			local yy = `y' + 1
		}
		u cpsb_`yy'_`mm', clear
		
		replace hrmis=hrmis-1
		ren sex sex1 
		ren race race1 
		ren age age1
		keep hrhhid hrhhid2 pulineno hrmis sex1 race1 age1
		sort hrhhid hrhhid2 pulineno hrmis
		save temp, replace 

		u "cpsb_`y'_`m'", clear
		sort hrhhid hrhhid2 occurnum
		merge hrhhid hrhhid2 occurnum using cps_basic_`y'_`m'_df	/* As before, merge df data for ownership */ 
		drop _m hrintsta 
		ren hryear4 year
		ren hrmonth month
		ren df_hetenure own

		drop if hrmis==4 | hrmis==8 	/* These are 25% of outgoing so are not in the sample for matching */ 

		sort hrhhid hrhhid2 pulineno hrmis
		merge hrhhid hrhhid2 pulineno hrmis using temp

		* S|R|A
		replace _m = 1 if sex!=sex1 & _m==3
		replace _m = 1 if race!=race1 & _m==3
		replace _m = 1 if age1-age>1 & _m==3
		replace _m = 1 if age1-age<0 & _m==3

		gen moved = _merge==1
		drop if _m==2
		drop _m age1 sex1 race1
		
		compress
		save "cpsb_`y'_`m'_match", replace
	}
}

forvalues y=12/12 {
	forvalues m=1/2 {
		if `m'<12 {
			local mm = `m'+1
			local yy = `y' 
		}
		else {
			local mm = 1
			local yy = `y' + 1
		}
		u cpsb_`yy'_`mm', clear
		
		replace hrmis=hrmis-1
		ren sex sex1 
		ren race race1 
		ren age age1
		keep hrhhid hrhhid2 pulineno hrmis sex1 race1 age1
		sort hrhhid hrhhid2 pulineno hrmis
		save temp, replace 

		u "cpsb_`y'_`m'", clear
		sort hrhhid hrhhid2 occurnum
		merge hrhhid hrhhid2 occurnum using cps_basic_`y'_`m'_df	/* As before, merge df data for ownership */ 
		drop _m hrintsta 
		ren hryear4 year
		ren hrmonth month
		ren df_hetenure own

		drop if hrmis==4 | hrmis==8 	/* These are 25% of outgoing so are not in the sample for matching */ 

		sort hrhhid hrhhid2 pulineno hrmis
		merge hrhhid hrhhid2 pulineno hrmis using temp

		* S|R|A
		replace _m = 1 if sex!=sex1 & _m==3
		replace _m = 1 if race!=race1 & _m==3
		replace _m = 1 if age1-age>1 & _m==3
		replace _m = 1 if age1-age<0 & _m==3

		gen moved = _merge==1
		drop if _m==2
		drop _m age1 sex1 race1
		
		compress
		save "cpsb_`y'_`m'_match", replace
	}
}

u cpsb_6_1_match, clear
erase cpsb_6_1_match.dta
forvalues m=2/12 {
	append using cpsb_6_`m'_match
	erase cpsb_6_`m'_match.dta
	erase cps_basic_6_`m'_df.dta
}

forvalues y=7/11 {
	forvalues m=1/12 {
		append using cpsb_`y'_`m'_match
		erase cpsb_`y'_`m'_match.dta
		erase cps_basic_`y'_`m'_df.dta
	}
}

forvalues y=12/12 {
	forvalues m=1/2 {
		append using cpsb_`y'_`m'_match
		erase cpsb_`y'_`m'_match.dta
		erase cps_basic_`y'_`m'_df.dta
	}
}

compress

save cpsm_2006_2012_matched, replace

tab year if own==1 [aw=weight], su(moved)
tab year if own>1 [aw=weight], su(moved)

tab year if own==1 & (empst==3 | empst==4) [aw=weight], su(moved)
tab year if own==1 & (empst!=3 & empst!=4) [aw=weight], su(moved)
tab year if own>1 & (empst==3 | empst==4) [aw=weight], su(moved)
tab year if own>1 & (empst!=3 & empst!=4) [aw=weight], su(moved)

cd "$do"
