/* NOTE: This file does not need to be run to replicate any of the results in the main paper. It is needed only to replicate the results discussed in footnote **
	in section ***, in the web appendix. 
	All the data in the main paper for the March CPS is taken from IPUMS. However, the household and person identifiers in the IPUMS March files are scrambled and cannot
	be used to match the March files to the basic CPS or to other March files. Without this matching, we cannot cluster on households over time when we use the regressions
	descibed in the web appendix to generate the joint covariance matrix of unemployment levels and mobility rates.
		
	To run this file you will need to download the March CPS data from the NBER from 2005 to 2012 and extract them into STATA format (see readme)
	
	The main output file generated here is cps_data_nber.dta

*/

clear all
set more off
set mem 2g

cd "$nber_march"


use "$nber_march\output\cpsmar05.dta", clear
erase "$nber_march\output\cpsmar05.dta"

foreach i in 06 07 08 09 10 11 12 {
	append using "$nber_march\output\cpsmar`i'.dta"
	erase "$nber_march\output\cpsmar`i'.dta"
}

compress
save "$output\cps_data_nber.dta", replace



**** Recoding Variables ****


*** Year 
ren h_year year

*** Ownership
gen 	ownershp = 10
replace ownershp = 21 if h_tenure==3
replace ownershp = 22 if h_tenure==2

*** State
ren gestfips state

*** Use the March S weight (verified that weight is in the same place as last year - column 155)
ren marsupwt weight

*** famsize
ren fpersons famsize

*** Age
ren a_age age

*** Sex
ren a_sex sex

*** Race
gen 	race = 100 if prdtrace==1
replace race = 200 if prdtrace==2
replace race = 700 if prdtrace>2 & prdtrace!=.
replace race = 300 if prdthsp> 0 & prdthsp!=.

#delimit;
cap label drop racelb_new;
label define racelb_new
	100 "white"
	200 "black"
	300 "hispanic"
	700 "other";
#delimit cr; 

label val race racelb_new

*** marst - Marital status
gen 	marst = a_maritl if a_maritl==1
replace marst = 1 if a_maritl==2 
replace marst = 2 if a_maritl==3
replace marst = 3 if a_maritl==6
replace marst = 4 if a_maritl==5
replace marst = 5 if a_maritl==4
replace marst = 6 if a_maritl==7

#delimit;
cap label drop marst;
label define marst
	1	"Married, spouse present" 
	2	"Married, spouse absent"
	3   "Separated" 
	4   "Divorced" 
	5   "Widowed" 
	6	"Never married/single";
#delimit cr; 
label val marst marst

*** Education
ren a_hga educ
#delimit;
recode 	educ 
		(0=1)
		(31=2)
		(32=10)
		(33=20)
		(34=30)
		(35=40)
		(36=50)
		(37=60)
		(38=71)
		(39=73)
		(40=81)
		(41=91)
		(42=92)
		(43=111)
		(44=123)
		(45=124)
		(46=125);
#delimit cr		

label define educ_lbl 001 `"NIU"', add
label define educ_lbl 002 `"None or preschool"', add
label define educ_lbl 010 `"Grades 1, 2, 3, or 4"', add
label define educ_lbl 020 `"Grades 5 or 6"', add
label define educ_lbl 030 `"Grades 7 or 8"', add
label define educ_lbl 040 `"Grade 9"', add
label define educ_lbl 050 `"Grade 10"', add
label define educ_lbl 060 `"Grade 11"', add
label define educ_lbl 071 `"12th grade, no diploma"', add
label define educ_lbl 073 `"High school diploma or equivalent"', add
label define educ_lbl 081 `"Some college but no degree"', add
label define educ_lbl 091 `"Associate's degree, occupational/vocational program"', add
label define educ_lbl 092 `"Associate's degree, academic program"', add
label define educ_lbl 111 `"Bachelor's degree"', add
label define educ_lbl 123 `"Master's degree"', add
label define educ_lbl 124 `"Professional school degree"', add
label define educ_lbl 125 `"Doctorate degree"', add
label values educ educ_lbl

*** Employment Status
gen 	empstat = 10 if pemlr==1 | pemlr==2
replace empstat = 20 if pemlr==3 | pemlr==4
replace empstat = 30 if pemlr>=5 	/* No missing values */ 

*** Use ftotval for total family income 	

*** Migration
gen 	migrate1 = 0 if mig_mtr3==8
replace migrate1 = 1 if mig_mtr3==1
replace migrate1 = 3 if mig_mtr3==2
replace migrate1 = 4 if mig_mtr3==3
replace migrate1 = 5 if mig_mtr3==4 | mig_mtr3==5 |mig_mtr3==6
replace migrate1 = 6 if mig_mtr3==7

*** State of origin
gen 	migsta1 	= mig_st
replace migsta1 	= state if migrate1==1

*** Why moved
ren nxtres whymove
replace whymove=. if whymove==0

*** want job
gen 	wantjob = a_wantjb==2
replace wantjob = 2 if a_wantjb==1

*** Reason not working
gen 	whynwly = 0
replace whynwly = 1 if rsnnotw==5
replace whynwly = 2 if rsnnotw==1
replace whynwly = 3 if rsnnotw==3
replace whynwly = 4 if rsnnotw==4
replace whynwly = 5 if rsnnotw==2

*** migration impute flags
gen 	qmigrat1 = 0
replace qmigrat1 = 1 if i_mig1==1
replace qmigrat1 = 2 if i_mig1==2
replace qmigrat1 = 3 if i_mig1==5
replace qmigrat1 = 4 if i_mig1==3 | i_mig1==4

gen 	qmigst1b = 0
replace qmigst1b = 1 if i_mig2==1
replace qmigst1b = 2 if i_mig2==2
replace qmigst1b = 3 if i_mig2==3 | i_mig2==4
replace qmigst1b = 4 if i_mig2==5
replace qmigst1b = 5 if i_mig2==6
replace qmigst1b = 6 if i_mig2==7
replace qmigst1b = 7 if i_mig2==8
replace qmigst1b = 8 if i_mig2==9
replace qmigst1b = 9 if i_mig2==10

save "$output\cps_data_nber.dta", replace

cd "$do"
