clear all  
set mem 2000m

cd "$output"

*********************************************************************************************************
* This files reweights renters to have similar demographics to homeowners. The way this is done, is by  *
* first regressing renters mobility on a set of demographic characteristics, and then using the         *
* homeowners' sample characteristics and weights to project mobility. 									*
* The characteristics we use are roughly following Kaplan and Schulhofer-Wohl (2012 trend paper), 		*
* including: age, education (and and interaction of age and education), marital status, number of 		*
* labor force participants in the households, income, industry and occupation + number of family members*
* We then produce the usual set of measures: 														    *
* 1) Baseline (in the labor force)				   													    *
* 2) Inter-county			   																		    *
* Note: Standard erros in the probits would not matter as we will bootstrap everything. 				*
*																										*
*********************************************************************************************************

*===================
* Prepare variables 
*===================

u year serial weight state migrate1 marst own empstat qmigrat1 age educ famsize wks* weeks* whymove ftotval using "cps_data" if year>=2006, clear

*** How many of the persons in the house are labor force participants (as usual post move)
gen lf_dum 	= empstat<30 
egen lfp 	= sum(lf_dum), by(serial year)
replace lfp = 3 if lfp>3 

**** Generate demographics
* Ownership
gen own=0
replace own=1 if ownershp==10

* Categories of income, age, and schooling
egen p_inc = xtile(ftotval), n(10)

gen age_cat 	= 1 
replace age_cat	= 2 if age>25 & age!=.
replace age_cat	= 3 if age>30 & age!=.
replace age_cat	= 4 if age>35 & age!=.
replace age_cat	= 5 if age>40 & age!=.
replace age_cat	= 6 if age>45 & age!=.
replace age_cat	= 7 if age>50 & age!=.
replace age_cat	= 8 if age>55 & age!=.
replace age_cat	= 9 if age>60 & age!=.

gen young = age<20

gen school= 1
replace school = 2 if educ>=73
replace school = 3 if educ>=111

* family size
replace famsize=5 if famsize>5

xi i.age_cat*i.school i.famsize i.lfp i.marst i.p_inc

save data4reweight, replace

*==========================*
* (1) Basline: Labor force *
*==========================*
u data4reweight, clear

*** Sample correction criteria
keep if empstat<30 & migrate1>0 & migrate1!=. 		/* 	We only work with the individuals in the labor force. 
													Migrate>0 is not binding. migrate!=. is missing for some years
													(last of them is 1995) */ 

*** Generate the outcome variables
gen moved=migrate1>1
gen moved_job=whymove==4|whymove==5|whymove==6|whymove==8
gen movedjob=moved*moved_job

*** Run probit
cap drop moved_hat
gen moved_hat = .

cap drop movedjob_hat
gen movedjob_hat = .

forvalues y=2006/2012 {
	probit moved young _I* [iw=weight] if own==0 & year==`y'
	cap drop moved_hat_temp
	predict moved_hat_temp
	replace moved_hat=moved_hat_temp if year==`y'

	probit movedjob young _I* [iw=weight] if own==0 & year==`y'
	cap drop movedjob_hat_temp
	predict movedjob_hat_temp
	replace movedjob_hat=movedjob_hat_temp if year==`y'
}

*** Caclculate the total moves (using homeowner weights, so note that should later devide by homeowner population)
gen temp=weight*moved_hat
egen double M_OWN_reweight = sum(temp) if owner==10, by(year)
label var M_OWN_reweight "Renters' mobility reweighted with homeowners' weights"
drop temp

gen temp=weight*movedjob_hat
egen double M_OWN_J_reweight = sum(temp) if owner==10, by(year)
label var M_OWN_J_reweight "Renters' mobility for job reweighted with homeowners' weights"
drop temp

collapse  M_OWN_reweight M_OWN_J_reweight, by(year)
save "M_RENT_reweight_baseline", replace



*=================================*
* (4) Mobility outside the county *
*=================================*
u data4reweight, clear

*** Sample correction criteria
keep if empstat<30 & migrate1>0 & migrate1!=. 		/* 	We only work with the individuals in the labor force. 
													Migrate>0 is not binding. migrate!=. is missing for some years
													(last of them is 1995) */ 

*** Generate the outcome variables
gen moved=migrate1>3
gen moved_job=whymove==4|whymove==5|whymove==6|whymove==8
gen movedjob=moved*moved_job

*** Run probit
cap drop moved_hat
gen moved_hat = .

cap drop movedjob_hat
gen movedjob_hat = .

forvalues y=2006/2012 {
	probit moved young _I* [iw=weight] if own==0 & year==`y' 
	cap drop moved_hat_temp
	predict moved_hat_temp
	replace moved_hat=moved_hat_temp if year==`y'

	probit movedjob young  _I* [iw=weight] if own==0 & year==`y' 
	cap drop movedjob_hat_temp
	predict movedjob_hat_temp
	replace movedjob_hat=movedjob_hat_temp if year==`y'
}

*** Caclculate the total moves (using homeowner weights, so note that should later devide by homeowner population)
gen temp=weight*moved_hat
egen double M_OWN_reweight = sum(temp) if owner==10, by(year)
label var M_OWN_reweight "Renters' mobility reweighted with homeowners' weights"
drop temp

gen temp=weight*movedjob_hat
egen double M_OWN_J_reweight = sum(temp) if owner==10, by(year)
label var M_OWN_J_reweight "Renters' mobility for job reweighted with homeowners' weights"
drop temp

collapse  M_OWN_reweight M_OWN_J_reweight, by(year)
save "M_RENT_reweight_county", replace




cd "$do"
