/* Generates the employment status and moving rates based on the non-matched monthly CPS conditional on ownership in the previous period. */ 

clear all
set mem 1500m
set more off
cd "$output"


***************************************
*** Data Preparation Matched		***
***************************************
*** Sample selection
u cpsm_2006_2012_matched, clear
keep if empst<5	& empst>0						/* 	We only work with the individuals in the labor force.  */ 
													
keep year month weight own empst moved

*** Use CPS Prepare the aggregate level sums and collapse by year, month
egen double POP = sum(weight), by(year month) 
label var POP "Labor force level"
egen double U = sum(weight) if empst==3|empst==4, by(year month)
label var U "Unemployment level"
egen double OWN = sum(weight) if own==1, by(year month)
label var OWN "Home owners level"
egen double RENT = sum(weight) if own>1, by(year month)
label var RENT "Home renters level"
egen double U_OWN = sum(weight) if own==1 & (empst==3|empst==4), by(year month)
label var U_OWN "Home owners who are unemployed level"
egen double U_RENT = sum(weight) if own>1 & (empst==3|empst==4), by(year month)
label var U_RENT "Renters who are unemployed level"
egen double M_OWN = sum(weight) if moved==1 & own==1, by(year month)
label var M_OWN "Home owners who moved level"
egen double M_RENT = sum(weight) if moved==1 & own>1, by(year month)
label var M_RENT "Renters who moved level"
egen double M_OWN_UE = sum(weight) if moved==1 & own==1 & (empst==3|empst==4), by(year month)
label var M_OWN_UE "Unemployed Home owners who moved level"
egen double M_RENT_UE = sum(weight) if moved==1 & own>1 & (empst==3|empst==4), by(year month)
label var M_RENT_UE "Unemployed renters who moved level"

collapse POP U OWN RENT U_OWN U_RENT M_OWN M_RENT M_OWN_UE M_RENT_UE, by(year month)
sort year month

gen date=ym(year,month)
format date %tm
drop year month
foreach var of varlist  POP-M_RENT_UE {
	ren `var' matched_`var'
}

sort date
save matched_mobility, replace

cd "$do"
