*========================================================
* Prepares consumption aggregates at that coh-edu-year level using CEX 
*========================================================

cd "$output"

* Add price indices (CEX is already deflated, but this will be used in ATUS later)
u "$MD/price_indices", clear
drop if year>112
replace year=year+1900
sort year
expand 2 if year==2012
replace year=2013 if year==2012 & year[_n-1]==2012
expand 2 if year==2013
replace year=2014 if year==2013 & year[_n-1]==2013
expand 2 if year==2014
replace year=2015 if year==2014 & year[_n-1]==2014
replace p_totcons=232.957 if year==2013
replace p_totcons=236.736 if year==2014
replace p_totcons=237.017 if year==2015
save temp, replace

u "$CEX\cex_dataset_1996_2015", clear
merge m:1 year using temp
drop if _m==2 
drop _m

* Sample
keep if w_age>=25 & w_age<=65							/* wives 25 to 26 */
keep if spouseinhh==1									/* Select couples*/
keep if minage<=10										/* only families with kids 10 or younger */ 
keep if h_employed==1 & w_employed==1					/* Only participating husbands and wives */ 

gen fsize = numadults+numdepchild

replace TOTALNDUR = TOTALNDUR +HOUSING

sort cuid intno
collapse (mean) TOTALNDUR (first) p_totcons h_age h_race w_age w_race h_educ sp_educ minage male year fsize (count) ni=TOTALNDUR,  by(cuid)
keep if ni==4
drop if year==2015	/* Very few with complete data */ 
gen log_c = log(TOTALNDUR/sqrt(fsize))

gen ybw = year-w_age

cap drop wcoh*
g wcoh=.

replace wcoh=1 if ybw<=1959
replace wcoh=2 if ybw>=1960 & ybw<=1964
replace wcoh=3 if ybw>=1965 & ybw<=1969
replace wcoh=4 if ybw>=1970 & ybw<=1974
replace wcoh=5 if ybw>=1975 & ybw<=1979
replace wcoh=6 if ybw>=1980 

replace sp_educ=3 if sp_educ==4
ren sp_educ weduc

collapse log_c (first)p_totcons (count) ncex = log_c, by(weduc wcoh year)

save "c_cex_coh_educ", replace

erase "temp.dta"

cd "$MD"
