
cd "$output"

*========================
* Use PSID for the estimation of equations 7, 8 
*========================
u data_PSID, clear

* Baseline (Table 3, panel A, column (1))
#delimit;
gmm (logL_w - (
	{K1} +{K3}*mills - {psi_L2}*logwg_w  + ({psi_L2}/{eta_cp})*logc_wh
	+ ({psi_L2}/{psi_L1})*{rho_L}*(1-{psi_L1})*logL
	- ({psi_L2}*{rho_L})*({psi_L2}*(1-{psi_L1}))/({psi_L1}*(1-{psi_L2}))*ratio1
	+ 0.1*({psi_L2})*log_y
	))
	(logL - (
	{K2} +{K4}*mills + {psi_L1}*(logwg_w -logwg_h )
	+ ({psi_L1}/{psi_L2})*logL_w 
	)),
	from(psi_L1 0.9 psi_L2 0.9 eta_cp 0.5 rho_L 0.5)
	instruments(1: logUY two_ms_fa edd1 edd2 wedd1 wedd2 WCd1 WCd2 WCd3 WCd4 WCd5 WCd6 WCd7 yearschl wyearschl  mills 
				   wCEd* )
	instruments(2: edd1 edd2 wedd1 wedd2 WCd1 WCd2 WCd3 WCd4 WCd5 WCd6 WCd7 yearschl wyearschl  mills 
				   wCEd* )
	winitial(identity) 
    quickd vce(cluster person);
#delimit cr
matrix VAR_psid_temp=e(V)	/* Store variance matrix for correction of SMM estimates */ 
matrix VAR_psid = VAR_psid_temp[3..6,3..6]
svmat VAR_psid, names(SIG)
format SIG* %24.0g
outsheet SIG* using "$MATLAB/SIGMA_psid.csv" in 1/4, replace comma noname
eststo model_base
global eta_cp = round(_b[/eta_cp],0.001)

* Appendix table, column 1
#delimit;
gmm (logL_w - (
	{K1} +{K3}*mills - {psi_L2}*logwg_w  + ({psi_L2}/{eta_cp})*logc_wh
	+ ({psi_L2}/{psi_L1})*{rho_L}*(1-{psi_L1})*logL
	- ({psi_L2}*{rho_L})*({psi_L2}*(1-{psi_L1}))/({psi_L1}*(1-{psi_L2}))*ratio1
	+ 0.1*({psi_L2})*log_y
	))
	(logL - (
	{K2} +{K4}*mills + {psi_L1}*(logwg_w -logwg_h )
	+ ({psi_L1}/{psi_L2})*logL_w 
	)),
	from(psi_L1 0.9 psi_L2 0.9 eta_cp 0.5 rho_L 0.5)
	instruments(1: mills 
				   l2_logwg_w l2_logwg_h l2_d_logc_wh l2_d_logL l2_d_logL_w)
	instruments(2: mills 
				   l2_logwg_w l2_logwg_h l2_d_logc_wh l2_d_logL l2_d_logL_w)
	winitial(identity) 
    quickd vce(cluster person);
#delimit cr

eststo model_A1

* Appendix table, column 2
#delimit;
gmm (logL_w - (
	{E1}*edd1 + {E2}*edd2 + {WE1}*wedd1 + {WE2}*wedd2 + 
	{WC1}*WCd1 + {WC2}*WCd2 + {WC3}*WCd3 + {WC4}*WCd4 + {WC5}*WCd5 + {WC6}*WCd6 + {WC7}*WCd7 +
	{K1} +{K3}*mills - {psi_L2}*logwg_w  + ({psi_L2}/{eta_cp})*logc_wh
	+ ({psi_L2}/{psi_L1})*{rho_L}*(1-{psi_L1})*logL
	- ({psi_L2}*{rho_L})*({psi_L2}*(1-{psi_L1}))/({psi_L1}*(1-{psi_L2}))*ratio1
	+ 0.1*({psi_L2})*log_y
	))
	(logL - (
	{E1_2}*edd1 + {E2_2}*edd2 + {WE1_2}*wedd1 + {WE2_2}*wedd2 + 
	{WC1_2}*WCd1 + {WC2_2}*WCd2 + {WC3_2}*WCd3 + {WC4_2}*WCd4 + {WC5_2}*WCd5 + {WC6_2}*WCd6 + {WC7_2}*WCd7 +
	{K2} +{K4}*mills + {psi_L1}*(logwg_w -logwg_h )
	+ ({psi_L1}/{psi_L2})*logL_w 
	)),
	from(psi_L1 0.9 psi_L2 0.9 eta_cp 0.5 rho_L 0.5)
	instruments(1: edd1 edd2 wedd1 wedd2 WCd1 WCd2 WCd3 WCd4 WCd5 WCd6 WCd7 mills 
				   l2_logwg_w l2_logwg_h l2_d_logc_wh l2_d_logL l2_d_logL_w)
	instruments(2: edd1 edd2 wedd1 wedd2 WCd1 WCd2 WCd3 WCd4 WCd5 WCd6 WCd7 mills 
				   l2_logwg_w l2_logwg_h l2_d_logc_wh l2_d_logL l2_d_logL_w)
	winitial(identity) 
    quickd vce(cluster person);
#delimit cr
eststo model_A2

* Appendix table, column 3
#delimit;
gmm (logL_w - (
	{E1}*edd1 + {E2}*edd2 + {WE1}*wedd1 + {WE2}*wedd2 + 
	{WC1}*WCd1 + {WC2}*WCd2 + {WC3}*WCd3 + {WC4}*WCd4 + {WC5}*WCd5 + {WC6}*WCd6 + {WC7}*WCd7 +
	{K1} +{K3}*mills - {psi_L2}*logwg_w  + ({psi_L2}/{eta_cp})*logc_wh
	+ ({psi_L2}/{psi_L1})*{rho_L}*(1-{psi_L1})*logL
	- ({psi_L2}*{rho_L})*({psi_L2}*(1-{psi_L1}))/({psi_L1}*(1-{psi_L2}))*ratio1
	+ 0.1*({psi_L2})*log_y
	))
	(logL - (
	{E1_2}*edd1 + {E2_2}*edd2 + {WE1_2}*wedd1 + {WE2_2}*wedd2 + 
	{WC1_2}*WCd1 + {WC2_2}*WCd2 + {WC3_2}*WCd3 + {WC4_2}*WCd4 + {WC5_2}*WCd5 + {WC6_2}*WCd6 + {WC7_2}*WCd7 +
	{K2} +{K4}*mills + {psi_L1}*(logwg_w -logwg_h )
	+ ({psi_L1}/{psi_L2})*logL_w 
	)),
	from(psi_L1 0.9 psi_L2 0.9 eta_cp 0.5 rho_L 0.5)
	instruments(1: edd1 edd2 wedd1 wedd2 WCd1 WCd2 WCd3 WCd4 WCd5 WCd6 WCd7 mills 
				   l2_logwg_w l2_logwg_h two_ms_fa logUY noUY l2_d_logc_wh l2_d_logL l2_d_logL_w)
	instruments(2: edd1 edd2 wedd1 wedd2 WCd1 WCd2 WCd3 WCd4 WCd5 WCd6 WCd7 mills 
				   l2_logwg_w l2_logwg_h l2_d_logc_wh l2_d_logL l2_d_logL_w)
	winitial(identity) 
    quickd vce(cluster person);
#delimit cr
eststo model_A3

esttab 	model_base model_A1 model_A2 model_A3 using "$tables/gmm_psid.csv", cells(b(star fmt(%9.3f)) se(par)) replace

*===========================================================
* Use PSID for the estimation of equations 9, 10 
*===========================================================
u data_ATUS, clear

cap drop gmmsample
gen gmmsample=ncex>=5 & n_cc>=5	/* Only include cells with size of at least 5 */ 

#delimit;
gmm (logcc_w - (
	{K1} +{K3}*mills- exp({psi_T2})*logwg_w + (exp({psi_T2})/${eta_cp})*log_c
	+ (exp({psi_T2})/exp({psi_T1}))*{rho_T}*(1-exp({psi_T1}))*logcc_h
	- (exp({psi_T2})*{rho_T})*(exp({psi_T2})*(1-exp({psi_T1})))/(exp({psi_T1})*(1-exp({psi_T2})))*ratioT 
	))
	(logcc_h - (
	{K2} +{K4}*mills+ exp({psi_T1})*(logwg_w-logwg_h)
	+ (exp({psi_T1})/exp({psi_T2}))*logcc_w
	))
	if gmmsample
	,
	from(psi_T1 -1 psi_T2 -0.25 rho_T -0.4)
	instruments(1: edd* wedd* wyearschl mills )
	instruments(2: edd* wedd* wyearschl mills )
	winitial(identity) 
	quickd
	onestep
;
#delimit cr

matrix VAR_atus_temp=e(V)
matrix VAR_atus_small = VAR_atus_temp[3..5,3..5]
matrix R = J(3,3,0)
matrix R[1,1] = exp(_b[/psi_T2])
matrix R[2,2] = exp(_b[/psi_T1])
matrix R[3,3] = 1
matrix VAR_atus = R'*(VAR_atus_small)*R	/* Apply delta to rescale variance matrix */
svmat VAR_atus, names(SIG)
format SIG* %24.0g
outsheet SIG* using "$MATLAB/SIGMA_atus.csv" in 1/3, replace comma noname

eststo model1_atus
nlcom exp(_b[/psi_T1])	/* Rescale parameters */ 
matrix temp=r(b)
scalar b_psi_T1 = temp[1,1]
matrix temp=r(V)
scalar se_psi_T1 = sqrt(temp[1,1])
estadd scalar psi_T1=b_psi_T1
estadd scalar se_psi_T1=se_psi_T1

nlcom exp(_b[/psi_T2])
matrix temp=r(b)
scalar b_psi_T2 = temp[1,1]
matrix temp=r(V)
scalar se_psi_T2 = sqrt(temp[1,1])
estadd scalar psi_T2=b_psi_T2
estadd scalar se_psi_T2=se_psi_T2

esttab 	model1_atus using "$tables/gmm_atus.csv", cells(b(star fmt(%9.3f)) se(par))                ///
		scalars( "psi_T1 psi T1" "se_psi_T1 se(psi T1)"  "psi_T2 psi T2" "se_psi_T2 se(psi T2)") replace

cd "$MD"
