clear all
cd "$output"

cap postclose desc_ATUS
postfile desc_ATUS str32 varname mean p25 p50 p75 using desc_ATUS, replace
u data_ATUS, clear
keep if ncex>=5 & n_cc>=5 /* Not conditioning on zero cc to show the share with 0 in the table */ 

cap log close

*** ATUS
gen pos_cc_w=cc_w>0
su pos_cc_w
local mean = r(mean)
local p25 = .
local p50 = .
local p75 = .
post desc_ATUS ("Positive cc_w") (`mean') (`p25') (`p50') (`p75') 

su cc_w,d 
local mean = r(mean)
local p25 = r(p25)
local p50 = r(p50)
local p75 = r(p75)
post desc_ATUS ("cc_w") (`mean') (`p25') (`p50') (`p75') 

su cc_w if cc_w>0,d 
local mean = r(mean)
local p25 = r(p25)
local p50 = r(p50)
local p75 = r(p75)
post desc_ATUS ("cc_w|nonzero") (`mean') (`p25') (`p50') (`p75') 

gen cc = exp(logcc_h)

su cc,d 
local mean = r(mean)
local p25 = r(p25)
local p50 = r(p50)
local p75 = r(p75)
post desc_ATUS ("cc") (`mean') (`p25') (`p50') (`p75') 

preserve
u husband_avg_childcare_for_descstat, clear
gen pos_cc=cc>0
su pos_cc
local mean = r(mean)
local p25 = .
local p50 = .
local p75 = .
post desc_ATUS ("Positive cc") (`mean') (`p25') (`p50') (`p75') 
restore

count
local mean = r(N)
local p25 = .
local p50 = .
local p75 = .
post desc_ATUS ("Obsevations") (`mean') (`p25') (`p50') (`p75') 

cap postclose desc_ATUS
u desc_ATUS, clear
outsheet using "$tables/desc_ATUS.csv", comma replace

*** PSID
cap postclose desc_PSID
postfile desc_PSID str32 varname mean p25 p50 p75 using desc_PSID, replace
u data_PSID, clear

keep if mills!=. & logc_wh!=. & logL!=. & logL_w!=.

gen C=exp(logc_wh)*sqrt(fsize)
gen L1=exp(logL)
gen L2=exp(logL_w)
gen W1=exp(logwg_h)
gen W2=exp(logwg_w)

*convert to 2010 prices
su p_totcons if year==2010
local norm = r(mean)/100

foreach var in C W1 W2 {
	replace `var' =`var'*`norm'
}

gen dummy=age_youngest<=10
foreach var in C L1 L2 hours hourw W1 W2 {
	su `var', de
	local mean=r(mean)
	local p25 = r(p25)
	local p50 = r(p50)
	local p75 = r(p75)
	post desc_PSID ("`var'") (`mean') (`p25') (`p50') (`p75') 
}

count
local mean = r(N)
local p25 = .
local p50 = .
local p75 = .
post desc_PSID ("Obsevations") (`mean') (`p25') (`p50') (`p75') 

cap postclose desc_PSID
u desc_PSID, clear
outsheet using "$tables/desc_PSID.csv", comma replace

erase desc_ATUS.dta
erase desc_PSID.dta
