function [L1temp,L2temp,T1temp,T2temp,H1temp,H2temp,Ytemp,atYtemp,Atemp,Ctemp,Vtemp,FVALtemp,CORcortemp,Utemp,LAM1temp,LAM2temp]=solve_terminal_E2_1(Aprev,w1,w2,parameters,tt)

eta_cp = parameters.eta_cp ;
MU_0  = parameters.mu_0  ;
psi_l1 = parameters.psi_l1 ;
psi_l2 = parameters.psi_l2 ;
rhou_l = parameters.rhou_l ;
MU_l1 = parameters.mu_l1 ;
MU_l2 = parameters.mu_l2 ;
L_bar = parameters.L_bar ;
KT    = parameters.KT;
CHI    = parameters.chi    ;
TAUMU  = parameters.taumu  ;
TAU_B  = parameters.tau_b  ;
TAU_GAMMA  = parameters.tau_gamma  ;
r      = parameters.r  ;

kt   = KT(tt);

chi  = CHI(kt);
taumu= TAUMU(kt);
tau_b= TAU_B(kt);
tau_gamma= TAU_GAMMA(kt);

mu_l1= MU_l1(kt);
mu_l2= MU_l2(kt);
mu_0 = MU_0(kt);   

mu_l1_tild = mu_l1*(1/psi_l1-1);
mu_l2_tild = mu_l2*(1/psi_l2-1);

try 
    tempmax = min(((w2/w1)*(mu_l1_tild/mu_l2_tild)*(L_bar)^(1/psi_l2))^psi_l1,L_bar);
    LT1_0=[10^-9 tempmax];
    ok=1; i=1;
    while i<10 && ok==1
    try
        f = @(LT1)foc_int_terminal_nk(LT1,w1,w2,Aprev,parameters,tt);
        [LT,fval]= fzero(f,LT1_0); 
        ok=0;
    catch 
        LT1_0(2) = LT1_0(2)-0.1;
        i=i+1;
    end
    end

    %% Corners of hours - check all options
    L1temp = LT(1); 
    T1temp = 0;
    L2temp = ((w1/w2)*(mu_l2_tild/mu_l1_tild)*L1temp^(1/psi_l1))^psi_l2;
    T2temp = 0;
    H1temp = L_bar-L1temp - T1temp; 
    H2temp = L_bar-L2temp - T2temp;
    FVALtemp = fval;
    CORcortemp = 0;
    LAM1temp = 0;
    LAM2temp = 0;
catch
% no solution in bounds
    H1temp = -1;
    H2temp = -1;
end

if H1temp<1e-9 || H2temp<1e-9
    L1cor=zeros(1,3);
    L2cor=zeros(size(L1cor));
    T1cor=zeros(size(L1cor));
    T2cor=zeros(size(L1cor));
    H1cor=zeros(size(L1cor));
    H2cor=zeros(size(L1cor));
    Ycor =zeros(size(L1cor));
    atYcor=zeros(size(L1cor));
    Acor =zeros(size(L1cor));
    Ccor =zeros(size(L1cor));
    Vcor =ones(size(L1cor))*(-inf);
    FVALcor = zeros(size(L1cor));
    CORcor = zeros(size(L1cor));
    LAM1cor = zeros(size(L1cor));
    LAM2cor = zeros(size(L1cor));

    % Calculate case H1 constrained
        if H1temp<0
            try
                L2_0=[10^-9 1];
                ok=1; i=1;
                while i<10 && ok==1
                try
                    f = @(L2)foc_corH1_terminal_nk(L2,w1,w2,Aprev,parameters,tt);
                    [L2LAM1,fval]= fzero(f,L2_0); 
                    ok=0;
                catch 
                    L2_0(2) = L2_0(2)-0.1;
                    i=i+1;
                end
                end
                L2cor(2) = L2LAM1(1);
                L1cor(2) = L_bar;
                T1cor(2) = 0;
                T2cor(2) = 0;
                H1cor(2) = L_bar-L1cor(2)-T1cor(2);
                H2cor(2) = L_bar-L2cor(2)-T2cor(2);
                Ycor(2)  = tau_b + w1*H1cor(2) + w2*H2cor(2);
                atYcor(2)= chi*Ycor(2)^(1-taumu) - tau_gamma;
                Acor(2)  = 0;
                Ccor(2)  = Aprev + atYcor(2) - Acor(2);
                Vcor(2) = mu_0*(1/(1-1/eta_cp))*Ccor(2)^(1-1/eta_cp) ... 
                          - (1/(1-rhou_l))*(mu_l1*L1cor(2).^(1-1/psi_l1) + mu_l2*L2cor(2).^(1-1/psi_l2))^(1-rhou_l);
                FVALcor(2)=fval;
                CORcor(2)=2;
                if H2cor(2)<0
                   Vcor(2)=-inf;
                end
            catch
                Vcor(2)=-inf;
            end
        end

	% Compare magnitudes of V
    [~,ii]=max(Vcor);
    L1temp = L1cor(ii); 
    T1temp = T1cor(ii);
    L2temp = L2cor(ii);
    T2temp = T2cor(ii);
    H1temp = H1cor(ii); 
    H2temp = H2cor(ii);
    FVALtemp  = FVALcor(ii);
    CORcortemp  = CORcor(ii);
    LAM1temp = LAM1cor(ii);
    LAM2temp = LAM2cor(ii);
end

Ytemp  = tau_b + w1*H1temp + w2*H2temp;
atYtemp= chi*Ytemp^(1-taumu) - tau_gamma;
Atemp  = 0;
Ctemp  = Aprev + atYtemp - Atemp/(1+r);
Vtemp  = mu_0*(1/(1-1/eta_cp))*Ctemp^(1-1/eta_cp) ... 
                    - (1/(1-rhou_l))*(mu_l1*L1temp.^(1-1/psi_l1) + mu_l2*L2temp.^(1-1/psi_l2))^(1-rhou_l);
Utemp  = mu_0*Ctemp.^(-1/eta_cp);

if imag(Vtemp)>0
    Ytemp  = NaN;
    atYtemp= NaN;
    Atemp  = NaN;
    Ctemp  = NaN;
    Vtemp  = -inf;
    Utemp  = NaN;
end

end


