function [L1temp,L2temp,T1temp,T2temp,H1temp,H2temp,Ytemp,atYtemp,Atemp,Ctemp,Vtemp,FVALtemp,CORcortemp,Utemp,LAM1temp,LAM2temp]=solve_terminal_E2_0(Aprev,w1,w2,parameters,tt)

eta_cp = parameters.eta_cp ;
MU_0  = parameters.mu_0  ;
psi_l1 = parameters.psi_l1 ;
psi_l2 = parameters.psi_l2 ;
rhou_l = parameters.rhou_l ;
MU_l1 = parameters.mu_l1 ;
MU_l2 = parameters.mu_l2 ;
L_bar = parameters.L_bar ;
KT    = parameters.KT;
CHI    = parameters.chi    ;
TAUMU  = parameters.taumu  ;
TAU_B  = parameters.tau_b  ;
r      = parameters.r  ;

kt   = KT(tt);

chi  = CHI(kt);
taumu= TAUMU(kt);
tau_b= TAU_B(kt);

mu_l1= MU_l1(kt);
mu_l2= MU_l2(kt);
mu_0 = MU_0(kt);   

mu_l1_tild = mu_l1*(1/psi_l1-1);
mu_l2_tild = mu_l2*(1/psi_l2-1);

L1cor=zeros(1,2);
L2cor=zeros(size(L1cor));
T1cor=zeros(size(L1cor));
T2cor=zeros(size(L1cor));
H1cor=zeros(size(L1cor));
H2cor=zeros(size(L1cor));
Ycor =zeros(size(L1cor));
atYcor=zeros(size(L1cor));
Acor =zeros(size(L1cor));
Ccor =zeros(size(L1cor));
Vcor =ones(size(L1cor))*(-inf);
FVALcor = zeros(size(L1cor));
CORcor = zeros(size(L1cor));
LAM1cor = zeros(size(L1cor));
LAM2cor = zeros(size(L1cor));

% Calculate case H2 constrained
try 
    L1_0 = [10^-9 1];
    ok=1; i=1;
    while i<10 && ok==1
    try
        f = @(L1)foc_corH2_terminal_nk(L1,w1,w2,Aprev,parameters,tt);
        [L1LAM2,fval]= fzero(f,L1_0); 
        ok=0;
    catch
        L1_0(2) = L1_0(2)-0.1;
        i=i+1;
    end
    end
    L1cor(1) = L1LAM2(1);
    L2cor(1) = L_bar;
    T2cor(1) = 0;
    T1cor(1) = 0;
    H1cor(1) = L_bar-L1cor(1)-T1cor(1);
    H2cor(1) = L_bar-L2cor(1)-T2cor(1);
    Ycor(1)  = tau_b + w1*H1cor(1) + w2*H2cor(1);
    atYcor(1)= chi*Ycor(1)^(1-taumu);
    Acor(1)  = 0;
    Ccor(1)  = Aprev + atYcor(1) - Acor(1);
    Vcor(1) = mu_0*(1/(1-1/eta_cp))*Ccor(1)^(1-1/eta_cp) ... 
              - (1/(1-rhou_l))*(mu_l1*L1cor(1).^(1-1/psi_l1) + mu_l2*L2cor(1).^(1-1/psi_l2))^(1-rhou_l);
    FVALcor(1)=fval;
    CORcor(1)=11;
    if H1cor(1)<0 
       Vcor(1)=-inf;
    end
catch
    Vcor(1)=-inf;
end

% Calculate case both constrained. 
L1cor(2) = L_bar;
L2cor(2) = L_bar;
T1cor(2) = 0;
T2cor(2) = 0;
H1cor(2) = 0;
H2cor(2) = 0;
Ycor(2)  = tau_b + w1*H1cor(2) + w2*H2cor(2);
atYcor(2)= chi*Ycor(2)^(1-taumu);
Acor(2)  = 0;
Ccor(2)  = Aprev + atYcor(2) - Acor(2);
Vcor(2) = mu_0*(1/(1-1/eta_cp))*Ccor(2)^(1-1/eta_cp) ... 
      - (1/(1-rhou_l))*(mu_l1*L1cor(2).^(1-1/psi_l1) + mu_l2*L2cor(2).^(1-1/psi_l2))^(1-rhou_l);
CORcor(2)=12;

% Compare magnitudes of V
[~,ii]=max(Vcor);
L1temp = L1cor(ii); 
T1temp = T1cor(ii);
L2temp = L2cor(ii);
T2temp = T2cor(ii);
H1temp = H1cor(ii); 
H2temp = H2cor(ii);
FVALtemp  = FVALcor(ii);
CORcortemp  = CORcor(ii);
LAM1temp  = LAM1cor(ii);
LAM2temp  = LAM2cor(ii);


Ytemp  = tau_b + w1*H1temp + w2*H2temp;
atYtemp= chi*Ytemp^(1-taumu);
Atemp  = 0;
Ctemp  = Aprev + atYtemp - Atemp/(1+r);
Vtemp  = mu_0*(1/(1-1/eta_cp))*Ctemp^(1-1/eta_cp) ... 
                    - (1/(1-rhou_l))*(mu_l1*L1temp.^(1-1/psi_l1) + mu_l2*L2temp.^(1-1/psi_l2))^(1-rhou_l);
Utemp  = mu_0*Ctemp.^(-1/eta_cp);


end


