function [L1temp,L2temp,T1temp,T2temp,H1temp,H2temp,...
          Ytemp,atYtemp,Atemp,Ctemp,Vtemp,FVALtemp,CORcortemp,Utemp,LAM1temp,LAM2temp]=...
          solve_E2_0_nk(Aprev,w1,w2,parameters,EUfunc,EVsmall,...
          A_grid,tt)

eta_cp = parameters.eta_cp ;
MU_0  = parameters.mu_0  ;
psi_l1 = parameters.psi_l1 ;
psi_l2 = parameters.psi_l2 ;
rhou_l = parameters.rhou_l ;
MU_l1 = parameters.mu_l1 ;
MU_l2 = parameters.mu_l2 ;
L_bar = parameters.L_bar ;
KT    = parameters.KT;
CHI    = parameters.chi    ;
TAUMU  = parameters.taumu  ;
TAU_B  = parameters.tau_b  ;
r      = parameters.r  ;
amin   = parameters.amin  ;
beta   = parameters.beta  ;
apoints= parameters.apoints  ;

kt   = KT(tt);

chi  = CHI(kt);
taumu= TAUMU(kt);
tau_b= TAU_B(kt);

mu_l1= MU_l1(kt);
mu_l2= MU_l2(kt);
mu_0 = MU_0(kt);   

mu_l1_tild = mu_l1*(1/psi_l1-1);
mu_l2_tild = mu_l2*(1/psi_l2-1);

L1cor=zeros(1,4);
L2cor=zeros(size(L1cor));
T1cor=zeros(size(L1cor));
T2cor=zeros(size(L1cor));
H1cor=zeros(size(L1cor));
H2cor=zeros(size(L1cor));
Ycor =zeros(size(L1cor));
atYcor=zeros(size(L1cor));
mYcor =zeros(size(L1cor));
Acor =zeros(size(L1cor));
Ccor =zeros(size(L1cor));
Vcor =ones(size(L1cor))*(-inf);
FVALcor = zeros(size(L1cor));
CORcor = zeros(size(L1cor));
LAM1cor = zeros(size(L1cor));
LAM2cor = zeros(size(L1cor));

% Baseline: Constrained: H2
try
    L1_0 = [10^-9 1];
    ok=1; i=1;
    while i<10 && ok==1
    try
        f = @(L1)foc_corH2_nk(L1,w1,w2,Aprev,parameters,EUfunc,tt);
        [L1LAM2,fval]= fzero(f,L1_0); 
        ok=0;
    catch 
        L1_0(2) = L1_0(2)-0.1;
        i=i+1;
    end
    end
    L1cor(1) = L1LAM2(1);
    L2cor(1) = L_bar;
    T2cor(1) = 0;
    T1cor(1) = 0;
    H1cor(1) = L_bar-L1cor(1)-T1cor(1);
    H2cor(1) = L_bar-L2cor(1)-T2cor(1);
    Ycor(1)  = tau_b+w1*H1cor(1)+w2*H2cor(1);
    atYcor(1)= chi*Ycor(1)^(1-taumu);
    mYcor(1) = chi*(1-taumu)*(Ycor(1)^(-taumu));
    MULtemp  = (mu_l1*(L1cor(1)^(1-1/psi_l1)) + mu_l2*(L2cor(1)^(1-1/psi_l2)))^(-rhou_l);
    Ccor(1)  = (mu_0*mYcor(1)*w1/(MULtemp*mu_l1_tild*L1cor(1)^(-1/psi_l1)))^(eta_cp);
    Acor(1)  = (1+r)*(Aprev + atYcor(1) - Ccor(1));
    Aim = abs(imag(Acor(1)))>0;
    EV = interp1(A_grid,EVsmall,Acor(1)*Aim+(1-Aim)*min(Acor(1),A_grid(apoints)));
    Vcor(1)  = mu_0*(1/(1-1/eta_cp))*Ccor(1)^(1-1/eta_cp) ... 
                        - (1/(1-rhou_l))*(mu_l1*L1cor(1).^(1-1/psi_l1) + mu_l2*L2cor(1).^(1-1/psi_l2))^(1-rhou_l)...
                        + beta*EV;
    FVALcor(1)=fval;
    CORcor(1)=11;
if H1cor(1)<1e-9 || Acor(1)<amin
   Vcor(1)=-inf;
end
catch
   Vcor(1)=-inf;
end

% Calculate case constrained: A H2
if  Acor(1)<amin
    try
        L1_0 = [10^-9 1];
        ok=1; i=1;
        while i<10 && ok==1
        try
            f = @(L1)foc_cor_A_H2_nk(L1,w1,w2,Aprev,parameters,tt);
            [L1LAM2,fval]= fzero(f,L1_0); 
            ok=0;
        catch 
            L1_0(2) = L1_0(2)-0.1;
            i=i+1;
        end
        end
        L1cor(2) = L1LAM2(1);
        L2cor(2) = L_bar;
        T2cor(2) = 0;
        T1cor(2) = 0;
        H1cor(2) = L_bar-L1cor(2)-T1cor(2);
        H2cor(2) = L_bar-L2cor(2)-T2cor(2);
        Ycor(2)  = tau_b+w1*H1cor(2)+w2*H2cor(2);
        atYcor(2)= chi*Ycor(2)^(1-taumu);
        mYcor(2) = chi*(1-taumu)*(Ycor(2)^(-taumu));
        Acor(2)  = amin; 
        Ccor(2)  = Aprev + atYcor(2) - Acor(2)/(1+r);
        Aim = abs(imag(Acor(2)))>0;
        EV = interp1(A_grid,EVsmall,Acor(2)*Aim+(1-Aim)*min(Acor(2),A_grid(apoints)));
        Vcor(2)  = mu_0*(1/(1-1/eta_cp))*Ccor(2)^(1-1/eta_cp) ... 
                            - (1/(1-rhou_l))*(mu_l1*L1cor(2).^(1-1/psi_l1) + mu_l2*L2cor(2).^(1-1/psi_l2))^(1-rhou_l)...
                            + beta*EV;

        FVALcor(2)=fval;
        CORcor(2)=12;
    if H1cor(2)<1e-9
       Vcor(2)=-inf;
    end
    catch
       Vcor(2)=-inf;
    end
end

% Calculate case constrained: H1 H2
if Aprev>0 && H1cor(1)<1e-9 
    try
        L1L2A_0=[A_grid(2) (chi*tau_b^(1-taumu) + Aprev)*(1+r)-10^-9];
        ok=1; i=1;
        while i<10 && ok==1
        try
            f = @(L1L2A)foc_corH1H2_nk(L1L2A,w1,w2,Aprev,parameters,EUfunc,tt);
            [L1L2A,fval]= fzero(f,L1L2A_0); 
            ok=0;
        catch 
            L1L2A_0(2) = L1L2A_0(2)-0.1;
            i=i+1;
        end
        end
        Acor(3)  = L1L2A(1);
        L1cor(3) = L_bar ;
        L2cor(3) = L_bar ;
        T1cor(3) = 0;
        T2cor(3) = 0;
        H1cor(3) = 0;
        H2cor(3) = 0;
        Ycor(3)  = tau_b + w1*H1cor(3) + w2*H2cor(3);
        atYcor(3)= chi*Ycor(3)^(1-taumu);
        Ccor(3)  = atYcor(3) + Aprev-Acor(3)/(1+r);
        Aim = abs(imag(Acor(3)))>0;
        EV = interp1(A_grid,EVsmall,Acor(3)*Aim+(1-Aim)*min(Acor(3),A_grid(apoints)));
        Vcor(3)  = mu_0*(1/(1-1/eta_cp))*Ccor(3)^(1-1/eta_cp) ... 
                            - (1/(1-rhou_l))*(mu_l1*L1cor(3).^(1-1/psi_l1) + mu_l2*L2cor(3).^(1-1/psi_l2))^(1-rhou_l)...
                            + beta*EV;
        FVALcor(3)=fval;
        CORcor(3)=13;
    if Acor(3)<amin || Ccor(3)<=0
       Vcor(3)=-inf;
    end
    catch
       Vcor(3)=-inf;
    end
end


% Calculate case constrained: A H1 H2
L1cor(4) = L_bar;
L2cor(4) = L_bar;
T1cor(4) = 0;
T2cor(4) = 0;
H1cor(4) = 0;
H2cor(4) = 0;
Ycor(4)  = tau_b + w1*H1cor(4) + w2*H2cor(4);
atYcor(4)= chi*Ycor(4)^(1-taumu);
Acor(4)  = amin;
Ccor(4)  = Aprev + atYcor(4) - Acor(4)/(1+r);
EV       = interp1(A_grid,EVsmall,Acor(4));
Vcor(4)  = mu_0*(1/(1-1/eta_cp))*Ccor(4)^(1-1/eta_cp) ... 
                    - (1/(1-rhou_l))*(mu_l1*L1cor(4).^(1-1/psi_l1) + mu_l2*L2cor(4).^(1-1/psi_l2))^(1-rhou_l)...
                    + beta*EV;
FVALcor(4)=0;
CORcor(4)=14;

%% Choose the maximum within corners
[~,ii]=max(Vcor);
L1temp = L1cor(ii); 
T1temp = T1cor(ii);
L2temp = L2cor(ii);
T2temp = T2cor(ii);
H1temp = H1cor(ii); 
H2temp = H2cor(ii);
Ytemp  = Ycor(ii); 
atYtemp= atYcor(ii);
Atemp  = Acor(ii); 
Ctemp  = Ccor(ii);
Vtemp  = Vcor(ii);
FVALtemp  = FVALcor(ii);
CORcortemp  = CORcor(ii);
Utemp  = mu_0*Ctemp.^(-1/eta_cp);
LAM1temp  = LAM1cor(ii);
LAM2temp  = LAM2cor(ii);


end
      



