function v=ppvalshort(pp,xx)
% pp is a linear piecewise function
% x is a vector

xs = xx;

% take apart PP
b = pp.breaks; 
c = pp.coefs;

% for each evaluation site, compute its breakpoint interval
diff = abs(b-xs);
[~,index]=min(diff);
if b(index)-xs>0, index=index-1; end
if index==0, index=1; end
if index==length(b), index=index-1; end

% now go to local coordinates 
xs = xs-b(index);
v = xs*c(index,1) + c(index,2);

end
