function policy_calcs =policy_calc(parameters,simul_output)

%% this does policy calculations using the simulation output

r     = parameters.r;
tau_b = parameters.tau_b;
KTlarge = parameters.KTlarge;
TT    = parameters.TT;

% Prepare variables
tau_b_scaled= 4160*tau_b;
labor_Y = simul_output.Y_simul - tau_b_scaled(simul_output.kt_simul);
atY = simul_output.atY_simul;
Y = simul_output.Y_simul;

discfact = zeros(size(labor_Y));
for i=1:size(labor_Y,2)
    discfact(:,i) = (1/(1+r))^(i-1);
end

net_tax = labor_Y - atY;
net_tax_disc = discfact.*net_tax;
labor_Y_disc = discfact.*labor_Y;
Y_disc = discfact.*Y;
atY_disc = discfact.*atY;

% Calcualte the variables for 3 periods: pre-kids, kids, post-kids
temp = KTlarge(1,2:TT)-KTlarge(1,1:TT-1);
T1 = find(temp==-1);
T2 = find(temp==1);

pre =zeros(size(Y));
pre(:,1:T1)=1; 
kids=zeros(size(Y));
kids(:,T1+1:T2)=1; 
post=zeros(size(Y));
post(:,T2+1:TT)=1; 

cohort_tax_disc_pre = mean(net_tax_disc(pre==1));
cohort_labor_Y_disc_pre = mean(labor_Y_disc(pre==1));
cohort_Y_disc_pre = mean(Y_disc(pre==1));
cohort_atY_disc_pre = mean(atY_disc(pre==1));

cohort_tax_disc_kids = mean(net_tax_disc(kids==1));
cohort_labor_Y_disc_kids = mean(labor_Y_disc(kids==1));
cohort_Y_disc_kids = mean(Y_disc(kids==1));
cohort_atY_disc_kids = mean(atY_disc(kids==1));

cohort_tax_disc_post = mean(net_tax_disc(post==1));
cohort_labor_Y_disc_post = mean(labor_Y_disc(post==1));
cohort_Y_disc_post = mean(Y_disc(post==1));
cohort_atY_disc_post = mean(atY_disc(post==1));

policy_calcs.cohort_tax_disc_pre 	   = cohort_tax_disc_pre 	;
policy_calcs.cohort_labor_Y_disc_pre   = cohort_labor_Y_disc_pre ;
policy_calcs.cohort_Y_disc_pre 		   = cohort_Y_disc_pre 		;
policy_calcs.cohort_atY_disc_pre 	   = cohort_atY_disc_pre    ;

policy_calcs.cohort_tax_disc_kids 	   = cohort_tax_disc_kids 	;
policy_calcs.cohort_labor_Y_disc_kids  = cohort_labor_Y_disc_kids;
policy_calcs.cohort_Y_disc_kids 	   = cohort_Y_disc_kids 	;	
policy_calcs.cohort_atY_disc_kids 	   = cohort_atY_disc_kids 	;	

policy_calcs.cohort_tax_disc_post 	   = cohort_tax_disc_post 	;
policy_calcs.cohort_labor_Y_disc_post  = cohort_labor_Y_disc_post;
policy_calcs.cohort_Y_disc_post 	   = cohort_Y_disc_post 	;	
policy_calcs.cohort_atY_disc_post 	   = cohort_atY_disc_post 	;	

policy_calcs.T1                        = T1                     ;	
policy_calcs.T2                        = T2                     ;	


