function moments= moment_match(T1_simul,T2_simul,H1_simul,H2_simul,C_simul,kt_simul,Z2,n,t1,t2)

% this function will calculate the simulated moments for the range t1 to t2
% (inclusive). It will return moments from the model and the objective will
% be then calculated outside using the relevant objective function. 

% The list of moments in this code (applied to any simulation input):
% m1: mean of H2 (including zeros) 
% m2: mean of H1 (including zeros) 
% m3: mean of T2 
% m4: mean of T1 
% m5: mean employment of wife E2
% m6: 75-50 of H2 
% m7: Change in consumption when kid is born


% Calculate moments
moments = zeros(7,1);

moments(1)=mean(mean(H2_simul(:,t1:t2))); 
moments(2)=mean(mean(H1_simul(:,t1:t2))); 
moments(3)=mean(mean(T2_simul(:,t1:t2))); 
moments(4)=mean(mean(T1_simul(:,t1:t2))); 
moments(5)=1-mean(mean(Z2(:,t1:t2))); 
pc75 = prctile(reshape(H2_simul(:,t1:t2),(t2-t1+1)*n,1),75);
pc50 = prctile(reshape(H2_simul(:,t1:t2),(t2-t1+1)*n,1),50);
moments(6)=pc75-pc50; 

young_simul = kt_simul==1;
dlogc  = zeros(n,t2-1);
dyoung= zeros(n,t2-1);
i=1;
for tau=2:t2
    dlogc(:,i)  = log(C_simul(:,tau))-log(C_simul(:,tau-1));
    dyoung(:,i) = young_simul(:,tau)-young_simul(:,tau-1);
    i=i+1;
end

dlogc_long=reshape(dlogc,(t2-1)*n,1);
dyoung_long=reshape(dyoung,(t2-1)*n,1);
UNOS = ones(size(dyoung_long));

b1 = regress(dlogc_long,[UNOS dyoung_long]);
if imag(b1(2))>0
    b1(2)=NaN;
end
moments(7)=b1(2); 

