function F=foc_cor_A_H1(L2LAM1,w1,w2,Aprev,parameters,tt,norm_switch)

L2 = L2LAM1(1);
LAM1 = L2LAM1(2);

%% Assign parameters
eta_cp = parameters.eta_cp ;
MU_0  = parameters.mu_0  ;
psi_l1 = parameters.psi_l1 ;
psi_l2 = parameters.psi_l2 ;
rhou_l = parameters.rhou_l ;
MU_l1 = parameters.mu_l1 ;
MU_l2 = parameters.mu_l2 ;
psi_t1 = parameters.psi_t1 ;
psi_t2 = parameters.psi_t2 ;
rhou_t = parameters.rhou_t ;
MU_t1 = parameters.mu_t1 ;
MU_t2 = parameters.mu_t2 ;
L_bar = parameters.L_bar ;
r     = parameters.r ;
beta  = parameters.beta;
amin = parameters.amin ;
KT    = parameters.KT;
CHI    = parameters.chi    ;
TAUMU  = parameters.taumu  ;
TAU_B  = parameters.tau_b  ;
TAU_GAMMA= parameters.tau_gamma;

kt   = KT(tt);

chi  = CHI(kt);
taumu= TAUMU(kt);
tau_b= TAU_B(kt);
tau_gamma= TAU_GAMMA(kt);

mu_l1= MU_l1(kt);
mu_l2= MU_l2(kt);
mu_t1= MU_t1(kt);
mu_t2= MU_t2(kt);
mu_0 = MU_0(kt);

mu_l1_tild = mu_l1*(1/psi_l1-1);
mu_l2_tild = mu_l2*(1/psi_l2-1);
mu_t1_tild = mu_t1*(1/psi_t1-1);
mu_t2_tild = mu_t2*(1/psi_t2-1);

L1 = (((mu_l2_tild/mu_l1_tild)*(w1/w2 + LAM1))^(-psi_l1))*L2^(psi_l1/psi_l2);
T1 = L_bar - L1;
if T1<=0
   T1 = 10^-6;
end
T2 = (((mu_t2_tild/mu_t1_tild)*(w1/w2 + LAM1))^( psi_t2))*T1^(psi_t2/psi_t1);
if T2<=10^-6
   T2 = 10^-6;
end

H2 = L_bar-L2-T2;
H1 = 0;

Y   = tau_b+w1*H1+w2*H2;
if Y<=0
   Y = 10^-9;
end
atY = chi*Y^(1-taumu) - tau_gamma;
mY  = chi*(1-taumu)*(Y^(-taumu));

MUL = (mu_l1*(L1^(1-1/psi_l1))... 
     + mu_l2*(L2^(1-1/psi_l2)))^(-rhou_l);

MUT = (mu_t1*(T1^(1-1/psi_t1))... 
     + mu_t2*(T2^(1-1/psi_t2)))^(-rhou_t);

C   = atY + Aprev - amin/(1+r);
if C<=0 
   C = 10^-6;
end

F = zeros(2,1);
F(1) = (MUL*mu_l2_tild*L2^(-1/psi_l2) - mY*w2*mu_0*C^(-1/eta_cp))/(mY*w2*mu_0*C^(-1/eta_cp));
F(2) = (MUL*mu_l1_tild*L1^(-1/psi_l1) - MUT*mu_t1_tild*T1^(-1/psi_t1))/(MUL*mu_l1_tild*L1^(-1/psi_l1));
if norm_switch == 1
	F(1) = (MUL*mu_l2_tild*L2^(-1/psi_l2) - mY*w2*mu_0*C^(-1/eta_cp))/(MUL*mu_l2_tild*L2^(-1/psi_l2));
end
if norm_switch == 2
	F(2) = (MUL*mu_l1_tild*L1^(-1/psi_l1) - MUT*mu_t1_tild*T1^(-1/psi_t1))/(MUT*mu_t1_tild*T1^(-1/psi_t1));
end
if norm_switch == 12
	F(1) = (MUL*mu_l2_tild*L2^(-1/psi_l2) - mY*w2*mu_0*C^(-1/eta_cp))/(MUL*mu_l2_tild*L2^(-1/psi_l2));
	F(2) = (MUL*mu_l1_tild*L1^(-1/psi_l1) - MUT*mu_t1_tild*T1^(-1/psi_t1))/(MUT*mu_t1_tild*T1^(-1/psi_t1));
end



