function F=foc_corH2_nk(L1LAM2,w1,w2,Aprev,parameters,EUfunc,tt)

L1 = L1LAM2(1);

%% Assign parameters
eta_cp = parameters.eta_cp ;
MU_0  = parameters.mu_0  ;
psi_l1 = parameters.psi_l1 ;
psi_l2 = parameters.psi_l2 ;
rhou_l = parameters.rhou_l ;
MU_l1 = parameters.mu_l1 ;
MU_l2 = parameters.mu_l2 ;
psi_t1 = parameters.psi_t1 ;
psi_t2 = parameters.psi_t2 ;
rhou_t = parameters.rhou_t ;
MU_t1 = parameters.mu_t1 ;
MU_t2 = parameters.mu_t2 ;
L_bar = parameters.L_bar ;
r     = parameters.r ;
beta  = parameters.beta;
KT    = parameters.KT;
CHI    = parameters.chi    ;
TAUMU  = parameters.taumu  ;
TAU_B  = parameters.tau_b  ;
TAU_GAMMA= parameters.tau_gamma;

kt   = KT(tt);

chi  = CHI(kt);
taumu= TAUMU(kt);
tau_b= TAU_B(kt);
tau_gamma= TAU_GAMMA(kt);

mu_l1= MU_l1(kt);
mu_l2= MU_l2(kt);
mu_0 = MU_0(kt);

mu_l1_tild = mu_l1*(1/psi_l1-1);
mu_l2_tild = mu_l2*(1/psi_l2-1);

L2 = L_bar;
T2 = 0;
T1 = 0;

H1 = L_bar-L1-T1;
H2 = 0;

Y   = tau_b+w1*H1+w2*H2;
atY = chi*Y^(1-taumu) - tau_gamma;
mY  = chi*(1-taumu)*(Y^(-taumu));

MUL = (mu_l1*(L1^(1-1/psi_l1))... 
     + mu_l2*(L2^(1-1/psi_l2)))^(-rhou_l);

C = (mu_0*mY*w1/(MUL*mu_l1_tild*L1^(-1/psi_l1)))^(eta_cp);
A = (1+r)*(Aprev + atY - C); 

EU = ppval(EUfunc,A);

F = (mu_0*C^(-1/eta_cp) - (1+r)*beta*EU)/abs(mu_0*C^(-1/eta_cp));


