function F=foc_corA_nk(LT1,w1,w2,Aprev,parameters,tt)
L1 = LT1(1);

%% Assign parameters
eta_cp = parameters.eta_cp ;
MU_0  = parameters.mu_0  ;
psi_l1 = parameters.psi_l1 ;
psi_l2 = parameters.psi_l2 ;
rhou_l = parameters.rhou_l ;
MU_l1 = parameters.mu_l1 ;
MU_l2 = parameters.mu_l2 ;
psi_t1 = parameters.psi_t1 ;
psi_t2 = parameters.psi_t2 ;
rhou_t = parameters.rhou_t ;
MU_t1 = parameters.mu_t1 ;
MU_t2 = parameters.mu_t2 ;
chi   = parameters.chi ;
taumu = parameters.taumu ;
L_bar = parameters.L_bar ;
r     = parameters.r ;
amin  = parameters.amin ;
KT    = parameters.KT;
tau_b = parameters.tau_b;
CHI    = parameters.chi    ;
TAUMU  = parameters.taumu  ;
TAU_B  = parameters.tau_b  ;
TAU_GAMMA= parameters.tau_gamma;

kt   = KT(tt);

chi  = CHI(kt);
taumu= TAUMU(kt);
tau_b= TAU_B(kt);
tau_gamma= TAU_GAMMA(kt);

mu_l1= MU_l1(kt);
mu_l2= MU_l2(kt);
mu_0 = MU_0(kt);

mu_l1_tild = mu_l1*(1/psi_l1-1);
mu_l2_tild = mu_l2*(1/psi_l2-1);

L2 = ((w1/w2)*(mu_l2_tild/mu_l1_tild)*L1^(1/psi_l1))^psi_l2;

H1 = L_bar-L1;
H2 = L_bar-L2;

Y   = tau_b+w1*H1+w2*H2;
atY = chi*Y^(1-taumu) - tau_gamma;
mY  = chi*(1-taumu)*(Y^(-taumu));
C   = atY + Aprev - amin/(1+r);   

MUL = (mu_l1*(L1^(1-1/psi_l1))... 
     + mu_l2*(L2^(1-1/psi_l2)))^(-rhou_l);

F = (MUL*mu_l1_tild*L1^(-1/psi_l1) - mY*w1*mu_0*C^(-1/eta_cp))/abs(mY*w1*mu_0*C^(-1/eta_cp));


