function [] = calc_elasticities(out,means,dirname,shock_t,ver)

subdirname = strcat(dirname,'/t',num2str(shock_t));
vernum = ver;

if vernum == 1
    fname = '/v1';
    wind = 10;
elseif vernum == 2
    fname = '/v2';
    wind = 11;
elseif vernum == 3
    fname = '/u1';
    wind = 10;
elseif vernum == 4
    fname = '/u2';
    wind = 11;
end

out1     = out(1:17,:);
C_elast  = out1(1,:)./out1(wind,shock_t);
H1_elast = out1(2,:)./out1(wind,shock_t);
H2_elast = out1(3,:)./out1(wind,shock_t);
E1_elast = out1(4,:)./out1(wind,shock_t);
E2_elast = out1(5,:)./out1(wind,shock_t);
L1_elast = out1(6,:)./out1(wind,shock_t);
L2_elast = out1(7,:)./out1(wind,shock_t);
T1_elast = out1(8,:)./out1(wind,shock_t);
T2_elast = out1(9,:)./out1(wind,shock_t);
w1_elast = out1(10,:)./out1(wind,shock_t);
w2_elast = out1(11,:)./out1(wind,shock_t);
H2c_elast= out1(12,:)./out1(wind,shock_t);
Y1_elast = out1(13,:)./out1(wind,shock_t);
Y2_elast = out1(14,:)./out1(wind,shock_t);
Y_elast  = out1(15,:)./out1(wind,shock_t);
atY_elast= out1(16,:)./out1(wind,shock_t);
Y2c_elast= out1(17,:)./out1(wind,shock_t);

out2     = out(18:29,:);
C_elast_nk  = out2(1,:)./out2(wind,shock_t);
H1_elast_nk = out2(2,:)./out2(wind,shock_t);
H2_elast_nk = out2(3,:)./out2(wind,shock_t);
E1_elast_nk = out2(4,:)./out2(wind,shock_t);
E2_elast_nk = out2(5,:)./out2(wind,shock_t);
L1_elast_nk = out2(6,:)./out2(wind,shock_t);
L2_elast_nk = out2(7,:)./out2(wind,shock_t);
T1_elast_nk = out2(8,:)./out2(wind,shock_t);
T2_elast_nk = out2(9,:)./out2(wind,shock_t);
w1_elast_nk = out2(10,:)./out2(wind,shock_t);
w2_elast_nk = out2(11,:)./out2(wind,shock_t);
H2c_elast_nk= out2(12,:)./out2(wind,shock_t);

out3     = out(30:41,:);
C_elast_lowA  = out3(1,:)./out3(wind,shock_t);
H1_elast_lowA = out3(2,:)./out3(wind,shock_t);
H2_elast_lowA = out3(3,:)./out3(wind,shock_t);
E1_elast_lowA = out3(4,:)./out3(wind,shock_t);
E2_elast_lowA = out3(5,:)./out3(wind,shock_t);
L1_elast_lowA = out3(6,:)./out3(wind,shock_t);
L2_elast_lowA = out3(7,:)./out3(wind,shock_t);
T1_elast_lowA = out3(8,:)./out3(wind,shock_t);
T2_elast_lowA = out3(9,:)./out3(wind,shock_t);
w1_elast_lowA = out3(10,:)./out3(wind,shock_t);
w2_elast_lowA = out3(11,:)./out3(wind,shock_t);
H2c_elast_lowA= out3(12,:)./out3(wind,shock_t);

out4     = out(42:53,:);
C_elast_higA  = out4(1,:)./out4(wind,shock_t);
H1_elast_higA = out4(2,:)./out4(wind,shock_t);
H2_elast_higA = out4(3,:)./out4(wind,shock_t);
E1_elast_higA = out4(4,:)./out4(wind,shock_t);
E2_elast_higA = out4(5,:)./out4(wind,shock_t);
L1_elast_higA = out4(6,:)./out4(wind,shock_t);
L2_elast_higA = out4(7,:)./out4(wind,shock_t);
T1_elast_higA = out4(8,:)./out4(wind,shock_t);
T2_elast_higA = out4(9,:)./out4(wind,shock_t);
w1_elast_higA = out4(10,:)./out4(wind,shock_t);
w2_elast_higA = out4(11,:)./out4(wind,shock_t);
H2c_elast_higA= out4(12,:)./out4(wind,shock_t);

table5_row      = [C_elast(shock_t) C_elast_nk(shock_t) H1_elast(shock_t) H1_elast_nk(shock_t)...
                   H2_elast(shock_t) H2_elast_nk(shock_t) E2_elast(shock_t) E2_elast_nk(shock_t)...
                   H2c_elast(shock_t) H2c_elast_nk(shock_t)...
                   L1_elast(shock_t) L1_elast_nk(shock_t) L2_elast(shock_t) L2_elast_nk(shock_t)...
                   T1_elast(shock_t) T2_elast(shock_t)...
                   Y1_elast(shock_t) Y2_elast(shock_t) Y_elast(shock_t) atY_elast(shock_t)];
table5_row_lowA = [C_elast_lowA(shock_t) C_elast_higA(shock_t) H1_elast_lowA(shock_t) H1_elast_higA(shock_t)...
                   H2_elast_lowA(shock_t) H2_elast_higA(shock_t) E2_elast_lowA(shock_t) E2_elast_higA(shock_t)... 
                   H2c_elast_lowA(shock_t) H2c_elast_higA(shock_t)...
                   L1_elast_lowA(shock_t) L1_elast_higA(shock_t) L2_elast_lowA(shock_t) L2_elast_higA(shock_t)... 
                   T1_elast_lowA(shock_t) T1_elast_higA(shock_t) T2_elast_lowA(shock_t) T2_elast_higA(shock_t)];

              
save(strcat(subdirname,fname,'_table5_6'),'table5_row')
save(strcat(subdirname,fname,'_table5_6_lowA'),'table5_row_lowA')

dlmwrite(strcat(subdirname,fname,'_table5_6.csv'),table5_row);
dlmwrite(strcat(subdirname,fname,'_table5_6_lowA.csv'),table5_row_lowA);

%% Keep husband and wife's share pre shock
if vernum == 1
    share_out=[means(18,shock_t),means(19,shock_t)];
    dlmwrite(strcat(subdirname,'/mean_shares.csv'),share_out);
end               
