/*
 * Copyright 1984-2012 The MathWorks, Inc.
 * All Rights Reserved.
 */

/*
 *  Header File include/mllapack.h
 *  Auto generated by f2h.pl, do not modify by hand
 */

#if defined(_MSC_VER)
# pragma once
#endif
#if defined(__GNUC__) && (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ > 3))
# pragma once
#endif

#ifndef mllapack_h
#define mllapack_h

#if !defined(MW_HAVE_LAPACK_DECLS) && defined(_LAPACKE_H_) /* %#ok */
#error "The files lapack.h and lapacke.h may not be simultaneously included because of conflicting declarations of LAPACK routines. Include at most one of these headers in each source file." /* %#ok */
#else  /* %#ok */
#if defined(_WIN32) || defined(__hpux)
#define FORTRAN_WRAPPER(x) x
#else
#define FORTRAN_WRAPPER(x) x ## _
#endif

#ifndef COMPLEX_TYPES
#define COMPLEX_TYPES
  typedef struct{float r,i;} complex;
  typedef struct{double r,i;} doublecomplex;
#endif

#ifdef __cplusplus
    extern "C" {
#endif


/* Source: dlamch.f */
#define dlamch FORTRAN_WRAPPER(dlamch)
extern double dlamch(
    const char   *cmach
);

/* Source: dlamch.f */
#define dlamc3 FORTRAN_WRAPPER(dlamc3)
extern double dlamc3(
    const double *a,
    const double *b
);

/* Source: slamch.f */
#define slamch FORTRAN_WRAPPER(slamch)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slamch(
#else
extern float slamch(
#endif 
    const char   *cmach
);

/* Source: slamch.f */
#define slamc3 FORTRAN_WRAPPER(slamc3)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slamc3(
#else
extern float slamc3(
#endif 
    const float  *a,
    const float  *b
);

/* Source: cbbcsd.f */
#define cbbcsd FORTRAN_WRAPPER(cbbcsd)
extern void cbbcsd(
    const char   *jobu1,
    const char   *jobu2,
    const char   *jobv1t,
    const char   *jobv2t,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *q,
    float  *theta,
    float  *phi,
    float  *u1,
    const ptrdiff_t *ldu1,
    float  *u2,
    const ptrdiff_t *ldu2,
    float  *v1t,
    const ptrdiff_t *ldv1t,
    float  *v2t,
    const ptrdiff_t *ldv2t,
    float  *b11d,
    float  *b11e,
    float  *b12d,
    float  *b12e,
    float  *b21d,
    float  *b21e,
    float  *b22d,
    float  *b22e,
    float  *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *info
);

/* Source: cbdsqr.f */
#define cbdsqr FORTRAN_WRAPPER(cbdsqr)
extern void cbdsqr(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ncvt,
    const ptrdiff_t *nru,
    const ptrdiff_t *ncc,
    float  *d,
    float  *e,
    float  *vt,
    const ptrdiff_t *ldvt,
    float  *u,
    const ptrdiff_t *ldu,
    float  *c,
    const ptrdiff_t *ldc,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgbbrd.f */
#define cgbbrd FORTRAN_WRAPPER(cgbbrd)
extern void cgbbrd(
    const char   *vect,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *ncc,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *d,
    float  *e,
    float  *q,
    const ptrdiff_t *ldq,
    float  *pt,
    const ptrdiff_t *ldpt,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgbcon.f */
#define cgbcon FORTRAN_WRAPPER(cgbcon)
extern void cgbcon(
    const char   *norm,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const float  *ab,
    const ptrdiff_t *ldab,
    const ptrdiff_t *ipiv,
    const float  *anorm,
    float  *rcond,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgbequ.f */
#define cgbequ FORTRAN_WRAPPER(cgbequ)
extern void cgbequ(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *r,
    float  *c,
    float  *rowcnd,
    float  *colcnd,
    float  *amax,
    ptrdiff_t *info
);

/* Source: cgbequb.f */
#define cgbequb FORTRAN_WRAPPER(cgbequb)
extern void cgbequb(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *r,
    float  *c,
    float  *rowcnd,
    float  *colcnd,
    float  *amax,
    ptrdiff_t *info
);

/* Source: cgbrfs.f */
#define cgbrfs FORTRAN_WRAPPER(cgbrfs)
extern void cgbrfs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    const float  *ab,
    const ptrdiff_t *ldab,
    const float  *afb,
    const ptrdiff_t *ldafb,
    const ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgbsv.f */
#define cgbsv FORTRAN_WRAPPER(cgbsv)
extern void cgbsv(
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    float  *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cgbsvx.f */
#define cgbsvx FORTRAN_WRAPPER(cgbsvx)
extern void cgbsvx(
    const char   *fact,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *afb,
    const ptrdiff_t *ldafb,
    ptrdiff_t *ipiv,
    char   *equed,
    float  *r,
    float  *c,
    float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgbtf2.f */
#define cgbtf2 FORTRAN_WRAPPER(cgbtf2)
extern void cgbtf2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    float  *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: cgbtrf.f */
#define cgbtrf FORTRAN_WRAPPER(cgbtrf)
extern void cgbtrf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    float  *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: cgbtrs.f */
#define cgbtrs FORTRAN_WRAPPER(cgbtrs)
extern void cgbtrs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    const float  *ab,
    const ptrdiff_t *ldab,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cgebak.f */
#define cgebak FORTRAN_WRAPPER(cgebak)
extern void cgebak(
    const char   *job,
    const char   *side,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    const float  *scale,
    const ptrdiff_t *m,
    float  *v,
    const ptrdiff_t *ldv,
    ptrdiff_t *info
);

/* Source: cgebal.f */
#define cgebal FORTRAN_WRAPPER(cgebal)
extern void cgebal(
    const char   *job,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    float  *scale,
    ptrdiff_t *info
);

/* Source: cgebd2.f */
#define cgebd2 FORTRAN_WRAPPER(cgebd2)
extern void cgebd2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *d,
    float  *e,
    float  *tauq,
    float  *taup,
    float  *work,
    ptrdiff_t *info
);

/* Source: cgebrd.f */
#define cgebrd FORTRAN_WRAPPER(cgebrd)
extern void cgebrd(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *d,
    float  *e,
    float  *tauq,
    float  *taup,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cgecon.f */
#define cgecon FORTRAN_WRAPPER(cgecon)
extern void cgecon(
    const char   *norm,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *anorm,
    float  *rcond,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgeequ.f */
#define cgeequ FORTRAN_WRAPPER(cgeequ)
extern void cgeequ(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *r,
    float  *c,
    float  *rowcnd,
    float  *colcnd,
    float  *amax,
    ptrdiff_t *info
);

/* Source: cgeequb.f */
#define cgeequb FORTRAN_WRAPPER(cgeequb)
extern void cgeequb(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *r,
    float  *c,
    float  *rowcnd,
    float  *colcnd,
    float  *amax,
    ptrdiff_t *info
);

/* Source: cgees.f */
#define cgees FORTRAN_WRAPPER(cgees)
extern void cgees(
    const char   *jobvs,
    const char   *sort,
    ptrdiff_t (*select)(),
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *sdim,
    float  *w,
    float  *vs,
    const ptrdiff_t *ldvs,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: cgeesx.f */
#define cgeesx FORTRAN_WRAPPER(cgeesx)
extern void cgeesx(
    const char   *jobvs,
    const char   *sort,
    ptrdiff_t (*select)(),
    const char   *sense,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *sdim,
    float  *w,
    float  *vs,
    const ptrdiff_t *ldvs,
    float  *rconde,
    float  *rcondv,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: cgeev.f */
#define cgeev FORTRAN_WRAPPER(cgeev)
extern void cgeev(
    const char   *jobvl,
    const char   *jobvr,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *w,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgeevx.f */
#define cgeevx FORTRAN_WRAPPER(cgeevx)
extern void cgeevx(
    const char   *balanc,
    const char   *jobvl,
    const char   *jobvr,
    const char   *sense,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *w,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    float  *scale,
    float  *abnrm,
    float  *rconde,
    float  *rcondv,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgegs.f */
#define cgegs FORTRAN_WRAPPER(cgegs)
extern void cgegs(
    const char   *jobvsl,
    const char   *jobvsr,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *alpha,
    float  *beta,
    float  *vsl,
    const ptrdiff_t *ldvsl,
    float  *vsr,
    const ptrdiff_t *ldvsr,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgegv.f */
#define cgegv FORTRAN_WRAPPER(cgegv)
extern void cgegv(
    const char   *jobvl,
    const char   *jobvr,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *alpha,
    float  *beta,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgehd2.f */
#define cgehd2 FORTRAN_WRAPPER(cgehd2)
extern void cgehd2(
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: cgehrd.f */
#define cgehrd FORTRAN_WRAPPER(cgehrd)
extern void cgehrd(
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cgelq2.f */
#define cgelq2 FORTRAN_WRAPPER(cgelq2)
extern void cgelq2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: cgelqf.f */
#define cgelqf FORTRAN_WRAPPER(cgelqf)
extern void cgelqf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cgels.f */
#define cgels FORTRAN_WRAPPER(cgels)
extern void cgels(
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cgelsd.f */
#define cgelsd FORTRAN_WRAPPER(cgelsd)
extern void cgelsd(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *s,
    const float  *rcond,
    ptrdiff_t *rank,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: cgelss.f */
#define cgelss FORTRAN_WRAPPER(cgelss)
extern void cgelss(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *s,
    const float  *rcond,
    ptrdiff_t *rank,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgelsx.f */
#define cgelsx FORTRAN_WRAPPER(cgelsx)
extern void cgelsx(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *jpvt,
    const float  *rcond,
    ptrdiff_t *rank,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgelsy.f */
#define cgelsy FORTRAN_WRAPPER(cgelsy)
extern void cgelsy(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *jpvt,
    const float  *rcond,
    ptrdiff_t *rank,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgemqrt.f */
#define cgemqrt FORTRAN_WRAPPER(cgemqrt)
extern void cgemqrt(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *nb,
    const float  *v,
    const ptrdiff_t *ldv,
    const float  *t,
    const ptrdiff_t *ldt,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: cgeql2.f */
#define cgeql2 FORTRAN_WRAPPER(cgeql2)
extern void cgeql2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: cgeqlf.f */
#define cgeqlf FORTRAN_WRAPPER(cgeqlf)
extern void cgeqlf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cgeqp3.f */
#define cgeqp3 FORTRAN_WRAPPER(cgeqp3)
extern void cgeqp3(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgeqpf.f */
#define cgeqpf FORTRAN_WRAPPER(cgeqpf)
extern void cgeqpf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    float  *tau,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgeqr2.f */
#define cgeqr2 FORTRAN_WRAPPER(cgeqr2)
extern void cgeqr2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: cgeqr2p.f */
#define cgeqr2p FORTRAN_WRAPPER(cgeqr2p)
extern void cgeqr2p(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: cgeqrf.f */
#define cgeqrf FORTRAN_WRAPPER(cgeqrf)
extern void cgeqrf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cgeqrfp.f */
#define cgeqrfp FORTRAN_WRAPPER(cgeqrfp)
extern void cgeqrfp(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cgeqrt.f */
#define cgeqrt FORTRAN_WRAPPER(cgeqrt)
extern void cgeqrt(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    float  *a,
    const ptrdiff_t *lda,
    float  *t,
    const ptrdiff_t *ldt,
    float  *work,
    ptrdiff_t *info
);

/* Source: cgeqrt2.f */
#define cgeqrt2 FORTRAN_WRAPPER(cgeqrt2)
extern void cgeqrt2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *t,
    const ptrdiff_t *ldt,
    ptrdiff_t *info
);

/* Source: cgeqrt3.f */
#define cgeqrt3 FORTRAN_WRAPPER(cgeqrt3)
extern void cgeqrt3(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *t,
    const ptrdiff_t *ldt,
    ptrdiff_t *info
);

/* Source: cgerfs.f */
#define cgerfs FORTRAN_WRAPPER(cgerfs)
extern void cgerfs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *af,
    const ptrdiff_t *ldaf,
    const ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgerq2.f */
#define cgerq2 FORTRAN_WRAPPER(cgerq2)
extern void cgerq2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: cgerqf.f */
#define cgerqf FORTRAN_WRAPPER(cgerqf)
extern void cgerqf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cgesc2.f */
#define cgesc2 FORTRAN_WRAPPER(cgesc2)
extern void cgesc2(
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *rhs,
    const ptrdiff_t *ipiv,
    const ptrdiff_t *jpiv,
    float  *scale
);

/* Source: cgesdd.f */
#define cgesdd FORTRAN_WRAPPER(cgesdd)
extern void cgesdd(
    const char   *jobz,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *s,
    float  *u,
    const ptrdiff_t *ldu,
    float  *vt,
    const ptrdiff_t *ldvt,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: cgesv.f */
#define cgesv FORTRAN_WRAPPER(cgesv)
extern void cgesv(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cgesvd.f */
#define cgesvd FORTRAN_WRAPPER(cgesvd)
extern void cgesvd(
    const char   *jobu,
    const char   *jobvt,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *s,
    float  *u,
    const ptrdiff_t *ldu,
    float  *vt,
    const ptrdiff_t *ldvt,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgesvx.f */
#define cgesvx FORTRAN_WRAPPER(cgesvx)
extern void cgesvx(
    const char   *fact,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    float  *af,
    const ptrdiff_t *ldaf,
    ptrdiff_t *ipiv,
    char   *equed,
    float  *r,
    float  *c,
    float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgetc2.f */
#define cgetc2 FORTRAN_WRAPPER(cgetc2)
extern void cgetc2(
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *jpiv,
    ptrdiff_t *info
);

/* Source: cgetf2.f */
#define cgetf2 FORTRAN_WRAPPER(cgetf2)
extern void cgetf2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: cgetrf.f */
#define cgetrf FORTRAN_WRAPPER(cgetrf)
extern void cgetrf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: cgetri.f */
#define cgetri FORTRAN_WRAPPER(cgetri)
extern void cgetri(
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cgetrs.f */
#define cgetrs FORTRAN_WRAPPER(cgetrs)
extern void cgetrs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cggbak.f */
#define cggbak FORTRAN_WRAPPER(cggbak)
extern void cggbak(
    const char   *job,
    const char   *side,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    const float  *lscale,
    const float  *rscale,
    const ptrdiff_t *m,
    float  *v,
    const ptrdiff_t *ldv,
    ptrdiff_t *info
);

/* Source: cggbal.f */
#define cggbal FORTRAN_WRAPPER(cggbal)
extern void cggbal(
    const char   *job,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    float  *lscale,
    float  *rscale,
    float  *work,
    ptrdiff_t *info
);

/* Source: cgges.f */
#define cgges FORTRAN_WRAPPER(cgges)
extern void cgges(
    const char   *jobvsl,
    const char   *jobvsr,
    const char   *sort,
    ptrdiff_t (*selctg)(),
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *sdim,
    float  *alpha,
    float  *beta,
    float  *vsl,
    const ptrdiff_t *ldvsl,
    float  *vsr,
    const ptrdiff_t *ldvsr,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: cggesx.f */
#define cggesx FORTRAN_WRAPPER(cggesx)
extern void cggesx(
    const char   *jobvsl,
    const char   *jobvsr,
    const char   *sort,
    ptrdiff_t (*selctg)(),
    const char   *sense,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *sdim,
    float  *alpha,
    float  *beta,
    float  *vsl,
    const ptrdiff_t *ldvsl,
    float  *vsr,
    const ptrdiff_t *ldvsr,
    float  *rconde,
    float  *rcondv,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: cggev.f */
#define cggev FORTRAN_WRAPPER(cggev)
extern void cggev(
    const char   *jobvl,
    const char   *jobvr,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *alpha,
    float  *beta,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cggevx.f */
#define cggevx FORTRAN_WRAPPER(cggevx)
extern void cggevx(
    const char   *balanc,
    const char   *jobvl,
    const char   *jobvr,
    const char   *sense,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *alpha,
    float  *beta,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    float  *lscale,
    float  *rscale,
    float  *abnrm,
    float  *bbnrm,
    float  *rconde,
    float  *rcondv,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: cggglm.f */
#define cggglm FORTRAN_WRAPPER(cggglm)
extern void cggglm(
    const ptrdiff_t *n,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *d,
    float  *x,
    float  *y,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cgghrd.f */
#define cgghrd FORTRAN_WRAPPER(cgghrd)
extern void cgghrd(
    const char   *compq,
    const char   *compz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *q,
    const ptrdiff_t *ldq,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *info
);

/* Source: cgglse.f */
#define cgglse FORTRAN_WRAPPER(cgglse)
extern void cgglse(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *p,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *c,
    float  *d,
    float  *x,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cggqrf.f */
#define cggqrf FORTRAN_WRAPPER(cggqrf)
extern void cggqrf(
    const ptrdiff_t *n,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    float  *a,
    const ptrdiff_t *lda,
    float  *taua,
    float  *b,
    const ptrdiff_t *ldb,
    float  *taub,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cggrqf.f */
#define cggrqf FORTRAN_WRAPPER(cggrqf)
extern void cggrqf(
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *taua,
    float  *b,
    const ptrdiff_t *ldb,
    float  *taub,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cggsvd.f */
#define cggsvd FORTRAN_WRAPPER(cggsvd)
extern void cggsvd(
    const char   *jobu,
    const char   *jobv,
    const char   *jobq,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *p,
    ptrdiff_t *k,
    ptrdiff_t *l,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *alpha,
    float  *beta,
    float  *u,
    const ptrdiff_t *ldu,
    float  *v,
    const ptrdiff_t *ldv,
    float  *q,
    const ptrdiff_t *ldq,
    float  *work,
    float  *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: cggsvp.f */
#define cggsvp FORTRAN_WRAPPER(cggsvp)
extern void cggsvp(
    const char   *jobu,
    const char   *jobv,
    const char   *jobq,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    const float  *tola,
    const float  *tolb,
    ptrdiff_t *k,
    ptrdiff_t *l,
    float  *u,
    const ptrdiff_t *ldu,
    float  *v,
    const ptrdiff_t *ldv,
    float  *q,
    const ptrdiff_t *ldq,
    ptrdiff_t *iwork,
    float  *rwork,
    float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: cgtcon.f */
#define cgtcon FORTRAN_WRAPPER(cgtcon)
extern void cgtcon(
    const char   *norm,
    const ptrdiff_t *n,
    const float  *dl,
    const float  *d,
    const float  *du,
    const float  *du2,
    const ptrdiff_t *ipiv,
    const float  *anorm,
    float  *rcond,
    float  *work,
    ptrdiff_t *info
);

/* Source: cgtrfs.f */
#define cgtrfs FORTRAN_WRAPPER(cgtrfs)
extern void cgtrfs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *dl,
    const float  *d,
    const float  *du,
    const float  *dlf,
    const float  *df,
    const float  *duf,
    const float  *du2,
    const ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgtsv.f */
#define cgtsv FORTRAN_WRAPPER(cgtsv)
extern void cgtsv(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *dl,
    float  *d,
    float  *du,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cgtsvx.f */
#define cgtsvx FORTRAN_WRAPPER(cgtsvx)
extern void cgtsvx(
    const char   *fact,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *dl,
    const float  *d,
    const float  *du,
    float  *dlf,
    float  *df,
    float  *duf,
    float  *du2,
    ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cgttrf.f */
#define cgttrf FORTRAN_WRAPPER(cgttrf)
extern void cgttrf(
    const ptrdiff_t *n,
    float  *dl,
    float  *d,
    float  *du,
    float  *du2,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: cgttrs.f */
#define cgttrs FORTRAN_WRAPPER(cgttrs)
extern void cgttrs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *dl,
    const float  *d,
    const float  *du,
    const float  *du2,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cgtts2.f */
#define cgtts2 FORTRAN_WRAPPER(cgtts2)
extern void cgtts2(
    const ptrdiff_t *itrans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *dl,
    const float  *d,
    const float  *du,
    const float  *du2,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb
);

/* Source: chbev.f */
#define chbev FORTRAN_WRAPPER(chbev)
extern void chbev(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: chbevd.f */
#define chbevd FORTRAN_WRAPPER(chbevd)
extern void chbevd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: chbevx.f */
#define chbevx FORTRAN_WRAPPER(chbevx)
extern void chbevx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *q,
    const ptrdiff_t *ldq,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    float  *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: chbgst.f */
#define chbgst FORTRAN_WRAPPER(chbgst)
extern void chbgst(
    const char   *vect,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    float  *ab,
    const ptrdiff_t *ldab,
    const float  *bb,
    const ptrdiff_t *ldbb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: chbgv.f */
#define chbgv FORTRAN_WRAPPER(chbgv)
extern void chbgv(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *bb,
    const ptrdiff_t *ldbb,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: chbgvd.f */
#define chbgvd FORTRAN_WRAPPER(chbgvd)
extern void chbgvd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *bb,
    const ptrdiff_t *ldbb,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: chbgvx.f */
#define chbgvx FORTRAN_WRAPPER(chbgvx)
extern void chbgvx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *bb,
    const ptrdiff_t *ldbb,
    float  *q,
    const ptrdiff_t *ldq,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    float  *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: chbtrd.f */
#define chbtrd FORTRAN_WRAPPER(chbtrd)
extern void chbtrd(
    const char   *vect,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *d,
    float  *e,
    float  *q,
    const ptrdiff_t *ldq,
    float  *work,
    ptrdiff_t *info
);

/* Source: checon.f */
#define checon FORTRAN_WRAPPER(checon)
extern void checon(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    const float  *anorm,
    float  *rcond,
    float  *work,
    ptrdiff_t *info
);

/* Source: cheequb.f */
#define cheequb FORTRAN_WRAPPER(cheequb)
extern void cheequb(
    char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *s,
    float  *scond,
    float  *amax,
    float  *work,
    ptrdiff_t *info
);

/* Source: cheev.f */
#define cheev FORTRAN_WRAPPER(cheev)
extern void cheev(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *w,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cheevd.f */
#define cheevd FORTRAN_WRAPPER(cheevd)
extern void cheevd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *w,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: cheevr.f */
#define cheevr FORTRAN_WRAPPER(cheevr)
extern void cheevr(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *isuppz,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: cheevx.f */
#define cheevx FORTRAN_WRAPPER(cheevx)
extern void cheevx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: chegs2.f */
#define chegs2 FORTRAN_WRAPPER(chegs2)
extern void chegs2(
    const ptrdiff_t *itype,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: chegst.f */
#define chegst FORTRAN_WRAPPER(chegst)
extern void chegst(
    const ptrdiff_t *itype,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: chegv.f */
#define chegv FORTRAN_WRAPPER(chegv)
extern void chegv(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *w,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: chegvd.f */
#define chegvd FORTRAN_WRAPPER(chegvd)
extern void chegvd(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *w,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: chegvx.f */
#define chegvx FORTRAN_WRAPPER(chegvx)
extern void chegvx(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: cherfs.f */
#define cherfs FORTRAN_WRAPPER(cherfs)
extern void cherfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *af,
    const ptrdiff_t *ldaf,
    const ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: chesv.f */
#define chesv FORTRAN_WRAPPER(chesv)
extern void chesv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: chesvx.f */
#define chesvx FORTRAN_WRAPPER(chesvx)
extern void chesvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    float  *af,
    const ptrdiff_t *ldaf,
    ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cheswapr.f */
#define cheswapr FORTRAN_WRAPPER(cheswapr)
extern void cheswapr(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *i1,
    const ptrdiff_t *i2
);

/* Source: chetd2.f */
#define chetd2 FORTRAN_WRAPPER(chetd2)
extern void chetd2(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *d,
    float  *e,
    float  *tau,
    ptrdiff_t *info
);

/* Source: chetf2.f */
#define chetf2 FORTRAN_WRAPPER(chetf2)
extern void chetf2(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: chetrd.f */
#define chetrd FORTRAN_WRAPPER(chetrd)
extern void chetrd(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *d,
    float  *e,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: chetrf.f */
#define chetrf FORTRAN_WRAPPER(chetrf)
extern void chetrf(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: chetri.f */
#define chetri FORTRAN_WRAPPER(chetri)
extern void chetri(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *work,
    ptrdiff_t *info
);

/* Source: chetri2.f */
#define chetri2 FORTRAN_WRAPPER(chetri2)
extern void chetri2(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: chetri2x.f */
#define chetri2x FORTRAN_WRAPPER(chetri2x)
extern void chetri2x(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *work,
    const ptrdiff_t *nb,
    ptrdiff_t *info
);

/* Source: chetrs.f */
#define chetrs FORTRAN_WRAPPER(chetrs)
extern void chetrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: chetrs2.f */
#define chetrs2 FORTRAN_WRAPPER(chetrs2)
extern void chetrs2(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    float  *work,
    ptrdiff_t *info
);

/* Source: chfrk.f */
#define chfrk FORTRAN_WRAPPER(chfrk)
extern void chfrk(
    const char   *transr,
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *beta,
    float  *c
);

/* Source: chgeqz.f */
#define chgeqz FORTRAN_WRAPPER(chgeqz)
extern void chgeqz(
    const char   *job,
    const char   *compq,
    const char   *compz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *h,
    const ptrdiff_t *ldh,
    float  *t,
    const ptrdiff_t *ldt,
    float  *alpha,
    float  *beta,
    float  *q,
    const ptrdiff_t *ldq,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: chla_transtype.f */
#define chla_transtype FORTRAN_WRAPPER(chla_transtype)
extern char chla_transtype(
    const ptrdiff_t *trans
);

/* Source: chpcon.f */
#define chpcon FORTRAN_WRAPPER(chpcon)
extern void chpcon(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    const ptrdiff_t *ipiv,
    const float  *anorm,
    float  *rcond,
    float  *work,
    ptrdiff_t *info
);

/* Source: chpev.f */
#define chpev FORTRAN_WRAPPER(chpev)
extern void chpev(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: chpevd.f */
#define chpevd FORTRAN_WRAPPER(chpevd)
extern void chpevd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: chpevx.f */
#define chpevx FORTRAN_WRAPPER(chpevx)
extern void chpevx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    float  *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: chpgst.f */
#define chpgst FORTRAN_WRAPPER(chpgst)
extern void chpgst(
    const ptrdiff_t *itype,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    const float  *bp,
    ptrdiff_t *info
);

/* Source: chpgv.f */
#define chpgv FORTRAN_WRAPPER(chpgv)
extern void chpgv(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    float  *bp,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: chpgvd.f */
#define chpgvd FORTRAN_WRAPPER(chpgvd)
extern void chpgvd(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    float  *bp,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: chpgvx.f */
#define chpgvx FORTRAN_WRAPPER(chpgvx)
extern void chpgvx(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    float  *bp,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    float  *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: chprfs.f */
#define chprfs FORTRAN_WRAPPER(chprfs)
extern void chprfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    const float  *afp,
    const ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: chpsv.f */
#define chpsv FORTRAN_WRAPPER(chpsv)
extern void chpsv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *ap,
    ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: chpsvx.f */
#define chpsvx FORTRAN_WRAPPER(chpsvx)
extern void chpsvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    float  *afp,
    ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: chptrd.f */
#define chptrd FORTRAN_WRAPPER(chptrd)
extern void chptrd(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    float  *d,
    float  *e,
    float  *tau,
    ptrdiff_t *info
);

/* Source: chptrf.f */
#define chptrf FORTRAN_WRAPPER(chptrf)
extern void chptrf(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: chptri.f */
#define chptri FORTRAN_WRAPPER(chptri)
extern void chptri(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    const ptrdiff_t *ipiv,
    float  *work,
    ptrdiff_t *info
);

/* Source: chptrs.f */
#define chptrs FORTRAN_WRAPPER(chptrs)
extern void chptrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: chsein.f */
#define chsein FORTRAN_WRAPPER(chsein)
extern void chsein(
    const char   *side,
    const char   *eigsrc,
    const char   *initv,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    const float  *h,
    const ptrdiff_t *ldh,
    float  *w,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    float  *work,
    float  *rwork,
    ptrdiff_t *ifaill,
    ptrdiff_t *ifailr,
    ptrdiff_t *info
);

/* Source: chseqr.f */
#define chseqr FORTRAN_WRAPPER(chseqr)
extern void chseqr(
    const char   *job,
    const char   *compz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *h,
    const ptrdiff_t *ldh,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: clabrd.f */
#define clabrd FORTRAN_WRAPPER(clabrd)
extern void clabrd(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    float  *a,
    const ptrdiff_t *lda,
    float  *d,
    float  *e,
    float  *tauq,
    float  *taup,
    float  *x,
    const ptrdiff_t *ldx,
    float  *y,
    const ptrdiff_t *ldy
);

/* Source: clacgv.f */
#define clacgv FORTRAN_WRAPPER(clacgv)
extern void clacgv(
    const ptrdiff_t *n,
    float  *x,
    const ptrdiff_t *incx
);

/* Source: clacn2.f */
#define clacn2 FORTRAN_WRAPPER(clacn2)
extern void clacn2(
    const ptrdiff_t *n,
    float  *v,
    float  *x,
    float  *est,
    ptrdiff_t *kase,
    ptrdiff_t *isave
);

/* Source: clacon.f */
#define clacon FORTRAN_WRAPPER(clacon)
extern void clacon(
    const ptrdiff_t *n,
    float  *v,
    float  *x,
    float  *est,
    ptrdiff_t *kase
);

/* Source: clacp2.f */
#define clacp2 FORTRAN_WRAPPER(clacp2)
extern void clacp2(
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb
);

/* Source: clacpy.f */
#define clacpy FORTRAN_WRAPPER(clacpy)
extern void clacpy(
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb
);

/* Source: clacrm.f */
#define clacrm FORTRAN_WRAPPER(clacrm)
extern void clacrm(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *c,
    const ptrdiff_t *ldc,
    float  *rwork
);

/* Source: clacrt.f */
#define clacrt FORTRAN_WRAPPER(clacrt)
extern void clacrt(
    const ptrdiff_t *n,
    float  *cx,
    const ptrdiff_t *incx,
    float  *cy,
    const ptrdiff_t *incy,
    const float  *c,
    const float  *s
);

/* Source: cladiv.f */
#define cladiv FORTRAN_WRAPPER(cladiv)
#ifndef FORTRAN_COMPLEX_FUNCTIONS_RETURN_VOID
extern complex cladiv(
#else
extern void cladiv(
    complex* retval,
#endif 
    const float  *x,
    const float  *y
);

/* Source: claed0.f */
#define claed0 FORTRAN_WRAPPER(claed0)
extern void claed0(
    const ptrdiff_t *qsiz,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    float  *q,
    const ptrdiff_t *ldq,
    float  *qstore,
    const ptrdiff_t *ldqs,
    float  *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: claed7.f */
#define claed7 FORTRAN_WRAPPER(claed7)
extern void claed7(
    const ptrdiff_t *n,
    const ptrdiff_t *cutpnt,
    const ptrdiff_t *qsiz,
    const ptrdiff_t *tlvls,
    const ptrdiff_t *curlvl,
    const ptrdiff_t *curpbm,
    float  *d,
    float  *q,
    const ptrdiff_t *ldq,
    const float  *rho,
    ptrdiff_t *indxq,
    float  *qstore,
    ptrdiff_t *qptr,
    const ptrdiff_t *prmptr,
    const ptrdiff_t *perm,
    const ptrdiff_t *givptr,
    const ptrdiff_t *givcol,
    const float  *givnum,
    float  *work,
    float  *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: claed8.f */
#define claed8 FORTRAN_WRAPPER(claed8)
extern void claed8(
    ptrdiff_t *k,
    const ptrdiff_t *n,
    const ptrdiff_t *qsiz,
    float  *q,
    const ptrdiff_t *ldq,
    float  *d,
    float  *rho,
    const ptrdiff_t *cutpnt,
    const float  *z,
    float  *dlamda,
    float  *q2,
    const ptrdiff_t *ldq2,
    float  *w,
    ptrdiff_t *indxp,
    ptrdiff_t *indx,
    const ptrdiff_t *indxq,
    ptrdiff_t *perm,
    ptrdiff_t *givptr,
    ptrdiff_t *givcol,
    float  *givnum,
    ptrdiff_t *info
);

/* Source: claein.f */
#define claein FORTRAN_WRAPPER(claein)
extern void claein(
    const ptrdiff_t *rightv,
    const ptrdiff_t *noinit,
    const ptrdiff_t *n,
    const float  *h,
    const ptrdiff_t *ldh,
    const float  *w,
    float  *v,
    float  *b,
    const ptrdiff_t *ldb,
    float  *rwork,
    const float  *eps3,
    const float  *smlnum,
    ptrdiff_t *info
);

/* Source: claesy.f */
#define claesy FORTRAN_WRAPPER(claesy)
extern void claesy(
    const float  *a,
    const float  *b,
    const float  *c,
    float  *rt1,
    float  *rt2,
    float  *evscal,
    float  *cs1,
    float  *sn1
);

/* Source: claev2.f */
#define claev2 FORTRAN_WRAPPER(claev2)
extern void claev2(
    const float  *a,
    const float  *b,
    const float  *c,
    float  *rt1,
    float  *rt2,
    float  *cs1,
    float  *sn1
);

/* Source: clag2z.f */
#define clag2z FORTRAN_WRAPPER(clag2z)
extern void clag2z(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *sa,
    const ptrdiff_t *ldsa,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: clags2.f */
#define clags2 FORTRAN_WRAPPER(clags2)
extern void clags2(
    const ptrdiff_t *upper,
    const float  *a1,
    const float  *a2,
    const float  *a3,
    const float  *b1,
    const float  *b2,
    const float  *b3,
    float  *csu,
    float  *snu,
    float  *csv,
    float  *snv,
    float  *csq,
    float  *snq
);

/* Source: clagtm.f */
#define clagtm FORTRAN_WRAPPER(clagtm)
extern void clagtm(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *alpha,
    const float  *dl,
    const float  *d,
    const float  *du,
    const float  *x,
    const ptrdiff_t *ldx,
    const float  *beta,
    float  *b,
    const ptrdiff_t *ldb
);

/* Source: clahef.f */
#define clahef FORTRAN_WRAPPER(clahef)
extern void clahef(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    ptrdiff_t *kb,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    float  *w,
    const ptrdiff_t *ldw,
    ptrdiff_t *info
);

/* Source: clahqr.f */
#define clahqr FORTRAN_WRAPPER(clahqr)
extern void clahqr(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *h,
    const ptrdiff_t *ldh,
    float  *w,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *info
);

/* Source: clahr2.f */
#define clahr2 FORTRAN_WRAPPER(clahr2)
extern void clahr2(
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *nb,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *t,
    const ptrdiff_t *ldt,
    float  *y,
    const ptrdiff_t *ldy
);

/* Source: clahrd.f */
#define clahrd FORTRAN_WRAPPER(clahrd)
extern void clahrd(
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *nb,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *t,
    const ptrdiff_t *ldt,
    float  *y,
    const ptrdiff_t *ldy
);

/* Source: claic1.f */
#define claic1 FORTRAN_WRAPPER(claic1)
extern void claic1(
    const ptrdiff_t *job,
    const ptrdiff_t *j,
    const float  *x,
    const float  *sest,
    const float  *w,
    const float  *gamma_,
    float  *sestpr,
    float  *s,
    float  *c
);

/* Source: clals0.f */
#define clals0 FORTRAN_WRAPPER(clals0)
extern void clals0(
    const ptrdiff_t *icompq,
    const ptrdiff_t *nl,
    const ptrdiff_t *nr,
    const ptrdiff_t *sqre,
    const ptrdiff_t *nrhs,
    float  *b,
    const ptrdiff_t *ldb,
    float  *bx,
    const ptrdiff_t *ldbx,
    const ptrdiff_t *perm,
    const ptrdiff_t *givptr,
    const ptrdiff_t *givcol,
    const ptrdiff_t *ldgcol,
    const float  *givnum,
    const ptrdiff_t *ldgnum,
    const float  *poles,
    const float  *difl,
    const float  *difr,
    const float  *z,
    const ptrdiff_t *k,
    const float  *c,
    const float  *s,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: clalsa.f */
#define clalsa FORTRAN_WRAPPER(clalsa)
extern void clalsa(
    const ptrdiff_t *icompq,
    const ptrdiff_t *smlsiz,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *b,
    const ptrdiff_t *ldb,
    float  *bx,
    const ptrdiff_t *ldbx,
    const float  *u,
    const ptrdiff_t *ldu,
    const float  *vt,
    const ptrdiff_t *k,
    const float  *difl,
    const float  *difr,
    const float  *z,
    const float  *poles,
    const ptrdiff_t *givptr,
    const ptrdiff_t *givcol,
    const ptrdiff_t *ldgcol,
    const ptrdiff_t *perm,
    const float  *givnum,
    const float  *c,
    const float  *s,
    float  *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: clalsd.f */
#define clalsd FORTRAN_WRAPPER(clalsd)
extern void clalsd(
    const char   *uplo,
    const ptrdiff_t *smlsiz,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *d,
    float  *e,
    float  *b,
    const ptrdiff_t *ldb,
    const float  *rcond,
    ptrdiff_t *rank,
    float  *work,
    float  *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: clangb.f */
#define clangb FORTRAN_WRAPPER(clangb)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double clangb(
#else
extern float clangb(
#endif 
    const char   *norm,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *work
);

/* Source: clange.f */
#define clange FORTRAN_WRAPPER(clange)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double clange(
#else
extern float clange(
#endif 
    const char   *norm,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *work
);

/* Source: clangt.f */
#define clangt FORTRAN_WRAPPER(clangt)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double clangt(
#else
extern float clangt(
#endif 
    const char   *norm,
    const ptrdiff_t *n,
    const float  *dl,
    const float  *d,
    const float  *du
);

/* Source: clanhb.f */
#define clanhb FORTRAN_WRAPPER(clanhb)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double clanhb(
#else
extern float clanhb(
#endif 
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *work
);

/* Source: clanhe.f */
#define clanhe FORTRAN_WRAPPER(clanhe)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double clanhe(
#else
extern float clanhe(
#endif 
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *work
);

/* Source: clanhf.f */
#define clanhf FORTRAN_WRAPPER(clanhf)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double clanhf(
#else
extern float clanhf(
#endif 
    const char   *norm,
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    float  *work
);

/* Source: clanhp.f */
#define clanhp FORTRAN_WRAPPER(clanhp)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double clanhp(
#else
extern float clanhp(
#endif 
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    float  *work
);

/* Source: clanhs.f */
#define clanhs FORTRAN_WRAPPER(clanhs)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double clanhs(
#else
extern float clanhs(
#endif 
    const char   *norm,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *work
);

/* Source: clanht.f */
#define clanht FORTRAN_WRAPPER(clanht)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double clanht(
#else
extern float clanht(
#endif 
    const char   *norm,
    const ptrdiff_t *n,
    const float  *d,
    const float  *e
);

/* Source: clansb.f */
#define clansb FORTRAN_WRAPPER(clansb)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double clansb(
#else
extern float clansb(
#endif 
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *work
);

/* Source: clansp.f */
#define clansp FORTRAN_WRAPPER(clansp)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double clansp(
#else
extern float clansp(
#endif 
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    float  *work
);

/* Source: clansy.f */
#define clansy FORTRAN_WRAPPER(clansy)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double clansy(
#else
extern float clansy(
#endif 
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *work
);

/* Source: clantb.f */
#define clantb FORTRAN_WRAPPER(clantb)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double clantb(
#else
extern float clantb(
#endif 
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *work
);

/* Source: clantp.f */
#define clantp FORTRAN_WRAPPER(clantp)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double clantp(
#else
extern float clantp(
#endif 
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const float  *ap,
    float  *work
);

/* Source: clantr.f */
#define clantr FORTRAN_WRAPPER(clantr)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double clantr(
#else
extern float clantr(
#endif 
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *work
);

/* Source: clapll.f */
#define clapll FORTRAN_WRAPPER(clapll)
extern void clapll(
    const ptrdiff_t *n,
    float  *x,
    const ptrdiff_t *incx,
    float  *y,
    const ptrdiff_t *incy,
    float  *ssmin
);

/* Source: clapmr.f */
#define clapmr FORTRAN_WRAPPER(clapmr)
extern void clapmr(
    const ptrdiff_t *forwrd,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *x,
    const ptrdiff_t *ldx,
    ptrdiff_t *k
);

/* Source: clapmt.f */
#define clapmt FORTRAN_WRAPPER(clapmt)
extern void clapmt(
    const ptrdiff_t *forwrd,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *x,
    const ptrdiff_t *ldx,
    ptrdiff_t *k
);

/* Source: claqgb.f */
#define claqgb FORTRAN_WRAPPER(claqgb)
extern void claqgb(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    float  *ab,
    const ptrdiff_t *ldab,
    const float  *r,
    const float  *c,
    const float  *rowcnd,
    const float  *colcnd,
    const float  *amax,
    char   *equed
);

/* Source: claqge.f */
#define claqge FORTRAN_WRAPPER(claqge)
extern void claqge(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const float  *r,
    const float  *c,
    const float  *rowcnd,
    const float  *colcnd,
    const float  *amax,
    char   *equed
);

/* Source: claqhb.f */
#define claqhb FORTRAN_WRAPPER(claqhb)
extern void claqhb(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *s,
    const float  *scond,
    const float  *amax,
    char   *equed
);

/* Source: claqhe.f */
#define claqhe FORTRAN_WRAPPER(claqhe)
extern void claqhe(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const float  *s,
    const float  *scond,
    const float  *amax,
    char   *equed
);

/* Source: claqhp.f */
#define claqhp FORTRAN_WRAPPER(claqhp)
extern void claqhp(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    const float  *s,
    const float  *scond,
    const float  *amax,
    char   *equed
);

/* Source: claqp2.f */
#define claqp2 FORTRAN_WRAPPER(claqp2)
extern void claqp2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *offset,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    float  *tau,
    float  *vn1,
    float  *vn2,
    float  *work
);

/* Source: claqps.f */
#define claqps FORTRAN_WRAPPER(claqps)
extern void claqps(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *offset,
    const ptrdiff_t *nb,
    ptrdiff_t *kb,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    float  *tau,
    float  *vn1,
    float  *vn2,
    float  *auxv,
    float  *f,
    const ptrdiff_t *ldf
);

/* Source: claqr0.f */
#define claqr0 FORTRAN_WRAPPER(claqr0)
extern void claqr0(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *h,
    const ptrdiff_t *ldh,
    float  *w,
    ptrdiff_t *iloz,
    ptrdiff_t *ihiz,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: claqr1.f */
#define claqr1 FORTRAN_WRAPPER(claqr1)
extern void claqr1(
    const ptrdiff_t *n,
    const float  *h,
    const ptrdiff_t *ldh,
    const float  *s1,
    float  *s2,
    float  *v
);

/* Source: claqr2.f */
#define claqr2 FORTRAN_WRAPPER(claqr2)
extern void claqr2(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ktop,
    const ptrdiff_t *kbot,
    const ptrdiff_t *nw,
    float  *h,
    const ptrdiff_t *ldh,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *ns,
    ptrdiff_t *nd,
    float  *sh,
    float  *v,
    const ptrdiff_t *ldv,
    const ptrdiff_t *nh,
    float  *t,
    const ptrdiff_t *ldt,
    const ptrdiff_t *nv,
    float  *wv,
    const ptrdiff_t *ldwv,
    float  *work,
    const ptrdiff_t *lwork
);

/* Source: claqr3.f */
#define claqr3 FORTRAN_WRAPPER(claqr3)
extern void claqr3(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ktop,
    const ptrdiff_t *kbot,
    const ptrdiff_t *nw,
    float  *h,
    const ptrdiff_t *ldh,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *ns,
    ptrdiff_t *nd,
    float  *sh,
    float  *v,
    const ptrdiff_t *ldv,
    const ptrdiff_t *nh,
    float  *t,
    const ptrdiff_t *ldt,
    const ptrdiff_t *nv,
    float  *wv,
    const ptrdiff_t *ldwv,
    float  *work,
    const ptrdiff_t *lwork
);

/* Source: claqr4.f */
#define claqr4 FORTRAN_WRAPPER(claqr4)
extern void claqr4(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *h,
    const ptrdiff_t *ldh,
    float  *w,
    ptrdiff_t *iloz,
    ptrdiff_t *ihiz,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: claqr5.f */
#define claqr5 FORTRAN_WRAPPER(claqr5)
extern void claqr5(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *kacc22,
    const ptrdiff_t *n,
    const ptrdiff_t *ktop,
    const ptrdiff_t *kbot,
    const ptrdiff_t *nshfts,
    float  *s,
    float  *h,
    const ptrdiff_t *ldh,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    float  *z,
    const ptrdiff_t *ldz,
    float  *v,
    const ptrdiff_t *ldv,
    float  *u,
    const ptrdiff_t *ldu,
    const ptrdiff_t *nv,
    float  *wv,
    const ptrdiff_t *ldwv,
    const ptrdiff_t *nh,
    float  *wh,
    const ptrdiff_t *ldwh
);

/* Source: claqsb.f */
#define claqsb FORTRAN_WRAPPER(claqsb)
extern void claqsb(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    const float  *s,
    const float  *scond,
    const float  *amax,
    char   *equed
);

/* Source: claqsp.f */
#define claqsp FORTRAN_WRAPPER(claqsp)
extern void claqsp(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    const float  *s,
    const float  *scond,
    const float  *amax,
    char   *equed
);

/* Source: claqsy.f */
#define claqsy FORTRAN_WRAPPER(claqsy)
extern void claqsy(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const float  *s,
    const float  *scond,
    const float  *amax,
    char   *equed
);

/* Source: clar1v.f */
#define clar1v FORTRAN_WRAPPER(clar1v)
extern void clar1v(
    const ptrdiff_t *n,
    const ptrdiff_t *b1,
    const ptrdiff_t *bn,
    const float  *lambda,
    const float  *d,
    const float  *l,
    const float  *ld,
    const float  *lld,
    const float  *pivmin,
    const float  *gaptol,
    float  *z,
    const ptrdiff_t *wantnc,
    ptrdiff_t *negcnt,
    float  *ztz,
    float  *mingma,
    ptrdiff_t *r,
    ptrdiff_t *isuppz,
    float  *nrminv,
    float  *resid,
    float  *rqcorr,
    float  *work
);

/* Source: clar2v.f */
#define clar2v FORTRAN_WRAPPER(clar2v)
extern void clar2v(
    const ptrdiff_t *n,
    float  *x,
    float  *y,
    float  *z,
    const ptrdiff_t *incx,
    const float  *c,
    const float  *s,
    const ptrdiff_t *incc
);

/* Source: clarcm.f */
#define clarcm FORTRAN_WRAPPER(clarcm)
extern void clarcm(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *c,
    const ptrdiff_t *ldc,
    float  *rwork
);

/* Source: clarf.f */
#define clarf FORTRAN_WRAPPER(clarf)
extern void clarf(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *v,
    const ptrdiff_t *incv,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work
);

/* Source: clarfb.f */
#define clarfb FORTRAN_WRAPPER(clarfb)
extern void clarfb(
    const char   *side,
    const char   *trans,
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *v,
    const ptrdiff_t *ldv,
    const float  *t,
    const ptrdiff_t *ldt,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *ldwork
);

/* Source: clarfg.f */
#define clarfg FORTRAN_WRAPPER(clarfg)
extern void clarfg(
    const ptrdiff_t *n,
    float  *alpha,
    float  *x,
    const ptrdiff_t *incx,
    float  *tau
);

/* Source: clarfgp.f */
#define clarfgp FORTRAN_WRAPPER(clarfgp)
extern void clarfgp(
    const ptrdiff_t *n,
    float  *alpha,
    float  *x,
    const ptrdiff_t *incx,
    float  *tau
);

/* Source: clarft.f */
#define clarft FORTRAN_WRAPPER(clarft)
extern void clarft(
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *v,
    const ptrdiff_t *ldv,
    const float  *tau,
    float  *t,
    const ptrdiff_t *ldt
);

/* Source: clarfx.f */
#define clarfx FORTRAN_WRAPPER(clarfx)
extern void clarfx(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *v,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work
);

/* Source: clargv.f */
#define clargv FORTRAN_WRAPPER(clargv)
extern void clargv(
    const ptrdiff_t *n,
    float  *x,
    const ptrdiff_t *incx,
    float  *y,
    const ptrdiff_t *incy,
    float  *c,
    const ptrdiff_t *incc
);

/* Source: clarnv.f */
#define clarnv FORTRAN_WRAPPER(clarnv)
extern void clarnv(
    const ptrdiff_t *idist,
    ptrdiff_t *iseed,
    const ptrdiff_t *n,
    float  *x
);

/* Source: clarrv.f */
#define clarrv FORTRAN_WRAPPER(clarrv)
extern void clarrv(
    const ptrdiff_t *n,
    const float  *vl,
    const float  *vu,
    float  *d,
    float  *l,
    float  *pivmin,
    const ptrdiff_t *isplit,
    const ptrdiff_t *m,
    const ptrdiff_t *dol,
    const ptrdiff_t *dou,
    const float  *minrgp,
    const float  *rtol1,
    const float  *rtol2,
    float  *w,
    float  *werr,
    float  *wgap,
    const ptrdiff_t *iblock,
    const ptrdiff_t *indexw,
    const float  *gers,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *isuppz,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: clartg.f */
#define clartg FORTRAN_WRAPPER(clartg)
extern void clartg(
    const float  *f,
    const float  *g,
    float  *cs,
    float  *sn,
    float  *r
);

/* Source: clartv.f */
#define clartv FORTRAN_WRAPPER(clartv)
extern void clartv(
    const ptrdiff_t *n,
    float  *x,
    const ptrdiff_t *incx,
    float  *y,
    const ptrdiff_t *incy,
    const float  *c,
    const float  *s,
    const ptrdiff_t *incc
);

/* Source: clarz.f */
#define clarz FORTRAN_WRAPPER(clarz)
extern void clarz(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    const float  *v,
    const ptrdiff_t *incv,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work
);

/* Source: clarzb.f */
#define clarzb FORTRAN_WRAPPER(clarzb)
extern void clarzb(
    const char   *side,
    const char   *trans,
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const float  *v,
    const ptrdiff_t *ldv,
    const float  *t,
    const ptrdiff_t *ldt,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *ldwork
);

/* Source: clarzt.f */
#define clarzt FORTRAN_WRAPPER(clarzt)
extern void clarzt(
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *v,
    const ptrdiff_t *ldv,
    const float  *tau,
    float  *t,
    const ptrdiff_t *ldt
);

/* Source: clascl.f */
#define clascl FORTRAN_WRAPPER(clascl)
extern void clascl(
    const char   *type,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const float  *cfrom,
    const float  *cto,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: claset.f */
#define claset FORTRAN_WRAPPER(claset)
extern void claset(
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *beta,
    float  *a,
    const ptrdiff_t *lda
);

/* Source: clasr.f */
#define clasr FORTRAN_WRAPPER(clasr)
extern void clasr(
    const char   *side,
    const char   *pivot,
    const char   *direct,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *c,
    const float  *s,
    float  *a,
    const ptrdiff_t *lda
);

/* Source: classq.f */
#define classq FORTRAN_WRAPPER(classq)
extern void classq(
    const ptrdiff_t *n,
    const float  *x,
    const ptrdiff_t *incx,
    float  *scale,
    float  *sumsq
);

/* Source: claswp.f */
#define claswp FORTRAN_WRAPPER(claswp)
extern void claswp(
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *k1,
    const ptrdiff_t *k2,
    const ptrdiff_t *ipiv,
    const ptrdiff_t *incx
);

/* Source: clasyf.f */
#define clasyf FORTRAN_WRAPPER(clasyf)
extern void clasyf(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    ptrdiff_t *kb,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    float  *w,
    const ptrdiff_t *ldw,
    ptrdiff_t *info
);

/* Source: clatbs.f */
#define clatbs FORTRAN_WRAPPER(clatbs)
extern void clatbs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const char   *normin,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *x,
    float  *scale,
    float  *cnorm,
    ptrdiff_t *info
);

/* Source: clatdf.f */
#define clatdf FORTRAN_WRAPPER(clatdf)
extern void clatdf(
    const ptrdiff_t *ijob,
    const ptrdiff_t *n,
    const float  *z,
    const ptrdiff_t *ldz,
    float  *rhs,
    float  *rdsum,
    float  *rdscal,
    const ptrdiff_t *ipiv,
    const ptrdiff_t *jpiv
);

/* Source: clatps.f */
#define clatps FORTRAN_WRAPPER(clatps)
extern void clatps(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const char   *normin,
    const ptrdiff_t *n,
    const float  *ap,
    float  *x,
    float  *scale,
    float  *cnorm,
    ptrdiff_t *info
);

/* Source: clatrd.f */
#define clatrd FORTRAN_WRAPPER(clatrd)
extern void clatrd(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    float  *a,
    const ptrdiff_t *lda,
    float  *e,
    float  *tau,
    float  *w,
    const ptrdiff_t *ldw
);

/* Source: clatrs.f */
#define clatrs FORTRAN_WRAPPER(clatrs)
extern void clatrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const char   *normin,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *x,
    float  *scale,
    float  *cnorm,
    ptrdiff_t *info
);

/* Source: clatrz.f */
#define clatrz FORTRAN_WRAPPER(clatrz)
extern void clatrz(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work
);

/* Source: clatzm.f */
#define clatzm FORTRAN_WRAPPER(clatzm)
extern void clatzm(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *v,
    const ptrdiff_t *incv,
    const float  *tau,
    float  *c1,
    float  *c2,
    const ptrdiff_t *ldc,
    float  *work
);

/* Source: clauu2.f */
#define clauu2 FORTRAN_WRAPPER(clauu2)
extern void clauu2(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: clauum.f */
#define clauum FORTRAN_WRAPPER(clauum)
extern void clauum(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: cpbcon.f */
#define cpbcon FORTRAN_WRAPPER(cpbcon)
extern void cpbcon(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const float  *ab,
    const ptrdiff_t *ldab,
    const float  *anorm,
    float  *rcond,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cpbequ.f */
#define cpbequ FORTRAN_WRAPPER(cpbequ)
extern void cpbequ(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *s,
    float  *scond,
    float  *amax,
    ptrdiff_t *info
);

/* Source: cpbrfs.f */
#define cpbrfs FORTRAN_WRAPPER(cpbrfs)
extern void cpbrfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const float  *ab,
    const ptrdiff_t *ldab,
    const float  *afb,
    const ptrdiff_t *ldafb,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cpbstf.f */
#define cpbstf FORTRAN_WRAPPER(cpbstf)
extern void cpbstf(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *info
);

/* Source: cpbsv.f */
#define cpbsv FORTRAN_WRAPPER(cpbsv)
extern void cpbsv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cpbsvx.f */
#define cpbsvx FORTRAN_WRAPPER(cpbsvx)
extern void cpbsvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *afb,
    const ptrdiff_t *ldafb,
    char   *equed,
    float  *s,
    float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cpbtf2.f */
#define cpbtf2 FORTRAN_WRAPPER(cpbtf2)
extern void cpbtf2(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *info
);

/* Source: cpbtrf.f */
#define cpbtrf FORTRAN_WRAPPER(cpbtrf)
extern void cpbtrf(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *info
);

/* Source: cpbtrs.f */
#define cpbtrs FORTRAN_WRAPPER(cpbtrs)
extern void cpbtrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cpftrf.f */
#define cpftrf FORTRAN_WRAPPER(cpftrf)
extern void cpftrf(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    ptrdiff_t *info
);

/* Source: cpftri.f */
#define cpftri FORTRAN_WRAPPER(cpftri)
extern void cpftri(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    ptrdiff_t *info
);

/* Source: cpftrs.f */
#define cpftrs FORTRAN_WRAPPER(cpftrs)
extern void cpftrs(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cpocon.f */
#define cpocon FORTRAN_WRAPPER(cpocon)
extern void cpocon(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *anorm,
    float  *rcond,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cpoequ.f */
#define cpoequ FORTRAN_WRAPPER(cpoequ)
extern void cpoequ(
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *s,
    float  *scond,
    float  *amax,
    ptrdiff_t *info
);

/* Source: cpoequb.f */
#define cpoequb FORTRAN_WRAPPER(cpoequb)
extern void cpoequb(
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *s,
    float  *scond,
    float  *amax,
    ptrdiff_t *info
);

/* Source: cporfs.f */
#define cporfs FORTRAN_WRAPPER(cporfs)
extern void cporfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *af,
    const ptrdiff_t *ldaf,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cposv.f */
#define cposv FORTRAN_WRAPPER(cposv)
extern void cposv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cposvx.f */
#define cposvx FORTRAN_WRAPPER(cposvx)
extern void cposvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    float  *af,
    const ptrdiff_t *ldaf,
    char   *equed,
    float  *s,
    float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cpotf2.f */
#define cpotf2 FORTRAN_WRAPPER(cpotf2)
extern void cpotf2(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: cpotrf.f */
#define cpotrf FORTRAN_WRAPPER(cpotrf)
extern void cpotrf(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: cpotri.f */
#define cpotri FORTRAN_WRAPPER(cpotri)
extern void cpotri(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: cpotrs.f */
#define cpotrs FORTRAN_WRAPPER(cpotrs)
extern void cpotrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cppcon.f */
#define cppcon FORTRAN_WRAPPER(cppcon)
extern void cppcon(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    const float  *anorm,
    float  *rcond,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cppequ.f */
#define cppequ FORTRAN_WRAPPER(cppequ)
extern void cppequ(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    float  *s,
    float  *scond,
    float  *amax,
    ptrdiff_t *info
);

/* Source: cpprfs.f */
#define cpprfs FORTRAN_WRAPPER(cpprfs)
extern void cpprfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    const float  *afp,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cppsv.f */
#define cppsv FORTRAN_WRAPPER(cppsv)
extern void cppsv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *ap,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cppsvx.f */
#define cppsvx FORTRAN_WRAPPER(cppsvx)
extern void cppsvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *ap,
    float  *afp,
    char   *equed,
    float  *s,
    float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cpptrf.f */
#define cpptrf FORTRAN_WRAPPER(cpptrf)
extern void cpptrf(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    ptrdiff_t *info
);

/* Source: cpptri.f */
#define cpptri FORTRAN_WRAPPER(cpptri)
extern void cpptri(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    ptrdiff_t *info
);

/* Source: cpptrs.f */
#define cpptrs FORTRAN_WRAPPER(cpptrs)
extern void cpptrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cpstf2.f */
#define cpstf2 FORTRAN_WRAPPER(cpstf2)
extern void cpstf2(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *piv,
    ptrdiff_t *rank,
    const float  *tol,
    float  *work,
    ptrdiff_t *info
);

/* Source: cpstrf.f */
#define cpstrf FORTRAN_WRAPPER(cpstrf)
extern void cpstrf(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *piv,
    ptrdiff_t *rank,
    const float  *tol,
    float  *work,
    ptrdiff_t *info
);

/* Source: cptcon.f */
#define cptcon FORTRAN_WRAPPER(cptcon)
extern void cptcon(
    const ptrdiff_t *n,
    const float  *d,
    const float  *e,
    const float  *anorm,
    float  *rcond,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cpteqr.f */
#define cpteqr FORTRAN_WRAPPER(cpteqr)
extern void cpteqr(
    const char   *compz,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *info
);

/* Source: cptrfs.f */
#define cptrfs FORTRAN_WRAPPER(cptrfs)
extern void cptrfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *d,
    const float  *e,
    const float  *df,
    const float  *ef,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cptsv.f */
#define cptsv FORTRAN_WRAPPER(cptsv)
extern void cptsv(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *d,
    float  *e,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cptsvx.f */
#define cptsvx FORTRAN_WRAPPER(cptsvx)
extern void cptsvx(
    const char   *fact,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *d,
    const float  *e,
    float  *df,
    float  *ef,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cpttrf.f */
#define cpttrf FORTRAN_WRAPPER(cpttrf)
extern void cpttrf(
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    ptrdiff_t *info
);

/* Source: cpttrs.f */
#define cpttrs FORTRAN_WRAPPER(cpttrs)
extern void cpttrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *d,
    const float  *e,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cptts2.f */
#define cptts2 FORTRAN_WRAPPER(cptts2)
extern void cptts2(
    const ptrdiff_t *iuplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *d,
    const float  *e,
    float  *b,
    const ptrdiff_t *ldb
);

/* Source: crot.f */
#define crot FORTRAN_WRAPPER(crot)
extern void crot(
    const ptrdiff_t *n,
    float  *cx,
    const ptrdiff_t *incx,
    float  *cy,
    const ptrdiff_t *incy,
    const float  *c,
    const float  *s
);

/* Source: cspcon.f */
#define cspcon FORTRAN_WRAPPER(cspcon)
extern void cspcon(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    const ptrdiff_t *ipiv,
    const float  *anorm,
    float  *rcond,
    float  *work,
    ptrdiff_t *info
);

/* Source: cspmv.f */
#define cspmv FORTRAN_WRAPPER(cspmv)
extern void cspmv(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *ap,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *beta,
    float  *y,
    const ptrdiff_t *incy
);

/* Source: cspr.f */
#define cspr FORTRAN_WRAPPER(cspr)
extern void cspr(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *x,
    const ptrdiff_t *incx,
    float  *ap
);

/* Source: csprfs.f */
#define csprfs FORTRAN_WRAPPER(csprfs)
extern void csprfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    const float  *afp,
    const ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: cspsv.f */
#define cspsv FORTRAN_WRAPPER(cspsv)
extern void cspsv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *ap,
    ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: cspsvx.f */
#define cspsvx FORTRAN_WRAPPER(cspsvx)
extern void cspsvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    float  *afp,
    ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: csptrf.f */
#define csptrf FORTRAN_WRAPPER(csptrf)
extern void csptrf(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: csptri.f */
#define csptri FORTRAN_WRAPPER(csptri)
extern void csptri(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    const ptrdiff_t *ipiv,
    float  *work,
    ptrdiff_t *info
);

/* Source: csptrs.f */
#define csptrs FORTRAN_WRAPPER(csptrs)
extern void csptrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: csrscl.f */
#define csrscl FORTRAN_WRAPPER(csrscl)
extern void csrscl(
    const ptrdiff_t *n,
    const float  *sa,
    float  *sx,
    const ptrdiff_t *incx
);

/* Source: cstedc.f */
#define cstedc FORTRAN_WRAPPER(cstedc)
extern void cstedc(
    const char   *compz,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: cstegr.f */
#define cstegr FORTRAN_WRAPPER(cstegr)
extern void cstegr(
    const char   *jobz,
    const char   *range,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *isuppz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: cstein.f */
#define cstein FORTRAN_WRAPPER(cstein)
extern void cstein(
    const ptrdiff_t *n,
    const float  *d,
    const float  *e,
    const ptrdiff_t *m,
    const float  *w,
    const ptrdiff_t *iblock,
    const ptrdiff_t *isplit,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: cstemr.f */
#define cstemr FORTRAN_WRAPPER(cstemr)
extern void cstemr(
    const char   *jobz,
    const char   *range,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    const ptrdiff_t *nzc,
    ptrdiff_t *isuppz,
    ptrdiff_t *tryrac,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: csteqr.f */
#define csteqr FORTRAN_WRAPPER(csteqr)
extern void csteqr(
    const char   *compz,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *info
);

/* Source: csycon.f */
#define csycon FORTRAN_WRAPPER(csycon)
extern void csycon(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    const float  *anorm,
    float  *rcond,
    float  *work,
    ptrdiff_t *info
);

/* Source: csyconv.f */
#define csyconv FORTRAN_WRAPPER(csyconv)
extern void csyconv(
    const char   *uplo,
    const char   *way,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *work,
    ptrdiff_t *info
);

/* Source: csyequb.f */
#define csyequb FORTRAN_WRAPPER(csyequb)
extern void csyequb(
    char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *s,
    float  *scond,
    float  *amax,
    float  *work,
    ptrdiff_t *info
);

/* Source: csymv.f */
#define csymv FORTRAN_WRAPPER(csymv)
extern void csymv(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *beta,
    float  *y,
    const ptrdiff_t *incy
);

/* Source: csyr.f */
#define csyr FORTRAN_WRAPPER(csyr)
extern void csyr(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *x,
    const ptrdiff_t *incx,
    float  *a,
    const ptrdiff_t *lda
);

/* Source: csyrfs.f */
#define csyrfs FORTRAN_WRAPPER(csyrfs)
extern void csyrfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *af,
    const ptrdiff_t *ldaf,
    const ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: csysv.f */
#define csysv FORTRAN_WRAPPER(csysv)
extern void csysv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: csysvx.f */
#define csysvx FORTRAN_WRAPPER(csysvx)
extern void csysvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    float  *af,
    const ptrdiff_t *ldaf,
    ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: csyswapr.f */
#define csyswapr FORTRAN_WRAPPER(csyswapr)
extern void csyswapr(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *i1,
    const ptrdiff_t *i2
);

/* Source: csytf2.f */
#define csytf2 FORTRAN_WRAPPER(csytf2)
extern void csytf2(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: csytrf.f */
#define csytrf FORTRAN_WRAPPER(csytrf)
extern void csytrf(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: csytri.f */
#define csytri FORTRAN_WRAPPER(csytri)
extern void csytri(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *work,
    ptrdiff_t *info
);

/* Source: csytri2.f */
#define csytri2 FORTRAN_WRAPPER(csytri2)
extern void csytri2(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: csytri2x.f */
#define csytri2x FORTRAN_WRAPPER(csytri2x)
extern void csytri2x(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *work,
    ptrdiff_t *nb,
    ptrdiff_t *info
);

/* Source: csytrs.f */
#define csytrs FORTRAN_WRAPPER(csytrs)
extern void csytrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: csytrs2.f */
#define csytrs2 FORTRAN_WRAPPER(csytrs2)
extern void csytrs2(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    float  *work,
    ptrdiff_t *info
);

/* Source: ctbcon.f */
#define ctbcon FORTRAN_WRAPPER(ctbcon)
extern void ctbcon(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *rcond,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: ctbrfs.f */
#define ctbrfs FORTRAN_WRAPPER(ctbrfs)
extern void ctbrfs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const float  *ab,
    const ptrdiff_t *ldab,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: ctbtrs.f */
#define ctbtrs FORTRAN_WRAPPER(ctbtrs)
extern void ctbtrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: ctfsm.f */
#define ctfsm FORTRAN_WRAPPER(ctfsm)
extern void ctfsm(
    const char   *transr,
    const char   *side,
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *a,
    float  *b,
    const ptrdiff_t *ldb
);

/* Source: ctftri.f */
#define ctftri FORTRAN_WRAPPER(ctftri)
extern void ctftri(
    const char   *transr,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    float  *a,
    ptrdiff_t *info
);

/* Source: ctfttp.f */
#define ctfttp FORTRAN_WRAPPER(ctfttp)
extern void ctfttp(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *arf,
    float  *ap,
    ptrdiff_t *info
);

/* Source: ctfttr.f */
#define ctfttr FORTRAN_WRAPPER(ctfttr)
extern void ctfttr(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *arf,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: ctgevc.f */
#define ctgevc FORTRAN_WRAPPER(ctgevc)
extern void ctgevc(
    const char   *side,
    const char   *howmny,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    const float  *s,
    const ptrdiff_t *lds,
    const float  *p,
    const ptrdiff_t *ldp,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: ctgex2.f */
#define ctgex2 FORTRAN_WRAPPER(ctgex2)
extern void ctgex2(
    const ptrdiff_t *wantq,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *q,
    const ptrdiff_t *ldq,
    float  *z,
    const ptrdiff_t *ldz,
    const ptrdiff_t *j1_,
    ptrdiff_t *info
);

/* Source: ctgexc.f */
#define ctgexc FORTRAN_WRAPPER(ctgexc)
extern void ctgexc(
    const ptrdiff_t *wantq,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *q,
    const ptrdiff_t *ldq,
    float  *z,
    const ptrdiff_t *ldz,
    const ptrdiff_t *ifst,
    ptrdiff_t *ilst,
    ptrdiff_t *info
);

/* Source: ctgsen.f */
#define ctgsen FORTRAN_WRAPPER(ctgsen)
extern void ctgsen(
    const ptrdiff_t *ijob,
    const ptrdiff_t *wantq,
    const ptrdiff_t *wantz,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *alpha,
    float  *beta,
    float  *q,
    const ptrdiff_t *ldq,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *m,
    float  *pl,
    float  *pr,
    float  *dif,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: ctgsja.f */
#define ctgsja FORTRAN_WRAPPER(ctgsja)
extern void ctgsja(
    const char   *jobu,
    const char   *jobv,
    const char   *jobq,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    const float  *tola,
    const float  *tolb,
    float  *alpha,
    float  *beta,
    float  *u,
    const ptrdiff_t *ldu,
    float  *v,
    const ptrdiff_t *ldv,
    float  *q,
    const ptrdiff_t *ldq,
    float  *work,
    ptrdiff_t *ncycle,
    ptrdiff_t *info
);

/* Source: ctgsna.f */
#define ctgsna FORTRAN_WRAPPER(ctgsna)
extern void ctgsna(
    const char   *job,
    const char   *howmny,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *vl,
    const ptrdiff_t *ldvl,
    const float  *vr,
    const ptrdiff_t *ldvr,
    float  *s,
    float  *dif,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: ctgsy2.f */
#define ctgsy2 FORTRAN_WRAPPER(ctgsy2)
extern void ctgsy2(
    const char   *trans,
    const ptrdiff_t *ijob,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *c,
    const ptrdiff_t *ldc,
    const float  *d,
    const ptrdiff_t *ldd,
    const float  *e,
    const ptrdiff_t *lde,
    float  *f,
    const ptrdiff_t *ldf,
    float  *scale,
    float  *rdsum,
    float  *rdscal,
    ptrdiff_t *info
);

/* Source: ctgsyl.f */
#define ctgsyl FORTRAN_WRAPPER(ctgsyl)
extern void ctgsyl(
    const char   *trans,
    const ptrdiff_t *ijob,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *c,
    const ptrdiff_t *ldc,
    const float  *d,
    const ptrdiff_t *ldd,
    const float  *e,
    const ptrdiff_t *lde,
    float  *f,
    const ptrdiff_t *ldf,
    float  *scale,
    float  *dif,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: ctpcon.f */
#define ctpcon FORTRAN_WRAPPER(ctpcon)
extern void ctpcon(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const float  *ap,
    float  *rcond,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: ctpmqrt.f */
#define ctpmqrt FORTRAN_WRAPPER(ctpmqrt)
extern void ctpmqrt(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const ptrdiff_t *nb,
    const float  *v,
    const ptrdiff_t *ldv,
    const float  *t,
    const ptrdiff_t *ldt,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *work,
    ptrdiff_t *info
);

/* Source: ctpqrt.f */
#define ctpqrt FORTRAN_WRAPPER(ctpqrt)
extern void ctpqrt(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    const ptrdiff_t *nb,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *t,
    const ptrdiff_t *ldt,
    const float  *work,
    ptrdiff_t *info
);

/* Source: ctpqrt2.f */
#define ctpqrt2 FORTRAN_WRAPPER(ctpqrt2)
extern void ctpqrt2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *t,
    const ptrdiff_t *ldt,
    ptrdiff_t *info
);

/* Source: ctprfb.f */
#define ctprfb FORTRAN_WRAPPER(ctprfb)
extern void ctprfb(
    const char   *side,
    const char   *trans,
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const float  *v,
    const ptrdiff_t *ldv,
    const float  *t,
    const ptrdiff_t *ldt,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *work,
    const ptrdiff_t *ldwork
);

/* Source: ctprfs.f */
#define ctprfs FORTRAN_WRAPPER(ctprfs)
extern void ctprfs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: ctptri.f */
#define ctptri FORTRAN_WRAPPER(ctptri)
extern void ctptri(
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    float  *ap,
    ptrdiff_t *info
);

/* Source: ctptrs.f */
#define ctptrs FORTRAN_WRAPPER(ctptrs)
extern void ctptrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: ctpttf.f */
#define ctpttf FORTRAN_WRAPPER(ctpttf)
extern void ctpttf(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    float  *arf,
    ptrdiff_t *info
);

/* Source: ctpttr.f */
#define ctpttr FORTRAN_WRAPPER(ctpttr)
extern void ctpttr(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: ctrcon.f */
#define ctrcon FORTRAN_WRAPPER(ctrcon)
extern void ctrcon(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *rcond,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: ctrevc.f */
#define ctrevc FORTRAN_WRAPPER(ctrevc)
extern void ctrevc(
    const char   *side,
    const char   *howmny,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    float  *t,
    const ptrdiff_t *ldt,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: ctrexc.f */
#define ctrexc FORTRAN_WRAPPER(ctrexc)
extern void ctrexc(
    const char   *compq,
    const ptrdiff_t *n,
    float  *t,
    const ptrdiff_t *ldt,
    float  *q,
    const ptrdiff_t *ldq,
    const ptrdiff_t *ifst,
    const ptrdiff_t *ilst,
    ptrdiff_t *info
);

/* Source: ctrrfs.f */
#define ctrrfs FORTRAN_WRAPPER(ctrrfs)
extern void ctrrfs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: ctrsen.f */
#define ctrsen FORTRAN_WRAPPER(ctrsen)
extern void ctrsen(
    const char   *job,
    const char   *compq,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    float  *t,
    const ptrdiff_t *ldt,
    float  *q,
    const ptrdiff_t *ldq,
    float  *w,
    ptrdiff_t *m,
    float  *s,
    float  *sep,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: ctrsna.f */
#define ctrsna FORTRAN_WRAPPER(ctrsna)
extern void ctrsna(
    const char   *job,
    const char   *howmny,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    const float  *t,
    const ptrdiff_t *ldt,
    const float  *vl,
    const ptrdiff_t *ldvl,
    const float  *vr,
    const ptrdiff_t *ldvr,
    float  *s,
    float  *sep,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    float  *work,
    const ptrdiff_t *ldwork,
    float  *rwork,
    ptrdiff_t *info
);

/* Source: ctrsyl.f */
#define ctrsyl FORTRAN_WRAPPER(ctrsyl)
extern void ctrsyl(
    const char   *trana,
    const char   *tranb,
    const ptrdiff_t *isgn,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *c,
    const ptrdiff_t *ldc,
    float  *scale,
    ptrdiff_t *info
);

/* Source: ctrti2.f */
#define ctrti2 FORTRAN_WRAPPER(ctrti2)
extern void ctrti2(
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: ctrtri.f */
#define ctrtri FORTRAN_WRAPPER(ctrtri)
extern void ctrtri(
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: ctrtrs.f */
#define ctrtrs FORTRAN_WRAPPER(ctrtrs)
extern void ctrtrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: ctrttf.f */
#define ctrttf FORTRAN_WRAPPER(ctrttf)
extern void ctrttf(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *arf,
    ptrdiff_t *info
);

/* Source: ctrttp.f */
#define ctrttp FORTRAN_WRAPPER(ctrttp)
extern void ctrttp(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *ap,
    ptrdiff_t *info
);

/* Source: ctzrqf.f */
#define ctzrqf FORTRAN_WRAPPER(ctzrqf)
extern void ctzrqf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    ptrdiff_t *info
);

/* Source: ctzrzf.f */
#define ctzrzf FORTRAN_WRAPPER(ctzrzf)
extern void ctzrzf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cunbdb.f */
#define cunbdb FORTRAN_WRAPPER(cunbdb)
extern void cunbdb(
    const char   *trans,
    const char   *signs,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *q,
    float  *x11,
    const ptrdiff_t *ldx11,
    float  *x12,
    const ptrdiff_t *ldx12,
    float  *x21,
    const ptrdiff_t *ldx21,
    float  *x22,
    const ptrdiff_t *ldx22,
    float  *theta,
    float  *phi,
    float  *taup1,
    float  *taup2,
    float  *tauq1,
    float  *tauq2,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cuncsd.f */
#define cuncsd FORTRAN_WRAPPER(cuncsd)
extern void cuncsd(
    const char   *jobu1,
    const char   *jobu2,
    const char   *jobv1t,
    const char   *jobv2t,
    const char   *trans,
    const char   *signs,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *q,
    float  *x11,
    const ptrdiff_t *ldx11,
    float  *x12,
    const ptrdiff_t *ldx12,
    float  *x21,
    const ptrdiff_t *ldx21,
    float  *x22,
    const ptrdiff_t *ldx22,
    float  *theta,
    float  *u1,
    const ptrdiff_t *ldu1,
    float  *u2,
    const ptrdiff_t *ldu2,
    float  *v1t,
    const ptrdiff_t *ldv1t,
    float  *v2t,
    const ptrdiff_t *ldv2t,
    float  *work,
    const ptrdiff_t *lwork,
    float  *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: cung2l.f */
#define cung2l FORTRAN_WRAPPER(cung2l)
extern void cung2l(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: cung2r.f */
#define cung2r FORTRAN_WRAPPER(cung2r)
extern void cung2r(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: cungbr.f */
#define cungbr FORTRAN_WRAPPER(cungbr)
extern void cungbr(
    const char   *vect,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cunghr.f */
#define cunghr FORTRAN_WRAPPER(cunghr)
extern void cunghr(
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cungl2.f */
#define cungl2 FORTRAN_WRAPPER(cungl2)
extern void cungl2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: cunglq.f */
#define cunglq FORTRAN_WRAPPER(cunglq)
extern void cunglq(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cungql.f */
#define cungql FORTRAN_WRAPPER(cungql)
extern void cungql(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cungqr.f */
#define cungqr FORTRAN_WRAPPER(cungqr)
extern void cungqr(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cungr2.f */
#define cungr2 FORTRAN_WRAPPER(cungr2)
extern void cungr2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: cungrq.f */
#define cungrq FORTRAN_WRAPPER(cungrq)
extern void cungrq(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cungtr.f */
#define cungtr FORTRAN_WRAPPER(cungtr)
extern void cungtr(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cunm2l.f */
#define cunm2l FORTRAN_WRAPPER(cunm2l)
extern void cunm2l(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: cunm2r.f */
#define cunm2r FORTRAN_WRAPPER(cunm2r)
extern void cunm2r(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: cunmbr.f */
#define cunmbr FORTRAN_WRAPPER(cunmbr)
extern void cunmbr(
    const char   *vect,
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cunmhr.f */
#define cunmhr FORTRAN_WRAPPER(cunmhr)
extern void cunmhr(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cunml2.f */
#define cunml2 FORTRAN_WRAPPER(cunml2)
extern void cunml2(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: cunmlq.f */
#define cunmlq FORTRAN_WRAPPER(cunmlq)
extern void cunmlq(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cunmql.f */
#define cunmql FORTRAN_WRAPPER(cunmql)
extern void cunmql(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cunmqr.f */
#define cunmqr FORTRAN_WRAPPER(cunmqr)
extern void cunmqr(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cunmr2.f */
#define cunmr2 FORTRAN_WRAPPER(cunmr2)
extern void cunmr2(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: cunmr3.f */
#define cunmr3 FORTRAN_WRAPPER(cunmr3)
extern void cunmr3(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: cunmrq.f */
#define cunmrq FORTRAN_WRAPPER(cunmrq)
extern void cunmrq(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cunmrz.f */
#define cunmrz FORTRAN_WRAPPER(cunmrz)
extern void cunmrz(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cunmtr.f */
#define cunmtr FORTRAN_WRAPPER(cunmtr)
extern void cunmtr(
    const char   *side,
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: cupgtr.f */
#define cupgtr FORTRAN_WRAPPER(cupgtr)
extern void cupgtr(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    const float  *tau,
    float  *q,
    const ptrdiff_t *ldq,
    float  *work,
    ptrdiff_t *info
);

/* Source: cupmtr.f */
#define cupmtr FORTRAN_WRAPPER(cupmtr)
extern void cupmtr(
    const char   *side,
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *ap,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: dbbcsd.f */
#define dbbcsd FORTRAN_WRAPPER(dbbcsd)
extern void dbbcsd(
    const char   *jobu1,
    const char   *jobu2,
    const char   *jobv1t,
    const char   *jobv2t,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *q,
    double *theta,
    double *phi,
    double *u1,
    const ptrdiff_t *ldu1,
    double *u2,
    const ptrdiff_t *ldu2,
    double *v1t,
    const ptrdiff_t *ldv1t,
    double *v2t,
    const ptrdiff_t *ldv2t,
    double *b11d,
    double *b11e,
    double *b12d,
    double *b12e,
    double *b21d,
    double *b21e,
    double *b22d,
    double *b22e,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dbdsdc.f */
#define dbdsdc FORTRAN_WRAPPER(dbdsdc)
extern void dbdsdc(
    const char   *uplo,
    const char   *compq,
    const ptrdiff_t *n,
    double *d,
    double *e,
    double *u,
    const ptrdiff_t *ldu,
    double *vt,
    const ptrdiff_t *ldvt,
    double *q,
    ptrdiff_t *iq,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dbdsqr.f */
#define dbdsqr FORTRAN_WRAPPER(dbdsqr)
extern void dbdsqr(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ncvt,
    const ptrdiff_t *nru,
    const ptrdiff_t *ncc,
    double *d,
    double *e,
    double *vt,
    const ptrdiff_t *ldvt,
    double *u,
    const ptrdiff_t *ldu,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: ddisna.f */
#define ddisna FORTRAN_WRAPPER(ddisna)
extern void ddisna(
    const char   *job,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *d,
    double *sep,
    ptrdiff_t *info
);

/* Source: dgbbrd.f */
#define dgbbrd FORTRAN_WRAPPER(dgbbrd)
extern void dgbbrd(
    const char   *vect,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *ncc,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    double *ab,
    const ptrdiff_t *ldab,
    double *d,
    double *e,
    double *q,
    const ptrdiff_t *ldq,
    double *pt,
    const ptrdiff_t *ldpt,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: dgbcon.f */
#define dgbcon FORTRAN_WRAPPER(dgbcon)
extern void dgbcon(
    const char   *norm,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const double *ab,
    const ptrdiff_t *ldab,
    const ptrdiff_t *ipiv,
    const double *anorm,
    double *rcond,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dgbequ.f */
#define dgbequ FORTRAN_WRAPPER(dgbequ)
extern void dgbequ(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const double *ab,
    const ptrdiff_t *ldab,
    double *r,
    double *c,
    double *rowcnd,
    double *colcnd,
    double *amax,
    ptrdiff_t *info
);

/* Source: dgbequb.f */
#define dgbequb FORTRAN_WRAPPER(dgbequb)
extern void dgbequb(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const double *ab,
    const ptrdiff_t *ldab,
    double *r,
    double *c,
    double *rowcnd,
    double *colcnd,
    double *amax,
    ptrdiff_t *info
);

/* Source: dgbrfs.f */
#define dgbrfs FORTRAN_WRAPPER(dgbrfs)
extern void dgbrfs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    const double *ab,
    const ptrdiff_t *ldab,
    const double *afb,
    const ptrdiff_t *ldafb,
    const ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dgbsv.f */
#define dgbsv FORTRAN_WRAPPER(dgbsv)
extern void dgbsv(
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    double *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dgbsvx.f */
#define dgbsvx FORTRAN_WRAPPER(dgbsvx)
extern void dgbsvx(
    const char   *fact,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    double *ab,
    const ptrdiff_t *ldab,
    double *afb,
    const ptrdiff_t *ldafb,
    ptrdiff_t *ipiv,
    char   *equed,
    double *r,
    double *c,
    double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dgbtf2.f */
#define dgbtf2 FORTRAN_WRAPPER(dgbtf2)
extern void dgbtf2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    double *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: dgbtrf.f */
#define dgbtrf FORTRAN_WRAPPER(dgbtrf)
extern void dgbtrf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    double *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: dgbtrs.f */
#define dgbtrs FORTRAN_WRAPPER(dgbtrs)
extern void dgbtrs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    const double *ab,
    const ptrdiff_t *ldab,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dgebak.f */
#define dgebak FORTRAN_WRAPPER(dgebak)
extern void dgebak(
    const char   *job,
    const char   *side,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    const double *scale,
    const ptrdiff_t *m,
    double *v,
    const ptrdiff_t *ldv,
    ptrdiff_t *info
);

/* Source: dgebal.f */
#define dgebal FORTRAN_WRAPPER(dgebal)
extern void dgebal(
    const char   *job,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    double *scale,
    ptrdiff_t *info
);

/* Source: dgebd2.f */
#define dgebd2 FORTRAN_WRAPPER(dgebd2)
extern void dgebd2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *d,
    double *e,
    double *tauq,
    double *taup,
    double *work,
    ptrdiff_t *info
);

/* Source: dgebrd.f */
#define dgebrd FORTRAN_WRAPPER(dgebrd)
extern void dgebrd(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *d,
    double *e,
    double *tauq,
    double *taup,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgecon.f */
#define dgecon FORTRAN_WRAPPER(dgecon)
extern void dgecon(
    const char   *norm,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *anorm,
    double *rcond,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dgeequ.f */
#define dgeequ FORTRAN_WRAPPER(dgeequ)
extern void dgeequ(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *r,
    double *c,
    double *rowcnd,
    double *colcnd,
    double *amax,
    ptrdiff_t *info
);

/* Source: dgeequb.f */
#define dgeequb FORTRAN_WRAPPER(dgeequb)
extern void dgeequb(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *r,
    double *c,
    double *rowcnd,
    double *colcnd,
    double *amax,
    ptrdiff_t *info
);

/* Source: dgees.f */
#define dgees FORTRAN_WRAPPER(dgees)
extern void dgees(
    const char   *jobvs,
    const char   *sort,
    ptrdiff_t (*select)(),
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *sdim,
    double *wr,
    double *wi,
    double *vs,
    const ptrdiff_t *ldvs,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: dgeesx.f */
#define dgeesx FORTRAN_WRAPPER(dgeesx)
extern void dgeesx(
    const char   *jobvs,
    const char   *sort,
    ptrdiff_t (*select)(),
    const char   *sense,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *sdim,
    double *wr,
    double *wi,
    double *vs,
    const ptrdiff_t *ldvs,
    double *rconde,
    double *rcondv,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: dgeev.f */
#define dgeev FORTRAN_WRAPPER(dgeev)
extern void dgeev(
    const char   *jobvl,
    const char   *jobvr,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *wr,
    double *wi,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgeevx.f */
#define dgeevx FORTRAN_WRAPPER(dgeevx)
extern void dgeevx(
    const char   *balanc,
    const char   *jobvl,
    const char   *jobvr,
    const char   *sense,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *wr,
    double *wi,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    double *scale,
    double *abnrm,
    double *rconde,
    double *rcondv,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dgegs.f */
#define dgegs FORTRAN_WRAPPER(dgegs)
extern void dgegs(
    const char   *jobvsl,
    const char   *jobvsr,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *alphar,
    double *alphai,
    double *beta,
    double *vsl,
    const ptrdiff_t *ldvsl,
    double *vsr,
    const ptrdiff_t *ldvsr,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgegv.f */
#define dgegv FORTRAN_WRAPPER(dgegv)
extern void dgegv(
    const char   *jobvl,
    const char   *jobvr,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *alphar,
    double *alphai,
    double *beta,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgehd2.f */
#define dgehd2 FORTRAN_WRAPPER(dgehd2)
extern void dgehd2(
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: dgehrd.f */
#define dgehrd FORTRAN_WRAPPER(dgehrd)
extern void dgehrd(
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgejsv.f */
#define dgejsv FORTRAN_WRAPPER(dgejsv)
extern void dgejsv(
    char   *joba,
    char   *jobu,
    char   *jobv,
    char   *jobr,
    char   *jobt,
    char   *jobp,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *sva,
    double *u,
    const ptrdiff_t *ldu,
    double *v,
    const ptrdiff_t *ldv,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dgelq2.f */
#define dgelq2 FORTRAN_WRAPPER(dgelq2)
extern void dgelq2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: dgelqf.f */
#define dgelqf FORTRAN_WRAPPER(dgelqf)
extern void dgelqf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgels.f */
#define dgels FORTRAN_WRAPPER(dgels)
extern void dgels(
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgelsd.f */
#define dgelsd FORTRAN_WRAPPER(dgelsd)
extern void dgelsd(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *s,
    const double *rcond,
    ptrdiff_t *rank,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dgelss.f */
#define dgelss FORTRAN_WRAPPER(dgelss)
extern void dgelss(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *s,
    const double *rcond,
    ptrdiff_t *rank,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgelsx.f */
#define dgelsx FORTRAN_WRAPPER(dgelsx)
extern void dgelsx(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *jpvt,
    const double *rcond,
    ptrdiff_t *rank,
    double *work,
    ptrdiff_t *info
);

/* Source: dgelsy.f */
#define dgelsy FORTRAN_WRAPPER(dgelsy)
extern void dgelsy(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *jpvt,
    const double *rcond,
    ptrdiff_t *rank,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgemqrt.f */
#define dgemqrt FORTRAN_WRAPPER(dgemqrt)
extern void dgemqrt(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *nb,
    const double *v,
    const ptrdiff_t *ldv,
    const double *t,
    const ptrdiff_t *ldt,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: dgeql2.f */
#define dgeql2 FORTRAN_WRAPPER(dgeql2)
extern void dgeql2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: dgeqlf.f */
#define dgeqlf FORTRAN_WRAPPER(dgeqlf)
extern void dgeqlf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgeqp3.f */
#define dgeqp3 FORTRAN_WRAPPER(dgeqp3)
extern void dgeqp3(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgeqpf.f */
#define dgeqpf FORTRAN_WRAPPER(dgeqpf)
extern void dgeqpf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: dgeqr2.f */
#define dgeqr2 FORTRAN_WRAPPER(dgeqr2)
extern void dgeqr2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: dgeqr2p.f */
#define dgeqr2p FORTRAN_WRAPPER(dgeqr2p)
extern void dgeqr2p(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: dgeqrf.f */
#define dgeqrf FORTRAN_WRAPPER(dgeqrf)
extern void dgeqrf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgeqrfp.f */
#define dgeqrfp FORTRAN_WRAPPER(dgeqrfp)
extern void dgeqrfp(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgeqrt.f */
#define dgeqrt FORTRAN_WRAPPER(dgeqrt)
extern void dgeqrt(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    double *a,
    const ptrdiff_t *lda,
    double *t,
    const ptrdiff_t *ldt,
    double *work,
    ptrdiff_t *info
);

/* Source: dgeqrt2.f */
#define dgeqrt2 FORTRAN_WRAPPER(dgeqrt2)
extern void dgeqrt2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *t,
    const ptrdiff_t *ldt,
    ptrdiff_t *info
);

/* Source: dgeqrt3.f */
#define dgeqrt3 FORTRAN_WRAPPER(dgeqrt3)
extern void dgeqrt3(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *t,
    const ptrdiff_t *ldt,
    ptrdiff_t *info
);

/* Source: dgerfs.f */
#define dgerfs FORTRAN_WRAPPER(dgerfs)
extern void dgerfs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const double *af,
    const ptrdiff_t *ldaf,
    const ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dgerq2.f */
#define dgerq2 FORTRAN_WRAPPER(dgerq2)
extern void dgerq2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: dgerqf.f */
#define dgerqf FORTRAN_WRAPPER(dgerqf)
extern void dgerqf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgesc2.f */
#define dgesc2 FORTRAN_WRAPPER(dgesc2)
extern void dgesc2(
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *rhs,
    const ptrdiff_t *ipiv,
    const ptrdiff_t *jpiv,
    double *scale
);

/* Source: dgesdd.f */
#define dgesdd FORTRAN_WRAPPER(dgesdd)
extern void dgesdd(
    const char   *jobz,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *s,
    double *u,
    const ptrdiff_t *ldu,
    double *vt,
    const ptrdiff_t *ldvt,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dgesv.f */
#define dgesv FORTRAN_WRAPPER(dgesv)
extern void dgesv(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dgesvd.f */
#define dgesvd FORTRAN_WRAPPER(dgesvd)
extern void dgesvd(
    const char   *jobu,
    const char   *jobvt,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *s,
    double *u,
    const ptrdiff_t *ldu,
    double *vt,
    const ptrdiff_t *ldvt,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgesvj.f */
#define dgesvj FORTRAN_WRAPPER(dgesvj)
extern void dgesvj(
    const char   *joba,
    const char   *jobu,
    const char   *jobv,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *sva,
    const ptrdiff_t *mv,
    double *v,
    const ptrdiff_t *ldv,
    double *work,
    ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgesvx.f */
#define dgesvx FORTRAN_WRAPPER(dgesvx)
extern void dgesvx(
    const char   *fact,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    double *af,
    const ptrdiff_t *ldaf,
    ptrdiff_t *ipiv,
    char   *equed,
    double *r,
    double *c,
    double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dgetc2.f */
#define dgetc2 FORTRAN_WRAPPER(dgetc2)
extern void dgetc2(
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *jpiv,
    ptrdiff_t *info
);

/* Source: dgetf2.f */
#define dgetf2 FORTRAN_WRAPPER(dgetf2)
extern void dgetf2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: dgetrf.f */
#define dgetrf FORTRAN_WRAPPER(dgetrf)
extern void dgetrf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: dgetri.f */
#define dgetri FORTRAN_WRAPPER(dgetri)
extern void dgetri(
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgetrs.f */
#define dgetrs FORTRAN_WRAPPER(dgetrs)
extern void dgetrs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dggbak.f */
#define dggbak FORTRAN_WRAPPER(dggbak)
extern void dggbak(
    const char   *job,
    const char   *side,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    const double *lscale,
    const double *rscale,
    const ptrdiff_t *m,
    double *v,
    const ptrdiff_t *ldv,
    ptrdiff_t *info
);

/* Source: dggbal.f */
#define dggbal FORTRAN_WRAPPER(dggbal)
extern void dggbal(
    const char   *job,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    double *lscale,
    double *rscale,
    double *work,
    ptrdiff_t *info
);

/* Source: dgges.f */
#define dgges FORTRAN_WRAPPER(dgges)
extern void dgges(
    const char   *jobvsl,
    const char   *jobvsr,
    const char   *sort,
    ptrdiff_t (*selctg)(),
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *sdim,
    double *alphar,
    double *alphai,
    double *beta,
    double *vsl,
    const ptrdiff_t *ldvsl,
    double *vsr,
    const ptrdiff_t *ldvsr,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: dggesx.f */
#define dggesx FORTRAN_WRAPPER(dggesx)
extern void dggesx(
    const char   *jobvsl,
    const char   *jobvsr,
    const char   *sort,
    ptrdiff_t (*selctg)(),
    const char   *sense,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *sdim,
    double *alphar,
    double *alphai,
    double *beta,
    double *vsl,
    const ptrdiff_t *ldvsl,
    double *vsr,
    const ptrdiff_t *ldvsr,
    double *rconde,
    double *rcondv,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: dggev.f */
#define dggev FORTRAN_WRAPPER(dggev)
extern void dggev(
    const char   *jobvl,
    const char   *jobvr,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *alphar,
    double *alphai,
    double *beta,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dggevx.f */
#define dggevx FORTRAN_WRAPPER(dggevx)
extern void dggevx(
    const char   *balanc,
    const char   *jobvl,
    const char   *jobvr,
    const char   *sense,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *alphar,
    double *alphai,
    double *beta,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    double *lscale,
    double *rscale,
    double *abnrm,
    double *bbnrm,
    double *rconde,
    double *rcondv,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: dggglm.f */
#define dggglm FORTRAN_WRAPPER(dggglm)
extern void dggglm(
    const ptrdiff_t *n,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *d,
    double *x,
    double *y,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgghrd.f */
#define dgghrd FORTRAN_WRAPPER(dgghrd)
extern void dgghrd(
    const char   *compq,
    const char   *compz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *q,
    const ptrdiff_t *ldq,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *info
);

/* Source: dgglse.f */
#define dgglse FORTRAN_WRAPPER(dgglse)
extern void dgglse(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *p,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *c,
    double *d,
    double *x,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dggqrf.f */
#define dggqrf FORTRAN_WRAPPER(dggqrf)
extern void dggqrf(
    const ptrdiff_t *n,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    double *a,
    const ptrdiff_t *lda,
    double *taua,
    double *b,
    const ptrdiff_t *ldb,
    double *taub,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dggrqf.f */
#define dggrqf FORTRAN_WRAPPER(dggrqf)
extern void dggrqf(
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *taua,
    double *b,
    const ptrdiff_t *ldb,
    double *taub,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dggsvd.f */
#define dggsvd FORTRAN_WRAPPER(dggsvd)
extern void dggsvd(
    const char   *jobu,
    const char   *jobv,
    const char   *jobq,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *p,
    ptrdiff_t *k,
    ptrdiff_t *l,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *alpha,
    double *beta,
    double *u,
    const ptrdiff_t *ldu,
    double *v,
    const ptrdiff_t *ldv,
    double *q,
    const ptrdiff_t *ldq,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dggsvp.f */
#define dggsvp FORTRAN_WRAPPER(dggsvp)
extern void dggsvp(
    const char   *jobu,
    const char   *jobv,
    const char   *jobq,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    const double *tola,
    const double *tolb,
    ptrdiff_t *k,
    ptrdiff_t *l,
    double *u,
    const ptrdiff_t *ldu,
    double *v,
    const ptrdiff_t *ldv,
    double *q,
    const ptrdiff_t *ldq,
    ptrdiff_t *iwork,
    double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: dgsvj0.f */
#define dgsvj0 FORTRAN_WRAPPER(dgsvj0)
extern void dgsvj0(
    const char   *jobv,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *d,
    double *sva,
    const ptrdiff_t *mv,
    double *v,
    const ptrdiff_t *ldv,
    const double *eps,
    const double *sfmin,
    const double *tol,
    const ptrdiff_t *nsweep,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgsvj1.f */
#define dgsvj1 FORTRAN_WRAPPER(dgsvj1)
extern void dgsvj1(
    const char   *jobv,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *n1,
    double *a,
    const ptrdiff_t *lda,
    double *d,
    double *sva,
    const ptrdiff_t *mv,
    double *v,
    const ptrdiff_t *ldv,
    const double *eps,
    const double *sfmin,
    const double *tol,
    const ptrdiff_t *nsweep,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dgtcon.f */
#define dgtcon FORTRAN_WRAPPER(dgtcon)
extern void dgtcon(
    const char   *norm,
    const ptrdiff_t *n,
    const double *dl,
    const double *d,
    const double *du,
    const double *du2,
    const ptrdiff_t *ipiv,
    const double *anorm,
    double *rcond,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dgtrfs.f */
#define dgtrfs FORTRAN_WRAPPER(dgtrfs)
extern void dgtrfs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *dl,
    const double *d,
    const double *du,
    const double *dlf,
    const double *df,
    const double *duf,
    const double *du2,
    const ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dgtsv.f */
#define dgtsv FORTRAN_WRAPPER(dgtsv)
extern void dgtsv(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *dl,
    double *d,
    double *du,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dgtsvx.f */
#define dgtsvx FORTRAN_WRAPPER(dgtsvx)
extern void dgtsvx(
    const char   *fact,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *dl,
    const double *d,
    const double *du,
    double *dlf,
    double *df,
    double *duf,
    double *du2,
    ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dgttrf.f */
#define dgttrf FORTRAN_WRAPPER(dgttrf)
extern void dgttrf(
    const ptrdiff_t *n,
    double *dl,
    double *d,
    double *du,
    double *du2,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: dgttrs.f */
#define dgttrs FORTRAN_WRAPPER(dgttrs)
extern void dgttrs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *dl,
    const double *d,
    const double *du,
    const double *du2,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dgtts2.f */
#define dgtts2 FORTRAN_WRAPPER(dgtts2)
extern void dgtts2(
    const ptrdiff_t *itrans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *dl,
    const double *d,
    const double *du,
    const double *du2,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb
);

/* Source: dhgeqz.f */
#define dhgeqz FORTRAN_WRAPPER(dhgeqz)
extern void dhgeqz(
    const char   *job,
    const char   *compq,
    const char   *compz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *h,
    const ptrdiff_t *ldh,
    double *t,
    const ptrdiff_t *ldt,
    double *alphar,
    double *alphai,
    double *beta,
    double *q,
    const ptrdiff_t *ldq,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dhsein.f */
#define dhsein FORTRAN_WRAPPER(dhsein)
extern void dhsein(
    const char   *side,
    const char   *eigsrc,
    const char   *initv,
    ptrdiff_t *select,
    const ptrdiff_t *n,
    const double *h,
    const ptrdiff_t *ldh,
    double *wr,
    const double *wi,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    double *work,
    ptrdiff_t *ifaill,
    ptrdiff_t *ifailr,
    ptrdiff_t *info
);

/* Source: dhseqr.f */
#define dhseqr FORTRAN_WRAPPER(dhseqr)
extern void dhseqr(
    const char   *job,
    const char   *compz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *h,
    const ptrdiff_t *ldh,
    double *wr,
    double *wi,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: disnan.f */
#define disnan FORTRAN_WRAPPER(disnan)
extern ptrdiff_t disnan(
    const double *din
);

/* Source: dlabad.f */
#define dlabad FORTRAN_WRAPPER(dlabad)
extern void dlabad(
    double *small,
    double *large
);

/* Source: dlabrd.f */
#define dlabrd FORTRAN_WRAPPER(dlabrd)
extern void dlabrd(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    double *a,
    const ptrdiff_t *lda,
    double *d,
    double *e,
    double *tauq,
    double *taup,
    double *x,
    const ptrdiff_t *ldx,
    double *y,
    const ptrdiff_t *ldy
);

/* Source: dlacn2.f */
#define dlacn2 FORTRAN_WRAPPER(dlacn2)
extern void dlacn2(
    const ptrdiff_t *n,
    double *v,
    double *x,
    ptrdiff_t *isgn,
    double *est,
    ptrdiff_t *kase,
    ptrdiff_t *isave
);

/* Source: dlacon.f */
#define dlacon FORTRAN_WRAPPER(dlacon)
extern void dlacon(
    const ptrdiff_t *n,
    double *v,
    double *x,
    ptrdiff_t *isgn,
    double *est,
    ptrdiff_t *kase
);

/* Source: dlacpy.f */
#define dlacpy FORTRAN_WRAPPER(dlacpy)
extern void dlacpy(
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb
);

/* Source: dladiv.f */
#define dladiv FORTRAN_WRAPPER(dladiv)
extern void dladiv(
    const double *a,
    const double *b,
    const double *c,
    const double *d,
    double *p,
    double *q
);

/* Source: dlae2.f */
#define dlae2 FORTRAN_WRAPPER(dlae2)
extern void dlae2(
    const double *a,
    const double *b,
    const double *c,
    double *rt1,
    double *rt2
);

/* Source: dlaebz.f */
#define dlaebz FORTRAN_WRAPPER(dlaebz)
extern void dlaebz(
    const ptrdiff_t *ijob,
    const ptrdiff_t *nitmax,
    const ptrdiff_t *n,
    const ptrdiff_t *mmax,
    const ptrdiff_t *minp,
    const ptrdiff_t *nbmin,
    const double *abstol,
    const double *reltol,
    const double *pivmin,
    const double *d,
    const double *e,
    const double *e2,
    ptrdiff_t *nval,
    double *ab,
    double *c,
    ptrdiff_t *mout,
    ptrdiff_t *nab,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dlaed0.f */
#define dlaed0 FORTRAN_WRAPPER(dlaed0)
extern void dlaed0(
    const ptrdiff_t *icompq,
    const ptrdiff_t *qsiz,
    const ptrdiff_t *n,
    double *d,
    const double *e,
    double *q,
    const ptrdiff_t *ldq,
    double *qstore,
    const ptrdiff_t *ldqs,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dlaed1.f */
#define dlaed1 FORTRAN_WRAPPER(dlaed1)
extern void dlaed1(
    const ptrdiff_t *n,
    double *d,
    double *q,
    const ptrdiff_t *ldq,
    ptrdiff_t *indxq,
    const double *rho,
    const ptrdiff_t *cutpnt,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dlaed2.f */
#define dlaed2 FORTRAN_WRAPPER(dlaed2)
extern void dlaed2(
    ptrdiff_t *k,
    const ptrdiff_t *n,
    const ptrdiff_t *n1,
    double *d,
    double *q,
    const ptrdiff_t *ldq,
    ptrdiff_t *indxq,
    double *rho,
    const double *z,
    double *dlamda,
    double *w,
    double *q2,
    ptrdiff_t *indx,
    ptrdiff_t *indxc,
    ptrdiff_t *indxp,
    ptrdiff_t *coltyp,
    ptrdiff_t *info
);

/* Source: dlaed3.f */
#define dlaed3 FORTRAN_WRAPPER(dlaed3)
extern void dlaed3(
    const ptrdiff_t *k,
    const ptrdiff_t *n,
    const ptrdiff_t *n1,
    double *d,
    double *q,
    const ptrdiff_t *ldq,
    const double *rho,
    double *dlamda,
    const double *q2,
    const ptrdiff_t *indx,
    const ptrdiff_t *ctot,
    double *w,
    double *s,
    ptrdiff_t *info
);

/* Source: dlaed4.f */
#define dlaed4 FORTRAN_WRAPPER(dlaed4)
extern void dlaed4(
    const ptrdiff_t *n,
    const ptrdiff_t *i,
    const double *d,
    const double *z,
    double *delta,
    const double *rho,
    double *dlam,
    ptrdiff_t *info
);

/* Source: dlaed5.f */
#define dlaed5 FORTRAN_WRAPPER(dlaed5)
extern void dlaed5(
    const ptrdiff_t *i,
    const double *d,
    const double *z,
    double *delta,
    const double *rho,
    double *dlam
);

/* Source: dlaed6.f */
#define dlaed6 FORTRAN_WRAPPER(dlaed6)
extern void dlaed6(
    const ptrdiff_t *kniter,
    const ptrdiff_t *orgati,
    const double *rho,
    const double *d,
    const double *z,
    const double *finit,
    double *tau,
    ptrdiff_t *info
);

/* Source: dlaed7.f */
#define dlaed7 FORTRAN_WRAPPER(dlaed7)
extern void dlaed7(
    const ptrdiff_t *icompq,
    const ptrdiff_t *n,
    const ptrdiff_t *qsiz,
    const ptrdiff_t *tlvls,
    const ptrdiff_t *curlvl,
    const ptrdiff_t *curpbm,
    double *d,
    double *q,
    const ptrdiff_t *ldq,
    ptrdiff_t *indxq,
    const double *rho,
    const ptrdiff_t *cutpnt,
    double *qstore,
    ptrdiff_t *qptr,
    const ptrdiff_t *prmptr,
    const ptrdiff_t *perm,
    const ptrdiff_t *givptr,
    const ptrdiff_t *givcol,
    const double *givnum,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dlaed8.f */
#define dlaed8 FORTRAN_WRAPPER(dlaed8)
extern void dlaed8(
    const ptrdiff_t *icompq,
    ptrdiff_t *k,
    const ptrdiff_t *n,
    const ptrdiff_t *qsiz,
    double *d,
    double *q,
    const ptrdiff_t *ldq,
    const ptrdiff_t *indxq,
    double *rho,
    const ptrdiff_t *cutpnt,
    const double *z,
    double *dlamda,
    double *q2,
    const ptrdiff_t *ldq2,
    double *w,
    ptrdiff_t *perm,
    ptrdiff_t *givptr,
    ptrdiff_t *givcol,
    double *givnum,
    ptrdiff_t *indxp,
    ptrdiff_t *indx,
    ptrdiff_t *info
);

/* Source: dlaed9.f */
#define dlaed9 FORTRAN_WRAPPER(dlaed9)
extern void dlaed9(
    const ptrdiff_t *k,
    const ptrdiff_t *kstart,
    const ptrdiff_t *kstop,
    const ptrdiff_t *n,
    double *d,
    double *q,
    const ptrdiff_t *ldq,
    const double *rho,
    const double *dlamda,
    const double *w,
    double *s,
    const ptrdiff_t *lds,
    ptrdiff_t *info
);

/* Source: dlaeda.f */
#define dlaeda FORTRAN_WRAPPER(dlaeda)
extern void dlaeda(
    const ptrdiff_t *n,
    const ptrdiff_t *tlvls,
    const ptrdiff_t *curlvl,
    const ptrdiff_t *curpbm,
    const ptrdiff_t *prmptr,
    const ptrdiff_t *perm,
    const ptrdiff_t *givptr,
    const ptrdiff_t *givcol,
    const double *givnum,
    const double *q,
    const ptrdiff_t *qptr,
    double *z,
    double *ztemp,
    ptrdiff_t *info
);

/* Source: dlaein.f */
#define dlaein FORTRAN_WRAPPER(dlaein)
extern void dlaein(
    const ptrdiff_t *rightv,
    const ptrdiff_t *noinit,
    const ptrdiff_t *n,
    const double *h,
    const ptrdiff_t *ldh,
    const double *wr,
    const double *wi,
    double *vr,
    double *vi,
    double *b,
    const ptrdiff_t *ldb,
    double *work,
    const double *eps3,
    const double *smlnum,
    const double *bignum,
    ptrdiff_t *info
);

/* Source: dlaev2.f */
#define dlaev2 FORTRAN_WRAPPER(dlaev2)
extern void dlaev2(
    const double *a,
    const double *b,
    const double *c,
    double *rt1,
    double *rt2,
    double *cs1,
    double *sn1
);

/* Source: dlaexc.f */
#define dlaexc FORTRAN_WRAPPER(dlaexc)
extern void dlaexc(
    const ptrdiff_t *wantq,
    const ptrdiff_t *n,
    double *t,
    const ptrdiff_t *ldt,
    double *q,
    const ptrdiff_t *ldq,
    const ptrdiff_t *j1_,
    const ptrdiff_t *n1,
    const ptrdiff_t *n2,
    double *work,
    ptrdiff_t *info
);

/* Source: dlag2.f */
#define dlag2 FORTRAN_WRAPPER(dlag2)
extern void dlag2(
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *safmin,
    double *scale1,
    double *scale2,
    double *wr1,
    double *wr2,
    double *wi
);

/* Source: dlag2s.f */
#define dlag2s FORTRAN_WRAPPER(dlag2s)
extern void dlag2s(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    float  *sa,
    const ptrdiff_t *ldsa,
    ptrdiff_t *info
);

/* Source: dlags2.f */
#define dlags2 FORTRAN_WRAPPER(dlags2)
extern void dlags2(
    const ptrdiff_t *upper,
    const double *a1,
    const double *a2,
    const double *a3,
    const double *b1,
    const double *b2,
    const double *b3,
    double *csu,
    double *snu,
    double *csv,
    double *snv,
    double *csq,
    double *snq
);

/* Source: dlagtf.f */
#define dlagtf FORTRAN_WRAPPER(dlagtf)
extern void dlagtf(
    const ptrdiff_t *n,
    double *a,
    const double *lambda,
    double *b,
    double *c,
    const double *tol,
    double *d,
    ptrdiff_t *in,
    ptrdiff_t *info
);

/* Source: dlagtm.f */
#define dlagtm FORTRAN_WRAPPER(dlagtm)
extern void dlagtm(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *alpha,
    const double *dl,
    const double *d,
    const double *du,
    const double *x,
    const ptrdiff_t *ldx,
    const double *beta,
    double *b,
    const ptrdiff_t *ldb
);

/* Source: dlagts.f */
#define dlagts FORTRAN_WRAPPER(dlagts)
extern void dlagts(
    const ptrdiff_t *job,
    const ptrdiff_t *n,
    const double *a,
    const double *b,
    const double *c,
    const double *d,
    const ptrdiff_t *in,
    double *y,
    double *tol,
    ptrdiff_t *info
);

/* Source: dlagv2.f */
#define dlagv2 FORTRAN_WRAPPER(dlagv2)
extern void dlagv2(
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *alphar,
    double *alphai,
    double *beta,
    double *csl,
    double *snl,
    double *csr,
    double *snr
);

/* Source: dlahqr.f */
#define dlahqr FORTRAN_WRAPPER(dlahqr)
extern void dlahqr(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *h,
    const ptrdiff_t *ldh,
    double *wr,
    double *wi,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *info
);

/* Source: dlahr2.f */
#define dlahr2 FORTRAN_WRAPPER(dlahr2)
extern void dlahr2(
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *nb,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *t,
    const ptrdiff_t *ldt,
    double *y,
    const ptrdiff_t *ldy
);

/* Source: dlahrd.f */
#define dlahrd FORTRAN_WRAPPER(dlahrd)
extern void dlahrd(
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *nb,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *t,
    const ptrdiff_t *ldt,
    double *y,
    const ptrdiff_t *ldy
);

/* Source: dlaic1.f */
#define dlaic1 FORTRAN_WRAPPER(dlaic1)
extern void dlaic1(
    const ptrdiff_t *job,
    const ptrdiff_t *j,
    const double *x,
    const double *sest,
    const double *w,
    const double *gamma_,
    double *sestpr,
    double *s,
    double *c
);

/* Source: dlaisnan.f */
#define dlaisnan FORTRAN_WRAPPER(dlaisnan)
extern ptrdiff_t dlaisnan(
    const double *din1,
    const double *din2
);

/* Source: dlaln2.f */
#define dlaln2 FORTRAN_WRAPPER(dlaln2)
extern void dlaln2(
    const ptrdiff_t *ltrans,
    const ptrdiff_t *na,
    const ptrdiff_t *nw,
    const double *smin,
    const double *ca,
    const double *a,
    const ptrdiff_t *lda,
    const double *d1,
    const double *d2,
    const double *b,
    const ptrdiff_t *ldb,
    const double *wr,
    const double *wi,
    double *x,
    const ptrdiff_t *ldx,
    double *scale,
    double *xnorm,
    ptrdiff_t *info
);

/* Source: dlals0.f */
#define dlals0 FORTRAN_WRAPPER(dlals0)
extern void dlals0(
    const ptrdiff_t *icompq,
    const ptrdiff_t *nl,
    const ptrdiff_t *nr,
    const ptrdiff_t *sqre,
    const ptrdiff_t *nrhs,
    double *b,
    const ptrdiff_t *ldb,
    double *bx,
    const ptrdiff_t *ldbx,
    const ptrdiff_t *perm,
    const ptrdiff_t *givptr,
    const ptrdiff_t *givcol,
    const ptrdiff_t *ldgcol,
    const double *givnum,
    const ptrdiff_t *ldgnum,
    const double *poles,
    const double *difl,
    const double *difr,
    const double *z,
    const ptrdiff_t *k,
    const double *c,
    const double *s,
    double *work,
    ptrdiff_t *info
);

/* Source: dlalsa.f */
#define dlalsa FORTRAN_WRAPPER(dlalsa)
extern void dlalsa(
    const ptrdiff_t *icompq,
    const ptrdiff_t *smlsiz,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *b,
    const ptrdiff_t *ldb,
    double *bx,
    const ptrdiff_t *ldbx,
    const double *u,
    const ptrdiff_t *ldu,
    const double *vt,
    const ptrdiff_t *k,
    const double *difl,
    const double *difr,
    const double *z,
    const double *poles,
    const ptrdiff_t *givptr,
    const ptrdiff_t *givcol,
    const ptrdiff_t *ldgcol,
    const ptrdiff_t *perm,
    const double *givnum,
    const double *c,
    const double *s,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dlalsd.f */
#define dlalsd FORTRAN_WRAPPER(dlalsd)
extern void dlalsd(
    const char   *uplo,
    const ptrdiff_t *smlsiz,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *d,
    double *e,
    double *b,
    const ptrdiff_t *ldb,
    const double *rcond,
    ptrdiff_t *rank,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dlamrg.f */
#define dlamrg FORTRAN_WRAPPER(dlamrg)
extern void dlamrg(
    const ptrdiff_t *n1,
    const ptrdiff_t *n2,
    const double *a,
    const ptrdiff_t *dtrd1,
    const ptrdiff_t *dtrd2,
    ptrdiff_t *index
);

/* Source: dlaneg.f */
#define dlaneg FORTRAN_WRAPPER(dlaneg)
extern ptrdiff_t dlaneg(
    const ptrdiff_t *n,
    const double *d,
    const double *lld,
    const double *sigma,
    const double *pivmin,
    const ptrdiff_t *r
);

/* Source: dlangb.f */
#define dlangb FORTRAN_WRAPPER(dlangb)
extern double dlangb(
    const char   *norm,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const double *ab,
    const ptrdiff_t *ldab,
    double *work
);

/* Source: dlange.f */
#define dlange FORTRAN_WRAPPER(dlange)
extern double dlange(
    const char   *norm,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *work
);

/* Source: dlangt.f */
#define dlangt FORTRAN_WRAPPER(dlangt)
extern double dlangt(
    const char   *norm,
    const ptrdiff_t *n,
    const double *dl,
    const double *d,
    const double *du
);

/* Source: dlanhs.f */
#define dlanhs FORTRAN_WRAPPER(dlanhs)
extern double dlanhs(
    const char   *norm,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *work
);

/* Source: dlansb.f */
#define dlansb FORTRAN_WRAPPER(dlansb)
extern double dlansb(
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *ab,
    const ptrdiff_t *ldab,
    double *work
);

/* Source: dlansf.f */
#define dlansf FORTRAN_WRAPPER(dlansf)
extern double dlansf(
    const char   *norm,
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    double *work
);

/* Source: dlansp.f */
#define dlansp FORTRAN_WRAPPER(dlansp)
extern double dlansp(
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    double *work
);

/* Source: dlanst.f */
#define dlanst FORTRAN_WRAPPER(dlanst)
extern double dlanst(
    const char   *norm,
    const ptrdiff_t *n,
    const double *d,
    const double *e
);

/* Source: dlansy.f */
#define dlansy FORTRAN_WRAPPER(dlansy)
extern double dlansy(
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *work
);

/* Source: dlantb.f */
#define dlantb FORTRAN_WRAPPER(dlantb)
extern double dlantb(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *ab,
    const ptrdiff_t *ldab,
    double *work
);

/* Source: dlantp.f */
#define dlantp FORTRAN_WRAPPER(dlantp)
extern double dlantp(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const double *ap,
    double *work
);

/* Source: dlantr.f */
#define dlantr FORTRAN_WRAPPER(dlantr)
extern double dlantr(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *work
);

/* Source: dlanv2.f */
#define dlanv2 FORTRAN_WRAPPER(dlanv2)
extern void dlanv2(
    double *a,
    double *b,
    double *c,
    double *d,
    double *rt1r,
    double *rt1i,
    double *rt2r,
    double *rt2i,
    double *cs,
    double *sn
);

/* Source: dlapll.f */
#define dlapll FORTRAN_WRAPPER(dlapll)
extern void dlapll(
    const ptrdiff_t *n,
    double *x,
    const ptrdiff_t *incx,
    double *y,
    const ptrdiff_t *incy,
    double *ssmin
);

/* Source: dlapmr.f */
#define dlapmr FORTRAN_WRAPPER(dlapmr)
extern void dlapmr(
    const ptrdiff_t *forwrd,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *x,
    const ptrdiff_t *ldx,
    ptrdiff_t *k
);

/* Source: dlapmt.f */
#define dlapmt FORTRAN_WRAPPER(dlapmt)
extern void dlapmt(
    const ptrdiff_t *forwrd,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *x,
    const ptrdiff_t *ldx,
    ptrdiff_t *k
);

/* Source: dlapy2.f */
#define dlapy2 FORTRAN_WRAPPER(dlapy2)
extern double dlapy2(
    const double *x,
    const double *y
);

/* Source: dlapy3.f */
#define dlapy3 FORTRAN_WRAPPER(dlapy3)
extern double dlapy3(
    const double *x,
    const double *y,
    const double *z
);

/* Source: dlaqgb.f */
#define dlaqgb FORTRAN_WRAPPER(dlaqgb)
extern void dlaqgb(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    double *ab,
    const ptrdiff_t *ldab,
    const double *r,
    const double *c,
    const double *rowcnd,
    const double *colcnd,
    const double *amax,
    char   *equed
);

/* Source: dlaqge.f */
#define dlaqge FORTRAN_WRAPPER(dlaqge)
extern void dlaqge(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const double *r,
    const double *c,
    const double *rowcnd,
    const double *colcnd,
    const double *amax,
    char   *equed
);

/* Source: dlaqp2.f */
#define dlaqp2 FORTRAN_WRAPPER(dlaqp2)
extern void dlaqp2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *offset,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    double *tau,
    double *vn1,
    double *vn2,
    double *work
);

/* Source: dlaqps.f */
#define dlaqps FORTRAN_WRAPPER(dlaqps)
extern void dlaqps(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *offset,
    const ptrdiff_t *nb,
    ptrdiff_t *kb,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    double *tau,
    double *vn1,
    double *vn2,
    double *auxv,
    double *f,
    const ptrdiff_t *ldf
);

/* Source: dlaqr0.f */
#define dlaqr0 FORTRAN_WRAPPER(dlaqr0)
extern void dlaqr0(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *h,
    const ptrdiff_t *ldh,
    double *wr,
    double *wi,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dlaqr1.f */
#define dlaqr1 FORTRAN_WRAPPER(dlaqr1)
extern void dlaqr1(
    const ptrdiff_t *n,
    const double *h,
    const ptrdiff_t *ldh,
    const double *sr1,
    double *si1,
    double *sr2,
    double *si2,
    double *v
);

/* Source: dlaqr2.f */
#define dlaqr2 FORTRAN_WRAPPER(dlaqr2)
extern void dlaqr2(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ktop,
    const ptrdiff_t *kbot,
    const ptrdiff_t *nw,
    double *h,
    const ptrdiff_t *ldh,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *ns,
    ptrdiff_t *nd,
    double *sr,
    double *si,
    double *v,
    const ptrdiff_t *ldv,
    const ptrdiff_t *nh,
    double *t,
    const ptrdiff_t *ldt,
    const ptrdiff_t *nv,
    double *wv,
    const ptrdiff_t *ldwv,
    double *work,
    const ptrdiff_t *lwork
);

/* Source: dlaqr3.f */
#define dlaqr3 FORTRAN_WRAPPER(dlaqr3)
extern void dlaqr3(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ktop,
    const ptrdiff_t *kbot,
    const ptrdiff_t *nw,
    double *h,
    const ptrdiff_t *ldh,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *ns,
    ptrdiff_t *nd,
    double *sr,
    double *si,
    double *v,
    const ptrdiff_t *ldv,
    const ptrdiff_t *nh,
    double *t,
    const ptrdiff_t *ldt,
    const ptrdiff_t *nv,
    double *wv,
    const ptrdiff_t *ldwv,
    double *work,
    const ptrdiff_t *lwork
);

/* Source: dlaqr4.f */
#define dlaqr4 FORTRAN_WRAPPER(dlaqr4)
extern void dlaqr4(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *h,
    const ptrdiff_t *ldh,
    double *wr,
    double *wi,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dlaqr5.f */
#define dlaqr5 FORTRAN_WRAPPER(dlaqr5)
extern void dlaqr5(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *kacc22,
    const ptrdiff_t *n,
    const ptrdiff_t *ktop,
    const ptrdiff_t *kbot,
    const ptrdiff_t *nshfts,
    double *sr,
    double *si,
    double *h,
    const ptrdiff_t *ldh,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    double *z,
    const ptrdiff_t *ldz,
    double *v,
    const ptrdiff_t *ldv,
    double *u,
    const ptrdiff_t *ldu,
    const ptrdiff_t *nv,
    double *wv,
    const ptrdiff_t *ldwv,
    const ptrdiff_t *nh,
    double *wh,
    const ptrdiff_t *ldwh
);

/* Source: dlaqsb.f */
#define dlaqsb FORTRAN_WRAPPER(dlaqsb)
extern void dlaqsb(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    const double *s,
    const double *scond,
    const double *amax,
    char   *equed
);

/* Source: dlaqsp.f */
#define dlaqsp FORTRAN_WRAPPER(dlaqsp)
extern void dlaqsp(
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    const double *s,
    const double *scond,
    const double *amax,
    char   *equed
);

/* Source: dlaqsy.f */
#define dlaqsy FORTRAN_WRAPPER(dlaqsy)
extern void dlaqsy(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const double *s,
    const double *scond,
    const double *amax,
    char   *equed
);

/* Source: dlaqtr.f */
#define dlaqtr FORTRAN_WRAPPER(dlaqtr)
extern void dlaqtr(
    const ptrdiff_t *ltran,
    const ptrdiff_t *lreal,
    const ptrdiff_t *n,
    const double *t,
    const ptrdiff_t *ldt,
    const double *b,
    const double *w,
    double *scale,
    double *x,
    double *work,
    ptrdiff_t *info
);

/* Source: dlar1v.f */
#define dlar1v FORTRAN_WRAPPER(dlar1v)
extern void dlar1v(
    const ptrdiff_t *n,
    const ptrdiff_t *b1,
    const ptrdiff_t *bn,
    const double *lambda,
    const double *d,
    const double *l,
    const double *ld,
    const double *lld,
    const double *pivmin,
    const double *gaptol,
    double *z,
    const ptrdiff_t *wantnc,
    ptrdiff_t *negcnt,
    double *ztz,
    double *mingma,
    ptrdiff_t *r,
    ptrdiff_t *isuppz,
    double *nrminv,
    double *resid,
    double *rqcorr,
    double *work
);

/* Source: dlar2v.f */
#define dlar2v FORTRAN_WRAPPER(dlar2v)
extern void dlar2v(
    const ptrdiff_t *n,
    double *x,
    double *y,
    double *z,
    const ptrdiff_t *incx,
    const double *c,
    const double *s,
    const ptrdiff_t *incc
);

/* Source: dlarf.f */
#define dlarf FORTRAN_WRAPPER(dlarf)
extern void dlarf(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *v,
    const ptrdiff_t *incv,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work
);

/* Source: dlarfb.f */
#define dlarfb FORTRAN_WRAPPER(dlarfb)
extern void dlarfb(
    const char   *side,
    const char   *trans,
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *v,
    const ptrdiff_t *ldv,
    const double *t,
    const ptrdiff_t *ldt,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *ldwork
);

/* Source: dlarfg.f */
#define dlarfg FORTRAN_WRAPPER(dlarfg)
extern void dlarfg(
    const ptrdiff_t *n,
    double *alpha,
    double *x,
    const ptrdiff_t *incx,
    double *tau
);

/* Source: dlarfgp.f */
#define dlarfgp FORTRAN_WRAPPER(dlarfgp)
extern void dlarfgp(
    const ptrdiff_t *n,
    double *alpha,
    double *x,
    const ptrdiff_t *incx,
    double *tau
);

/* Source: dlarft.f */
#define dlarft FORTRAN_WRAPPER(dlarft)
extern void dlarft(
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *v,
    const ptrdiff_t *ldv,
    const double *tau,
    double *t,
    const ptrdiff_t *ldt
);

/* Source: dlarfx.f */
#define dlarfx FORTRAN_WRAPPER(dlarfx)
extern void dlarfx(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *v,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work
);

/* Source: dlargv.f */
#define dlargv FORTRAN_WRAPPER(dlargv)
extern void dlargv(
    const ptrdiff_t *n,
    double *x,
    const ptrdiff_t *incx,
    double *y,
    const ptrdiff_t *incy,
    double *c,
    const ptrdiff_t *incc
);

/* Source: dlarnv.f */
#define dlarnv FORTRAN_WRAPPER(dlarnv)
extern void dlarnv(
    const ptrdiff_t *idist,
    ptrdiff_t *iseed,
    const ptrdiff_t *n,
    double *x
);

/* Source: dlarra.f */
#define dlarra FORTRAN_WRAPPER(dlarra)
extern void dlarra(
    const ptrdiff_t *n,
    const double *d,
    double *e,
    double *e2,
    const double *spltol,
    const double *tnrm,
    ptrdiff_t *nsplit,
    ptrdiff_t *isplit,
    ptrdiff_t *info
);

/* Source: dlarrb.f */
#define dlarrb FORTRAN_WRAPPER(dlarrb)
extern void dlarrb(
    const ptrdiff_t *n,
    const double *d,
    const double *lld,
    const ptrdiff_t *ifirst,
    const ptrdiff_t *ilast,
    const double *rtol1,
    const double *rtol2,
    const ptrdiff_t *offset,
    double *w,
    double *wgap,
    double *werr,
    double *work,
    ptrdiff_t *iwork,
    const double *pivmin,
    const double *spdiam,
    const ptrdiff_t *twist,
    ptrdiff_t *info
);

/* Source: dlarrc.f */
#define dlarrc FORTRAN_WRAPPER(dlarrc)
extern void dlarrc(
    const char   *jobt,
    const ptrdiff_t *n,
    const double *vl,
    const double *vu,
    const double *d,
    const double *e,
    const double *pivmin,
    ptrdiff_t *eigcnt,
    ptrdiff_t *lcnt,
    ptrdiff_t *rcnt,
    ptrdiff_t *info
);

/* Source: dlarrd.f */
#define dlarrd FORTRAN_WRAPPER(dlarrd)
extern void dlarrd(
    const char   *range,
    const char   *order,
    const ptrdiff_t *n,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *gers,
    const double *reltol,
    const double *d,
    const double *e,
    const double *e2,
    const double *pivmin,
    const ptrdiff_t *nsplit,
    const ptrdiff_t *isplit,
    ptrdiff_t *m,
    double *w,
    double *werr,
    double *wl,
    double *wu,
    ptrdiff_t *iblock,
    ptrdiff_t *indexw,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dlarre.f */
#define dlarre FORTRAN_WRAPPER(dlarre)
extern void dlarre(
    const char   *range,
    const ptrdiff_t *n,
    double *vl,
    double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    double *d,
    double *e,
    double *e2,
    const double *rtol1,
    const double *rtol2,
    const double *spltol,
    ptrdiff_t *nsplit,
    ptrdiff_t *isplit,
    ptrdiff_t *m,
    double *w,
    double *werr,
    double *wgap,
    ptrdiff_t *iblock,
    ptrdiff_t *indexw,
    double *gers,
    double *pivmin,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dlarrf.f */
#define dlarrf FORTRAN_WRAPPER(dlarrf)
extern void dlarrf(
    const ptrdiff_t *n,
    const double *d,
    const double *l,
    const double *ld,
    const ptrdiff_t *clstrt,
    const ptrdiff_t *clend,
    const double *w,
    double *wgap,
    const double *werr,
    const double *spdiam,
    const double *clgapl,
    double *clgapr,
    const double *pivmin,
    double *sigma,
    double *dplus,
    double *lplus,
    double *work,
    ptrdiff_t *info
);

/* Source: dlarrj.f */
#define dlarrj FORTRAN_WRAPPER(dlarrj)
extern void dlarrj(
    const ptrdiff_t *n,
    const double *d,
    const double *e2,
    const ptrdiff_t *ifirst,
    const ptrdiff_t *ilast,
    const double *rtol,
    const ptrdiff_t *offset,
    double *w,
    double *werr,
    double *work,
    ptrdiff_t *iwork,
    const double *pivmin,
    const double *spdiam,
    ptrdiff_t *info
);

/* Source: dlarrk.f */
#define dlarrk FORTRAN_WRAPPER(dlarrk)
extern void dlarrk(
    const ptrdiff_t *n,
    const ptrdiff_t *iw,
    const double *gl,
    const double *gu,
    const double *d,
    const double *e2,
    const double *pivmin,
    const double *reltol,
    double *w,
    double *werr,
    ptrdiff_t *info
);

/* Source: dlarrr.f */
#define dlarrr FORTRAN_WRAPPER(dlarrr)
extern void dlarrr(
    const ptrdiff_t *n,
    const double *d,
    double *e,
    ptrdiff_t *info
);

/* Source: dlarrv.f */
#define dlarrv FORTRAN_WRAPPER(dlarrv)
extern void dlarrv(
    const ptrdiff_t *n,
    const double *vl,
    const double *vu,
    double *d,
    double *l,
    double *pivmin,
    const ptrdiff_t *isplit,
    const ptrdiff_t *m,
    const ptrdiff_t *dol,
    const ptrdiff_t *dou,
    const double *minrgp,
    const double *rtol1,
    const double *rtol2,
    double *w,
    double *werr,
    double *wgap,
    const ptrdiff_t *iblock,
    const ptrdiff_t *indexw,
    const double *gers,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *isuppz,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dlartg.f */
#define dlartg FORTRAN_WRAPPER(dlartg)
extern void dlartg(
    const double *f,
    const double *g,
    double *cs,
    double *sn,
    double *r
);

/* Source: dlartgp.f */
#define dlartgp FORTRAN_WRAPPER(dlartgp)
extern void dlartgp(
    double *f,
    double *g,
    double *cs,
    double *sn,
    double *r
);

/* Source: dlartgs.f */
#define dlartgs FORTRAN_WRAPPER(dlartgs)
extern void dlartgs(
    double *x,
    double *y,
    double *sigma,
    double *cs,
    double *sn
);

/* Source: dlartv.f */
#define dlartv FORTRAN_WRAPPER(dlartv)
extern void dlartv(
    const ptrdiff_t *n,
    double *x,
    const ptrdiff_t *incx,
    double *y,
    const ptrdiff_t *incy,
    const double *c,
    const double *s,
    const ptrdiff_t *incc
);

/* Source: dlaruv.f */
#define dlaruv FORTRAN_WRAPPER(dlaruv)
extern void dlaruv(
    ptrdiff_t *iseed,
    const ptrdiff_t *n,
    double *x
);

/* Source: dlarz.f */
#define dlarz FORTRAN_WRAPPER(dlarz)
extern void dlarz(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    const double *v,
    const ptrdiff_t *incv,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work
);

/* Source: dlarzb.f */
#define dlarzb FORTRAN_WRAPPER(dlarzb)
extern void dlarzb(
    const char   *side,
    const char   *trans,
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const double *v,
    const ptrdiff_t *ldv,
    const double *t,
    const ptrdiff_t *ldt,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *ldwork
);

/* Source: dlarzt.f */
#define dlarzt FORTRAN_WRAPPER(dlarzt)
extern void dlarzt(
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *v,
    const ptrdiff_t *ldv,
    const double *tau,
    double *t,
    const ptrdiff_t *ldt
);

/* Source: dlas2.f */
#define dlas2 FORTRAN_WRAPPER(dlas2)
extern void dlas2(
    const double *f,
    const double *g,
    const double *h,
    double *ssmin,
    double *ssmax
);

/* Source: dlascl.f */
#define dlascl FORTRAN_WRAPPER(dlascl)
extern void dlascl(
    const char   *type,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const double *cfrom,
    const double *cto,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: dlasd0.f */
#define dlasd0 FORTRAN_WRAPPER(dlasd0)
extern void dlasd0(
    const ptrdiff_t *n,
    const ptrdiff_t *sqre,
    double *d,
    const double *e,
    double *u,
    const ptrdiff_t *ldu,
    double *vt,
    const ptrdiff_t *ldvt,
    const ptrdiff_t *smlsiz,
    ptrdiff_t *iwork,
    double *work,
    ptrdiff_t *info
);

/* Source: dlasd1.f */
#define dlasd1 FORTRAN_WRAPPER(dlasd1)
extern void dlasd1(
    const ptrdiff_t *nl,
    const ptrdiff_t *nr,
    const ptrdiff_t *sqre,
    double *d,
    double *alpha,
    double *beta,
    double *u,
    const ptrdiff_t *ldu,
    double *vt,
    const ptrdiff_t *ldvt,
    ptrdiff_t *idxq,
    ptrdiff_t *iwork,
    double *work,
    ptrdiff_t *info
);

/* Source: dlasd2.f */
#define dlasd2 FORTRAN_WRAPPER(dlasd2)
extern void dlasd2(
    const ptrdiff_t *nl,
    const ptrdiff_t *nr,
    const ptrdiff_t *sqre,
    ptrdiff_t *k,
    double *d,
    double *z,
    const double *alpha,
    const double *beta,
    double *u,
    const ptrdiff_t *ldu,
    double *vt,
    const ptrdiff_t *ldvt,
    double *dsigma,
    double *u2,
    const ptrdiff_t *ldu2,
    double *vt2,
    const ptrdiff_t *ldvt2,
    ptrdiff_t *idxp,
    ptrdiff_t *idx,
    ptrdiff_t *idxc,
    ptrdiff_t *idxq,
    ptrdiff_t *coltyp,
    ptrdiff_t *info
);

/* Source: dlasd3.f */
#define dlasd3 FORTRAN_WRAPPER(dlasd3)
extern void dlasd3(
    const ptrdiff_t *nl,
    const ptrdiff_t *nr,
    const ptrdiff_t *sqre,
    const ptrdiff_t *k,
    double *d,
    double *q,
    const ptrdiff_t *ldq,
    const double *dsigma,
    double *u,
    const ptrdiff_t *ldu,
    double *u2,
    const ptrdiff_t *ldu2,
    double *vt,
    const ptrdiff_t *ldvt,
    double *vt2,
    const ptrdiff_t *ldvt2,
    const ptrdiff_t *idxc,
    const ptrdiff_t *ctot,
    const double *z,
    ptrdiff_t *info
);

/* Source: dlasd4.f */
#define dlasd4 FORTRAN_WRAPPER(dlasd4)
extern void dlasd4(
    const ptrdiff_t *n,
    const ptrdiff_t *i,
    const double *d,
    const double *z,
    double *delta,
    const double *rho,
    double *sigma,
    double *work,
    ptrdiff_t *info
);

/* Source: dlasd5.f */
#define dlasd5 FORTRAN_WRAPPER(dlasd5)
extern void dlasd5(
    const ptrdiff_t *i,
    const double *d,
    const double *z,
    double *delta,
    const double *rho,
    double *dsigma,
    double *work
);

/* Source: dlasd6.f */
#define dlasd6 FORTRAN_WRAPPER(dlasd6)
extern void dlasd6(
    const ptrdiff_t *icompq,
    const ptrdiff_t *nl,
    const ptrdiff_t *nr,
    const ptrdiff_t *sqre,
    double *d,
    double *vf,
    double *vl,
    double *alpha,
    double *beta,
    ptrdiff_t *idxq,
    ptrdiff_t *perm,
    ptrdiff_t *givptr,
    ptrdiff_t *givcol,
    const ptrdiff_t *ldgcol,
    double *givnum,
    const ptrdiff_t *ldgnum,
    double *poles,
    double *difl,
    double *difr,
    double *z,
    ptrdiff_t *k,
    double *c,
    double *s,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dlasd7.f */
#define dlasd7 FORTRAN_WRAPPER(dlasd7)
extern void dlasd7(
    const ptrdiff_t *icompq,
    const ptrdiff_t *nl,
    const ptrdiff_t *nr,
    const ptrdiff_t *sqre,
    ptrdiff_t *k,
    double *d,
    double *z,
    double *zw,
    double *vf,
    double *vfw,
    double *vl,
    double *vlw,
    const double *alpha,
    const double *beta,
    double *dsigma,
    ptrdiff_t *idx,
    ptrdiff_t *idxp,
    const ptrdiff_t *idxq,
    ptrdiff_t *perm,
    ptrdiff_t *givptr,
    ptrdiff_t *givcol,
    const ptrdiff_t *ldgcol,
    double *givnum,
    const ptrdiff_t *ldgnum,
    double *c,
    double *s,
    ptrdiff_t *info
);

/* Source: dlasd8.f */
#define dlasd8 FORTRAN_WRAPPER(dlasd8)
extern void dlasd8(
    const ptrdiff_t *icompq,
    const ptrdiff_t *k,
    double *d,
    double *z,
    double *vf,
    double *vl,
    double *difl,
    double *difr,
    const ptrdiff_t *lddifr,
    double *dsigma,
    double *work,
    ptrdiff_t *info
);

/* Source: dlasda.f */
#define dlasda FORTRAN_WRAPPER(dlasda)
extern void dlasda(
    const ptrdiff_t *icompq,
    const ptrdiff_t *smlsiz,
    const ptrdiff_t *n,
    const ptrdiff_t *sqre,
    double *d,
    const double *e,
    double *u,
    const ptrdiff_t *ldu,
    double *vt,
    ptrdiff_t *k,
    double *difl,
    double *difr,
    double *z,
    double *poles,
    ptrdiff_t *givptr,
    ptrdiff_t *givcol,
    const ptrdiff_t *ldgcol,
    ptrdiff_t *perm,
    double *givnum,
    double *c,
    double *s,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dlasdq.f */
#define dlasdq FORTRAN_WRAPPER(dlasdq)
extern void dlasdq(
    const char   *uplo,
    const ptrdiff_t *sqre,
    const ptrdiff_t *n,
    const ptrdiff_t *ncvt,
    const ptrdiff_t *nru,
    const ptrdiff_t *ncc,
    double *d,
    double *e,
    double *vt,
    const ptrdiff_t *ldvt,
    double *u,
    const ptrdiff_t *ldu,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: dlasdt.f */
#define dlasdt FORTRAN_WRAPPER(dlasdt)
extern void dlasdt(
    const ptrdiff_t *n,
    ptrdiff_t *lvl,
    ptrdiff_t *nd,
    ptrdiff_t *inode,
    ptrdiff_t *ndiml,
    ptrdiff_t *ndimr,
    const ptrdiff_t *msub
);

/* Source: dlaset.f */
#define dlaset FORTRAN_WRAPPER(dlaset)
extern void dlaset(
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *beta,
    double *a,
    const ptrdiff_t *lda
);

/* Source: dlasq1.f */
#define dlasq1 FORTRAN_WRAPPER(dlasq1)
extern void dlasq1(
    const ptrdiff_t *n,
    double *d,
    double *e,
    double *work,
    ptrdiff_t *info
);

/* Source: dlasq2.f */
#define dlasq2 FORTRAN_WRAPPER(dlasq2)
extern void dlasq2(
    const ptrdiff_t *n,
    double *z,
    ptrdiff_t *info
);

/* Source: dlasq3.f */
#define dlasq3 FORTRAN_WRAPPER(dlasq3)
extern void dlasq3(
    const ptrdiff_t *i0,
    const ptrdiff_t *n0,
    const double *z,
    ptrdiff_t *pp,
    double *dmin,
    double *sigma,
    double *desig,
    const double *qmax,
    ptrdiff_t *nfail,
    ptrdiff_t *iter,
    ptrdiff_t *ndiv,
    const ptrdiff_t *ieee,
    ptrdiff_t *ttype,
    double *dmin1,
    double *dmin2,
    double *dn,
    double *dn1,
    double *dn2,
    double *g,
    double *tau
);

/* Source: dlasq4.f */
#define dlasq4 FORTRAN_WRAPPER(dlasq4)
extern void dlasq4(
    const ptrdiff_t *i0,
    const ptrdiff_t *n0,
    const double *z,
    const ptrdiff_t *pp,
    ptrdiff_t *n0in,
    const double *dmin,
    const double *dmin1,
    const double *dmin2,
    const double *dn,
    const double *dn1,
    const double *dn2,
    double *tau,
    ptrdiff_t *ttype,
    double *g
);

/* Source: dlasq5.f */
#define dlasq5 FORTRAN_WRAPPER(dlasq5)
extern void dlasq5(
    const ptrdiff_t *i0,
    const ptrdiff_t *n0,
    const double *z,
    const ptrdiff_t *pp,
    const double *tau,
    const double *sigma,
    double *dmin,
    double *dmin1,
    double *dmin2,
    double *dn,
    double *dnm1,
    double *dnm2,
    const ptrdiff_t *ieee,
    const double *eps
);

/* Source: dlasq6.f */
#define dlasq6 FORTRAN_WRAPPER(dlasq6)
extern void dlasq6(
    const ptrdiff_t *i0,
    const ptrdiff_t *n0,
    const double *z,
    const ptrdiff_t *pp,
    double *dmin,
    double *dmin1,
    double *dmin2,
    double *dn,
    double *dnm1,
    double *dnm2
);

/* Source: dlasr.f */
#define dlasr FORTRAN_WRAPPER(dlasr)
extern void dlasr(
    const char   *side,
    const char   *pivot,
    const char   *direct,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *c,
    const double *s,
    double *a,
    const ptrdiff_t *lda
);

/* Source: dlasrt.f */
#define dlasrt FORTRAN_WRAPPER(dlasrt)
extern void dlasrt(
    const char   *id,
    const ptrdiff_t *n,
    double *d,
    ptrdiff_t *info
);

/* Source: dlassq.f */
#define dlassq FORTRAN_WRAPPER(dlassq)
extern void dlassq(
    const ptrdiff_t *n,
    const double *x,
    const ptrdiff_t *incx,
    double *scale,
    double *sumsq
);

/* Source: dlasv2.f */
#define dlasv2 FORTRAN_WRAPPER(dlasv2)
extern void dlasv2(
    const double *f,
    const double *g,
    const double *h,
    double *ssmin,
    double *ssmax,
    double *snr,
    double *csr,
    double *snl,
    double *csl
);

/* Source: dlaswp.f */
#define dlaswp FORTRAN_WRAPPER(dlaswp)
extern void dlaswp(
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *k1,
    const ptrdiff_t *k2,
    const ptrdiff_t *ipiv,
    const ptrdiff_t *incx
);

/* Source: dlasy2.f */
#define dlasy2 FORTRAN_WRAPPER(dlasy2)
extern void dlasy2(
    const ptrdiff_t *ltranl,
    const ptrdiff_t *ltranr,
    const ptrdiff_t *isgn,
    const ptrdiff_t *n1,
    const ptrdiff_t *n2,
    const double *tl,
    const ptrdiff_t *ldtl,
    const double *tr,
    const ptrdiff_t *ldtr,
    const double *b,
    const ptrdiff_t *ldb,
    double *scale,
    double *x,
    const ptrdiff_t *ldx,
    double *xnorm,
    ptrdiff_t *info
);

/* Source: dlasyf.f */
#define dlasyf FORTRAN_WRAPPER(dlasyf)
extern void dlasyf(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    ptrdiff_t *kb,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    double *w,
    const ptrdiff_t *ldw,
    ptrdiff_t *info
);

/* Source: dlat2s.f */
#define dlat2s FORTRAN_WRAPPER(dlat2s)
extern void dlat2s(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    float  *sa,
    const ptrdiff_t *ldsa,
    ptrdiff_t *info
);

/* Source: dlatbs.f */
#define dlatbs FORTRAN_WRAPPER(dlatbs)
extern void dlatbs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const char   *normin,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const double *ab,
    const ptrdiff_t *ldab,
    double *x,
    double *scale,
    double *cnorm,
    ptrdiff_t *info
);

/* Source: dlatdf.f */
#define dlatdf FORTRAN_WRAPPER(dlatdf)
extern void dlatdf(
    const ptrdiff_t *ijob,
    const ptrdiff_t *n,
    const double *z,
    const ptrdiff_t *ldz,
    double *rhs,
    double *rdsum,
    double *rdscal,
    const ptrdiff_t *ipiv,
    const ptrdiff_t *jpiv
);

/* Source: dlatps.f */
#define dlatps FORTRAN_WRAPPER(dlatps)
extern void dlatps(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const char   *normin,
    const ptrdiff_t *n,
    const double *ap,
    double *x,
    double *scale,
    double *cnorm,
    ptrdiff_t *info
);

/* Source: dlatrd.f */
#define dlatrd FORTRAN_WRAPPER(dlatrd)
extern void dlatrd(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    double *a,
    const ptrdiff_t *lda,
    double *e,
    double *tau,
    double *w,
    const ptrdiff_t *ldw
);

/* Source: dlatrs.f */
#define dlatrs FORTRAN_WRAPPER(dlatrs)
extern void dlatrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const char   *normin,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *x,
    double *scale,
    double *cnorm,
    ptrdiff_t *info
);

/* Source: dlatrz.f */
#define dlatrz FORTRAN_WRAPPER(dlatrz)
extern void dlatrz(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work
);

/* Source: dlatzm.f */
#define dlatzm FORTRAN_WRAPPER(dlatzm)
extern void dlatzm(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *v,
    const ptrdiff_t *incv,
    const double *tau,
    double *c1,
    double *c2,
    const ptrdiff_t *ldc,
    double *work
);

/* Source: dlauu2.f */
#define dlauu2 FORTRAN_WRAPPER(dlauu2)
extern void dlauu2(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: dlauum.f */
#define dlauum FORTRAN_WRAPPER(dlauum)
extern void dlauum(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: dopgtr.f */
#define dopgtr FORTRAN_WRAPPER(dopgtr)
extern void dopgtr(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    const double *tau,
    double *q,
    const ptrdiff_t *ldq,
    double *work,
    ptrdiff_t *info
);

/* Source: dopmtr.f */
#define dopmtr FORTRAN_WRAPPER(dopmtr)
extern void dopmtr(
    const char   *side,
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *ap,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: dorbdb.f */
#define dorbdb FORTRAN_WRAPPER(dorbdb)
extern void dorbdb(
    const char   *trans,
    const char   *signs,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *q,
    double *x11,
    const ptrdiff_t *ldx11,
    double *x12,
    const ptrdiff_t *ldx12,
    double *x21,
    const ptrdiff_t *ldx21,
    double *x22,
    const ptrdiff_t *ldx22,
    double *theta,
    double *phi,
    double *taup1,
    double *taup2,
    double *tauq1,
    double *tauq2,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dorcsd.f */
#define dorcsd FORTRAN_WRAPPER(dorcsd)
extern void dorcsd(
    const char   *jobu1,
    const char   *jobu2,
    const char   *jobv1t,
    const char   *jobv2t,
    const char   *trans,
    const char   *signs,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *q,
    double *x11,
    const ptrdiff_t *ldx11,
    double *x12,
    const ptrdiff_t *ldx12,
    double *x21,
    const ptrdiff_t *ldx21,
    double *x22,
    const ptrdiff_t *ldx22,
    double *theta,
    double *u1,
    const ptrdiff_t *ldu1,
    double *u2,
    const ptrdiff_t *ldu2,
    double *v1t,
    const ptrdiff_t *ldv1t,
    double *v2t,
    const ptrdiff_t *ldv2t,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dorg2l.f */
#define dorg2l FORTRAN_WRAPPER(dorg2l)
extern void dorg2l(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: dorg2r.f */
#define dorg2r FORTRAN_WRAPPER(dorg2r)
extern void dorg2r(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: dorgbr.f */
#define dorgbr FORTRAN_WRAPPER(dorgbr)
extern void dorgbr(
    const char   *vect,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dorghr.f */
#define dorghr FORTRAN_WRAPPER(dorghr)
extern void dorghr(
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dorgl2.f */
#define dorgl2 FORTRAN_WRAPPER(dorgl2)
extern void dorgl2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: dorglq.f */
#define dorglq FORTRAN_WRAPPER(dorglq)
extern void dorglq(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dorgql.f */
#define dorgql FORTRAN_WRAPPER(dorgql)
extern void dorgql(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dorgqr.f */
#define dorgqr FORTRAN_WRAPPER(dorgqr)
extern void dorgqr(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dorgr2.f */
#define dorgr2 FORTRAN_WRAPPER(dorgr2)
extern void dorgr2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: dorgrq.f */
#define dorgrq FORTRAN_WRAPPER(dorgrq)
extern void dorgrq(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dorgtr.f */
#define dorgtr FORTRAN_WRAPPER(dorgtr)
extern void dorgtr(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dorm2l.f */
#define dorm2l FORTRAN_WRAPPER(dorm2l)
extern void dorm2l(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: dorm2r.f */
#define dorm2r FORTRAN_WRAPPER(dorm2r)
extern void dorm2r(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: dormbr.f */
#define dormbr FORTRAN_WRAPPER(dormbr)
extern void dormbr(
    const char   *vect,
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dormhr.f */
#define dormhr FORTRAN_WRAPPER(dormhr)
extern void dormhr(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dorml2.f */
#define dorml2 FORTRAN_WRAPPER(dorml2)
extern void dorml2(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: dormlq.f */
#define dormlq FORTRAN_WRAPPER(dormlq)
extern void dormlq(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dormql.f */
#define dormql FORTRAN_WRAPPER(dormql)
extern void dormql(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dormqr.f */
#define dormqr FORTRAN_WRAPPER(dormqr)
extern void dormqr(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dormr2.f */
#define dormr2 FORTRAN_WRAPPER(dormr2)
extern void dormr2(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: dormr3.f */
#define dormr3 FORTRAN_WRAPPER(dormr3)
extern void dormr3(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: dormrq.f */
#define dormrq FORTRAN_WRAPPER(dormrq)
extern void dormrq(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dormrz.f */
#define dormrz FORTRAN_WRAPPER(dormrz)
extern void dormrz(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dormtr.f */
#define dormtr FORTRAN_WRAPPER(dormtr)
extern void dormtr(
    const char   *side,
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dpbcon.f */
#define dpbcon FORTRAN_WRAPPER(dpbcon)
extern void dpbcon(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const double *ab,
    const ptrdiff_t *ldab,
    const double *anorm,
    double *rcond,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dpbequ.f */
#define dpbequ FORTRAN_WRAPPER(dpbequ)
extern void dpbequ(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const double *ab,
    const ptrdiff_t *ldab,
    double *s,
    double *scond,
    double *amax,
    ptrdiff_t *info
);

/* Source: dpbrfs.f */
#define dpbrfs FORTRAN_WRAPPER(dpbrfs)
extern void dpbrfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const double *ab,
    const ptrdiff_t *ldab,
    const double *afb,
    const ptrdiff_t *ldafb,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dpbstf.f */
#define dpbstf FORTRAN_WRAPPER(dpbstf)
extern void dpbstf(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *info
);

/* Source: dpbsv.f */
#define dpbsv FORTRAN_WRAPPER(dpbsv)
extern void dpbsv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    double *ab,
    const ptrdiff_t *ldab,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dpbsvx.f */
#define dpbsvx FORTRAN_WRAPPER(dpbsvx)
extern void dpbsvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    double *ab,
    const ptrdiff_t *ldab,
    double *afb,
    const ptrdiff_t *ldafb,
    char   *equed,
    double *s,
    double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dpbtf2.f */
#define dpbtf2 FORTRAN_WRAPPER(dpbtf2)
extern void dpbtf2(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *info
);

/* Source: dpbtrf.f */
#define dpbtrf FORTRAN_WRAPPER(dpbtrf)
extern void dpbtrf(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *info
);

/* Source: dpbtrs.f */
#define dpbtrs FORTRAN_WRAPPER(dpbtrs)
extern void dpbtrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const double *ab,
    const ptrdiff_t *ldab,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dpftrf.f */
#define dpftrf FORTRAN_WRAPPER(dpftrf)
extern void dpftrf(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    ptrdiff_t *info
);

/* Source: dpftri.f */
#define dpftri FORTRAN_WRAPPER(dpftri)
extern void dpftri(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    ptrdiff_t *info
);

/* Source: dpftrs.f */
#define dpftrs FORTRAN_WRAPPER(dpftrs)
extern void dpftrs(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dpocon.f */
#define dpocon FORTRAN_WRAPPER(dpocon)
extern void dpocon(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *anorm,
    double *rcond,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dpoequ.f */
#define dpoequ FORTRAN_WRAPPER(dpoequ)
extern void dpoequ(
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *s,
    double *scond,
    double *amax,
    ptrdiff_t *info
);

/* Source: dpoequb.f */
#define dpoequb FORTRAN_WRAPPER(dpoequb)
extern void dpoequb(
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *s,
    double *scond,
    double *amax,
    ptrdiff_t *info
);

/* Source: dporfs.f */
#define dporfs FORTRAN_WRAPPER(dporfs)
extern void dporfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const double *af,
    const ptrdiff_t *ldaf,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dposv.f */
#define dposv FORTRAN_WRAPPER(dposv)
extern void dposv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dposvx.f */
#define dposvx FORTRAN_WRAPPER(dposvx)
extern void dposvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    double *af,
    const ptrdiff_t *ldaf,
    char   *equed,
    double *s,
    double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dpotf2.f */
#define dpotf2 FORTRAN_WRAPPER(dpotf2)
extern void dpotf2(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: dpotrf.f */
#define dpotrf FORTRAN_WRAPPER(dpotrf)
extern void dpotrf(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: dpotri.f */
#define dpotri FORTRAN_WRAPPER(dpotri)
extern void dpotri(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: dpotrs.f */
#define dpotrs FORTRAN_WRAPPER(dpotrs)
extern void dpotrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dppcon.f */
#define dppcon FORTRAN_WRAPPER(dppcon)
extern void dppcon(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    const double *anorm,
    double *rcond,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dppequ.f */
#define dppequ FORTRAN_WRAPPER(dppequ)
extern void dppequ(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    double *s,
    double *scond,
    double *amax,
    ptrdiff_t *info
);

/* Source: dpprfs.f */
#define dpprfs FORTRAN_WRAPPER(dpprfs)
extern void dpprfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    const double *afp,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dppsv.f */
#define dppsv FORTRAN_WRAPPER(dppsv)
extern void dppsv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *ap,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dppsvx.f */
#define dppsvx FORTRAN_WRAPPER(dppsvx)
extern void dppsvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *ap,
    double *afp,
    char   *equed,
    double *s,
    double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dpptrf.f */
#define dpptrf FORTRAN_WRAPPER(dpptrf)
extern void dpptrf(
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    ptrdiff_t *info
);

/* Source: dpptri.f */
#define dpptri FORTRAN_WRAPPER(dpptri)
extern void dpptri(
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    ptrdiff_t *info
);

/* Source: dpptrs.f */
#define dpptrs FORTRAN_WRAPPER(dpptrs)
extern void dpptrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dpstf2.f */
#define dpstf2 FORTRAN_WRAPPER(dpstf2)
extern void dpstf2(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *piv,
    ptrdiff_t *rank,
    const double *tol,
    double *work,
    ptrdiff_t *info
);

/* Source: dpstrf.f */
#define dpstrf FORTRAN_WRAPPER(dpstrf)
extern void dpstrf(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *piv,
    ptrdiff_t *rank,
    const double *tol,
    double *work,
    ptrdiff_t *info
);

/* Source: dptcon.f */
#define dptcon FORTRAN_WRAPPER(dptcon)
extern void dptcon(
    const ptrdiff_t *n,
    const double *d,
    const double *e,
    const double *anorm,
    double *rcond,
    double *work,
    ptrdiff_t *info
);

/* Source: dpteqr.f */
#define dpteqr FORTRAN_WRAPPER(dpteqr)
extern void dpteqr(
    const char   *compz,
    const ptrdiff_t *n,
    double *d,
    double *e,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *info
);

/* Source: dptrfs.f */
#define dptrfs FORTRAN_WRAPPER(dptrfs)
extern void dptrfs(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *d,
    const double *e,
    const double *df,
    const double *ef,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *info
);

/* Source: dptsv.f */
#define dptsv FORTRAN_WRAPPER(dptsv)
extern void dptsv(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *d,
    double *e,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dptsvx.f */
#define dptsvx FORTRAN_WRAPPER(dptsvx)
extern void dptsvx(
    const char   *fact,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *d,
    const double *e,
    double *df,
    double *ef,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *info
);

/* Source: dpttrf.f */
#define dpttrf FORTRAN_WRAPPER(dpttrf)
extern void dpttrf(
    const ptrdiff_t *n,
    double *d,
    double *e,
    ptrdiff_t *info
);

/* Source: dpttrs.f */
#define dpttrs FORTRAN_WRAPPER(dpttrs)
extern void dpttrs(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *d,
    const double *e,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dptts2.f */
#define dptts2 FORTRAN_WRAPPER(dptts2)
extern void dptts2(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *d,
    const double *e,
    double *b,
    const ptrdiff_t *ldb
);

/* Source: drscl.f */
#define drscl FORTRAN_WRAPPER(drscl)
extern void drscl(
    const ptrdiff_t *n,
    const double *sa,
    double *sx,
    const ptrdiff_t *incx
);

/* Source: dsbev.f */
#define dsbev FORTRAN_WRAPPER(dsbev)
extern void dsbev(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *info
);

/* Source: dsbevd.f */
#define dsbevd FORTRAN_WRAPPER(dsbevd)
extern void dsbevd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: dsbevx.f */
#define dsbevx FORTRAN_WRAPPER(dsbevx)
extern void dsbevx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    double *q,
    const ptrdiff_t *ldq,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: dsbgst.f */
#define dsbgst FORTRAN_WRAPPER(dsbgst)
extern void dsbgst(
    const char   *vect,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    double *ab,
    const ptrdiff_t *ldab,
    const double *bb,
    const ptrdiff_t *ldbb,
    double *x,
    const ptrdiff_t *ldx,
    double *work,
    ptrdiff_t *info
);

/* Source: dsbgv.f */
#define dsbgv FORTRAN_WRAPPER(dsbgv)
extern void dsbgv(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    double *ab,
    const ptrdiff_t *ldab,
    double *bb,
    const ptrdiff_t *ldbb,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *info
);

/* Source: dsbgvd.f */
#define dsbgvd FORTRAN_WRAPPER(dsbgvd)
extern void dsbgvd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    double *ab,
    const ptrdiff_t *ldab,
    double *bb,
    const ptrdiff_t *ldbb,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: dsbgvx.f */
#define dsbgvx FORTRAN_WRAPPER(dsbgvx)
extern void dsbgvx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    double *ab,
    const ptrdiff_t *ldab,
    double *bb,
    const ptrdiff_t *ldbb,
    double *q,
    const ptrdiff_t *ldq,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: dsbtrd.f */
#define dsbtrd FORTRAN_WRAPPER(dsbtrd)
extern void dsbtrd(
    const char   *vect,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    double *d,
    double *e,
    double *q,
    const ptrdiff_t *ldq,
    double *work,
    ptrdiff_t *info
);

/* Source: dsfrk.f */
#define dsfrk FORTRAN_WRAPPER(dsfrk)
extern void dsfrk(
    const char   *transr,
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *beta,
    double *c
);

/* Source: dsgesv.f */
#define dsgesv FORTRAN_WRAPPER(dsgesv)
extern void dsgesv(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *work,
    float  *swork,
    ptrdiff_t *iter,
    ptrdiff_t *info
);

/* Source: dspcon.f */
#define dspcon FORTRAN_WRAPPER(dspcon)
extern void dspcon(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    const ptrdiff_t *ipiv,
    const double *anorm,
    double *rcond,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dspev.f */
#define dspev FORTRAN_WRAPPER(dspev)
extern void dspev(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *info
);

/* Source: dspevd.f */
#define dspevd FORTRAN_WRAPPER(dspevd)
extern void dspevd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: dspevx.f */
#define dspevx FORTRAN_WRAPPER(dspevx)
extern void dspevx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: dspgst.f */
#define dspgst FORTRAN_WRAPPER(dspgst)
extern void dspgst(
    const ptrdiff_t *itype,
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    const double *bp,
    ptrdiff_t *info
);

/* Source: dspgv.f */
#define dspgv FORTRAN_WRAPPER(dspgv)
extern void dspgv(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    double *bp,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *info
);

/* Source: dspgvd.f */
#define dspgvd FORTRAN_WRAPPER(dspgvd)
extern void dspgvd(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    double *bp,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: dspgvx.f */
#define dspgvx FORTRAN_WRAPPER(dspgvx)
extern void dspgvx(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    double *bp,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: dsposv.f */
#define dsposv FORTRAN_WRAPPER(dsposv)
extern void dsposv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *work,
    float  *swork,
    ptrdiff_t *iter,
    ptrdiff_t *info
);

/* Source: dsprfs.f */
#define dsprfs FORTRAN_WRAPPER(dsprfs)
extern void dsprfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    const double *afp,
    const ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dspsv.f */
#define dspsv FORTRAN_WRAPPER(dspsv)
extern void dspsv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *ap,
    ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dspsvx.f */
#define dspsvx FORTRAN_WRAPPER(dspsvx)
extern void dspsvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    double *afp,
    ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dsptrd.f */
#define dsptrd FORTRAN_WRAPPER(dsptrd)
extern void dsptrd(
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    double *d,
    double *e,
    double *tau,
    ptrdiff_t *info
);

/* Source: dsptrf.f */
#define dsptrf FORTRAN_WRAPPER(dsptrf)
extern void dsptrf(
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: dsptri.f */
#define dsptri FORTRAN_WRAPPER(dsptri)
extern void dsptri(
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    const ptrdiff_t *ipiv,
    double *work,
    ptrdiff_t *info
);

/* Source: dsptrs.f */
#define dsptrs FORTRAN_WRAPPER(dsptrs)
extern void dsptrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dstebz.f */
#define dstebz FORTRAN_WRAPPER(dstebz)
extern void dstebz(
    const char   *range,
    const char   *order,
    const ptrdiff_t *n,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    const double *d,
    const double *e,
    ptrdiff_t *m,
    ptrdiff_t *nsplit,
    double *w,
    ptrdiff_t *iblock,
    ptrdiff_t *isplit,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dstedc.f */
#define dstedc FORTRAN_WRAPPER(dstedc)
extern void dstedc(
    const char   *compz,
    const ptrdiff_t *n,
    double *d,
    double *e,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: dstegr.f */
#define dstegr FORTRAN_WRAPPER(dstegr)
extern void dstegr(
    const char   *jobz,
    const char   *range,
    const ptrdiff_t *n,
    double *d,
    double *e,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *isuppz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: dstein.f */
#define dstein FORTRAN_WRAPPER(dstein)
extern void dstein(
    const ptrdiff_t *n,
    const double *d,
    const double *e,
    const ptrdiff_t *m,
    const double *w,
    const ptrdiff_t *iblock,
    const ptrdiff_t *isplit,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: dstemr.f */
#define dstemr FORTRAN_WRAPPER(dstemr)
extern void dstemr(
    const char   *jobz,
    const char   *range,
    const ptrdiff_t *n,
    double *d,
    double *e,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    const ptrdiff_t *nzc,
    ptrdiff_t *isuppz,
    ptrdiff_t *tryrac,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: dsteqr.f */
#define dsteqr FORTRAN_WRAPPER(dsteqr)
extern void dsteqr(
    const char   *compz,
    const ptrdiff_t *n,
    double *d,
    double *e,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *info
);

/* Source: dsterf.f */
#define dsterf FORTRAN_WRAPPER(dsterf)
extern void dsterf(
    const ptrdiff_t *n,
    double *d,
    double *e,
    ptrdiff_t *info
);

/* Source: dstev.f */
#define dstev FORTRAN_WRAPPER(dstev)
extern void dstev(
    const char   *jobz,
    const ptrdiff_t *n,
    double *d,
    double *e,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *info
);

/* Source: dstevd.f */
#define dstevd FORTRAN_WRAPPER(dstevd)
extern void dstevd(
    const char   *jobz,
    const ptrdiff_t *n,
    double *d,
    double *e,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: dstevr.f */
#define dstevr FORTRAN_WRAPPER(dstevr)
extern void dstevr(
    const char   *jobz,
    const char   *range,
    const ptrdiff_t *n,
    double *d,
    double *e,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *isuppz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: dstevx.f */
#define dstevx FORTRAN_WRAPPER(dstevx)
extern void dstevx(
    const char   *jobz,
    const char   *range,
    const ptrdiff_t *n,
    double *d,
    double *e,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: dsycon.f */
#define dsycon FORTRAN_WRAPPER(dsycon)
extern void dsycon(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    const double *anorm,
    double *rcond,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dsyconv.f */
#define dsyconv FORTRAN_WRAPPER(dsyconv)
extern void dsyconv(
    const char   *uplo,
    const char   *way,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *work,
    ptrdiff_t *info
);

/* Source: dsyequb.f */
#define dsyequb FORTRAN_WRAPPER(dsyequb)
extern void dsyequb(
    char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *s,
    double *scond,
    double *amax,
    double *work,
    ptrdiff_t *info
);

/* Source: dsyev.f */
#define dsyev FORTRAN_WRAPPER(dsyev)
extern void dsyev(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *w,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dsyevd.f */
#define dsyevd FORTRAN_WRAPPER(dsyevd)
extern void dsyevd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *w,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: dsyevr.f */
#define dsyevr FORTRAN_WRAPPER(dsyevr)
extern void dsyevr(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *isuppz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: dsyevx.f */
#define dsyevx FORTRAN_WRAPPER(dsyevx)
extern void dsyevx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: dsygs2.f */
#define dsygs2 FORTRAN_WRAPPER(dsygs2)
extern void dsygs2(
    const ptrdiff_t *itype,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dsygst.f */
#define dsygst FORTRAN_WRAPPER(dsygst)
extern void dsygst(
    const ptrdiff_t *itype,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dsygv.f */
#define dsygv FORTRAN_WRAPPER(dsygv)
extern void dsygv(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *w,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dsygvd.f */
#define dsygvd FORTRAN_WRAPPER(dsygvd)
extern void dsygvd(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *w,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: dsygvx.f */
#define dsygvx FORTRAN_WRAPPER(dsygvx)
extern void dsygvx(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: dsyrfs.f */
#define dsyrfs FORTRAN_WRAPPER(dsyrfs)
extern void dsyrfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const double *af,
    const ptrdiff_t *ldaf,
    const ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dsysv.f */
#define dsysv FORTRAN_WRAPPER(dsysv)
extern void dsysv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dsysvx.f */
#define dsysvx FORTRAN_WRAPPER(dsysvx)
extern void dsysvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    double *af,
    const ptrdiff_t *ldaf,
    ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dsyswapr.f */
#define dsyswapr FORTRAN_WRAPPER(dsyswapr)
extern void dsyswapr(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *i1,
    const ptrdiff_t *i2
);

/* Source: dsytd2.f */
#define dsytd2 FORTRAN_WRAPPER(dsytd2)
extern void dsytd2(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *d,
    double *e,
    double *tau,
    ptrdiff_t *info
);

/* Source: dsytf2.f */
#define dsytf2 FORTRAN_WRAPPER(dsytf2)
extern void dsytf2(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: dsytrd.f */
#define dsytrd FORTRAN_WRAPPER(dsytrd)
extern void dsytrd(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *d,
    double *e,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dsytrf.f */
#define dsytrf FORTRAN_WRAPPER(dsytrf)
extern void dsytrf(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dsytri.f */
#define dsytri FORTRAN_WRAPPER(dsytri)
extern void dsytri(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *work,
    ptrdiff_t *info
);

/* Source: dsytri2.f */
#define dsytri2 FORTRAN_WRAPPER(dsytri2)
extern void dsytri2(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dsytri2x.f */
#define dsytri2x FORTRAN_WRAPPER(dsytri2x)
extern void dsytri2x(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *work,
    ptrdiff_t *nb,
    ptrdiff_t *info
);

/* Source: dsytrs.f */
#define dsytrs FORTRAN_WRAPPER(dsytrs)
extern void dsytrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dsytrs2.f */
#define dsytrs2 FORTRAN_WRAPPER(dsytrs2)
extern void dsytrs2(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    double *work,
    ptrdiff_t *info
);

/* Source: dtbcon.f */
#define dtbcon FORTRAN_WRAPPER(dtbcon)
extern void dtbcon(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const double *ab,
    const ptrdiff_t *ldab,
    double *rcond,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dtbrfs.f */
#define dtbrfs FORTRAN_WRAPPER(dtbrfs)
extern void dtbrfs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const double *ab,
    const ptrdiff_t *ldab,
    const double *b,
    const ptrdiff_t *ldb,
    const double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dtbtrs.f */
#define dtbtrs FORTRAN_WRAPPER(dtbtrs)
extern void dtbtrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const double *ab,
    const ptrdiff_t *ldab,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dtfsm.f */
#define dtfsm FORTRAN_WRAPPER(dtfsm)
extern void dtfsm(
    const char   *transr,
    const char   *side,
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *a,
    double *b,
    const ptrdiff_t *ldb
);

/* Source: dtftri.f */
#define dtftri FORTRAN_WRAPPER(dtftri)
extern void dtftri(
    const char   *transr,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    double *a,
    ptrdiff_t *info
);

/* Source: dtfttp.f */
#define dtfttp FORTRAN_WRAPPER(dtfttp)
extern void dtfttp(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *arf,
    double *ap,
    ptrdiff_t *info
);

/* Source: dtfttr.f */
#define dtfttr FORTRAN_WRAPPER(dtfttr)
extern void dtfttr(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *arf,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: dtgevc.f */
#define dtgevc FORTRAN_WRAPPER(dtgevc)
extern void dtgevc(
    const char   *side,
    const char   *howmny,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    const double *s,
    const ptrdiff_t *lds,
    const double *p,
    const ptrdiff_t *ldp,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    double *work,
    ptrdiff_t *info
);

/* Source: dtgex2.f */
#define dtgex2 FORTRAN_WRAPPER(dtgex2)
extern void dtgex2(
    const ptrdiff_t *wantq,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *q,
    const ptrdiff_t *ldq,
    double *z,
    const ptrdiff_t *ldz,
    const ptrdiff_t *j1_,
    const ptrdiff_t *n1,
    const ptrdiff_t *n2,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dtgexc.f */
#define dtgexc FORTRAN_WRAPPER(dtgexc)
extern void dtgexc(
    const ptrdiff_t *wantq,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *q,
    const ptrdiff_t *ldq,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *ifst,
    ptrdiff_t *ilst,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dtgsen.f */
#define dtgsen FORTRAN_WRAPPER(dtgsen)
extern void dtgsen(
    const ptrdiff_t *ijob,
    const ptrdiff_t *wantq,
    const ptrdiff_t *wantz,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *alphar,
    double *alphai,
    double *beta,
    double *q,
    const ptrdiff_t *ldq,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *m,
    double *pl,
    double *pr,
    double *dif,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: dtgsja.f */
#define dtgsja FORTRAN_WRAPPER(dtgsja)
extern void dtgsja(
    const char   *jobu,
    const char   *jobv,
    const char   *jobq,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    const double *tola,
    const double *tolb,
    double *alpha,
    double *beta,
    double *u,
    const ptrdiff_t *ldu,
    double *v,
    const ptrdiff_t *ldv,
    double *q,
    const ptrdiff_t *ldq,
    double *work,
    ptrdiff_t *ncycle,
    ptrdiff_t *info
);

/* Source: dtgsna.f */
#define dtgsna FORTRAN_WRAPPER(dtgsna)
extern void dtgsna(
    const char   *job,
    const char   *howmny,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *vl,
    const ptrdiff_t *ldvl,
    const double *vr,
    const ptrdiff_t *ldvr,
    double *s,
    double *dif,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dtgsy2.f */
#define dtgsy2 FORTRAN_WRAPPER(dtgsy2)
extern void dtgsy2(
    const char   *trans,
    const ptrdiff_t *ijob,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    double *c,
    const ptrdiff_t *ldc,
    const double *d,
    const ptrdiff_t *ldd,
    const double *e,
    const ptrdiff_t *lde,
    double *f,
    const ptrdiff_t *ldf,
    double *scale,
    double *rdsum,
    double *rdscal,
    ptrdiff_t *iwork,
    ptrdiff_t *pq,
    ptrdiff_t *info
);

/* Source: dtgsyl.f */
#define dtgsyl FORTRAN_WRAPPER(dtgsyl)
extern void dtgsyl(
    const char   *trans,
    const ptrdiff_t *ijob,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    double *c,
    const ptrdiff_t *ldc,
    const double *d,
    const ptrdiff_t *ldd,
    const double *e,
    const ptrdiff_t *lde,
    double *f,
    const ptrdiff_t *ldf,
    double *scale,
    double *dif,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dtpcon.f */
#define dtpcon FORTRAN_WRAPPER(dtpcon)
extern void dtpcon(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const double *ap,
    double *rcond,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dtpmqrt.f */
#define dtpmqrt FORTRAN_WRAPPER(dtpmqrt)
extern void dtpmqrt(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const ptrdiff_t *nb,
    const double *v,
    const ptrdiff_t *ldv,
    const double *t,
    const ptrdiff_t *ldt,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *work,
    ptrdiff_t *info
);

/* Source: dtpqrt.f */
#define dtpqrt FORTRAN_WRAPPER(dtpqrt)
extern void dtpqrt(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    const ptrdiff_t *nb,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *t,
    const ptrdiff_t *ldt,
    const double *work,
    ptrdiff_t *info
);

/* Source: dtpqrt2.f */
#define dtpqrt2 FORTRAN_WRAPPER(dtpqrt2)
extern void dtpqrt2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *t,
    const ptrdiff_t *ldt,
    ptrdiff_t *info
);

/* Source: dtprfb.f */
#define dtprfb FORTRAN_WRAPPER(dtprfb)
extern void dtprfb(
    const char   *side,
    const char   *trans,
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const double *v,
    const ptrdiff_t *ldv,
    const double *t,
    const ptrdiff_t *ldt,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *work,
    const ptrdiff_t *ldwork
);

/* Source: dtprfs.f */
#define dtprfs FORTRAN_WRAPPER(dtprfs)
extern void dtprfs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    const double *b,
    const ptrdiff_t *ldb,
    const double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dtptri.f */
#define dtptri FORTRAN_WRAPPER(dtptri)
extern void dtptri(
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    double *ap,
    ptrdiff_t *info
);

/* Source: dtptrs.f */
#define dtptrs FORTRAN_WRAPPER(dtptrs)
extern void dtptrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dtpttf.f */
#define dtpttf FORTRAN_WRAPPER(dtpttf)
extern void dtpttf(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    double *arf,
    ptrdiff_t *info
);

/* Source: dtpttr.f */
#define dtpttr FORTRAN_WRAPPER(dtpttr)
extern void dtpttr(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: dtrcon.f */
#define dtrcon FORTRAN_WRAPPER(dtrcon)
extern void dtrcon(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *rcond,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dtrevc.f */
#define dtrevc FORTRAN_WRAPPER(dtrevc)
extern void dtrevc(
    const char   *side,
    const char   *howmny,
    ptrdiff_t *select,
    const ptrdiff_t *n,
    const double *t,
    const ptrdiff_t *ldt,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    double *work,
    ptrdiff_t *info
);

/* Source: dtrexc.f */
#define dtrexc FORTRAN_WRAPPER(dtrexc)
extern void dtrexc(
    const char   *compq,
    const ptrdiff_t *n,
    double *t,
    const ptrdiff_t *ldt,
    double *q,
    const ptrdiff_t *ldq,
    ptrdiff_t *ifst,
    ptrdiff_t *ilst,
    double *work,
    ptrdiff_t *info
);

/* Source: dtrrfs.f */
#define dtrrfs FORTRAN_WRAPPER(dtrrfs)
extern void dtrrfs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dtrsen.f */
#define dtrsen FORTRAN_WRAPPER(dtrsen)
extern void dtrsen(
    const char   *job,
    const char   *compq,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    double *t,
    const ptrdiff_t *ldt,
    double *q,
    const ptrdiff_t *ldq,
    double *wr,
    double *wi,
    ptrdiff_t *m,
    double *s,
    double *sep,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: dtrsna.f */
#define dtrsna FORTRAN_WRAPPER(dtrsna)
extern void dtrsna(
    const char   *job,
    const char   *howmny,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    const double *t,
    const ptrdiff_t *ldt,
    const double *vl,
    const ptrdiff_t *ldvl,
    const double *vr,
    const ptrdiff_t *ldvr,
    double *s,
    double *sep,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    double *work,
    const ptrdiff_t *ldwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: dtrsyl.f */
#define dtrsyl FORTRAN_WRAPPER(dtrsyl)
extern void dtrsyl(
    const char   *trana,
    const char   *tranb,
    const ptrdiff_t *isgn,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    double *c,
    const ptrdiff_t *ldc,
    double *scale,
    ptrdiff_t *info
);

/* Source: dtrti2.f */
#define dtrti2 FORTRAN_WRAPPER(dtrti2)
extern void dtrti2(
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: dtrtri.f */
#define dtrtri FORTRAN_WRAPPER(dtrtri)
extern void dtrtri(
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: dtrtrs.f */
#define dtrtrs FORTRAN_WRAPPER(dtrtrs)
extern void dtrtrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: dtrttf.f */
#define dtrttf FORTRAN_WRAPPER(dtrttf)
extern void dtrttf(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *arf,
    ptrdiff_t *info
);

/* Source: dtrttp.f */
#define dtrttp FORTRAN_WRAPPER(dtrttp)
extern void dtrttp(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *ap,
    ptrdiff_t *info
);

/* Source: dtzrqf.f */
#define dtzrqf FORTRAN_WRAPPER(dtzrqf)
extern void dtzrqf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    ptrdiff_t *info
);

/* Source: dtzrzf.f */
#define dtzrzf FORTRAN_WRAPPER(dtzrzf)
extern void dtzrzf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: dzsum1.f */
#define dzsum1 FORTRAN_WRAPPER(dzsum1)
extern double dzsum1(
    const ptrdiff_t *n,
    const double *cx,
    const ptrdiff_t *incx
);

/* Source: icmax1.f */
#define icmax1 FORTRAN_WRAPPER(icmax1)
extern ptrdiff_t icmax1(
    const ptrdiff_t *n,
    const float  *cx,
    const ptrdiff_t *incx
);

/* Source: ieeeck.f */
#define ieeeck FORTRAN_WRAPPER(ieeeck)
extern ptrdiff_t ieeeck(
    const ptrdiff_t *ispec,
    const float  *zero,
    const float  *one
);

/* Source: ilaclc.f */
#define ilaclc FORTRAN_WRAPPER(ilaclc)
extern ptrdiff_t ilaclc(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda
);

/* Source: ilaclr.f */
#define ilaclr FORTRAN_WRAPPER(ilaclr)
extern ptrdiff_t ilaclr(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda
);

/* Source: iladiag.f */
#define iladiag FORTRAN_WRAPPER(iladiag)
extern ptrdiff_t iladiag(
    const char   *diag
);

/* Source: iladlc.f */
#define iladlc FORTRAN_WRAPPER(iladlc)
extern ptrdiff_t iladlc(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda
);

/* Source: iladlr.f */
#define iladlr FORTRAN_WRAPPER(iladlr)
extern ptrdiff_t iladlr(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda
);

/* Source: ilaenv.f */
#define ilaenv FORTRAN_WRAPPER(ilaenv)
extern ptrdiff_t ilaenv(
    const ptrdiff_t *ispec,
    const char   *name,
    const char   *opts,
    const ptrdiff_t *n1,
    const ptrdiff_t *n2,
    const ptrdiff_t *n3,
    const ptrdiff_t *n4,
    ptrdiff_t name_len,
    ptrdiff_t opts_len
);

/* Source: ilaprec.f */
#define ilaprec FORTRAN_WRAPPER(ilaprec)
extern ptrdiff_t ilaprec(
    const char   *prec
);

/* Source: ilaslc.f */
#define ilaslc FORTRAN_WRAPPER(ilaslc)
extern ptrdiff_t ilaslc(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda
);

/* Source: ilaslr.f */
#define ilaslr FORTRAN_WRAPPER(ilaslr)
extern ptrdiff_t ilaslr(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda
);

/* Source: ilatrans.f */
#define ilatrans FORTRAN_WRAPPER(ilatrans)
extern ptrdiff_t ilatrans(
    const char   *trans
);

/* Source: ilauplo.f */
#define ilauplo FORTRAN_WRAPPER(ilauplo)
extern ptrdiff_t ilauplo(
    const char   *uplo
);

/* Source: ilaver.f */
#define ilaver FORTRAN_WRAPPER(ilaver)
extern void ilaver(
    ptrdiff_t *vers_major,
    ptrdiff_t *vers_minor,
    ptrdiff_t *vers_patch
);

/* Source: ilazlc.f */
#define ilazlc FORTRAN_WRAPPER(ilazlc)
extern ptrdiff_t ilazlc(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda
);

/* Source: ilazlr.f */
#define ilazlr FORTRAN_WRAPPER(ilazlr)
extern ptrdiff_t ilazlr(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda
);

/* Source: iparmq.f */
#define iparmq FORTRAN_WRAPPER(iparmq)
extern ptrdiff_t iparmq(
    const ptrdiff_t *ispec,
    const char   *name,
    const char   *opts,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    const ptrdiff_t *lwork
);

/* Source: izmax1.f */
#define izmax1 FORTRAN_WRAPPER(izmax1)
extern ptrdiff_t izmax1(
    const ptrdiff_t *n,
    const double *cx,
    const ptrdiff_t *incx
);

/* Source: lsamen.f */
#define lsamen FORTRAN_WRAPPER(lsamen)
extern ptrdiff_t lsamen(
    const ptrdiff_t *n,
    const char   *ca,
    const char   *cb,
    ptrdiff_t ca_len,
    ptrdiff_t cb_len
);

/* Source: sbbcsd.f */
#define sbbcsd FORTRAN_WRAPPER(sbbcsd)
extern void sbbcsd(
    const char   *jobu1,
    const char   *jobu2,
    const char   *jobv1t,
    const char   *jobv2t,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *q,
    float  *theta,
    float  *phi,
    float  *u1,
    const ptrdiff_t *ldu1,
    float  *u2,
    const ptrdiff_t *ldu2,
    float  *v1t,
    const ptrdiff_t *ldv1t,
    float  *v2t,
    const ptrdiff_t *ldv2t,
    float  *b11d,
    float  *b11e,
    float  *b12d,
    float  *b12e,
    float  *b21d,
    float  *b21e,
    float  *b22d,
    float  *b22e,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sbdsdc.f */
#define sbdsdc FORTRAN_WRAPPER(sbdsdc)
extern void sbdsdc(
    const char   *uplo,
    const char   *compq,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    float  *u,
    const ptrdiff_t *ldu,
    float  *vt,
    const ptrdiff_t *ldvt,
    float  *q,
    ptrdiff_t *iq,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sbdsqr.f */
#define sbdsqr FORTRAN_WRAPPER(sbdsqr)
extern void sbdsqr(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ncvt,
    const ptrdiff_t *nru,
    const ptrdiff_t *ncc,
    float  *d,
    float  *e,
    float  *vt,
    const ptrdiff_t *ldvt,
    float  *u,
    const ptrdiff_t *ldu,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: scsum1.f */
#define scsum1 FORTRAN_WRAPPER(scsum1)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double scsum1(
#else
extern float scsum1(
#endif 
    const ptrdiff_t *n,
    const float  *cx,
    const ptrdiff_t *incx
);

/* Source: sdisna.f */
#define sdisna FORTRAN_WRAPPER(sdisna)
extern void sdisna(
    const char   *job,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *d,
    float  *sep,
    ptrdiff_t *info
);

/* Source: sgbbrd.f */
#define sgbbrd FORTRAN_WRAPPER(sgbbrd)
extern void sgbbrd(
    const char   *vect,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *ncc,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *d,
    float  *e,
    float  *q,
    const ptrdiff_t *ldq,
    float  *pt,
    const ptrdiff_t *ldpt,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: sgbcon.f */
#define sgbcon FORTRAN_WRAPPER(sgbcon)
extern void sgbcon(
    const char   *norm,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const float  *ab,
    const ptrdiff_t *ldab,
    const ptrdiff_t *ipiv,
    const float  *anorm,
    float  *rcond,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sgbequ.f */
#define sgbequ FORTRAN_WRAPPER(sgbequ)
extern void sgbequ(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *r,
    float  *c,
    float  *rowcnd,
    float  *colcnd,
    float  *amax,
    ptrdiff_t *info
);

/* Source: sgbequb.f */
#define sgbequb FORTRAN_WRAPPER(sgbequb)
extern void sgbequb(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *r,
    float  *c,
    float  *rowcnd,
    float  *colcnd,
    float  *amax,
    ptrdiff_t *info
);

/* Source: sgbrfs.f */
#define sgbrfs FORTRAN_WRAPPER(sgbrfs)
extern void sgbrfs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    const float  *ab,
    const ptrdiff_t *ldab,
    const float  *afb,
    const ptrdiff_t *ldafb,
    const ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sgbsv.f */
#define sgbsv FORTRAN_WRAPPER(sgbsv)
extern void sgbsv(
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    float  *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: sgbsvx.f */
#define sgbsvx FORTRAN_WRAPPER(sgbsvx)
extern void sgbsvx(
    const char   *fact,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *afb,
    const ptrdiff_t *ldafb,
    ptrdiff_t *ipiv,
    char   *equed,
    float  *r,
    float  *c,
    float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sgbtf2.f */
#define sgbtf2 FORTRAN_WRAPPER(sgbtf2)
extern void sgbtf2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    float  *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: sgbtrf.f */
#define sgbtrf FORTRAN_WRAPPER(sgbtrf)
extern void sgbtrf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    float  *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: sgbtrs.f */
#define sgbtrs FORTRAN_WRAPPER(sgbtrs)
extern void sgbtrs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    const float  *ab,
    const ptrdiff_t *ldab,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: sgebak.f */
#define sgebak FORTRAN_WRAPPER(sgebak)
extern void sgebak(
    const char   *job,
    const char   *side,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    const float  *scale,
    const ptrdiff_t *m,
    float  *v,
    const ptrdiff_t *ldv,
    ptrdiff_t *info
);

/* Source: sgebal.f */
#define sgebal FORTRAN_WRAPPER(sgebal)
extern void sgebal(
    const char   *job,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    float  *scale,
    ptrdiff_t *info
);

/* Source: sgebd2.f */
#define sgebd2 FORTRAN_WRAPPER(sgebd2)
extern void sgebd2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *d,
    float  *e,
    float  *tauq,
    float  *taup,
    float  *work,
    ptrdiff_t *info
);

/* Source: sgebrd.f */
#define sgebrd FORTRAN_WRAPPER(sgebrd)
extern void sgebrd(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *d,
    float  *e,
    float  *tauq,
    float  *taup,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgecon.f */
#define sgecon FORTRAN_WRAPPER(sgecon)
extern void sgecon(
    const char   *norm,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *anorm,
    float  *rcond,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sgeequ.f */
#define sgeequ FORTRAN_WRAPPER(sgeequ)
extern void sgeequ(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *r,
    float  *c,
    float  *rowcnd,
    float  *colcnd,
    float  *amax,
    ptrdiff_t *info
);

/* Source: sgeequb.f */
#define sgeequb FORTRAN_WRAPPER(sgeequb)
extern void sgeequb(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *r,
    float  *c,
    float  *rowcnd,
    float  *colcnd,
    float  *amax,
    ptrdiff_t *info
);

/* Source: sgees.f */
#define sgees FORTRAN_WRAPPER(sgees)
extern void sgees(
    const char   *jobvs,
    const char   *sort,
    ptrdiff_t (*select)(),
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *sdim,
    float  *wr,
    float  *wi,
    float  *vs,
    const ptrdiff_t *ldvs,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: sgeesx.f */
#define sgeesx FORTRAN_WRAPPER(sgeesx)
extern void sgeesx(
    const char   *jobvs,
    const char   *sort,
    ptrdiff_t (*select)(),
    const char   *sense,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *sdim,
    float  *wr,
    float  *wi,
    float  *vs,
    const ptrdiff_t *ldvs,
    float  *rconde,
    float  *rcondv,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: sgeev.f */
#define sgeev FORTRAN_WRAPPER(sgeev)
extern void sgeev(
    const char   *jobvl,
    const char   *jobvr,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *wr,
    float  *wi,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgeevx.f */
#define sgeevx FORTRAN_WRAPPER(sgeevx)
extern void sgeevx(
    const char   *balanc,
    const char   *jobvl,
    const char   *jobvr,
    const char   *sense,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *wr,
    float  *wi,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    float  *scale,
    float  *abnrm,
    float  *rconde,
    float  *rcondv,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sgegs.f */
#define sgegs FORTRAN_WRAPPER(sgegs)
extern void sgegs(
    const char   *jobvsl,
    const char   *jobvsr,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *alphar,
    float  *alphai,
    float  *beta,
    float  *vsl,
    const ptrdiff_t *ldvsl,
    float  *vsr,
    const ptrdiff_t *ldvsr,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgegv.f */
#define sgegv FORTRAN_WRAPPER(sgegv)
extern void sgegv(
    const char   *jobvl,
    const char   *jobvr,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *alphar,
    float  *alphai,
    float  *beta,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgehd2.f */
#define sgehd2 FORTRAN_WRAPPER(sgehd2)
extern void sgehd2(
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: sgehrd.f */
#define sgehrd FORTRAN_WRAPPER(sgehrd)
extern void sgehrd(
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgejsv.f */
#define sgejsv FORTRAN_WRAPPER(sgejsv)
extern void sgejsv(
    char   *joba,
    char   *jobu,
    char   *jobv,
    char   *jobr,
    char   *jobt,
    char   *jobp,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *sva,
    float  *u,
    const ptrdiff_t *ldu,
    float  *v,
    const ptrdiff_t *ldv,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sgelq2.f */
#define sgelq2 FORTRAN_WRAPPER(sgelq2)
extern void sgelq2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: sgelqf.f */
#define sgelqf FORTRAN_WRAPPER(sgelqf)
extern void sgelqf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgels.f */
#define sgels FORTRAN_WRAPPER(sgels)
extern void sgels(
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgelsd.f */
#define sgelsd FORTRAN_WRAPPER(sgelsd)
extern void sgelsd(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *s,
    const float  *rcond,
    ptrdiff_t *rank,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sgelss.f */
#define sgelss FORTRAN_WRAPPER(sgelss)
extern void sgelss(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *s,
    const float  *rcond,
    ptrdiff_t *rank,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgelsx.f */
#define sgelsx FORTRAN_WRAPPER(sgelsx)
extern void sgelsx(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *jpvt,
    const float  *rcond,
    ptrdiff_t *rank,
    float  *work,
    ptrdiff_t *info
);

/* Source: sgelsy.f */
#define sgelsy FORTRAN_WRAPPER(sgelsy)
extern void sgelsy(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *jpvt,
    const float  *rcond,
    ptrdiff_t *rank,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgemqrt.f */
#define sgemqrt FORTRAN_WRAPPER(sgemqrt)
extern void sgemqrt(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *nb,
    const float  *v,
    const ptrdiff_t *ldv,
    const float  *t,
    const ptrdiff_t *ldt,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: sgeql2.f */
#define sgeql2 FORTRAN_WRAPPER(sgeql2)
extern void sgeql2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: sgeqlf.f */
#define sgeqlf FORTRAN_WRAPPER(sgeqlf)
extern void sgeqlf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgeqp3.f */
#define sgeqp3 FORTRAN_WRAPPER(sgeqp3)
extern void sgeqp3(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgeqpf.f */
#define sgeqpf FORTRAN_WRAPPER(sgeqpf)
extern void sgeqpf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: sgeqr2.f */
#define sgeqr2 FORTRAN_WRAPPER(sgeqr2)
extern void sgeqr2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: sgeqr2p.f */
#define sgeqr2p FORTRAN_WRAPPER(sgeqr2p)
extern void sgeqr2p(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: sgeqrf.f */
#define sgeqrf FORTRAN_WRAPPER(sgeqrf)
extern void sgeqrf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgeqrfp.f */
#define sgeqrfp FORTRAN_WRAPPER(sgeqrfp)
extern void sgeqrfp(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgeqrt.f */
#define sgeqrt FORTRAN_WRAPPER(sgeqrt)
extern void sgeqrt(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    float  *a,
    const ptrdiff_t *lda,
    float  *t,
    const ptrdiff_t *ldt,
    float  *work,
    ptrdiff_t *info
);

/* Source: sgeqrt2.f */
#define sgeqrt2 FORTRAN_WRAPPER(sgeqrt2)
extern void sgeqrt2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *t,
    const ptrdiff_t *ldt,
    ptrdiff_t *info
);

/* Source: sgeqrt3.f */
#define sgeqrt3 FORTRAN_WRAPPER(sgeqrt3)
extern void sgeqrt3(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *t,
    const ptrdiff_t *ldt,
    ptrdiff_t *info
);

/* Source: sgerfs.f */
#define sgerfs FORTRAN_WRAPPER(sgerfs)
extern void sgerfs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *af,
    const ptrdiff_t *ldaf,
    const ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sgerq2.f */
#define sgerq2 FORTRAN_WRAPPER(sgerq2)
extern void sgerq2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: sgerqf.f */
#define sgerqf FORTRAN_WRAPPER(sgerqf)
extern void sgerqf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgesc2.f */
#define sgesc2 FORTRAN_WRAPPER(sgesc2)
extern void sgesc2(
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *rhs,
    const ptrdiff_t *ipiv,
    const ptrdiff_t *jpiv,
    float  *scale
);

/* Source: sgesdd.f */
#define sgesdd FORTRAN_WRAPPER(sgesdd)
extern void sgesdd(
    const char   *jobz,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *s,
    float  *u,
    const ptrdiff_t *ldu,
    float  *vt,
    const ptrdiff_t *ldvt,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sgesv.f */
#define sgesv FORTRAN_WRAPPER(sgesv)
extern void sgesv(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: sgesvd.f */
#define sgesvd FORTRAN_WRAPPER(sgesvd)
extern void sgesvd(
    const char   *jobu,
    const char   *jobvt,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *s,
    float  *u,
    const ptrdiff_t *ldu,
    float  *vt,
    const ptrdiff_t *ldvt,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgesvj.f */
#define sgesvj FORTRAN_WRAPPER(sgesvj)
extern void sgesvj(
    const char   *joba,
    const char   *jobu,
    const char   *jobv,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *sva,
    const ptrdiff_t *mv,
    float  *v,
    const ptrdiff_t *ldv,
    float  *work,
    ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgesvx.f */
#define sgesvx FORTRAN_WRAPPER(sgesvx)
extern void sgesvx(
    const char   *fact,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    float  *af,
    const ptrdiff_t *ldaf,
    ptrdiff_t *ipiv,
    char   *equed,
    float  *r,
    float  *c,
    float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sgetc2.f */
#define sgetc2 FORTRAN_WRAPPER(sgetc2)
extern void sgetc2(
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *jpiv,
    ptrdiff_t *info
);

/* Source: sgetf2.f */
#define sgetf2 FORTRAN_WRAPPER(sgetf2)
extern void sgetf2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: sgetrf.f */
#define sgetrf FORTRAN_WRAPPER(sgetrf)
extern void sgetrf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: sgetri.f */
#define sgetri FORTRAN_WRAPPER(sgetri)
extern void sgetri(
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgetrs.f */
#define sgetrs FORTRAN_WRAPPER(sgetrs)
extern void sgetrs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: sggbak.f */
#define sggbak FORTRAN_WRAPPER(sggbak)
extern void sggbak(
    const char   *job,
    const char   *side,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    const float  *lscale,
    const float  *rscale,
    const ptrdiff_t *m,
    float  *v,
    const ptrdiff_t *ldv,
    ptrdiff_t *info
);

/* Source: sggbal.f */
#define sggbal FORTRAN_WRAPPER(sggbal)
extern void sggbal(
    const char   *job,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    float  *lscale,
    float  *rscale,
    float  *work,
    ptrdiff_t *info
);

/* Source: sgges.f */
#define sgges FORTRAN_WRAPPER(sgges)
extern void sgges(
    const char   *jobvsl,
    const char   *jobvsr,
    const char   *sort,
    ptrdiff_t (*selctg)(),
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *sdim,
    float  *alphar,
    float  *alphai,
    float  *beta,
    float  *vsl,
    const ptrdiff_t *ldvsl,
    float  *vsr,
    const ptrdiff_t *ldvsr,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: sggesx.f */
#define sggesx FORTRAN_WRAPPER(sggesx)
extern void sggesx(
    const char   *jobvsl,
    const char   *jobvsr,
    const char   *sort,
    ptrdiff_t (*selctg)(),
    const char   *sense,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *sdim,
    float  *alphar,
    float  *alphai,
    float  *beta,
    float  *vsl,
    const ptrdiff_t *ldvsl,
    float  *vsr,
    const ptrdiff_t *ldvsr,
    float  *rconde,
    float  *rcondv,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: sggev.f */
#define sggev FORTRAN_WRAPPER(sggev)
extern void sggev(
    const char   *jobvl,
    const char   *jobvr,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *alphar,
    float  *alphai,
    float  *beta,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sggevx.f */
#define sggevx FORTRAN_WRAPPER(sggevx)
extern void sggevx(
    const char   *balanc,
    const char   *jobvl,
    const char   *jobvr,
    const char   *sense,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *alphar,
    float  *alphai,
    float  *beta,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    float  *lscale,
    float  *rscale,
    float  *abnrm,
    float  *bbnrm,
    float  *rconde,
    float  *rcondv,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: sggglm.f */
#define sggglm FORTRAN_WRAPPER(sggglm)
extern void sggglm(
    const ptrdiff_t *n,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *d,
    float  *x,
    float  *y,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgghrd.f */
#define sgghrd FORTRAN_WRAPPER(sgghrd)
extern void sgghrd(
    const char   *compq,
    const char   *compz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *q,
    const ptrdiff_t *ldq,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *info
);

/* Source: sgglse.f */
#define sgglse FORTRAN_WRAPPER(sgglse)
extern void sgglse(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *p,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *c,
    float  *d,
    float  *x,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sggqrf.f */
#define sggqrf FORTRAN_WRAPPER(sggqrf)
extern void sggqrf(
    const ptrdiff_t *n,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    float  *a,
    const ptrdiff_t *lda,
    float  *taua,
    float  *b,
    const ptrdiff_t *ldb,
    float  *taub,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sggrqf.f */
#define sggrqf FORTRAN_WRAPPER(sggrqf)
extern void sggrqf(
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *taua,
    float  *b,
    const ptrdiff_t *ldb,
    float  *taub,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sggsvd.f */
#define sggsvd FORTRAN_WRAPPER(sggsvd)
extern void sggsvd(
    const char   *jobu,
    const char   *jobv,
    const char   *jobq,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *p,
    ptrdiff_t *k,
    ptrdiff_t *l,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *alpha,
    float  *beta,
    float  *u,
    const ptrdiff_t *ldu,
    float  *v,
    const ptrdiff_t *ldv,
    float  *q,
    const ptrdiff_t *ldq,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sggsvp.f */
#define sggsvp FORTRAN_WRAPPER(sggsvp)
extern void sggsvp(
    const char   *jobu,
    const char   *jobv,
    const char   *jobq,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    const float  *tola,
    const float  *tolb,
    ptrdiff_t *k,
    ptrdiff_t *l,
    float  *u,
    const ptrdiff_t *ldu,
    float  *v,
    const ptrdiff_t *ldv,
    float  *q,
    const ptrdiff_t *ldq,
    ptrdiff_t *iwork,
    float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: sgsvj0.f */
#define sgsvj0 FORTRAN_WRAPPER(sgsvj0)
extern void sgsvj0(
    const char   *jobv,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *d,
    float  *sva,
    const ptrdiff_t *mv,
    float  *v,
    const ptrdiff_t *ldv,
    const float  *eps,
    const float  *sfmin,
    const float  *tol,
    const ptrdiff_t *nsweep,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgsvj1.f */
#define sgsvj1 FORTRAN_WRAPPER(sgsvj1)
extern void sgsvj1(
    const char   *jobv,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *n1,
    float  *a,
    const ptrdiff_t *lda,
    float  *d,
    float  *sva,
    const ptrdiff_t *mv,
    float  *v,
    const ptrdiff_t *ldv,
    const float  *eps,
    const float  *sfmin,
    const float  *tol,
    const ptrdiff_t *nsweep,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sgtcon.f */
#define sgtcon FORTRAN_WRAPPER(sgtcon)
extern void sgtcon(
    const char   *norm,
    const ptrdiff_t *n,
    const float  *dl,
    const float  *d,
    const float  *du,
    const float  *du2,
    const ptrdiff_t *ipiv,
    const float  *anorm,
    float  *rcond,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sgtrfs.f */
#define sgtrfs FORTRAN_WRAPPER(sgtrfs)
extern void sgtrfs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *dl,
    const float  *d,
    const float  *du,
    const float  *dlf,
    const float  *df,
    const float  *duf,
    const float  *du2,
    const ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sgtsv.f */
#define sgtsv FORTRAN_WRAPPER(sgtsv)
extern void sgtsv(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *dl,
    float  *d,
    float  *du,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: sgtsvx.f */
#define sgtsvx FORTRAN_WRAPPER(sgtsvx)
extern void sgtsvx(
    const char   *fact,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *dl,
    const float  *d,
    const float  *du,
    float  *dlf,
    float  *df,
    float  *duf,
    float  *du2,
    ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sgttrf.f */
#define sgttrf FORTRAN_WRAPPER(sgttrf)
extern void sgttrf(
    const ptrdiff_t *n,
    float  *dl,
    float  *d,
    float  *du,
    float  *du2,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: sgttrs.f */
#define sgttrs FORTRAN_WRAPPER(sgttrs)
extern void sgttrs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *dl,
    const float  *d,
    const float  *du,
    const float  *du2,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: sgtts2.f */
#define sgtts2 FORTRAN_WRAPPER(sgtts2)
extern void sgtts2(
    const ptrdiff_t *itrans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *dl,
    const float  *d,
    const float  *du,
    const float  *du2,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb
);

/* Source: shgeqz.f */
#define shgeqz FORTRAN_WRAPPER(shgeqz)
extern void shgeqz(
    const char   *job,
    const char   *compq,
    const char   *compz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *h,
    const ptrdiff_t *ldh,
    float  *t,
    const ptrdiff_t *ldt,
    float  *alphar,
    float  *alphai,
    float  *beta,
    float  *q,
    const ptrdiff_t *ldq,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: shsein.f */
#define shsein FORTRAN_WRAPPER(shsein)
extern void shsein(
    const char   *side,
    const char   *eigsrc,
    const char   *initv,
    ptrdiff_t *select,
    const ptrdiff_t *n,
    const float  *h,
    const ptrdiff_t *ldh,
    float  *wr,
    const float  *wi,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    float  *work,
    ptrdiff_t *ifaill,
    ptrdiff_t *ifailr,
    ptrdiff_t *info
);

/* Source: shseqr.f */
#define shseqr FORTRAN_WRAPPER(shseqr)
extern void shseqr(
    const char   *job,
    const char   *compz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *h,
    const ptrdiff_t *ldh,
    float  *wr,
    float  *wi,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sisnan.f */
#define sisnan FORTRAN_WRAPPER(sisnan)
extern ptrdiff_t sisnan(
    const float  *sin
);

/* Source: slabad.f */
#define slabad FORTRAN_WRAPPER(slabad)
extern void slabad(
    float  *small,
    float  *large
);

/* Source: slabrd.f */
#define slabrd FORTRAN_WRAPPER(slabrd)
extern void slabrd(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    float  *a,
    const ptrdiff_t *lda,
    float  *d,
    float  *e,
    float  *tauq,
    float  *taup,
    float  *x,
    const ptrdiff_t *ldx,
    float  *y,
    const ptrdiff_t *ldy
);

/* Source: slacn2.f */
#define slacn2 FORTRAN_WRAPPER(slacn2)
extern void slacn2(
    const ptrdiff_t *n,
    float  *v,
    float  *x,
    ptrdiff_t *isgn,
    float  *est,
    ptrdiff_t *kase,
    ptrdiff_t *isave
);

/* Source: slacon.f */
#define slacon FORTRAN_WRAPPER(slacon)
extern void slacon(
    const ptrdiff_t *n,
    float  *v,
    float  *x,
    ptrdiff_t *isgn,
    float  *est,
    ptrdiff_t *kase
);

/* Source: slacpy.f */
#define slacpy FORTRAN_WRAPPER(slacpy)
extern void slacpy(
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb
);

/* Source: sladiv.f */
#define sladiv FORTRAN_WRAPPER(sladiv)
extern void sladiv(
    const float  *a,
    const float  *b,
    const float  *c,
    const float  *d,
    float  *p,
    float  *q
);

/* Source: slae2.f */
#define slae2 FORTRAN_WRAPPER(slae2)
extern void slae2(
    const float  *a,
    const float  *b,
    const float  *c,
    float  *rt1,
    float  *rt2
);

/* Source: slaebz.f */
#define slaebz FORTRAN_WRAPPER(slaebz)
extern void slaebz(
    const ptrdiff_t *ijob,
    const ptrdiff_t *nitmax,
    const ptrdiff_t *n,
    const ptrdiff_t *mmax,
    const ptrdiff_t *minp,
    const ptrdiff_t *nbmin,
    const float  *abstol,
    const float  *reltol,
    const float  *pivmin,
    const float  *d,
    const float  *e,
    const float  *e2,
    ptrdiff_t *nval,
    float  *ab,
    float  *c,
    ptrdiff_t *mout,
    ptrdiff_t *nab,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: slaed0.f */
#define slaed0 FORTRAN_WRAPPER(slaed0)
extern void slaed0(
    const ptrdiff_t *icompq,
    const ptrdiff_t *qsiz,
    const ptrdiff_t *n,
    float  *d,
    const float  *e,
    float  *q,
    const ptrdiff_t *ldq,
    float  *qstore,
    const ptrdiff_t *ldqs,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: slaed1.f */
#define slaed1 FORTRAN_WRAPPER(slaed1)
extern void slaed1(
    const ptrdiff_t *n,
    float  *d,
    float  *q,
    const ptrdiff_t *ldq,
    ptrdiff_t *indxq,
    const float  *rho,
    const ptrdiff_t *cutpnt,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: slaed2.f */
#define slaed2 FORTRAN_WRAPPER(slaed2)
extern void slaed2(
    ptrdiff_t *k,
    const ptrdiff_t *n,
    const ptrdiff_t *n1,
    float  *d,
    float  *q,
    const ptrdiff_t *ldq,
    ptrdiff_t *indxq,
    float  *rho,
    const float  *z,
    float  *dlamda,
    float  *w,
    float  *q2,
    ptrdiff_t *indx,
    ptrdiff_t *indxc,
    ptrdiff_t *indxp,
    ptrdiff_t *coltyp,
    ptrdiff_t *info
);

/* Source: slaed3.f */
#define slaed3 FORTRAN_WRAPPER(slaed3)
extern void slaed3(
    const ptrdiff_t *k,
    const ptrdiff_t *n,
    const ptrdiff_t *n1,
    float  *d,
    float  *q,
    const ptrdiff_t *ldq,
    const float  *rho,
    float  *dlamda,
    const float  *q2,
    const ptrdiff_t *indx,
    const ptrdiff_t *ctot,
    float  *w,
    float  *s,
    ptrdiff_t *info
);

/* Source: slaed4.f */
#define slaed4 FORTRAN_WRAPPER(slaed4)
extern void slaed4(
    const ptrdiff_t *n,
    const ptrdiff_t *i,
    const float  *d,
    const float  *z,
    float  *delta,
    const float  *rho,
    float  *dlam,
    ptrdiff_t *info
);

/* Source: slaed5.f */
#define slaed5 FORTRAN_WRAPPER(slaed5)
extern void slaed5(
    const ptrdiff_t *i,
    const float  *d,
    const float  *z,
    float  *delta,
    const float  *rho,
    float  *dlam
);

/* Source: slaed6.f */
#define slaed6 FORTRAN_WRAPPER(slaed6)
extern void slaed6(
    const ptrdiff_t *kniter,
    const ptrdiff_t *orgati,
    const float  *rho,
    const float  *d,
    const float  *z,
    const float  *finit,
    float  *tau,
    ptrdiff_t *info
);

/* Source: slaed7.f */
#define slaed7 FORTRAN_WRAPPER(slaed7)
extern void slaed7(
    const ptrdiff_t *icompq,
    const ptrdiff_t *n,
    const ptrdiff_t *qsiz,
    const ptrdiff_t *tlvls,
    const ptrdiff_t *curlvl,
    const ptrdiff_t *curpbm,
    float  *d,
    float  *q,
    const ptrdiff_t *ldq,
    ptrdiff_t *indxq,
    const float  *rho,
    const ptrdiff_t *cutpnt,
    float  *qstore,
    ptrdiff_t *qptr,
    const ptrdiff_t *prmptr,
    const ptrdiff_t *perm,
    const ptrdiff_t *givptr,
    const ptrdiff_t *givcol,
    const float  *givnum,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: slaed8.f */
#define slaed8 FORTRAN_WRAPPER(slaed8)
extern void slaed8(
    const ptrdiff_t *icompq,
    ptrdiff_t *k,
    const ptrdiff_t *n,
    const ptrdiff_t *qsiz,
    float  *d,
    float  *q,
    const ptrdiff_t *ldq,
    const ptrdiff_t *indxq,
    float  *rho,
    const ptrdiff_t *cutpnt,
    const float  *z,
    float  *dlamda,
    float  *q2,
    const ptrdiff_t *ldq2,
    float  *w,
    ptrdiff_t *perm,
    ptrdiff_t *givptr,
    ptrdiff_t *givcol,
    float  *givnum,
    ptrdiff_t *indxp,
    ptrdiff_t *indx,
    ptrdiff_t *info
);

/* Source: slaed9.f */
#define slaed9 FORTRAN_WRAPPER(slaed9)
extern void slaed9(
    const ptrdiff_t *k,
    const ptrdiff_t *kstart,
    const ptrdiff_t *kstop,
    const ptrdiff_t *n,
    float  *d,
    float  *q,
    const ptrdiff_t *ldq,
    const float  *rho,
    const float  *dlamda,
    const float  *w,
    float  *s,
    const ptrdiff_t *lds,
    ptrdiff_t *info
);

/* Source: slaeda.f */
#define slaeda FORTRAN_WRAPPER(slaeda)
extern void slaeda(
    const ptrdiff_t *n,
    const ptrdiff_t *tlvls,
    const ptrdiff_t *curlvl,
    const ptrdiff_t *curpbm,
    const ptrdiff_t *prmptr,
    const ptrdiff_t *perm,
    const ptrdiff_t *givptr,
    const ptrdiff_t *givcol,
    const float  *givnum,
    const float  *q,
    const ptrdiff_t *qptr,
    float  *z,
    float  *ztemp,
    ptrdiff_t *info
);

/* Source: slaein.f */
#define slaein FORTRAN_WRAPPER(slaein)
extern void slaein(
    const ptrdiff_t *rightv,
    const ptrdiff_t *noinit,
    const ptrdiff_t *n,
    const float  *h,
    const ptrdiff_t *ldh,
    const float  *wr,
    const float  *wi,
    float  *vr,
    float  *vi,
    float  *b,
    const ptrdiff_t *ldb,
    float  *work,
    const float  *eps3,
    const float  *smlnum,
    const float  *bignum,
    ptrdiff_t *info
);

/* Source: slaev2.f */
#define slaev2 FORTRAN_WRAPPER(slaev2)
extern void slaev2(
    const float  *a,
    const float  *b,
    const float  *c,
    float  *rt1,
    float  *rt2,
    float  *cs1,
    float  *sn1
);

/* Source: slaexc.f */
#define slaexc FORTRAN_WRAPPER(slaexc)
extern void slaexc(
    const ptrdiff_t *wantq,
    const ptrdiff_t *n,
    float  *t,
    const ptrdiff_t *ldt,
    float  *q,
    const ptrdiff_t *ldq,
    const ptrdiff_t *j1_,
    const ptrdiff_t *n1,
    const ptrdiff_t *n2,
    float  *work,
    ptrdiff_t *info
);

/* Source: slag2.f */
#define slag2 FORTRAN_WRAPPER(slag2)
extern void slag2(
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *safmin,
    float  *scale1,
    float  *scale2,
    float  *wr1,
    float  *wr2,
    float  *wi
);

/* Source: slag2d.f */
#define slag2d FORTRAN_WRAPPER(slag2d)
extern void slag2d(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *sa,
    const ptrdiff_t *ldsa,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: slags2.f */
#define slags2 FORTRAN_WRAPPER(slags2)
extern void slags2(
    const ptrdiff_t *upper,
    const float  *a1,
    const float  *a2,
    const float  *a3,
    const float  *b1,
    const float  *b2,
    const float  *b3,
    float  *csu,
    float  *snu,
    float  *csv,
    float  *snv,
    float  *csq,
    float  *snq
);

/* Source: slagtf.f */
#define slagtf FORTRAN_WRAPPER(slagtf)
extern void slagtf(
    const ptrdiff_t *n,
    float  *a,
    const float  *lambda,
    float  *b,
    float  *c,
    const float  *tol,
    float  *d,
    ptrdiff_t *in,
    ptrdiff_t *info
);

/* Source: slagtm.f */
#define slagtm FORTRAN_WRAPPER(slagtm)
extern void slagtm(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *alpha,
    const float  *dl,
    const float  *d,
    const float  *du,
    const float  *x,
    const ptrdiff_t *ldx,
    const float  *beta,
    float  *b,
    const ptrdiff_t *ldb
);

/* Source: slagts.f */
#define slagts FORTRAN_WRAPPER(slagts)
extern void slagts(
    const ptrdiff_t *job,
    const ptrdiff_t *n,
    const float  *a,
    const float  *b,
    const float  *c,
    const float  *d,
    const ptrdiff_t *in,
    float  *y,
    float  *tol,
    ptrdiff_t *info
);

/* Source: slagv2.f */
#define slagv2 FORTRAN_WRAPPER(slagv2)
extern void slagv2(
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *alphar,
    float  *alphai,
    float  *beta,
    float  *csl,
    float  *snl,
    float  *csr,
    float  *snr
);

/* Source: slahqr.f */
#define slahqr FORTRAN_WRAPPER(slahqr)
extern void slahqr(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *h,
    const ptrdiff_t *ldh,
    float  *wr,
    float  *wi,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *info
);

/* Source: slahr2.f */
#define slahr2 FORTRAN_WRAPPER(slahr2)
extern void slahr2(
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *nb,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *t,
    const ptrdiff_t *ldt,
    float  *y,
    const ptrdiff_t *ldy
);

/* Source: slahrd.f */
#define slahrd FORTRAN_WRAPPER(slahrd)
extern void slahrd(
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *nb,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *t,
    const ptrdiff_t *ldt,
    float  *y,
    const ptrdiff_t *ldy
);

/* Source: slaic1.f */
#define slaic1 FORTRAN_WRAPPER(slaic1)
extern void slaic1(
    const ptrdiff_t *job,
    const ptrdiff_t *j,
    const float  *x,
    const float  *sest,
    const float  *w,
    const float  *gamma_,
    float  *sestpr,
    float  *s,
    float  *c
);

/* Source: slaisnan.f */
#define slaisnan FORTRAN_WRAPPER(slaisnan)
extern ptrdiff_t slaisnan(
    const float  *sin1,
    const float  *sin2
);

/* Source: slaln2.f */
#define slaln2 FORTRAN_WRAPPER(slaln2)
extern void slaln2(
    const ptrdiff_t *ltrans,
    const ptrdiff_t *na,
    const ptrdiff_t *nw,
    const float  *smin,
    const float  *ca,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *d1,
    const float  *d2,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *wr,
    const float  *wi,
    float  *x,
    const ptrdiff_t *ldx,
    float  *scale,
    float  *xnorm,
    ptrdiff_t *info
);

/* Source: slals0.f */
#define slals0 FORTRAN_WRAPPER(slals0)
extern void slals0(
    const ptrdiff_t *icompq,
    const ptrdiff_t *nl,
    const ptrdiff_t *nr,
    const ptrdiff_t *sqre,
    const ptrdiff_t *nrhs,
    float  *b,
    const ptrdiff_t *ldb,
    float  *bx,
    const ptrdiff_t *ldbx,
    const ptrdiff_t *perm,
    const ptrdiff_t *givptr,
    const ptrdiff_t *givcol,
    const ptrdiff_t *ldgcol,
    const float  *givnum,
    const ptrdiff_t *ldgnum,
    const float  *poles,
    const float  *difl,
    const float  *difr,
    const float  *z,
    const ptrdiff_t *k,
    const float  *c,
    const float  *s,
    float  *work,
    ptrdiff_t *info
);

/* Source: slalsa.f */
#define slalsa FORTRAN_WRAPPER(slalsa)
extern void slalsa(
    const ptrdiff_t *icompq,
    const ptrdiff_t *smlsiz,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *b,
    const ptrdiff_t *ldb,
    float  *bx,
    const ptrdiff_t *ldbx,
    const float  *u,
    const ptrdiff_t *ldu,
    const float  *vt,
    const ptrdiff_t *k,
    const float  *difl,
    const float  *difr,
    const float  *z,
    const float  *poles,
    const ptrdiff_t *givptr,
    const ptrdiff_t *givcol,
    const ptrdiff_t *ldgcol,
    const ptrdiff_t *perm,
    const float  *givnum,
    const float  *c,
    const float  *s,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: slalsd.f */
#define slalsd FORTRAN_WRAPPER(slalsd)
extern void slalsd(
    const char   *uplo,
    const ptrdiff_t *smlsiz,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *d,
    float  *e,
    float  *b,
    const ptrdiff_t *ldb,
    const float  *rcond,
    ptrdiff_t *rank,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: slamrg.f */
#define slamrg FORTRAN_WRAPPER(slamrg)
extern void slamrg(
    const ptrdiff_t *n1,
    const ptrdiff_t *n2,
    const float  *a,
    const ptrdiff_t *strd1,
    const ptrdiff_t *strd2,
    ptrdiff_t *index
);

/* Source: slaneg.f */
#define slaneg FORTRAN_WRAPPER(slaneg)
extern ptrdiff_t slaneg(
    const ptrdiff_t *n,
    const float  *d,
    const float  *lld,
    const float  *sigma,
    const float  *pivmin,
    const ptrdiff_t *r
);

/* Source: slangb.f */
#define slangb FORTRAN_WRAPPER(slangb)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slangb(
#else
extern float slangb(
#endif 
    const char   *norm,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *work
);

/* Source: slange.f */
#define slange FORTRAN_WRAPPER(slange)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slange(
#else
extern float slange(
#endif 
    const char   *norm,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *work
);

/* Source: slangt.f */
#define slangt FORTRAN_WRAPPER(slangt)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slangt(
#else
extern float slangt(
#endif 
    const char   *norm,
    const ptrdiff_t *n,
    const float  *dl,
    const float  *d,
    const float  *du
);

/* Source: slanhs.f */
#define slanhs FORTRAN_WRAPPER(slanhs)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slanhs(
#else
extern float slanhs(
#endif 
    const char   *norm,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *work
);

/* Source: slansb.f */
#define slansb FORTRAN_WRAPPER(slansb)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slansb(
#else
extern float slansb(
#endif 
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *work
);

/* Source: slansf.f */
#define slansf FORTRAN_WRAPPER(slansf)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slansf(
#else
extern float slansf(
#endif 
    const char   *norm,
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    float  *work
);

/* Source: slansp.f */
#define slansp FORTRAN_WRAPPER(slansp)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slansp(
#else
extern float slansp(
#endif 
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    float  *work
);

/* Source: slanst.f */
#define slanst FORTRAN_WRAPPER(slanst)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slanst(
#else
extern float slanst(
#endif 
    const char   *norm,
    const ptrdiff_t *n,
    const float  *d,
    const float  *e
);

/* Source: slansy.f */
#define slansy FORTRAN_WRAPPER(slansy)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slansy(
#else
extern float slansy(
#endif 
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *work
);

/* Source: slantb.f */
#define slantb FORTRAN_WRAPPER(slantb)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slantb(
#else
extern float slantb(
#endif 
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *work
);

/* Source: slantp.f */
#define slantp FORTRAN_WRAPPER(slantp)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slantp(
#else
extern float slantp(
#endif 
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const float  *ap,
    float  *work
);

/* Source: slantr.f */
#define slantr FORTRAN_WRAPPER(slantr)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slantr(
#else
extern float slantr(
#endif 
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *work
);

/* Source: slanv2.f */
#define slanv2 FORTRAN_WRAPPER(slanv2)
extern void slanv2(
    float  *a,
    float  *b,
    float  *c,
    float  *d,
    float  *rt1r,
    float  *rt1i,
    float  *rt2r,
    float  *rt2i,
    float  *cs,
    float  *sn
);

/* Source: slapll.f */
#define slapll FORTRAN_WRAPPER(slapll)
extern void slapll(
    const ptrdiff_t *n,
    float  *x,
    const ptrdiff_t *incx,
    float  *y,
    const ptrdiff_t *incy,
    float  *ssmin
);

/* Source: slapmr.f */
#define slapmr FORTRAN_WRAPPER(slapmr)
extern void slapmr(
    const ptrdiff_t *forwrd,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *x,
    const ptrdiff_t *ldx,
    ptrdiff_t *k
);

/* Source: slapmt.f */
#define slapmt FORTRAN_WRAPPER(slapmt)
extern void slapmt(
    const ptrdiff_t *forwrd,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *x,
    const ptrdiff_t *ldx,
    ptrdiff_t *k
);

/* Source: slapy2.f */
#define slapy2 FORTRAN_WRAPPER(slapy2)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slapy2(
#else
extern float slapy2(
#endif 
    const float  *x,
    const float  *y
);

/* Source: slapy3.f */
#define slapy3 FORTRAN_WRAPPER(slapy3)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double slapy3(
#else
extern float slapy3(
#endif 
    const float  *x,
    const float  *y,
    const float  *z
);

/* Source: slaqgb.f */
#define slaqgb FORTRAN_WRAPPER(slaqgb)
extern void slaqgb(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    float  *ab,
    const ptrdiff_t *ldab,
    const float  *r,
    const float  *c,
    const float  *rowcnd,
    const float  *colcnd,
    const float  *amax,
    char   *equed
);

/* Source: slaqge.f */
#define slaqge FORTRAN_WRAPPER(slaqge)
extern void slaqge(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const float  *r,
    const float  *c,
    const float  *rowcnd,
    const float  *colcnd,
    const float  *amax,
    char   *equed
);

/* Source: slaqp2.f */
#define slaqp2 FORTRAN_WRAPPER(slaqp2)
extern void slaqp2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *offset,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    float  *tau,
    float  *vn1,
    float  *vn2,
    float  *work
);

/* Source: slaqps.f */
#define slaqps FORTRAN_WRAPPER(slaqps)
extern void slaqps(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *offset,
    const ptrdiff_t *nb,
    ptrdiff_t *kb,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    float  *tau,
    float  *vn1,
    float  *vn2,
    float  *auxv,
    float  *f,
    const ptrdiff_t *ldf
);

/* Source: slaqr0.f */
#define slaqr0 FORTRAN_WRAPPER(slaqr0)
extern void slaqr0(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *h,
    const ptrdiff_t *ldh,
    float  *wr,
    float  *wi,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: slaqr1.f */
#define slaqr1 FORTRAN_WRAPPER(slaqr1)
extern void slaqr1(
    const ptrdiff_t *n,
    const float  *h,
    const ptrdiff_t *ldh,
    const float  *sr1,
    float  *si1,
    float  *sr2,
    float  *si2,
    float  *v
);

/* Source: slaqr2.f */
#define slaqr2 FORTRAN_WRAPPER(slaqr2)
extern void slaqr2(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ktop,
    const ptrdiff_t *kbot,
    const ptrdiff_t *nw,
    float  *h,
    const ptrdiff_t *ldh,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *ns,
    ptrdiff_t *nd,
    float  *sr,
    float  *si,
    float  *v,
    const ptrdiff_t *ldv,
    const ptrdiff_t *nh,
    float  *t,
    const ptrdiff_t *ldt,
    const ptrdiff_t *nv,
    float  *wv,
    const ptrdiff_t *ldwv,
    float  *work,
    const ptrdiff_t *lwork
);

/* Source: slaqr3.f */
#define slaqr3 FORTRAN_WRAPPER(slaqr3)
extern void slaqr3(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ktop,
    const ptrdiff_t *kbot,
    const ptrdiff_t *nw,
    float  *h,
    const ptrdiff_t *ldh,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *ns,
    ptrdiff_t *nd,
    float  *sr,
    float  *si,
    float  *v,
    const ptrdiff_t *ldv,
    const ptrdiff_t *nh,
    float  *t,
    const ptrdiff_t *ldt,
    const ptrdiff_t *nv,
    float  *wv,
    const ptrdiff_t *ldwv,
    float  *work,
    const ptrdiff_t *lwork
);

/* Source: slaqr4.f */
#define slaqr4 FORTRAN_WRAPPER(slaqr4)
extern void slaqr4(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *h,
    const ptrdiff_t *ldh,
    float  *wr,
    float  *wi,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: slaqr5.f */
#define slaqr5 FORTRAN_WRAPPER(slaqr5)
extern void slaqr5(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *kacc22,
    const ptrdiff_t *n,
    const ptrdiff_t *ktop,
    const ptrdiff_t *kbot,
    const ptrdiff_t *nshfts,
    float  *sr,
    float  *si,
    float  *h,
    const ptrdiff_t *ldh,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    float  *z,
    const ptrdiff_t *ldz,
    float  *v,
    const ptrdiff_t *ldv,
    float  *u,
    const ptrdiff_t *ldu,
    const ptrdiff_t *nv,
    float  *wv,
    const ptrdiff_t *ldwv,
    const ptrdiff_t *nh,
    float  *wh,
    const ptrdiff_t *ldwh
);

/* Source: slaqsb.f */
#define slaqsb FORTRAN_WRAPPER(slaqsb)
extern void slaqsb(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    const float  *s,
    const float  *scond,
    const float  *amax,
    char   *equed
);

/* Source: slaqsp.f */
#define slaqsp FORTRAN_WRAPPER(slaqsp)
extern void slaqsp(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    const float  *s,
    const float  *scond,
    const float  *amax,
    char   *equed
);

/* Source: slaqsy.f */
#define slaqsy FORTRAN_WRAPPER(slaqsy)
extern void slaqsy(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const float  *s,
    const float  *scond,
    const float  *amax,
    char   *equed
);

/* Source: slaqtr.f */
#define slaqtr FORTRAN_WRAPPER(slaqtr)
extern void slaqtr(
    const ptrdiff_t *ltran,
    const ptrdiff_t *lreal,
    const ptrdiff_t *n,
    const float  *t,
    const ptrdiff_t *ldt,
    const float  *b,
    const float  *w,
    float  *scale,
    float  *x,
    float  *work,
    ptrdiff_t *info
);

/* Source: slar1v.f */
#define slar1v FORTRAN_WRAPPER(slar1v)
extern void slar1v(
    const ptrdiff_t *n,
    const ptrdiff_t *b1,
    const ptrdiff_t *bn,
    const float  *lambda,
    const float  *d,
    const float  *l,
    const float  *ld,
    const float  *lld,
    const float  *pivmin,
    const float  *gaptol,
    float  *z,
    const ptrdiff_t *wantnc,
    ptrdiff_t *negcnt,
    float  *ztz,
    float  *mingma,
    ptrdiff_t *r,
    ptrdiff_t *isuppz,
    float  *nrminv,
    float  *resid,
    float  *rqcorr,
    float  *work
);

/* Source: slar2v.f */
#define slar2v FORTRAN_WRAPPER(slar2v)
extern void slar2v(
    const ptrdiff_t *n,
    float  *x,
    float  *y,
    float  *z,
    const ptrdiff_t *incx,
    const float  *c,
    const float  *s,
    const ptrdiff_t *incc
);

/* Source: slarf.f */
#define slarf FORTRAN_WRAPPER(slarf)
extern void slarf(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *v,
    const ptrdiff_t *incv,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work
);

/* Source: slarfb.f */
#define slarfb FORTRAN_WRAPPER(slarfb)
extern void slarfb(
    const char   *side,
    const char   *trans,
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *v,
    const ptrdiff_t *ldv,
    const float  *t,
    const ptrdiff_t *ldt,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *ldwork
);

/* Source: slarfg.f */
#define slarfg FORTRAN_WRAPPER(slarfg)
extern void slarfg(
    const ptrdiff_t *n,
    float  *alpha,
    float  *x,
    const ptrdiff_t *incx,
    float  *tau
);

/* Source: slarfgp.f */
#define slarfgp FORTRAN_WRAPPER(slarfgp)
extern void slarfgp(
    const ptrdiff_t *n,
    float  *alpha,
    float  *x,
    const ptrdiff_t *incx,
    float  *tau
);

/* Source: slarft.f */
#define slarft FORTRAN_WRAPPER(slarft)
extern void slarft(
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *v,
    const ptrdiff_t *ldv,
    const float  *tau,
    float  *t,
    const ptrdiff_t *ldt
);

/* Source: slarfx.f */
#define slarfx FORTRAN_WRAPPER(slarfx)
extern void slarfx(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *v,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work
);

/* Source: slargv.f */
#define slargv FORTRAN_WRAPPER(slargv)
extern void slargv(
    const ptrdiff_t *n,
    float  *x,
    const ptrdiff_t *incx,
    float  *y,
    const ptrdiff_t *incy,
    float  *c,
    const ptrdiff_t *incc
);

/* Source: slarnv.f */
#define slarnv FORTRAN_WRAPPER(slarnv)
extern void slarnv(
    const ptrdiff_t *idist,
    ptrdiff_t *iseed,
    const ptrdiff_t *n,
    float  *x
);

/* Source: slarra.f */
#define slarra FORTRAN_WRAPPER(slarra)
extern void slarra(
    const ptrdiff_t *n,
    const float  *d,
    float  *e,
    float  *e2,
    const float  *spltol,
    const float  *tnrm,
    ptrdiff_t *nsplit,
    ptrdiff_t *isplit,
    ptrdiff_t *info
);

/* Source: slarrb.f */
#define slarrb FORTRAN_WRAPPER(slarrb)
extern void slarrb(
    const ptrdiff_t *n,
    const float  *d,
    const float  *lld,
    const ptrdiff_t *ifirst,
    const ptrdiff_t *ilast,
    const float  *rtol1,
    const float  *rtol2,
    const ptrdiff_t *offset,
    float  *w,
    float  *wgap,
    float  *werr,
    float  *work,
    ptrdiff_t *iwork,
    const float  *pivmin,
    const float  *spdiam,
    const ptrdiff_t *twist,
    ptrdiff_t *info
);

/* Source: slarrc.f */
#define slarrc FORTRAN_WRAPPER(slarrc)
extern void slarrc(
    const char   *jobt,
    const ptrdiff_t *n,
    const float  *vl,
    const float  *vu,
    const float  *d,
    const float  *e,
    const float  *pivmin,
    ptrdiff_t *eigcnt,
    ptrdiff_t *lcnt,
    ptrdiff_t *rcnt,
    ptrdiff_t *info
);

/* Source: slarrd.f */
#define slarrd FORTRAN_WRAPPER(slarrd)
extern void slarrd(
    const char   *range,
    const char   *order,
    const ptrdiff_t *n,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *gers,
    const float  *reltol,
    const float  *d,
    const float  *e,
    const float  *e2,
    const float  *pivmin,
    const ptrdiff_t *nsplit,
    const ptrdiff_t *isplit,
    ptrdiff_t *m,
    float  *w,
    float  *werr,
    float  *wl,
    float  *wu,
    ptrdiff_t *iblock,
    ptrdiff_t *indexw,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: slarre.f */
#define slarre FORTRAN_WRAPPER(slarre)
extern void slarre(
    const char   *range,
    const ptrdiff_t *n,
    float  *vl,
    float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    float  *d,
    float  *e,
    float  *e2,
    const float  *rtol1,
    const float  *rtol2,
    const float  *spltol,
    ptrdiff_t *nsplit,
    ptrdiff_t *isplit,
    ptrdiff_t *m,
    float  *w,
    float  *werr,
    float  *wgap,
    ptrdiff_t *iblock,
    ptrdiff_t *indexw,
    float  *gers,
    float  *pivmin,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: slarrf.f */
#define slarrf FORTRAN_WRAPPER(slarrf)
extern void slarrf(
    const ptrdiff_t *n,
    const float  *d,
    const float  *l,
    const float  *ld,
    const ptrdiff_t *clstrt,
    const ptrdiff_t *clend,
    const float  *w,
    float  *wgap,
    const float  *werr,
    const float  *spdiam,
    const float  *clgapl,
    float  *clgapr,
    const float  *pivmin,
    float  *sigma,
    float  *dplus,
    float  *lplus,
    float  *work,
    ptrdiff_t *info
);

/* Source: slarrj.f */
#define slarrj FORTRAN_WRAPPER(slarrj)
extern void slarrj(
    const ptrdiff_t *n,
    const float  *d,
    const float  *e2,
    const ptrdiff_t *ifirst,
    const ptrdiff_t *ilast,
    const float  *rtol,
    const ptrdiff_t *offset,
    float  *w,
    float  *werr,
    float  *work,
    ptrdiff_t *iwork,
    const float  *pivmin,
    const float  *spdiam,
    ptrdiff_t *info
);

/* Source: slarrk.f */
#define slarrk FORTRAN_WRAPPER(slarrk)
extern void slarrk(
    const ptrdiff_t *n,
    const ptrdiff_t *iw,
    const float  *gl,
    const float  *gu,
    const float  *d,
    const float  *e2,
    const float  *pivmin,
    const float  *reltol,
    float  *w,
    float  *werr,
    ptrdiff_t *info
);

/* Source: slarrr.f */
#define slarrr FORTRAN_WRAPPER(slarrr)
extern void slarrr(
    const ptrdiff_t *n,
    const float  *d,
    float  *e,
    ptrdiff_t *info
);

/* Source: slarrv.f */
#define slarrv FORTRAN_WRAPPER(slarrv)
extern void slarrv(
    const ptrdiff_t *n,
    const float  *vl,
    const float  *vu,
    float  *d,
    float  *l,
    float  *pivmin,
    const ptrdiff_t *isplit,
    const ptrdiff_t *m,
    const ptrdiff_t *dol,
    const ptrdiff_t *dou,
    const float  *minrgp,
    const float  *rtol1,
    const float  *rtol2,
    float  *w,
    float  *werr,
    float  *wgap,
    const ptrdiff_t *iblock,
    const ptrdiff_t *indexw,
    const float  *gers,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *isuppz,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: slartg.f */
#define slartg FORTRAN_WRAPPER(slartg)
extern void slartg(
    const float  *f,
    const float  *g,
    float  *cs,
    float  *sn,
    float  *r
);

/* Source: slartgp.f */
#define slartgp FORTRAN_WRAPPER(slartgp)
extern void slartgp(
    float  *f,
    float  *g,
    float  *cs,
    float  *sn,
    float  *r
);

/* Source: slartgs.f */
#define slartgs FORTRAN_WRAPPER(slartgs)
extern void slartgs(
    float  *x,
    float  *y,
    float  *sigma,
    float  *cs,
    float  *sn
);

/* Source: slartv.f */
#define slartv FORTRAN_WRAPPER(slartv)
extern void slartv(
    const ptrdiff_t *n,
    float  *x,
    const ptrdiff_t *incx,
    float  *y,
    const ptrdiff_t *incy,
    const float  *c,
    const float  *s,
    const ptrdiff_t *incc
);

/* Source: slaruv.f */
#define slaruv FORTRAN_WRAPPER(slaruv)
extern void slaruv(
    ptrdiff_t *iseed,
    const ptrdiff_t *n,
    float  *x
);

/* Source: slarz.f */
#define slarz FORTRAN_WRAPPER(slarz)
extern void slarz(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    const float  *v,
    const ptrdiff_t *incv,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work
);

/* Source: slarzb.f */
#define slarzb FORTRAN_WRAPPER(slarzb)
extern void slarzb(
    const char   *side,
    const char   *trans,
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const float  *v,
    const ptrdiff_t *ldv,
    const float  *t,
    const ptrdiff_t *ldt,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *ldwork
);

/* Source: slarzt.f */
#define slarzt FORTRAN_WRAPPER(slarzt)
extern void slarzt(
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *v,
    const ptrdiff_t *ldv,
    const float  *tau,
    float  *t,
    const ptrdiff_t *ldt
);

/* Source: slas2.f */
#define slas2 FORTRAN_WRAPPER(slas2)
extern void slas2(
    const float  *f,
    const float  *g,
    const float  *h,
    float  *ssmin,
    float  *ssmax
);

/* Source: slascl.f */
#define slascl FORTRAN_WRAPPER(slascl)
extern void slascl(
    const char   *type,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const float  *cfrom,
    const float  *cto,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: slasd0.f */
#define slasd0 FORTRAN_WRAPPER(slasd0)
extern void slasd0(
    const ptrdiff_t *n,
    const ptrdiff_t *sqre,
    float  *d,
    const float  *e,
    float  *u,
    const ptrdiff_t *ldu,
    float  *vt,
    const ptrdiff_t *ldvt,
    const ptrdiff_t *smlsiz,
    ptrdiff_t *iwork,
    float  *work,
    ptrdiff_t *info
);

/* Source: slasd1.f */
#define slasd1 FORTRAN_WRAPPER(slasd1)
extern void slasd1(
    const ptrdiff_t *nl,
    const ptrdiff_t *nr,
    const ptrdiff_t *sqre,
    float  *d,
    float  *alpha,
    float  *beta,
    float  *u,
    const ptrdiff_t *ldu,
    float  *vt,
    const ptrdiff_t *ldvt,
    ptrdiff_t *idxq,
    ptrdiff_t *iwork,
    float  *work,
    ptrdiff_t *info
);

/* Source: slasd2.f */
#define slasd2 FORTRAN_WRAPPER(slasd2)
extern void slasd2(
    const ptrdiff_t *nl,
    const ptrdiff_t *nr,
    const ptrdiff_t *sqre,
    ptrdiff_t *k,
    float  *d,
    float  *z,
    const float  *alpha,
    const float  *beta,
    float  *u,
    const ptrdiff_t *ldu,
    float  *vt,
    const ptrdiff_t *ldvt,
    float  *dsigma,
    float  *u2,
    const ptrdiff_t *ldu2,
    float  *vt2,
    const ptrdiff_t *ldvt2,
    ptrdiff_t *idxp,
    ptrdiff_t *idx,
    ptrdiff_t *idxc,
    ptrdiff_t *idxq,
    ptrdiff_t *coltyp,
    ptrdiff_t *info
);

/* Source: slasd3.f */
#define slasd3 FORTRAN_WRAPPER(slasd3)
extern void slasd3(
    const ptrdiff_t *nl,
    const ptrdiff_t *nr,
    const ptrdiff_t *sqre,
    const ptrdiff_t *k,
    float  *d,
    float  *q,
    const ptrdiff_t *ldq,
    float  *dsigma,
    float  *u,
    const ptrdiff_t *ldu,
    const float  *u2,
    const ptrdiff_t *ldu2,
    float  *vt,
    const ptrdiff_t *ldvt,
    float  *vt2,
    const ptrdiff_t *ldvt2,
    const ptrdiff_t *idxc,
    const ptrdiff_t *ctot,
    float  *z,
    ptrdiff_t *info
);

/* Source: slasd4.f */
#define slasd4 FORTRAN_WRAPPER(slasd4)
extern void slasd4(
    const ptrdiff_t *n,
    const ptrdiff_t *i,
    const float  *d,
    const float  *z,
    float  *delta,
    const float  *rho,
    float  *sigma,
    float  *work,
    ptrdiff_t *info
);

/* Source: slasd5.f */
#define slasd5 FORTRAN_WRAPPER(slasd5)
extern void slasd5(
    const ptrdiff_t *i,
    const float  *d,
    const float  *z,
    float  *delta,
    const float  *rho,
    float  *dsigma,
    float  *work
);

/* Source: slasd6.f */
#define slasd6 FORTRAN_WRAPPER(slasd6)
extern void slasd6(
    const ptrdiff_t *icompq,
    const ptrdiff_t *nl,
    const ptrdiff_t *nr,
    const ptrdiff_t *sqre,
    float  *d,
    float  *vf,
    float  *vl,
    float  *alpha,
    float  *beta,
    ptrdiff_t *idxq,
    ptrdiff_t *perm,
    ptrdiff_t *givptr,
    ptrdiff_t *givcol,
    const ptrdiff_t *ldgcol,
    float  *givnum,
    const ptrdiff_t *ldgnum,
    float  *poles,
    float  *difl,
    float  *difr,
    float  *z,
    ptrdiff_t *k,
    float  *c,
    float  *s,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: slasd7.f */
#define slasd7 FORTRAN_WRAPPER(slasd7)
extern void slasd7(
    const ptrdiff_t *icompq,
    const ptrdiff_t *nl,
    const ptrdiff_t *nr,
    const ptrdiff_t *sqre,
    ptrdiff_t *k,
    float  *d,
    float  *z,
    float  *zw,
    float  *vf,
    float  *vfw,
    float  *vl,
    float  *vlw,
    const float  *alpha,
    const float  *beta,
    float  *dsigma,
    ptrdiff_t *idx,
    ptrdiff_t *idxp,
    const ptrdiff_t *idxq,
    ptrdiff_t *perm,
    ptrdiff_t *givptr,
    ptrdiff_t *givcol,
    const ptrdiff_t *ldgcol,
    float  *givnum,
    const ptrdiff_t *ldgnum,
    float  *c,
    float  *s,
    ptrdiff_t *info
);

/* Source: slasd8.f */
#define slasd8 FORTRAN_WRAPPER(slasd8)
extern void slasd8(
    const ptrdiff_t *icompq,
    const ptrdiff_t *k,
    float  *d,
    float  *z,
    float  *vf,
    float  *vl,
    float  *difl,
    float  *difr,
    const ptrdiff_t *lddifr,
    float  *dsigma,
    float  *work,
    ptrdiff_t *info
);

/* Source: slasda.f */
#define slasda FORTRAN_WRAPPER(slasda)
extern void slasda(
    const ptrdiff_t *icompq,
    const ptrdiff_t *smlsiz,
    const ptrdiff_t *n,
    const ptrdiff_t *sqre,
    float  *d,
    const float  *e,
    float  *u,
    const ptrdiff_t *ldu,
    float  *vt,
    ptrdiff_t *k,
    float  *difl,
    float  *difr,
    float  *z,
    float  *poles,
    ptrdiff_t *givptr,
    ptrdiff_t *givcol,
    const ptrdiff_t *ldgcol,
    ptrdiff_t *perm,
    float  *givnum,
    float  *c,
    float  *s,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: slasdq.f */
#define slasdq FORTRAN_WRAPPER(slasdq)
extern void slasdq(
    const char   *uplo,
    const ptrdiff_t *sqre,
    const ptrdiff_t *n,
    const ptrdiff_t *ncvt,
    const ptrdiff_t *nru,
    const ptrdiff_t *ncc,
    float  *d,
    float  *e,
    float  *vt,
    const ptrdiff_t *ldvt,
    float  *u,
    const ptrdiff_t *ldu,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: slasdt.f */
#define slasdt FORTRAN_WRAPPER(slasdt)
extern void slasdt(
    const ptrdiff_t *n,
    ptrdiff_t *lvl,
    ptrdiff_t *nd,
    ptrdiff_t *inode,
    ptrdiff_t *ndiml,
    ptrdiff_t *ndimr,
    const ptrdiff_t *msub
);

/* Source: slaset.f */
#define slaset FORTRAN_WRAPPER(slaset)
extern void slaset(
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *beta,
    float  *a,
    const ptrdiff_t *lda
);

/* Source: slasq1.f */
#define slasq1 FORTRAN_WRAPPER(slasq1)
extern void slasq1(
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    float  *work,
    ptrdiff_t *info
);

/* Source: slasq2.f */
#define slasq2 FORTRAN_WRAPPER(slasq2)
extern void slasq2(
    const ptrdiff_t *n,
    float  *z,
    ptrdiff_t *info
);

/* Source: slasq3.f */
#define slasq3 FORTRAN_WRAPPER(slasq3)
extern void slasq3(
    const ptrdiff_t *i0,
    const ptrdiff_t *n0,
    const float  *z,
    ptrdiff_t *pp,
    float  *dmin,
    float  *sigma,
    float  *desig,
    const float  *qmax,
    ptrdiff_t *nfail,
    ptrdiff_t *iter,
    ptrdiff_t *ndiv,
    const ptrdiff_t *ieee,
    ptrdiff_t *ttype,
    float  *dmin1,
    float  *dmin2,
    float  *dn,
    float  *dn1,
    float  *dn2,
    float  *g,
    float  *tau
);

/* Source: slasq4.f */
#define slasq4 FORTRAN_WRAPPER(slasq4)
extern void slasq4(
    const ptrdiff_t *i0,
    const ptrdiff_t *n0,
    const float  *z,
    const ptrdiff_t *pp,
    ptrdiff_t *n0in,
    const float  *dmin,
    const float  *dmin1,
    const float  *dmin2,
    const float  *dn,
    const float  *dn1,
    const float  *dn2,
    float  *tau,
    ptrdiff_t *ttype,
    float  *g
);

/* Source: slasq5.f */
#define slasq5 FORTRAN_WRAPPER(slasq5)
extern void slasq5(
    const ptrdiff_t *i0,
    const ptrdiff_t *n0,
    const float  *z,
    const ptrdiff_t *pp,
    const float  *tau,
    const float  *sigma,
    float  *dmin,
    float  *dmin1,
    float  *dmin2,
    float  *dn,
    float  *dnm1,
    float  *dnm2,
    const ptrdiff_t *ieee,
    const float  *eps
);

/* Source: slasq6.f */
#define slasq6 FORTRAN_WRAPPER(slasq6)
extern void slasq6(
    const ptrdiff_t *i0,
    const ptrdiff_t *n0,
    const float  *z,
    const ptrdiff_t *pp,
    float  *dmin,
    float  *dmin1,
    float  *dmin2,
    float  *dn,
    float  *dnm1,
    float  *dnm2
);

/* Source: slasr.f */
#define slasr FORTRAN_WRAPPER(slasr)
extern void slasr(
    const char   *side,
    const char   *pivot,
    const char   *direct,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *c,
    const float  *s,
    float  *a,
    const ptrdiff_t *lda
);

/* Source: slasrt.f */
#define slasrt FORTRAN_WRAPPER(slasrt)
extern void slasrt(
    const char   *id,
    const ptrdiff_t *n,
    float  *d,
    ptrdiff_t *info
);

/* Source: slassq.f */
#define slassq FORTRAN_WRAPPER(slassq)
extern void slassq(
    const ptrdiff_t *n,
    const float  *x,
    const ptrdiff_t *incx,
    float  *scale,
    float  *sumsq
);

/* Source: slasv2.f */
#define slasv2 FORTRAN_WRAPPER(slasv2)
extern void slasv2(
    const float  *f,
    const float  *g,
    const float  *h,
    float  *ssmin,
    float  *ssmax,
    float  *snr,
    float  *csr,
    float  *snl,
    float  *csl
);

/* Source: slaswp.f */
#define slaswp FORTRAN_WRAPPER(slaswp)
extern void slaswp(
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *k1,
    const ptrdiff_t *k2,
    const ptrdiff_t *ipiv,
    const ptrdiff_t *incx
);

/* Source: slasy2.f */
#define slasy2 FORTRAN_WRAPPER(slasy2)
extern void slasy2(
    const ptrdiff_t *ltranl,
    const ptrdiff_t *ltranr,
    const ptrdiff_t *isgn,
    const ptrdiff_t *n1,
    const ptrdiff_t *n2,
    const float  *tl,
    const ptrdiff_t *ldtl,
    const float  *tr,
    const ptrdiff_t *ldtr,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *scale,
    float  *x,
    const ptrdiff_t *ldx,
    float  *xnorm,
    ptrdiff_t *info
);

/* Source: slasyf.f */
#define slasyf FORTRAN_WRAPPER(slasyf)
extern void slasyf(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    ptrdiff_t *kb,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    float  *w,
    const ptrdiff_t *ldw,
    ptrdiff_t *info
);

/* Source: slatbs.f */
#define slatbs FORTRAN_WRAPPER(slatbs)
extern void slatbs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const char   *normin,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *x,
    float  *scale,
    float  *cnorm,
    ptrdiff_t *info
);

/* Source: slatdf.f */
#define slatdf FORTRAN_WRAPPER(slatdf)
extern void slatdf(
    const ptrdiff_t *ijob,
    const ptrdiff_t *n,
    const float  *z,
    const ptrdiff_t *ldz,
    float  *rhs,
    float  *rdsum,
    float  *rdscal,
    const ptrdiff_t *ipiv,
    const ptrdiff_t *jpiv
);

/* Source: slatps.f */
#define slatps FORTRAN_WRAPPER(slatps)
extern void slatps(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const char   *normin,
    const ptrdiff_t *n,
    const float  *ap,
    float  *x,
    float  *scale,
    float  *cnorm,
    ptrdiff_t *info
);

/* Source: slatrd.f */
#define slatrd FORTRAN_WRAPPER(slatrd)
extern void slatrd(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    float  *a,
    const ptrdiff_t *lda,
    float  *e,
    float  *tau,
    float  *w,
    const ptrdiff_t *ldw
);

/* Source: slatrs.f */
#define slatrs FORTRAN_WRAPPER(slatrs)
extern void slatrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const char   *normin,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *x,
    float  *scale,
    float  *cnorm,
    ptrdiff_t *info
);

/* Source: slatrz.f */
#define slatrz FORTRAN_WRAPPER(slatrz)
extern void slatrz(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work
);

/* Source: slatzm.f */
#define slatzm FORTRAN_WRAPPER(slatzm)
extern void slatzm(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *v,
    const ptrdiff_t *incv,
    const float  *tau,
    float  *c1,
    float  *c2,
    const ptrdiff_t *ldc,
    float  *work
);

/* Source: slauu2.f */
#define slauu2 FORTRAN_WRAPPER(slauu2)
extern void slauu2(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: slauum.f */
#define slauum FORTRAN_WRAPPER(slauum)
extern void slauum(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: sopgtr.f */
#define sopgtr FORTRAN_WRAPPER(sopgtr)
extern void sopgtr(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    const float  *tau,
    float  *q,
    const ptrdiff_t *ldq,
    float  *work,
    ptrdiff_t *info
);

/* Source: sopmtr.f */
#define sopmtr FORTRAN_WRAPPER(sopmtr)
extern void sopmtr(
    const char   *side,
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *ap,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: sorbdb.f */
#define sorbdb FORTRAN_WRAPPER(sorbdb)
extern void sorbdb(
    const char   *trans,
    const char   *signs,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *q,
    float  *x11,
    const ptrdiff_t *ldx11,
    float  *x12,
    const ptrdiff_t *ldx12,
    float  *x21,
    const ptrdiff_t *ldx21,
    float  *x22,
    const ptrdiff_t *ldx22,
    float  *theta,
    float  *phi,
    float  *taup1,
    float  *taup2,
    float  *tauq1,
    float  *tauq2,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sorcsd.f */
#define sorcsd FORTRAN_WRAPPER(sorcsd)
extern void sorcsd(
    const char   *jobu1,
    const char   *jobu2,
    const char   *jobv1t,
    const char   *jobv2t,
    const char   *trans,
    const char   *signs,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *q,
    float  *x11,
    const ptrdiff_t *ldx11,
    float  *x12,
    const ptrdiff_t *ldx12,
    float  *x21,
    const ptrdiff_t *ldx21,
    float  *x22,
    const ptrdiff_t *ldx22,
    float  *theta,
    float  *u1,
    const ptrdiff_t *ldu1,
    float  *u2,
    const ptrdiff_t *ldu2,
    float  *v1t,
    const ptrdiff_t *ldv1t,
    float  *v2t,
    const ptrdiff_t *ldv2t,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sorg2l.f */
#define sorg2l FORTRAN_WRAPPER(sorg2l)
extern void sorg2l(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: sorg2r.f */
#define sorg2r FORTRAN_WRAPPER(sorg2r)
extern void sorg2r(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: sorgbr.f */
#define sorgbr FORTRAN_WRAPPER(sorgbr)
extern void sorgbr(
    const char   *vect,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sorghr.f */
#define sorghr FORTRAN_WRAPPER(sorghr)
extern void sorghr(
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sorgl2.f */
#define sorgl2 FORTRAN_WRAPPER(sorgl2)
extern void sorgl2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: sorglq.f */
#define sorglq FORTRAN_WRAPPER(sorglq)
extern void sorglq(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sorgql.f */
#define sorgql FORTRAN_WRAPPER(sorgql)
extern void sorgql(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sorgqr.f */
#define sorgqr FORTRAN_WRAPPER(sorgqr)
extern void sorgqr(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sorgr2.f */
#define sorgr2 FORTRAN_WRAPPER(sorgr2)
extern void sorgr2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    ptrdiff_t *info
);

/* Source: sorgrq.f */
#define sorgrq FORTRAN_WRAPPER(sorgrq)
extern void sorgrq(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sorgtr.f */
#define sorgtr FORTRAN_WRAPPER(sorgtr)
extern void sorgtr(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sorm2l.f */
#define sorm2l FORTRAN_WRAPPER(sorm2l)
extern void sorm2l(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: sorm2r.f */
#define sorm2r FORTRAN_WRAPPER(sorm2r)
extern void sorm2r(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: sormbr.f */
#define sormbr FORTRAN_WRAPPER(sormbr)
extern void sormbr(
    const char   *vect,
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sormhr.f */
#define sormhr FORTRAN_WRAPPER(sormhr)
extern void sormhr(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sorml2.f */
#define sorml2 FORTRAN_WRAPPER(sorml2)
extern void sorml2(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: sormlq.f */
#define sormlq FORTRAN_WRAPPER(sormlq)
extern void sormlq(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sormql.f */
#define sormql FORTRAN_WRAPPER(sormql)
extern void sormql(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sormqr.f */
#define sormqr FORTRAN_WRAPPER(sormqr)
extern void sormqr(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sormr2.f */
#define sormr2 FORTRAN_WRAPPER(sormr2)
extern void sormr2(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: sormr3.f */
#define sormr3 FORTRAN_WRAPPER(sormr3)
extern void sormr3(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    ptrdiff_t *info
);

/* Source: sormrq.f */
#define sormrq FORTRAN_WRAPPER(sormrq)
extern void sormrq(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sormrz.f */
#define sormrz FORTRAN_WRAPPER(sormrz)
extern void sormrz(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: sormtr.f */
#define sormtr FORTRAN_WRAPPER(sormtr)
extern void sormtr(
    const char   *side,
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *tau,
    float  *c,
    const ptrdiff_t *ldc,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: spbcon.f */
#define spbcon FORTRAN_WRAPPER(spbcon)
extern void spbcon(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const float  *ab,
    const ptrdiff_t *ldab,
    const float  *anorm,
    float  *rcond,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: spbequ.f */
#define spbequ FORTRAN_WRAPPER(spbequ)
extern void spbequ(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *s,
    float  *scond,
    float  *amax,
    ptrdiff_t *info
);

/* Source: spbrfs.f */
#define spbrfs FORTRAN_WRAPPER(spbrfs)
extern void spbrfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const float  *ab,
    const ptrdiff_t *ldab,
    const float  *afb,
    const ptrdiff_t *ldafb,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: spbstf.f */
#define spbstf FORTRAN_WRAPPER(spbstf)
extern void spbstf(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *info
);

/* Source: spbsv.f */
#define spbsv FORTRAN_WRAPPER(spbsv)
extern void spbsv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: spbsvx.f */
#define spbsvx FORTRAN_WRAPPER(spbsvx)
extern void spbsvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *afb,
    const ptrdiff_t *ldafb,
    char   *equed,
    float  *s,
    float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: spbtf2.f */
#define spbtf2 FORTRAN_WRAPPER(spbtf2)
extern void spbtf2(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *info
);

/* Source: spbtrf.f */
#define spbtrf FORTRAN_WRAPPER(spbtrf)
extern void spbtrf(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *info
);

/* Source: spbtrs.f */
#define spbtrs FORTRAN_WRAPPER(spbtrs)
extern void spbtrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: spftrf.f */
#define spftrf FORTRAN_WRAPPER(spftrf)
extern void spftrf(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    ptrdiff_t *info
);

/* Source: spftri.f */
#define spftri FORTRAN_WRAPPER(spftri)
extern void spftri(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    ptrdiff_t *info
);

/* Source: spftrs.f */
#define spftrs FORTRAN_WRAPPER(spftrs)
extern void spftrs(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: spocon.f */
#define spocon FORTRAN_WRAPPER(spocon)
extern void spocon(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *anorm,
    float  *rcond,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: spoequ.f */
#define spoequ FORTRAN_WRAPPER(spoequ)
extern void spoequ(
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *s,
    float  *scond,
    float  *amax,
    ptrdiff_t *info
);

/* Source: spoequb.f */
#define spoequb FORTRAN_WRAPPER(spoequb)
extern void spoequb(
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *s,
    float  *scond,
    float  *amax,
    ptrdiff_t *info
);

/* Source: sporfs.f */
#define sporfs FORTRAN_WRAPPER(sporfs)
extern void sporfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *af,
    const ptrdiff_t *ldaf,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sposv.f */
#define sposv FORTRAN_WRAPPER(sposv)
extern void sposv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: sposvx.f */
#define sposvx FORTRAN_WRAPPER(sposvx)
extern void sposvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    float  *af,
    const ptrdiff_t *ldaf,
    char   *equed,
    float  *s,
    float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: spotf2.f */
#define spotf2 FORTRAN_WRAPPER(spotf2)
extern void spotf2(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: spotrf.f */
#define spotrf FORTRAN_WRAPPER(spotrf)
extern void spotrf(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: spotri.f */
#define spotri FORTRAN_WRAPPER(spotri)
extern void spotri(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: spotrs.f */
#define spotrs FORTRAN_WRAPPER(spotrs)
extern void spotrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: sppcon.f */
#define sppcon FORTRAN_WRAPPER(sppcon)
extern void sppcon(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    const float  *anorm,
    float  *rcond,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sppequ.f */
#define sppequ FORTRAN_WRAPPER(sppequ)
extern void sppequ(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    float  *s,
    float  *scond,
    float  *amax,
    ptrdiff_t *info
);

/* Source: spprfs.f */
#define spprfs FORTRAN_WRAPPER(spprfs)
extern void spprfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    const float  *afp,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sppsv.f */
#define sppsv FORTRAN_WRAPPER(sppsv)
extern void sppsv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *ap,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: sppsvx.f */
#define sppsvx FORTRAN_WRAPPER(sppsvx)
extern void sppsvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *ap,
    float  *afp,
    char   *equed,
    float  *s,
    float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: spptrf.f */
#define spptrf FORTRAN_WRAPPER(spptrf)
extern void spptrf(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    ptrdiff_t *info
);

/* Source: spptri.f */
#define spptri FORTRAN_WRAPPER(spptri)
extern void spptri(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    ptrdiff_t *info
);

/* Source: spptrs.f */
#define spptrs FORTRAN_WRAPPER(spptrs)
extern void spptrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: spstf2.f */
#define spstf2 FORTRAN_WRAPPER(spstf2)
extern void spstf2(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *piv,
    ptrdiff_t *rank,
    const float  *tol,
    float  *work,
    ptrdiff_t *info
);

/* Source: spstrf.f */
#define spstrf FORTRAN_WRAPPER(spstrf)
extern void spstrf(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *piv,
    ptrdiff_t *rank,
    const float  *tol,
    float  *work,
    ptrdiff_t *info
);

/* Source: sptcon.f */
#define sptcon FORTRAN_WRAPPER(sptcon)
extern void sptcon(
    const ptrdiff_t *n,
    const float  *d,
    const float  *e,
    const float  *anorm,
    float  *rcond,
    float  *work,
    ptrdiff_t *info
);

/* Source: spteqr.f */
#define spteqr FORTRAN_WRAPPER(spteqr)
extern void spteqr(
    const char   *compz,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *info
);

/* Source: sptrfs.f */
#define sptrfs FORTRAN_WRAPPER(sptrfs)
extern void sptrfs(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *d,
    const float  *e,
    const float  *df,
    const float  *ef,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *info
);

/* Source: sptsv.f */
#define sptsv FORTRAN_WRAPPER(sptsv)
extern void sptsv(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *d,
    float  *e,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: sptsvx.f */
#define sptsvx FORTRAN_WRAPPER(sptsvx)
extern void sptsvx(
    const char   *fact,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *d,
    const float  *e,
    float  *df,
    float  *ef,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *info
);

/* Source: spttrf.f */
#define spttrf FORTRAN_WRAPPER(spttrf)
extern void spttrf(
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    ptrdiff_t *info
);

/* Source: spttrs.f */
#define spttrs FORTRAN_WRAPPER(spttrs)
extern void spttrs(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *d,
    const float  *e,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: sptts2.f */
#define sptts2 FORTRAN_WRAPPER(sptts2)
extern void sptts2(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *d,
    const float  *e,
    float  *b,
    const ptrdiff_t *ldb
);

/* Source: srscl.f */
#define srscl FORTRAN_WRAPPER(srscl)
extern void srscl(
    const ptrdiff_t *n,
    const float  *sa,
    float  *sx,
    const ptrdiff_t *incx
);

/* Source: ssbev.f */
#define ssbev FORTRAN_WRAPPER(ssbev)
extern void ssbev(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *info
);

/* Source: ssbevd.f */
#define ssbevd FORTRAN_WRAPPER(ssbevd)
extern void ssbevd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: ssbevx.f */
#define ssbevx FORTRAN_WRAPPER(ssbevx)
extern void ssbevx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *q,
    const ptrdiff_t *ldq,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: ssbgst.f */
#define ssbgst FORTRAN_WRAPPER(ssbgst)
extern void ssbgst(
    const char   *vect,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    float  *ab,
    const ptrdiff_t *ldab,
    const float  *bb,
    const ptrdiff_t *ldbb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *work,
    ptrdiff_t *info
);

/* Source: ssbgv.f */
#define ssbgv FORTRAN_WRAPPER(ssbgv)
extern void ssbgv(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *bb,
    const ptrdiff_t *ldbb,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *info
);

/* Source: ssbgvd.f */
#define ssbgvd FORTRAN_WRAPPER(ssbgvd)
extern void ssbgvd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *bb,
    const ptrdiff_t *ldbb,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: ssbgvx.f */
#define ssbgvx FORTRAN_WRAPPER(ssbgvx)
extern void ssbgvx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *bb,
    const ptrdiff_t *ldbb,
    float  *q,
    const ptrdiff_t *ldq,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: ssbtrd.f */
#define ssbtrd FORTRAN_WRAPPER(ssbtrd)
extern void ssbtrd(
    const char   *vect,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    float  *ab,
    const ptrdiff_t *ldab,
    float  *d,
    float  *e,
    float  *q,
    const ptrdiff_t *ldq,
    float  *work,
    ptrdiff_t *info
);

/* Source: ssfrk.f */
#define ssfrk FORTRAN_WRAPPER(ssfrk)
extern void ssfrk(
    const char   *transr,
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *beta,
    float  *c
);

/* Source: sspcon.f */
#define sspcon FORTRAN_WRAPPER(sspcon)
extern void sspcon(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    const ptrdiff_t *ipiv,
    const float  *anorm,
    float  *rcond,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sspev.f */
#define sspev FORTRAN_WRAPPER(sspev)
extern void sspev(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *info
);

/* Source: sspevd.f */
#define sspevd FORTRAN_WRAPPER(sspevd)
extern void sspevd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: sspevx.f */
#define sspevx FORTRAN_WRAPPER(sspevx)
extern void sspevx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: sspgst.f */
#define sspgst FORTRAN_WRAPPER(sspgst)
extern void sspgst(
    const ptrdiff_t *itype,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    const float  *bp,
    ptrdiff_t *info
);

/* Source: sspgv.f */
#define sspgv FORTRAN_WRAPPER(sspgv)
extern void sspgv(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    float  *bp,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *info
);

/* Source: sspgvd.f */
#define sspgvd FORTRAN_WRAPPER(sspgvd)
extern void sspgvd(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    float  *bp,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: sspgvx.f */
#define sspgvx FORTRAN_WRAPPER(sspgvx)
extern void sspgvx(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    float  *bp,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: ssprfs.f */
#define ssprfs FORTRAN_WRAPPER(ssprfs)
extern void ssprfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    const float  *afp,
    const ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sspsv.f */
#define sspsv FORTRAN_WRAPPER(sspsv)
extern void sspsv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *ap,
    ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: sspsvx.f */
#define sspsvx FORTRAN_WRAPPER(sspsvx)
extern void sspsvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    float  *afp,
    ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: ssptrd.f */
#define ssptrd FORTRAN_WRAPPER(ssptrd)
extern void ssptrd(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    float  *d,
    float  *e,
    float  *tau,
    ptrdiff_t *info
);

/* Source: ssptrf.f */
#define ssptrf FORTRAN_WRAPPER(ssptrf)
extern void ssptrf(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: ssptri.f */
#define ssptri FORTRAN_WRAPPER(ssptri)
extern void ssptri(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *ap,
    const ptrdiff_t *ipiv,
    float  *work,
    ptrdiff_t *info
);

/* Source: ssptrs.f */
#define ssptrs FORTRAN_WRAPPER(ssptrs)
extern void ssptrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: sstebz.f */
#define sstebz FORTRAN_WRAPPER(sstebz)
extern void sstebz(
    const char   *range,
    const char   *order,
    const ptrdiff_t *n,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    const float  *d,
    const float  *e,
    ptrdiff_t *m,
    ptrdiff_t *nsplit,
    float  *w,
    ptrdiff_t *iblock,
    ptrdiff_t *isplit,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: sstedc.f */
#define sstedc FORTRAN_WRAPPER(sstedc)
extern void sstedc(
    const char   *compz,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: sstegr.f */
#define sstegr FORTRAN_WRAPPER(sstegr)
extern void sstegr(
    const char   *jobz,
    const char   *range,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *isuppz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: sstein.f */
#define sstein FORTRAN_WRAPPER(sstein)
extern void sstein(
    const ptrdiff_t *n,
    const float  *d,
    const float  *e,
    const ptrdiff_t *m,
    const float  *w,
    const ptrdiff_t *iblock,
    const ptrdiff_t *isplit,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: sstemr.f */
#define sstemr FORTRAN_WRAPPER(sstemr)
extern void sstemr(
    const char   *jobz,
    const char   *range,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    const ptrdiff_t *nzc,
    ptrdiff_t *isuppz,
    ptrdiff_t *tryrac,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: ssteqr.f */
#define ssteqr FORTRAN_WRAPPER(ssteqr)
extern void ssteqr(
    const char   *compz,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *info
);

/* Source: ssterf.f */
#define ssterf FORTRAN_WRAPPER(ssterf)
extern void ssterf(
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    ptrdiff_t *info
);

/* Source: sstev.f */
#define sstev FORTRAN_WRAPPER(sstev)
extern void sstev(
    const char   *jobz,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *info
);

/* Source: sstevd.f */
#define sstevd FORTRAN_WRAPPER(sstevd)
extern void sstevd(
    const char   *jobz,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: sstevr.f */
#define sstevr FORTRAN_WRAPPER(sstevr)
extern void sstevr(
    const char   *jobz,
    const char   *range,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *isuppz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: sstevx.f */
#define sstevx FORTRAN_WRAPPER(sstevx)
extern void sstevx(
    const char   *jobz,
    const char   *range,
    const ptrdiff_t *n,
    float  *d,
    float  *e,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: ssycon.f */
#define ssycon FORTRAN_WRAPPER(ssycon)
extern void ssycon(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    const float  *anorm,
    float  *rcond,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: ssyconv.f */
#define ssyconv FORTRAN_WRAPPER(ssyconv)
extern void ssyconv(
    const char   *uplo,
    const char   *way,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *work,
    ptrdiff_t *info
);

/* Source: ssyequb.f */
#define ssyequb FORTRAN_WRAPPER(ssyequb)
extern void ssyequb(
    char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *s,
    float  *scond,
    float  *amax,
    float  *work,
    ptrdiff_t *info
);

/* Source: ssyev.f */
#define ssyev FORTRAN_WRAPPER(ssyev)
extern void ssyev(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *w,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: ssyevd.f */
#define ssyevd FORTRAN_WRAPPER(ssyevd)
extern void ssyevd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *w,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: ssyevr.f */
#define ssyevr FORTRAN_WRAPPER(ssyevr)
extern void ssyevr(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *isuppz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: ssyevx.f */
#define ssyevx FORTRAN_WRAPPER(ssyevx)
extern void ssyevx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: ssygs2.f */
#define ssygs2 FORTRAN_WRAPPER(ssygs2)
extern void ssygs2(
    const ptrdiff_t *itype,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: ssygst.f */
#define ssygst FORTRAN_WRAPPER(ssygst)
extern void ssygst(
    const ptrdiff_t *itype,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: ssygv.f */
#define ssygv FORTRAN_WRAPPER(ssygv)
extern void ssygv(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *w,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: ssygvd.f */
#define ssygvd FORTRAN_WRAPPER(ssygvd)
extern void ssygvd(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *w,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: ssygvx.f */
#define ssygvx FORTRAN_WRAPPER(ssygvx)
extern void ssygvx(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    const float  *vl,
    const float  *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const float  *abstol,
    ptrdiff_t *m,
    float  *w,
    float  *z,
    const ptrdiff_t *ldz,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: ssyrfs.f */
#define ssyrfs FORTRAN_WRAPPER(ssyrfs)
extern void ssyrfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *af,
    const ptrdiff_t *ldaf,
    const ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: ssysv.f */
#define ssysv FORTRAN_WRAPPER(ssysv)
extern void ssysv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: ssysvx.f */
#define ssysvx FORTRAN_WRAPPER(ssysvx)
extern void ssysvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    float  *af,
    const ptrdiff_t *ldaf,
    ptrdiff_t *ipiv,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *x,
    const ptrdiff_t *ldx,
    float  *rcond,
    float  *ferr,
    float  *berr,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: ssyswapr.f */
#define ssyswapr FORTRAN_WRAPPER(ssyswapr)
extern void ssyswapr(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *i1,
    const ptrdiff_t *i2
);

/* Source: ssytd2.f */
#define ssytd2 FORTRAN_WRAPPER(ssytd2)
extern void ssytd2(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *d,
    float  *e,
    float  *tau,
    ptrdiff_t *info
);

/* Source: ssytf2.f */
#define ssytf2 FORTRAN_WRAPPER(ssytf2)
extern void ssytf2(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: ssytrd.f */
#define ssytrd FORTRAN_WRAPPER(ssytrd)
extern void ssytrd(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *d,
    float  *e,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: ssytrf.f */
#define ssytrf FORTRAN_WRAPPER(ssytrf)
extern void ssytrf(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: ssytri.f */
#define ssytri FORTRAN_WRAPPER(ssytri)
extern void ssytri(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *work,
    ptrdiff_t *info
);

/* Source: ssytri2.f */
#define ssytri2 FORTRAN_WRAPPER(ssytri2)
extern void ssytri2(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: ssytri2x.f */
#define ssytri2x FORTRAN_WRAPPER(ssytri2x)
extern void ssytri2x(
    const char   *uplo,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *work,
    ptrdiff_t *nb,
    ptrdiff_t *info
);

/* Source: ssytrs.f */
#define ssytrs FORTRAN_WRAPPER(ssytrs)
extern void ssytrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: ssytrs2.f */
#define ssytrs2 FORTRAN_WRAPPER(ssytrs2)
extern void ssytrs2(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    float  *b,
    const ptrdiff_t *ldb,
    float  *work,
    ptrdiff_t *info
);

/* Source: stbcon.f */
#define stbcon FORTRAN_WRAPPER(stbcon)
extern void stbcon(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *rcond,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: stbrfs.f */
#define stbrfs FORTRAN_WRAPPER(stbrfs)
extern void stbrfs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const float  *ab,
    const ptrdiff_t *ldab,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: stbtrs.f */
#define stbtrs FORTRAN_WRAPPER(stbtrs)
extern void stbtrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const float  *ab,
    const ptrdiff_t *ldab,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: stfsm.f */
#define stfsm FORTRAN_WRAPPER(stfsm)
extern void stfsm(
    const char   *transr,
    const char   *side,
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *a,
    float  *b,
    const ptrdiff_t *ldb
);

/* Source: stftri.f */
#define stftri FORTRAN_WRAPPER(stftri)
extern void stftri(
    const char   *transr,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    float  *a,
    ptrdiff_t *info
);

/* Source: stfttp.f */
#define stfttp FORTRAN_WRAPPER(stfttp)
extern void stfttp(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *arf,
    float  *ap,
    ptrdiff_t *info
);

/* Source: stfttr.f */
#define stfttr FORTRAN_WRAPPER(stfttr)
extern void stfttr(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *arf,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: stgevc.f */
#define stgevc FORTRAN_WRAPPER(stgevc)
extern void stgevc(
    const char   *side,
    const char   *howmny,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    const float  *s,
    const ptrdiff_t *lds,
    const float  *p,
    const ptrdiff_t *ldp,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    float  *work,
    ptrdiff_t *info
);

/* Source: stgex2.f */
#define stgex2 FORTRAN_WRAPPER(stgex2)
extern void stgex2(
    const ptrdiff_t *wantq,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *q,
    const ptrdiff_t *ldq,
    float  *z,
    const ptrdiff_t *ldz,
    const ptrdiff_t *j1_,
    const ptrdiff_t *n1,
    const ptrdiff_t *n2,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: stgexc.f */
#define stgexc FORTRAN_WRAPPER(stgexc)
extern void stgexc(
    const ptrdiff_t *wantq,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *q,
    const ptrdiff_t *ldq,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *ifst,
    ptrdiff_t *ilst,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: stgsen.f */
#define stgsen FORTRAN_WRAPPER(stgsen)
extern void stgsen(
    const ptrdiff_t *ijob,
    const ptrdiff_t *wantq,
    const ptrdiff_t *wantz,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *alphar,
    float  *alphai,
    float  *beta,
    float  *q,
    const ptrdiff_t *ldq,
    float  *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *m,
    float  *pl,
    float  *pr,
    float  *dif,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: stgsja.f */
#define stgsja FORTRAN_WRAPPER(stgsja)
extern void stgsja(
    const char   *jobu,
    const char   *jobv,
    const char   *jobq,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    const float  *tola,
    const float  *tolb,
    float  *alpha,
    float  *beta,
    float  *u,
    const ptrdiff_t *ldu,
    float  *v,
    const ptrdiff_t *ldv,
    float  *q,
    const ptrdiff_t *ldq,
    float  *work,
    ptrdiff_t *ncycle,
    ptrdiff_t *info
);

/* Source: stgsna.f */
#define stgsna FORTRAN_WRAPPER(stgsna)
extern void stgsna(
    const char   *job,
    const char   *howmny,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *vl,
    const ptrdiff_t *ldvl,
    const float  *vr,
    const ptrdiff_t *ldvr,
    float  *s,
    float  *dif,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: stgsy2.f */
#define stgsy2 FORTRAN_WRAPPER(stgsy2)
extern void stgsy2(
    const char   *trans,
    const ptrdiff_t *ijob,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *c,
    const ptrdiff_t *ldc,
    const float  *d,
    const ptrdiff_t *ldd,
    const float  *e,
    const ptrdiff_t *lde,
    float  *f,
    const ptrdiff_t *ldf,
    float  *scale,
    float  *rdsum,
    float  *rdscal,
    ptrdiff_t *iwork,
    ptrdiff_t *pq,
    ptrdiff_t *info
);

/* Source: stgsyl.f */
#define stgsyl FORTRAN_WRAPPER(stgsyl)
extern void stgsyl(
    const char   *trans,
    const ptrdiff_t *ijob,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *c,
    const ptrdiff_t *ldc,
    const float  *d,
    const ptrdiff_t *ldd,
    const float  *e,
    const ptrdiff_t *lde,
    float  *f,
    const ptrdiff_t *ldf,
    float  *scale,
    float  *dif,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: stpcon.f */
#define stpcon FORTRAN_WRAPPER(stpcon)
extern void stpcon(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const float  *ap,
    float  *rcond,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: stpmqrt.f */
#define stpmqrt FORTRAN_WRAPPER(stpmqrt)
extern void stpmqrt(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const ptrdiff_t *nb,
    const float  *v,
    const ptrdiff_t *ldv,
    const float  *t,
    const ptrdiff_t *ldt,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *work,
    ptrdiff_t *info
);

/* Source: stpqrt.f */
#define stpqrt FORTRAN_WRAPPER(stpqrt)
extern void stpqrt(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    const ptrdiff_t *nb,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *t,
    const ptrdiff_t *ldt,
    const float  *work,
    ptrdiff_t *info
);

/* Source: stpqrt2.f */
#define stpqrt2 FORTRAN_WRAPPER(stpqrt2)
extern void stpqrt2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *t,
    const ptrdiff_t *ldt,
    ptrdiff_t *info
);

/* Source: stprfb.f */
#define stprfb FORTRAN_WRAPPER(stprfb)
extern void stprfb(
    const char   *side,
    const char   *trans,
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const float  *v,
    const ptrdiff_t *ldv,
    const float  *t,
    const ptrdiff_t *ldt,
    float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    float  *work,
    const ptrdiff_t *ldwork
);

/* Source: stprfs.f */
#define stprfs FORTRAN_WRAPPER(stprfs)
extern void stprfs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: stptri.f */
#define stptri FORTRAN_WRAPPER(stptri)
extern void stptri(
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    float  *ap,
    ptrdiff_t *info
);

/* Source: stptrs.f */
#define stptrs FORTRAN_WRAPPER(stptrs)
extern void stptrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *ap,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: stpttf.f */
#define stpttf FORTRAN_WRAPPER(stpttf)
extern void stpttf(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    float  *arf,
    ptrdiff_t *info
);

/* Source: stpttr.f */
#define stpttr FORTRAN_WRAPPER(stpttr)
extern void stpttr(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *ap,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: strcon.f */
#define strcon FORTRAN_WRAPPER(strcon)
extern void strcon(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *rcond,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: strevc.f */
#define strevc FORTRAN_WRAPPER(strevc)
extern void strevc(
    const char   *side,
    const char   *howmny,
    ptrdiff_t *select,
    const ptrdiff_t *n,
    const float  *t,
    const ptrdiff_t *ldt,
    float  *vl,
    const ptrdiff_t *ldvl,
    float  *vr,
    const ptrdiff_t *ldvr,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    float  *work,
    ptrdiff_t *info
);

/* Source: strexc.f */
#define strexc FORTRAN_WRAPPER(strexc)
extern void strexc(
    const char   *compq,
    const ptrdiff_t *n,
    float  *t,
    const ptrdiff_t *ldt,
    float  *q,
    const ptrdiff_t *ldq,
    ptrdiff_t *ifst,
    ptrdiff_t *ilst,
    float  *work,
    ptrdiff_t *info
);

/* Source: strrfs.f */
#define strrfs FORTRAN_WRAPPER(strrfs)
extern void strrfs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *x,
    const ptrdiff_t *ldx,
    float  *ferr,
    float  *berr,
    float  *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: strsen.f */
#define strsen FORTRAN_WRAPPER(strsen)
extern void strsen(
    const char   *job,
    const char   *compq,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    float  *t,
    const ptrdiff_t *ldt,
    float  *q,
    const ptrdiff_t *ldq,
    float  *wr,
    float  *wi,
    ptrdiff_t *m,
    float  *s,
    float  *sep,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: strsna.f */
#define strsna FORTRAN_WRAPPER(strsna)
extern void strsna(
    const char   *job,
    const char   *howmny,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    const float  *t,
    const ptrdiff_t *ldt,
    const float  *vl,
    const ptrdiff_t *ldvl,
    const float  *vr,
    const ptrdiff_t *ldvr,
    float  *s,
    float  *sep,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    float  *work,
    const ptrdiff_t *ldwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: strsyl.f */
#define strsyl FORTRAN_WRAPPER(strsyl)
extern void strsyl(
    const char   *trana,
    const char   *tranb,
    const ptrdiff_t *isgn,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    float  *c,
    const ptrdiff_t *ldc,
    float  *scale,
    ptrdiff_t *info
);

/* Source: strti2.f */
#define strti2 FORTRAN_WRAPPER(strti2)
extern void strti2(
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: strtri.f */
#define strtri FORTRAN_WRAPPER(strtri)
extern void strtri(
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: strtrs.f */
#define strtrs FORTRAN_WRAPPER(strtrs)
extern void strtrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: strttf.f */
#define strttf FORTRAN_WRAPPER(strttf)
extern void strttf(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *arf,
    ptrdiff_t *info
);

/* Source: strttp.f */
#define strttp FORTRAN_WRAPPER(strttp)
extern void strttp(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *ap,
    ptrdiff_t *info
);

/* Source: stzrqf.f */
#define stzrqf FORTRAN_WRAPPER(stzrqf)
extern void stzrqf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    ptrdiff_t *info
);

/* Source: stzrzf.f */
#define stzrzf FORTRAN_WRAPPER(stzrzf)
extern void stzrzf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    float  *a,
    const ptrdiff_t *lda,
    float  *tau,
    float  *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: xerbla_array.f */
#define xerbla_array FORTRAN_WRAPPER(xerbla_array)
extern void xerbla_array(
    const char   *srname_array,
    const ptrdiff_t *srname_len,
    const ptrdiff_t *info
);

/* Source: zbbcsd.f */
#define zbbcsd FORTRAN_WRAPPER(zbbcsd)
extern void zbbcsd(
    const char   *jobu1,
    const char   *jobu2,
    const char   *jobv1t,
    const char   *jobv2t,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *q,
    double *theta,
    double *phi,
    double *u1,
    const ptrdiff_t *ldu1,
    double *u2,
    const ptrdiff_t *ldu2,
    double *v1t,
    const ptrdiff_t *ldv1t,
    double *v2t,
    const ptrdiff_t *ldv2t,
    double *b11d,
    double *b11e,
    double *b12d,
    double *b12e,
    double *b21d,
    double *b21e,
    double *b22d,
    double *b22e,
    double *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *info
);

/* Source: zbdsqr.f */
#define zbdsqr FORTRAN_WRAPPER(zbdsqr)
extern void zbdsqr(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ncvt,
    const ptrdiff_t *nru,
    const ptrdiff_t *ncc,
    double *d,
    double *e,
    double *vt,
    const ptrdiff_t *ldvt,
    double *u,
    const ptrdiff_t *ldu,
    double *c,
    const ptrdiff_t *ldc,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zcgesv.f */
#define zcgesv FORTRAN_WRAPPER(zcgesv)
extern void zcgesv(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *work,
    float  *swork,
    double *rwork,
    ptrdiff_t *iter,
    ptrdiff_t *info
);

/* Source: zcposv.f */
#define zcposv FORTRAN_WRAPPER(zcposv)
extern void zcposv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *work,
    float  *swork,
    double *rwork,
    ptrdiff_t *iter,
    ptrdiff_t *info
);

/* Source: zdrscl.f */
#define zdrscl FORTRAN_WRAPPER(zdrscl)
extern void zdrscl(
    const ptrdiff_t *n,
    const double *sa,
    double *sx,
    const ptrdiff_t *incx
);

/* Source: zgbbrd.f */
#define zgbbrd FORTRAN_WRAPPER(zgbbrd)
extern void zgbbrd(
    const char   *vect,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *ncc,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    double *ab,
    const ptrdiff_t *ldab,
    double *d,
    double *e,
    double *q,
    const ptrdiff_t *ldq,
    double *pt,
    const ptrdiff_t *ldpt,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgbcon.f */
#define zgbcon FORTRAN_WRAPPER(zgbcon)
extern void zgbcon(
    const char   *norm,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const double *ab,
    const ptrdiff_t *ldab,
    const ptrdiff_t *ipiv,
    const double *anorm,
    double *rcond,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgbequ.f */
#define zgbequ FORTRAN_WRAPPER(zgbequ)
extern void zgbequ(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const double *ab,
    const ptrdiff_t *ldab,
    double *r,
    double *c,
    double *rowcnd,
    double *colcnd,
    double *amax,
    ptrdiff_t *info
);

/* Source: zgbequb.f */
#define zgbequb FORTRAN_WRAPPER(zgbequb)
extern void zgbequb(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const double *ab,
    const ptrdiff_t *ldab,
    double *r,
    double *c,
    double *rowcnd,
    double *colcnd,
    double *amax,
    ptrdiff_t *info
);

/* Source: zgbrfs.f */
#define zgbrfs FORTRAN_WRAPPER(zgbrfs)
extern void zgbrfs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    const double *ab,
    const ptrdiff_t *ldab,
    const double *afb,
    const ptrdiff_t *ldafb,
    const ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgbsv.f */
#define zgbsv FORTRAN_WRAPPER(zgbsv)
extern void zgbsv(
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    double *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zgbsvx.f */
#define zgbsvx FORTRAN_WRAPPER(zgbsvx)
extern void zgbsvx(
    const char   *fact,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    double *ab,
    const ptrdiff_t *ldab,
    double *afb,
    const ptrdiff_t *ldafb,
    ptrdiff_t *ipiv,
    char   *equed,
    double *r,
    double *c,
    double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgbtf2.f */
#define zgbtf2 FORTRAN_WRAPPER(zgbtf2)
extern void zgbtf2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    double *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: zgbtrf.f */
#define zgbtrf FORTRAN_WRAPPER(zgbtrf)
extern void zgbtrf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    double *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: zgbtrs.f */
#define zgbtrs FORTRAN_WRAPPER(zgbtrs)
extern void zgbtrs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const ptrdiff_t *nrhs,
    const double *ab,
    const ptrdiff_t *ldab,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zgebak.f */
#define zgebak FORTRAN_WRAPPER(zgebak)
extern void zgebak(
    const char   *job,
    const char   *side,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    const double *scale,
    const ptrdiff_t *m,
    double *v,
    const ptrdiff_t *ldv,
    ptrdiff_t *info
);

/* Source: zgebal.f */
#define zgebal FORTRAN_WRAPPER(zgebal)
extern void zgebal(
    const char   *job,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    double *scale,
    ptrdiff_t *info
);

/* Source: zgebd2.f */
#define zgebd2 FORTRAN_WRAPPER(zgebd2)
extern void zgebd2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *d,
    double *e,
    double *tauq,
    double *taup,
    double *work,
    ptrdiff_t *info
);

/* Source: zgebrd.f */
#define zgebrd FORTRAN_WRAPPER(zgebrd)
extern void zgebrd(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *d,
    double *e,
    double *tauq,
    double *taup,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zgecon.f */
#define zgecon FORTRAN_WRAPPER(zgecon)
extern void zgecon(
    const char   *norm,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *anorm,
    double *rcond,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgeequ.f */
#define zgeequ FORTRAN_WRAPPER(zgeequ)
extern void zgeequ(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *r,
    double *c,
    double *rowcnd,
    double *colcnd,
    double *amax,
    ptrdiff_t *info
);

/* Source: zgeequb.f */
#define zgeequb FORTRAN_WRAPPER(zgeequb)
extern void zgeequb(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *r,
    double *c,
    double *rowcnd,
    double *colcnd,
    double *amax,
    ptrdiff_t *info
);

/* Source: zgees.f */
#define zgees FORTRAN_WRAPPER(zgees)
extern void zgees(
    const char   *jobvs,
    const char   *sort,
    ptrdiff_t (*select)(),
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *sdim,
    double *w,
    double *vs,
    const ptrdiff_t *ldvs,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: zgeesx.f */
#define zgeesx FORTRAN_WRAPPER(zgeesx)
extern void zgeesx(
    const char   *jobvs,
    const char   *sort,
    ptrdiff_t (*select)(),
    const char   *sense,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *sdim,
    double *w,
    double *vs,
    const ptrdiff_t *ldvs,
    double *rconde,
    double *rcondv,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: zgeev.f */
#define zgeev FORTRAN_WRAPPER(zgeev)
extern void zgeev(
    const char   *jobvl,
    const char   *jobvr,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *w,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgeevx.f */
#define zgeevx FORTRAN_WRAPPER(zgeevx)
extern void zgeevx(
    const char   *balanc,
    const char   *jobvl,
    const char   *jobvr,
    const char   *sense,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *w,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    double *scale,
    double *abnrm,
    double *rconde,
    double *rcondv,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgegs.f */
#define zgegs FORTRAN_WRAPPER(zgegs)
extern void zgegs(
    const char   *jobvsl,
    const char   *jobvsr,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *alpha,
    double *beta,
    double *vsl,
    const ptrdiff_t *ldvsl,
    double *vsr,
    const ptrdiff_t *ldvsr,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgegv.f */
#define zgegv FORTRAN_WRAPPER(zgegv)
extern void zgegv(
    const char   *jobvl,
    const char   *jobvr,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *alpha,
    double *beta,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgehd2.f */
#define zgehd2 FORTRAN_WRAPPER(zgehd2)
extern void zgehd2(
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: zgehrd.f */
#define zgehrd FORTRAN_WRAPPER(zgehrd)
extern void zgehrd(
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zgelq2.f */
#define zgelq2 FORTRAN_WRAPPER(zgelq2)
extern void zgelq2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: zgelqf.f */
#define zgelqf FORTRAN_WRAPPER(zgelqf)
extern void zgelqf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zgels.f */
#define zgels FORTRAN_WRAPPER(zgels)
extern void zgels(
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zgelsd.f */
#define zgelsd FORTRAN_WRAPPER(zgelsd)
extern void zgelsd(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *s,
    const double *rcond,
    ptrdiff_t *rank,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: zgelss.f */
#define zgelss FORTRAN_WRAPPER(zgelss)
extern void zgelss(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *s,
    const double *rcond,
    ptrdiff_t *rank,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgelsx.f */
#define zgelsx FORTRAN_WRAPPER(zgelsx)
extern void zgelsx(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *jpvt,
    const double *rcond,
    ptrdiff_t *rank,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgelsy.f */
#define zgelsy FORTRAN_WRAPPER(zgelsy)
extern void zgelsy(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *jpvt,
    const double *rcond,
    ptrdiff_t *rank,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgemqrt.f */
#define zgemqrt FORTRAN_WRAPPER(zgemqrt)
extern void zgemqrt(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *nb,
    const double *v,
    const ptrdiff_t *ldv,
    const double *t,
    const ptrdiff_t *ldt,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: zgeql2.f */
#define zgeql2 FORTRAN_WRAPPER(zgeql2)
extern void zgeql2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: zgeqlf.f */
#define zgeqlf FORTRAN_WRAPPER(zgeqlf)
extern void zgeqlf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zgeqp3.f */
#define zgeqp3 FORTRAN_WRAPPER(zgeqp3)
extern void zgeqp3(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgeqpf.f */
#define zgeqpf FORTRAN_WRAPPER(zgeqpf)
extern void zgeqpf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    double *tau,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgeqr2.f */
#define zgeqr2 FORTRAN_WRAPPER(zgeqr2)
extern void zgeqr2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: zgeqr2p.f */
#define zgeqr2p FORTRAN_WRAPPER(zgeqr2p)
extern void zgeqr2p(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: zgeqrf.f */
#define zgeqrf FORTRAN_WRAPPER(zgeqrf)
extern void zgeqrf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zgeqrfp.f */
#define zgeqrfp FORTRAN_WRAPPER(zgeqrfp)
extern void zgeqrfp(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zgeqrt.f */
#define zgeqrt FORTRAN_WRAPPER(zgeqrt)
extern void zgeqrt(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    double *a,
    const ptrdiff_t *lda,
    double *t,
    const ptrdiff_t *ldt,
    double *work,
    ptrdiff_t *info
);

/* Source: zgeqrt2.f */
#define zgeqrt2 FORTRAN_WRAPPER(zgeqrt2)
extern void zgeqrt2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *t,
    const ptrdiff_t *ldt,
    ptrdiff_t *info
);

/* Source: zgeqrt3.f */
#define zgeqrt3 FORTRAN_WRAPPER(zgeqrt3)
extern void zgeqrt3(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *t,
    const ptrdiff_t *ldt,
    ptrdiff_t *info
);

/* Source: zgerfs.f */
#define zgerfs FORTRAN_WRAPPER(zgerfs)
extern void zgerfs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const double *af,
    const ptrdiff_t *ldaf,
    const ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgerq2.f */
#define zgerq2 FORTRAN_WRAPPER(zgerq2)
extern void zgerq2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: zgerqf.f */
#define zgerqf FORTRAN_WRAPPER(zgerqf)
extern void zgerqf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zgesc2.f */
#define zgesc2 FORTRAN_WRAPPER(zgesc2)
extern void zgesc2(
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *rhs,
    const ptrdiff_t *ipiv,
    const ptrdiff_t *jpiv,
    double *scale
);

/* Source: zgesdd.f */
#define zgesdd FORTRAN_WRAPPER(zgesdd)
extern void zgesdd(
    const char   *jobz,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *s,
    double *u,
    const ptrdiff_t *ldu,
    double *vt,
    const ptrdiff_t *ldvt,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: zgesv.f */
#define zgesv FORTRAN_WRAPPER(zgesv)
extern void zgesv(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zgesvd.f */
#define zgesvd FORTRAN_WRAPPER(zgesvd)
extern void zgesvd(
    const char   *jobu,
    const char   *jobvt,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *s,
    double *u,
    const ptrdiff_t *ldu,
    double *vt,
    const ptrdiff_t *ldvt,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgesvx.f */
#define zgesvx FORTRAN_WRAPPER(zgesvx)
extern void zgesvx(
    const char   *fact,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    double *af,
    const ptrdiff_t *ldaf,
    ptrdiff_t *ipiv,
    char   *equed,
    double *r,
    double *c,
    double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgetc2.f */
#define zgetc2 FORTRAN_WRAPPER(zgetc2)
extern void zgetc2(
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *jpiv,
    ptrdiff_t *info
);

/* Source: zgetf2.f */
#define zgetf2 FORTRAN_WRAPPER(zgetf2)
extern void zgetf2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: zgetrf.f */
#define zgetrf FORTRAN_WRAPPER(zgetrf)
extern void zgetrf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: zgetri.f */
#define zgetri FORTRAN_WRAPPER(zgetri)
extern void zgetri(
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zgetrs.f */
#define zgetrs FORTRAN_WRAPPER(zgetrs)
extern void zgetrs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zggbak.f */
#define zggbak FORTRAN_WRAPPER(zggbak)
extern void zggbak(
    const char   *job,
    const char   *side,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    const double *lscale,
    const double *rscale,
    const ptrdiff_t *m,
    double *v,
    const ptrdiff_t *ldv,
    ptrdiff_t *info
);

/* Source: zggbal.f */
#define zggbal FORTRAN_WRAPPER(zggbal)
extern void zggbal(
    const char   *job,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    double *lscale,
    double *rscale,
    double *work,
    ptrdiff_t *info
);

/* Source: zgges.f */
#define zgges FORTRAN_WRAPPER(zgges)
extern void zgges(
    const char   *jobvsl,
    const char   *jobvsr,
    const char   *sort,
    ptrdiff_t (*selctg)(),
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *sdim,
    double *alpha,
    double *beta,
    double *vsl,
    const ptrdiff_t *ldvsl,
    double *vsr,
    const ptrdiff_t *ldvsr,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: zggesx.f */
#define zggesx FORTRAN_WRAPPER(zggesx)
extern void zggesx(
    const char   *jobvsl,
    const char   *jobvsr,
    const char   *sort,
    ptrdiff_t (*selctg)(),
    const char   *sense,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *sdim,
    double *alpha,
    double *beta,
    double *vsl,
    const ptrdiff_t *ldvsl,
    double *vsr,
    const ptrdiff_t *ldvsr,
    double *rconde,
    double *rcondv,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: zggev.f */
#define zggev FORTRAN_WRAPPER(zggev)
extern void zggev(
    const char   *jobvl,
    const char   *jobvr,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *alpha,
    double *beta,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zggevx.f */
#define zggevx FORTRAN_WRAPPER(zggevx)
extern void zggevx(
    const char   *balanc,
    const char   *jobvl,
    const char   *jobvr,
    const char   *sense,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *alpha,
    double *beta,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    ptrdiff_t *ilo,
    ptrdiff_t *ihi,
    double *lscale,
    double *rscale,
    double *abnrm,
    double *bbnrm,
    double *rconde,
    double *rcondv,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *bwork,
    ptrdiff_t *info
);

/* Source: zggglm.f */
#define zggglm FORTRAN_WRAPPER(zggglm)
extern void zggglm(
    const ptrdiff_t *n,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *d,
    double *x,
    double *y,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zgghrd.f */
#define zgghrd FORTRAN_WRAPPER(zgghrd)
extern void zgghrd(
    const char   *compq,
    const char   *compz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *q,
    const ptrdiff_t *ldq,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *info
);

/* Source: zgglse.f */
#define zgglse FORTRAN_WRAPPER(zgglse)
extern void zgglse(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *p,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *c,
    double *d,
    double *x,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zggqrf.f */
#define zggqrf FORTRAN_WRAPPER(zggqrf)
extern void zggqrf(
    const ptrdiff_t *n,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    double *a,
    const ptrdiff_t *lda,
    double *taua,
    double *b,
    const ptrdiff_t *ldb,
    double *taub,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zggrqf.f */
#define zggrqf FORTRAN_WRAPPER(zggrqf)
extern void zggrqf(
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *taua,
    double *b,
    const ptrdiff_t *ldb,
    double *taub,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zggsvd.f */
#define zggsvd FORTRAN_WRAPPER(zggsvd)
extern void zggsvd(
    const char   *jobu,
    const char   *jobv,
    const char   *jobq,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *p,
    ptrdiff_t *k,
    ptrdiff_t *l,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *alpha,
    double *beta,
    double *u,
    const ptrdiff_t *ldu,
    double *v,
    const ptrdiff_t *ldv,
    double *q,
    const ptrdiff_t *ldq,
    double *work,
    double *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: zggsvp.f */
#define zggsvp FORTRAN_WRAPPER(zggsvp)
extern void zggsvp(
    const char   *jobu,
    const char   *jobv,
    const char   *jobq,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    const double *tola,
    const double *tolb,
    ptrdiff_t *k,
    ptrdiff_t *l,
    double *u,
    const ptrdiff_t *ldu,
    double *v,
    const ptrdiff_t *ldv,
    double *q,
    const ptrdiff_t *ldq,
    ptrdiff_t *iwork,
    double *rwork,
    double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: zgtcon.f */
#define zgtcon FORTRAN_WRAPPER(zgtcon)
extern void zgtcon(
    const char   *norm,
    const ptrdiff_t *n,
    const double *dl,
    const double *d,
    const double *du,
    const double *du2,
    const ptrdiff_t *ipiv,
    const double *anorm,
    double *rcond,
    double *work,
    ptrdiff_t *info
);

/* Source: zgtrfs.f */
#define zgtrfs FORTRAN_WRAPPER(zgtrfs)
extern void zgtrfs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *dl,
    const double *d,
    const double *du,
    const double *dlf,
    const double *df,
    const double *duf,
    const double *du2,
    const ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgtsv.f */
#define zgtsv FORTRAN_WRAPPER(zgtsv)
extern void zgtsv(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *dl,
    double *d,
    double *du,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zgtsvx.f */
#define zgtsvx FORTRAN_WRAPPER(zgtsvx)
extern void zgtsvx(
    const char   *fact,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *dl,
    const double *d,
    const double *du,
    double *dlf,
    double *df,
    double *duf,
    double *du2,
    ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zgttrf.f */
#define zgttrf FORTRAN_WRAPPER(zgttrf)
extern void zgttrf(
    const ptrdiff_t *n,
    double *dl,
    double *d,
    double *du,
    double *du2,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: zgttrs.f */
#define zgttrs FORTRAN_WRAPPER(zgttrs)
extern void zgttrs(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *dl,
    const double *d,
    const double *du,
    const double *du2,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zgtts2.f */
#define zgtts2 FORTRAN_WRAPPER(zgtts2)
extern void zgtts2(
    const ptrdiff_t *itrans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *dl,
    const double *d,
    const double *du,
    const double *du2,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb
);

/* Source: zhbev.f */
#define zhbev FORTRAN_WRAPPER(zhbev)
extern void zhbev(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zhbevd.f */
#define zhbevd FORTRAN_WRAPPER(zhbevd)
extern void zhbevd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: zhbevx.f */
#define zhbevx FORTRAN_WRAPPER(zhbevx)
extern void zhbevx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    double *q,
    const ptrdiff_t *ldq,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    double *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: zhbgst.f */
#define zhbgst FORTRAN_WRAPPER(zhbgst)
extern void zhbgst(
    const char   *vect,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    double *ab,
    const ptrdiff_t *ldab,
    const double *bb,
    const ptrdiff_t *ldbb,
    double *x,
    const ptrdiff_t *ldx,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zhbgv.f */
#define zhbgv FORTRAN_WRAPPER(zhbgv)
extern void zhbgv(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    double *ab,
    const ptrdiff_t *ldab,
    double *bb,
    const ptrdiff_t *ldbb,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zhbgvd.f */
#define zhbgvd FORTRAN_WRAPPER(zhbgvd)
extern void zhbgvd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    double *ab,
    const ptrdiff_t *ldab,
    double *bb,
    const ptrdiff_t *ldbb,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: zhbgvx.f */
#define zhbgvx FORTRAN_WRAPPER(zhbgvx)
extern void zhbgvx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *ka,
    const ptrdiff_t *kb,
    double *ab,
    const ptrdiff_t *ldab,
    double *bb,
    const ptrdiff_t *ldbb,
    double *q,
    const ptrdiff_t *ldq,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    double *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: zhbtrd.f */
#define zhbtrd FORTRAN_WRAPPER(zhbtrd)
extern void zhbtrd(
    const char   *vect,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    double *d,
    double *e,
    double *q,
    const ptrdiff_t *ldq,
    double *work,
    ptrdiff_t *info
);

/* Source: zhecon.f */
#define zhecon FORTRAN_WRAPPER(zhecon)
extern void zhecon(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    const double *anorm,
    double *rcond,
    double *work,
    ptrdiff_t *info
);

/* Source: zheequb.f */
#define zheequb FORTRAN_WRAPPER(zheequb)
extern void zheequb(
    char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *s,
    double *scond,
    double *amax,
    double *work,
    ptrdiff_t *info
);

/* Source: zheev.f */
#define zheev FORTRAN_WRAPPER(zheev)
extern void zheev(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *w,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zheevd.f */
#define zheevd FORTRAN_WRAPPER(zheevd)
extern void zheevd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *w,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: zheevr.f */
#define zheevr FORTRAN_WRAPPER(zheevr)
extern void zheevr(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *isuppz,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: zheevx.f */
#define zheevx FORTRAN_WRAPPER(zheevx)
extern void zheevx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: zhegs2.f */
#define zhegs2 FORTRAN_WRAPPER(zhegs2)
extern void zhegs2(
    const ptrdiff_t *itype,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zhegst.f */
#define zhegst FORTRAN_WRAPPER(zhegst)
extern void zhegst(
    const ptrdiff_t *itype,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zhegv.f */
#define zhegv FORTRAN_WRAPPER(zhegv)
extern void zhegv(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *w,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zhegvd.f */
#define zhegvd FORTRAN_WRAPPER(zhegvd)
extern void zhegvd(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *w,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: zhegvx.f */
#define zhegvx FORTRAN_WRAPPER(zhegvx)
extern void zhegvx(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: zherfs.f */
#define zherfs FORTRAN_WRAPPER(zherfs)
extern void zherfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const double *af,
    const ptrdiff_t *ldaf,
    const ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zhesv.f */
#define zhesv FORTRAN_WRAPPER(zhesv)
extern void zhesv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zhesvx.f */
#define zhesvx FORTRAN_WRAPPER(zhesvx)
extern void zhesvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    double *af,
    const ptrdiff_t *ldaf,
    ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zheswapr.f */
#define zheswapr FORTRAN_WRAPPER(zheswapr)
extern void zheswapr(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *i1,
    const ptrdiff_t *i2
);

/* Source: zhetd2.f */
#define zhetd2 FORTRAN_WRAPPER(zhetd2)
extern void zhetd2(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *d,
    double *e,
    double *tau,
    ptrdiff_t *info
);

/* Source: zhetf2.f */
#define zhetf2 FORTRAN_WRAPPER(zhetf2)
extern void zhetf2(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: zhetrd.f */
#define zhetrd FORTRAN_WRAPPER(zhetrd)
extern void zhetrd(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *d,
    double *e,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zhetrf.f */
#define zhetrf FORTRAN_WRAPPER(zhetrf)
extern void zhetrf(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zhetri.f */
#define zhetri FORTRAN_WRAPPER(zhetri)
extern void zhetri(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *work,
    ptrdiff_t *info
);

/* Source: zhetri2.f */
#define zhetri2 FORTRAN_WRAPPER(zhetri2)
extern void zhetri2(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zhetri2x.f */
#define zhetri2x FORTRAN_WRAPPER(zhetri2x)
extern void zhetri2x(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *work,
    const ptrdiff_t *nb,
    ptrdiff_t *info
);

/* Source: zhetrs.f */
#define zhetrs FORTRAN_WRAPPER(zhetrs)
extern void zhetrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zhetrs2.f */
#define zhetrs2 FORTRAN_WRAPPER(zhetrs2)
extern void zhetrs2(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    double *work,
    ptrdiff_t *info
);

/* Source: zhfrk.f */
#define zhfrk FORTRAN_WRAPPER(zhfrk)
extern void zhfrk(
    const char   *transr,
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *beta,
    double *c
);

/* Source: zhgeqz.f */
#define zhgeqz FORTRAN_WRAPPER(zhgeqz)
extern void zhgeqz(
    const char   *job,
    const char   *compq,
    const char   *compz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *h,
    const ptrdiff_t *ldh,
    double *t,
    const ptrdiff_t *ldt,
    double *alpha,
    double *beta,
    double *q,
    const ptrdiff_t *ldq,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zhpcon.f */
#define zhpcon FORTRAN_WRAPPER(zhpcon)
extern void zhpcon(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    const ptrdiff_t *ipiv,
    const double *anorm,
    double *rcond,
    double *work,
    ptrdiff_t *info
);

/* Source: zhpev.f */
#define zhpev FORTRAN_WRAPPER(zhpev)
extern void zhpev(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zhpevd.f */
#define zhpevd FORTRAN_WRAPPER(zhpevd)
extern void zhpevd(
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: zhpevx.f */
#define zhpevx FORTRAN_WRAPPER(zhpevx)
extern void zhpevx(
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    double *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: zhpgst.f */
#define zhpgst FORTRAN_WRAPPER(zhpgst)
extern void zhpgst(
    const ptrdiff_t *itype,
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    const double *bp,
    ptrdiff_t *info
);

/* Source: zhpgv.f */
#define zhpgv FORTRAN_WRAPPER(zhpgv)
extern void zhpgv(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    double *bp,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zhpgvd.f */
#define zhpgvd FORTRAN_WRAPPER(zhpgvd)
extern void zhpgvd(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    double *bp,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: zhpgvx.f */
#define zhpgvx FORTRAN_WRAPPER(zhpgvx)
extern void zhpgvx(
    const ptrdiff_t *itype,
    const char   *jobz,
    const char   *range,
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    double *bp,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    double *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: zhprfs.f */
#define zhprfs FORTRAN_WRAPPER(zhprfs)
extern void zhprfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    const double *afp,
    const ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zhpsv.f */
#define zhpsv FORTRAN_WRAPPER(zhpsv)
extern void zhpsv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *ap,
    ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zhpsvx.f */
#define zhpsvx FORTRAN_WRAPPER(zhpsvx)
extern void zhpsvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    double *afp,
    ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zhptrd.f */
#define zhptrd FORTRAN_WRAPPER(zhptrd)
extern void zhptrd(
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    double *d,
    double *e,
    double *tau,
    ptrdiff_t *info
);

/* Source: zhptrf.f */
#define zhptrf FORTRAN_WRAPPER(zhptrf)
extern void zhptrf(
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: zhptri.f */
#define zhptri FORTRAN_WRAPPER(zhptri)
extern void zhptri(
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    const ptrdiff_t *ipiv,
    double *work,
    ptrdiff_t *info
);

/* Source: zhptrs.f */
#define zhptrs FORTRAN_WRAPPER(zhptrs)
extern void zhptrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zhsein.f */
#define zhsein FORTRAN_WRAPPER(zhsein)
extern void zhsein(
    const char   *side,
    const char   *eigsrc,
    const char   *initv,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    const double *h,
    const ptrdiff_t *ldh,
    double *w,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    double *work,
    double *rwork,
    ptrdiff_t *ifaill,
    ptrdiff_t *ifailr,
    ptrdiff_t *info
);

/* Source: zhseqr.f */
#define zhseqr FORTRAN_WRAPPER(zhseqr)
extern void zhseqr(
    const char   *job,
    const char   *compz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *h,
    const ptrdiff_t *ldh,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zlabrd.f */
#define zlabrd FORTRAN_WRAPPER(zlabrd)
extern void zlabrd(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    double *a,
    const ptrdiff_t *lda,
    double *d,
    double *e,
    double *tauq,
    double *taup,
    double *x,
    const ptrdiff_t *ldx,
    double *y,
    const ptrdiff_t *ldy
);

/* Source: zlacgv.f */
#define zlacgv FORTRAN_WRAPPER(zlacgv)
extern void zlacgv(
    const ptrdiff_t *n,
    double *x,
    const ptrdiff_t *incx
);

/* Source: zlacn2.f */
#define zlacn2 FORTRAN_WRAPPER(zlacn2)
extern void zlacn2(
    const ptrdiff_t *n,
    double *v,
    double *x,
    double *est,
    ptrdiff_t *kase,
    ptrdiff_t *isave
);

/* Source: zlacon.f */
#define zlacon FORTRAN_WRAPPER(zlacon)
extern void zlacon(
    const ptrdiff_t *n,
    double *v,
    double *x,
    double *est,
    ptrdiff_t *kase
);

/* Source: zlacp2.f */
#define zlacp2 FORTRAN_WRAPPER(zlacp2)
extern void zlacp2(
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb
);

/* Source: zlacpy.f */
#define zlacpy FORTRAN_WRAPPER(zlacpy)
extern void zlacpy(
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb
);

/* Source: zlacrm.f */
#define zlacrm FORTRAN_WRAPPER(zlacrm)
extern void zlacrm(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *c,
    const ptrdiff_t *ldc,
    double *rwork
);

/* Source: zlacrt.f */
#define zlacrt FORTRAN_WRAPPER(zlacrt)
extern void zlacrt(
    const ptrdiff_t *n,
    double *cx,
    const ptrdiff_t *incx,
    double *cy,
    const ptrdiff_t *incy,
    const double *c,
    const double *s
);

/* Source: zladiv.f */
#define zladiv FORTRAN_WRAPPER(zladiv)
#ifndef FORTRAN_COMPLEX_FUNCTIONS_RETURN_VOID
extern doublecomplex zladiv(
#else
extern void zladiv(
    doublecomplex* retval,
#endif 
    const double *x,
    const double *y
);

/* Source: zlaed0.f */
#define zlaed0 FORTRAN_WRAPPER(zlaed0)
extern void zlaed0(
    const ptrdiff_t *qsiz,
    const ptrdiff_t *n,
    double *d,
    double *e,
    double *q,
    const ptrdiff_t *ldq,
    double *qstore,
    const ptrdiff_t *ldqs,
    double *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: zlaed7.f */
#define zlaed7 FORTRAN_WRAPPER(zlaed7)
extern void zlaed7(
    const ptrdiff_t *n,
    const ptrdiff_t *cutpnt,
    const ptrdiff_t *qsiz,
    const ptrdiff_t *tlvls,
    const ptrdiff_t *curlvl,
    const ptrdiff_t *curpbm,
    double *d,
    double *q,
    const ptrdiff_t *ldq,
    const double *rho,
    ptrdiff_t *indxq,
    double *qstore,
    ptrdiff_t *qptr,
    const ptrdiff_t *prmptr,
    const ptrdiff_t *perm,
    const ptrdiff_t *givptr,
    const ptrdiff_t *givcol,
    const double *givnum,
    double *work,
    double *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: zlaed8.f */
#define zlaed8 FORTRAN_WRAPPER(zlaed8)
extern void zlaed8(
    ptrdiff_t *k,
    const ptrdiff_t *n,
    const ptrdiff_t *qsiz,
    double *q,
    const ptrdiff_t *ldq,
    double *d,
    double *rho,
    const ptrdiff_t *cutpnt,
    const double *z,
    double *dlamda,
    double *q2,
    const ptrdiff_t *ldq2,
    double *w,
    ptrdiff_t *indxp,
    ptrdiff_t *indx,
    const ptrdiff_t *indxq,
    ptrdiff_t *perm,
    ptrdiff_t *givptr,
    ptrdiff_t *givcol,
    double *givnum,
    ptrdiff_t *info
);

/* Source: zlaein.f */
#define zlaein FORTRAN_WRAPPER(zlaein)
extern void zlaein(
    const ptrdiff_t *rightv,
    const ptrdiff_t *noinit,
    const ptrdiff_t *n,
    const double *h,
    const ptrdiff_t *ldh,
    const double *w,
    double *v,
    double *b,
    const ptrdiff_t *ldb,
    double *rwork,
    const double *eps3,
    const double *smlnum,
    ptrdiff_t *info
);

/* Source: zlaesy.f */
#define zlaesy FORTRAN_WRAPPER(zlaesy)
extern void zlaesy(
    const double *a,
    const double *b,
    const double *c,
    double *rt1,
    double *rt2,
    double *evscal,
    double *cs1,
    double *sn1
);

/* Source: zlaev2.f */
#define zlaev2 FORTRAN_WRAPPER(zlaev2)
extern void zlaev2(
    const double *a,
    const double *b,
    const double *c,
    double *rt1,
    double *rt2,
    double *cs1,
    double *sn1
);

/* Source: zlag2c.f */
#define zlag2c FORTRAN_WRAPPER(zlag2c)
extern void zlag2c(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    float  *sa,
    const ptrdiff_t *ldsa,
    ptrdiff_t *info
);

/* Source: zlags2.f */
#define zlags2 FORTRAN_WRAPPER(zlags2)
extern void zlags2(
    const ptrdiff_t *upper,
    const double *a1,
    const double *a2,
    const double *a3,
    const double *b1,
    const double *b2,
    const double *b3,
    double *csu,
    double *snu,
    double *csv,
    double *snv,
    double *csq,
    double *snq
);

/* Source: zlagtm.f */
#define zlagtm FORTRAN_WRAPPER(zlagtm)
extern void zlagtm(
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *alpha,
    const double *dl,
    const double *d,
    const double *du,
    const double *x,
    const ptrdiff_t *ldx,
    const double *beta,
    double *b,
    const ptrdiff_t *ldb
);

/* Source: zlahef.f */
#define zlahef FORTRAN_WRAPPER(zlahef)
extern void zlahef(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    ptrdiff_t *kb,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    double *w,
    const ptrdiff_t *ldw,
    ptrdiff_t *info
);

/* Source: zlahqr.f */
#define zlahqr FORTRAN_WRAPPER(zlahqr)
extern void zlahqr(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *h,
    const ptrdiff_t *ldh,
    double *w,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *info
);

/* Source: zlahr2.f */
#define zlahr2 FORTRAN_WRAPPER(zlahr2)
extern void zlahr2(
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *nb,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *t,
    const ptrdiff_t *ldt,
    double *y,
    const ptrdiff_t *ldy
);

/* Source: zlahrd.f */
#define zlahrd FORTRAN_WRAPPER(zlahrd)
extern void zlahrd(
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *nb,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *t,
    const ptrdiff_t *ldt,
    double *y,
    const ptrdiff_t *ldy
);

/* Source: zlaic1.f */
#define zlaic1 FORTRAN_WRAPPER(zlaic1)
extern void zlaic1(
    const ptrdiff_t *job,
    const ptrdiff_t *j,
    const double *x,
    const double *sest,
    const double *w,
    const double *gamma_,
    double *sestpr,
    double *s,
    double *c
);

/* Source: zlals0.f */
#define zlals0 FORTRAN_WRAPPER(zlals0)
extern void zlals0(
    const ptrdiff_t *icompq,
    const ptrdiff_t *nl,
    const ptrdiff_t *nr,
    const ptrdiff_t *sqre,
    const ptrdiff_t *nrhs,
    double *b,
    const ptrdiff_t *ldb,
    double *bx,
    const ptrdiff_t *ldbx,
    const ptrdiff_t *perm,
    const ptrdiff_t *givptr,
    const ptrdiff_t *givcol,
    const ptrdiff_t *ldgcol,
    const double *givnum,
    const ptrdiff_t *ldgnum,
    const double *poles,
    const double *difl,
    const double *difr,
    const double *z,
    const ptrdiff_t *k,
    const double *c,
    const double *s,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zlalsa.f */
#define zlalsa FORTRAN_WRAPPER(zlalsa)
extern void zlalsa(
    const ptrdiff_t *icompq,
    const ptrdiff_t *smlsiz,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *b,
    const ptrdiff_t *ldb,
    double *bx,
    const ptrdiff_t *ldbx,
    const double *u,
    const ptrdiff_t *ldu,
    const double *vt,
    const ptrdiff_t *k,
    const double *difl,
    const double *difr,
    const double *z,
    const double *poles,
    const ptrdiff_t *givptr,
    const ptrdiff_t *givcol,
    const ptrdiff_t *ldgcol,
    const ptrdiff_t *perm,
    const double *givnum,
    const double *c,
    const double *s,
    double *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: zlalsd.f */
#define zlalsd FORTRAN_WRAPPER(zlalsd)
extern void zlalsd(
    const char   *uplo,
    const ptrdiff_t *smlsiz,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *d,
    double *e,
    double *b,
    const ptrdiff_t *ldb,
    const double *rcond,
    ptrdiff_t *rank,
    double *work,
    double *rwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: zlangb.f */
#define zlangb FORTRAN_WRAPPER(zlangb)
extern double zlangb(
    const char   *norm,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const double *ab,
    const ptrdiff_t *ldab,
    double *work
);

/* Source: zlange.f */
#define zlange FORTRAN_WRAPPER(zlange)
extern double zlange(
    const char   *norm,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *work
);

/* Source: zlangt.f */
#define zlangt FORTRAN_WRAPPER(zlangt)
extern double zlangt(
    const char   *norm,
    const ptrdiff_t *n,
    const double *dl,
    const double *d,
    const double *du
);

/* Source: zlanhb.f */
#define zlanhb FORTRAN_WRAPPER(zlanhb)
extern double zlanhb(
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *ab,
    const ptrdiff_t *ldab,
    double *work
);

/* Source: zlanhe.f */
#define zlanhe FORTRAN_WRAPPER(zlanhe)
extern double zlanhe(
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *work
);

/* Source: zlanhf.f */
#define zlanhf FORTRAN_WRAPPER(zlanhf)
extern double zlanhf(
    const char   *norm,
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    double *work
);

/* Source: zlanhp.f */
#define zlanhp FORTRAN_WRAPPER(zlanhp)
extern double zlanhp(
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    double *work
);

/* Source: zlanhs.f */
#define zlanhs FORTRAN_WRAPPER(zlanhs)
extern double zlanhs(
    const char   *norm,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *work
);

/* Source: zlanht.f */
#define zlanht FORTRAN_WRAPPER(zlanht)
extern double zlanht(
    const char   *norm,
    const ptrdiff_t *n,
    const double *d,
    const double *e
);

/* Source: zlansb.f */
#define zlansb FORTRAN_WRAPPER(zlansb)
extern double zlansb(
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *ab,
    const ptrdiff_t *ldab,
    double *work
);

/* Source: zlansp.f */
#define zlansp FORTRAN_WRAPPER(zlansp)
extern double zlansp(
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    double *work
);

/* Source: zlansy.f */
#define zlansy FORTRAN_WRAPPER(zlansy)
extern double zlansy(
    const char   *norm,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *work
);

/* Source: zlantb.f */
#define zlantb FORTRAN_WRAPPER(zlantb)
extern double zlantb(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *ab,
    const ptrdiff_t *ldab,
    double *work
);

/* Source: zlantp.f */
#define zlantp FORTRAN_WRAPPER(zlantp)
extern double zlantp(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const double *ap,
    double *work
);

/* Source: zlantr.f */
#define zlantr FORTRAN_WRAPPER(zlantr)
extern double zlantr(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *work
);

/* Source: zlapll.f */
#define zlapll FORTRAN_WRAPPER(zlapll)
extern void zlapll(
    const ptrdiff_t *n,
    double *x,
    const ptrdiff_t *incx,
    double *y,
    const ptrdiff_t *incy,
    double *ssmin
);

/* Source: zlapmr.f */
#define zlapmr FORTRAN_WRAPPER(zlapmr)
extern void zlapmr(
    const ptrdiff_t *forwrd,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *x,
    const ptrdiff_t *ldx,
    ptrdiff_t *k
);

/* Source: zlapmt.f */
#define zlapmt FORTRAN_WRAPPER(zlapmt)
extern void zlapmt(
    const ptrdiff_t *forwrd,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *x,
    const ptrdiff_t *ldx,
    ptrdiff_t *k
);

/* Source: zlaqgb.f */
#define zlaqgb FORTRAN_WRAPPER(zlaqgb)
extern void zlaqgb(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    double *ab,
    const ptrdiff_t *ldab,
    const double *r,
    const double *c,
    const double *rowcnd,
    const double *colcnd,
    const double *amax,
    char   *equed
);

/* Source: zlaqge.f */
#define zlaqge FORTRAN_WRAPPER(zlaqge)
extern void zlaqge(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const double *r,
    const double *c,
    const double *rowcnd,
    const double *colcnd,
    const double *amax,
    char   *equed
);

/* Source: zlaqhb.f */
#define zlaqhb FORTRAN_WRAPPER(zlaqhb)
extern void zlaqhb(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    double *s,
    const double *scond,
    const double *amax,
    char   *equed
);

/* Source: zlaqhe.f */
#define zlaqhe FORTRAN_WRAPPER(zlaqhe)
extern void zlaqhe(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const double *s,
    const double *scond,
    const double *amax,
    char   *equed
);

/* Source: zlaqhp.f */
#define zlaqhp FORTRAN_WRAPPER(zlaqhp)
extern void zlaqhp(
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    const double *s,
    const double *scond,
    const double *amax,
    char   *equed
);

/* Source: zlaqp2.f */
#define zlaqp2 FORTRAN_WRAPPER(zlaqp2)
extern void zlaqp2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *offset,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    double *tau,
    double *vn1,
    double *vn2,
    double *work
);

/* Source: zlaqps.f */
#define zlaqps FORTRAN_WRAPPER(zlaqps)
extern void zlaqps(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *offset,
    const ptrdiff_t *nb,
    ptrdiff_t *kb,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *jpvt,
    double *tau,
    double *vn1,
    double *vn2,
    double *auxv,
    double *f,
    const ptrdiff_t *ldf
);

/* Source: zlaqr0.f */
#define zlaqr0 FORTRAN_WRAPPER(zlaqr0)
extern void zlaqr0(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *h,
    const ptrdiff_t *ldh,
    double *w,
    ptrdiff_t *iloz,
    ptrdiff_t *ihiz,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zlaqr1.f */
#define zlaqr1 FORTRAN_WRAPPER(zlaqr1)
extern void zlaqr1(
    const ptrdiff_t *n,
    const double *h,
    const ptrdiff_t *ldh,
    const double *s1,
    double *s2,
    double *v
);

/* Source: zlaqr2.f */
#define zlaqr2 FORTRAN_WRAPPER(zlaqr2)
extern void zlaqr2(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ktop,
    const ptrdiff_t *kbot,
    const ptrdiff_t *nw,
    double *h,
    const ptrdiff_t *ldh,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *ns,
    ptrdiff_t *nd,
    double *sh,
    double *v,
    const ptrdiff_t *ldv,
    const ptrdiff_t *nh,
    double *t,
    const ptrdiff_t *ldt,
    const ptrdiff_t *nv,
    double *wv,
    const ptrdiff_t *ldwv,
    double *work,
    const ptrdiff_t *lwork
);

/* Source: zlaqr3.f */
#define zlaqr3 FORTRAN_WRAPPER(zlaqr3)
extern void zlaqr3(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ktop,
    const ptrdiff_t *kbot,
    const ptrdiff_t *nw,
    double *h,
    const ptrdiff_t *ldh,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *ns,
    ptrdiff_t *nd,
    double *sh,
    double *v,
    const ptrdiff_t *ldv,
    const ptrdiff_t *nh,
    double *t,
    const ptrdiff_t *ldt,
    const ptrdiff_t *nv,
    double *wv,
    const ptrdiff_t *ldwv,
    double *work,
    const ptrdiff_t *lwork
);

/* Source: zlaqr4.f */
#define zlaqr4 FORTRAN_WRAPPER(zlaqr4)
extern void zlaqr4(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *h,
    const ptrdiff_t *ldh,
    double *w,
    ptrdiff_t *iloz,
    ptrdiff_t *ihiz,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zlaqr5.f */
#define zlaqr5 FORTRAN_WRAPPER(zlaqr5)
extern void zlaqr5(
    const ptrdiff_t *wantt,
    const ptrdiff_t *wantz,
    const ptrdiff_t *kacc22,
    const ptrdiff_t *n,
    const ptrdiff_t *ktop,
    const ptrdiff_t *kbot,
    const ptrdiff_t *nshfts,
    double *s,
    double *h,
    const ptrdiff_t *ldh,
    const ptrdiff_t *iloz,
    const ptrdiff_t *ihiz,
    double *z,
    const ptrdiff_t *ldz,
    double *v,
    const ptrdiff_t *ldv,
    double *u,
    const ptrdiff_t *ldu,
    const ptrdiff_t *nv,
    double *wv,
    const ptrdiff_t *ldwv,
    const ptrdiff_t *nh,
    double *wh,
    const ptrdiff_t *ldwh
);

/* Source: zlaqsb.f */
#define zlaqsb FORTRAN_WRAPPER(zlaqsb)
extern void zlaqsb(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    const double *s,
    const double *scond,
    const double *amax,
    char   *equed
);

/* Source: zlaqsp.f */
#define zlaqsp FORTRAN_WRAPPER(zlaqsp)
extern void zlaqsp(
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    const double *s,
    const double *scond,
    const double *amax,
    char   *equed
);

/* Source: zlaqsy.f */
#define zlaqsy FORTRAN_WRAPPER(zlaqsy)
extern void zlaqsy(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const double *s,
    const double *scond,
    const double *amax,
    char   *equed
);

/* Source: zlar1v.f */
#define zlar1v FORTRAN_WRAPPER(zlar1v)
extern void zlar1v(
    const ptrdiff_t *n,
    const ptrdiff_t *b1,
    const ptrdiff_t *bn,
    const double *lambda,
    const double *d,
    const double *l,
    const double *ld,
    const double *lld,
    const double *pivmin,
    const double *gaptol,
    double *z,
    const ptrdiff_t *wantnc,
    ptrdiff_t *negcnt,
    double *ztz,
    double *mingma,
    ptrdiff_t *r,
    ptrdiff_t *isuppz,
    double *nrminv,
    double *resid,
    double *rqcorr,
    double *work
);

/* Source: zlar2v.f */
#define zlar2v FORTRAN_WRAPPER(zlar2v)
extern void zlar2v(
    const ptrdiff_t *n,
    double *x,
    double *y,
    double *z,
    const ptrdiff_t *incx,
    const double *c,
    const double *s,
    const ptrdiff_t *incc
);

/* Source: zlarcm.f */
#define zlarcm FORTRAN_WRAPPER(zlarcm)
extern void zlarcm(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *c,
    const ptrdiff_t *ldc,
    double *rwork
);

/* Source: zlarf.f */
#define zlarf FORTRAN_WRAPPER(zlarf)
extern void zlarf(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *v,
    const ptrdiff_t *incv,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work
);

/* Source: zlarfb.f */
#define zlarfb FORTRAN_WRAPPER(zlarfb)
extern void zlarfb(
    const char   *side,
    const char   *trans,
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *v,
    const ptrdiff_t *ldv,
    const double *t,
    const ptrdiff_t *ldt,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *ldwork
);

/* Source: zlarfg.f */
#define zlarfg FORTRAN_WRAPPER(zlarfg)
extern void zlarfg(
    const ptrdiff_t *n,
    double *alpha,
    double *x,
    const ptrdiff_t *incx,
    double *tau
);

/* Source: zlarfgp.f */
#define zlarfgp FORTRAN_WRAPPER(zlarfgp)
extern void zlarfgp(
    const ptrdiff_t *n,
    double *alpha,
    double *x,
    const ptrdiff_t *incx,
    double *tau
);

/* Source: zlarft.f */
#define zlarft FORTRAN_WRAPPER(zlarft)
extern void zlarft(
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *v,
    const ptrdiff_t *ldv,
    const double *tau,
    double *t,
    const ptrdiff_t *ldt
);

/* Source: zlarfx.f */
#define zlarfx FORTRAN_WRAPPER(zlarfx)
extern void zlarfx(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *v,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work
);

/* Source: zlargv.f */
#define zlargv FORTRAN_WRAPPER(zlargv)
extern void zlargv(
    const ptrdiff_t *n,
    double *x,
    const ptrdiff_t *incx,
    double *y,
    const ptrdiff_t *incy,
    double *c,
    const ptrdiff_t *incc
);

/* Source: zlarnv.f */
#define zlarnv FORTRAN_WRAPPER(zlarnv)
extern void zlarnv(
    const ptrdiff_t *idist,
    ptrdiff_t *iseed,
    const ptrdiff_t *n,
    double *x
);

/* Source: zlarrv.f */
#define zlarrv FORTRAN_WRAPPER(zlarrv)
extern void zlarrv(
    const ptrdiff_t *n,
    const double *vl,
    const double *vu,
    double *d,
    double *l,
    double *pivmin,
    const ptrdiff_t *isplit,
    const ptrdiff_t *m,
    const ptrdiff_t *dol,
    const ptrdiff_t *dou,
    const double *minrgp,
    const double *rtol1,
    const double *rtol2,
    double *w,
    double *werr,
    double *wgap,
    const ptrdiff_t *iblock,
    const ptrdiff_t *indexw,
    const double *gers,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *isuppz,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: zlartg.f */
#define zlartg FORTRAN_WRAPPER(zlartg)
extern void zlartg(
    const double *f,
    const double *g,
    double *cs,
    double *sn,
    double *r
);

/* Source: zlartv.f */
#define zlartv FORTRAN_WRAPPER(zlartv)
extern void zlartv(
    const ptrdiff_t *n,
    double *x,
    const ptrdiff_t *incx,
    double *y,
    const ptrdiff_t *incy,
    const double *c,
    const double *s,
    const ptrdiff_t *incc
);

/* Source: zlarz.f */
#define zlarz FORTRAN_WRAPPER(zlarz)
extern void zlarz(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    const double *v,
    const ptrdiff_t *incv,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work
);

/* Source: zlarzb.f */
#define zlarzb FORTRAN_WRAPPER(zlarzb)
extern void zlarzb(
    const char   *side,
    const char   *trans,
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const double *v,
    const ptrdiff_t *ldv,
    const double *t,
    const ptrdiff_t *ldt,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *ldwork
);

/* Source: zlarzt.f */
#define zlarzt FORTRAN_WRAPPER(zlarzt)
extern void zlarzt(
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *v,
    const ptrdiff_t *ldv,
    const double *tau,
    double *t,
    const ptrdiff_t *ldt
);

/* Source: zlascl.f */
#define zlascl FORTRAN_WRAPPER(zlascl)
extern void zlascl(
    const char   *type,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const double *cfrom,
    const double *cto,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: zlaset.f */
#define zlaset FORTRAN_WRAPPER(zlaset)
extern void zlaset(
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *beta,
    double *a,
    const ptrdiff_t *lda
);

/* Source: zlasr.f */
#define zlasr FORTRAN_WRAPPER(zlasr)
extern void zlasr(
    const char   *side,
    const char   *pivot,
    const char   *direct,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *c,
    const double *s,
    double *a,
    const ptrdiff_t *lda
);

/* Source: zlassq.f */
#define zlassq FORTRAN_WRAPPER(zlassq)
extern void zlassq(
    const ptrdiff_t *n,
    const double *x,
    const ptrdiff_t *incx,
    double *scale,
    double *sumsq
);

/* Source: zlaswp.f */
#define zlaswp FORTRAN_WRAPPER(zlaswp)
extern void zlaswp(
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *k1,
    const ptrdiff_t *k2,
    const ptrdiff_t *ipiv,
    const ptrdiff_t *incx
);

/* Source: zlasyf.f */
#define zlasyf FORTRAN_WRAPPER(zlasyf)
extern void zlasyf(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    ptrdiff_t *kb,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    double *w,
    const ptrdiff_t *ldw,
    ptrdiff_t *info
);

/* Source: zlat2c.f */
#define zlat2c FORTRAN_WRAPPER(zlat2c)
extern void zlat2c(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    float  *sa,
    const ptrdiff_t *ldsa,
    ptrdiff_t *info
);

/* Source: zlatbs.f */
#define zlatbs FORTRAN_WRAPPER(zlatbs)
extern void zlatbs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const char   *normin,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const double *ab,
    const ptrdiff_t *ldab,
    double *x,
    double *scale,
    double *cnorm,
    ptrdiff_t *info
);

/* Source: zlatdf.f */
#define zlatdf FORTRAN_WRAPPER(zlatdf)
extern void zlatdf(
    const ptrdiff_t *ijob,
    const ptrdiff_t *n,
    const double *z,
    const ptrdiff_t *ldz,
    double *rhs,
    double *rdsum,
    double *rdscal,
    const ptrdiff_t *ipiv,
    const ptrdiff_t *jpiv
);

/* Source: zlatps.f */
#define zlatps FORTRAN_WRAPPER(zlatps)
extern void zlatps(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const char   *normin,
    const ptrdiff_t *n,
    const double *ap,
    double *x,
    double *scale,
    double *cnorm,
    ptrdiff_t *info
);

/* Source: zlatrd.f */
#define zlatrd FORTRAN_WRAPPER(zlatrd)
extern void zlatrd(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nb,
    double *a,
    const ptrdiff_t *lda,
    double *e,
    double *tau,
    double *w,
    const ptrdiff_t *ldw
);

/* Source: zlatrs.f */
#define zlatrs FORTRAN_WRAPPER(zlatrs)
extern void zlatrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const char   *normin,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *x,
    double *scale,
    double *cnorm,
    ptrdiff_t *info
);

/* Source: zlatrz.f */
#define zlatrz FORTRAN_WRAPPER(zlatrz)
extern void zlatrz(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work
);

/* Source: zlatzm.f */
#define zlatzm FORTRAN_WRAPPER(zlatzm)
extern void zlatzm(
    const char   *side,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *v,
    const ptrdiff_t *incv,
    const double *tau,
    double *c1,
    double *c2,
    const ptrdiff_t *ldc,
    double *work
);

/* Source: zlauu2.f */
#define zlauu2 FORTRAN_WRAPPER(zlauu2)
extern void zlauu2(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: zlauum.f */
#define zlauum FORTRAN_WRAPPER(zlauum)
extern void zlauum(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: zpbcon.f */
#define zpbcon FORTRAN_WRAPPER(zpbcon)
extern void zpbcon(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const double *ab,
    const ptrdiff_t *ldab,
    const double *anorm,
    double *rcond,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zpbequ.f */
#define zpbequ FORTRAN_WRAPPER(zpbequ)
extern void zpbequ(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const double *ab,
    const ptrdiff_t *ldab,
    double *s,
    double *scond,
    double *amax,
    ptrdiff_t *info
);

/* Source: zpbrfs.f */
#define zpbrfs FORTRAN_WRAPPER(zpbrfs)
extern void zpbrfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const double *ab,
    const ptrdiff_t *ldab,
    const double *afb,
    const ptrdiff_t *ldafb,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zpbstf.f */
#define zpbstf FORTRAN_WRAPPER(zpbstf)
extern void zpbstf(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *info
);

/* Source: zpbsv.f */
#define zpbsv FORTRAN_WRAPPER(zpbsv)
extern void zpbsv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    double *ab,
    const ptrdiff_t *ldab,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zpbsvx.f */
#define zpbsvx FORTRAN_WRAPPER(zpbsvx)
extern void zpbsvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    double *ab,
    const ptrdiff_t *ldab,
    double *afb,
    const ptrdiff_t *ldafb,
    char   *equed,
    double *s,
    double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zpbtf2.f */
#define zpbtf2 FORTRAN_WRAPPER(zpbtf2)
extern void zpbtf2(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *info
);

/* Source: zpbtrf.f */
#define zpbtrf FORTRAN_WRAPPER(zpbtrf)
extern void zpbtrf(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    double *ab,
    const ptrdiff_t *ldab,
    ptrdiff_t *info
);

/* Source: zpbtrs.f */
#define zpbtrs FORTRAN_WRAPPER(zpbtrs)
extern void zpbtrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const double *ab,
    const ptrdiff_t *ldab,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zpftrf.f */
#define zpftrf FORTRAN_WRAPPER(zpftrf)
extern void zpftrf(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    ptrdiff_t *info
);

/* Source: zpftri.f */
#define zpftri FORTRAN_WRAPPER(zpftri)
extern void zpftri(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    ptrdiff_t *info
);

/* Source: zpftrs.f */
#define zpftrs FORTRAN_WRAPPER(zpftrs)
extern void zpftrs(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zpocon.f */
#define zpocon FORTRAN_WRAPPER(zpocon)
extern void zpocon(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *anorm,
    double *rcond,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zpoequ.f */
#define zpoequ FORTRAN_WRAPPER(zpoequ)
extern void zpoequ(
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *s,
    double *scond,
    double *amax,
    ptrdiff_t *info
);

/* Source: zpoequb.f */
#define zpoequb FORTRAN_WRAPPER(zpoequb)
extern void zpoequb(
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *s,
    double *scond,
    double *amax,
    ptrdiff_t *info
);

/* Source: zporfs.f */
#define zporfs FORTRAN_WRAPPER(zporfs)
extern void zporfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const double *af,
    const ptrdiff_t *ldaf,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zposv.f */
#define zposv FORTRAN_WRAPPER(zposv)
extern void zposv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zposvx.f */
#define zposvx FORTRAN_WRAPPER(zposvx)
extern void zposvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    double *af,
    const ptrdiff_t *ldaf,
    char   *equed,
    double *s,
    double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zpotf2.f */
#define zpotf2 FORTRAN_WRAPPER(zpotf2)
extern void zpotf2(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: zpotrf.f */
#define zpotrf FORTRAN_WRAPPER(zpotrf)
extern void zpotrf(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: zpotri.f */
#define zpotri FORTRAN_WRAPPER(zpotri)
extern void zpotri(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: zpotrs.f */
#define zpotrs FORTRAN_WRAPPER(zpotrs)
extern void zpotrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zppcon.f */
#define zppcon FORTRAN_WRAPPER(zppcon)
extern void zppcon(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    const double *anorm,
    double *rcond,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zppequ.f */
#define zppequ FORTRAN_WRAPPER(zppequ)
extern void zppequ(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    double *s,
    double *scond,
    double *amax,
    ptrdiff_t *info
);

/* Source: zpprfs.f */
#define zpprfs FORTRAN_WRAPPER(zpprfs)
extern void zpprfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    const double *afp,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zppsv.f */
#define zppsv FORTRAN_WRAPPER(zppsv)
extern void zppsv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *ap,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zppsvx.f */
#define zppsvx FORTRAN_WRAPPER(zppsvx)
extern void zppsvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *ap,
    double *afp,
    char   *equed,
    double *s,
    double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zpptrf.f */
#define zpptrf FORTRAN_WRAPPER(zpptrf)
extern void zpptrf(
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    ptrdiff_t *info
);

/* Source: zpptri.f */
#define zpptri FORTRAN_WRAPPER(zpptri)
extern void zpptri(
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    ptrdiff_t *info
);

/* Source: zpptrs.f */
#define zpptrs FORTRAN_WRAPPER(zpptrs)
extern void zpptrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zpstf2.f */
#define zpstf2 FORTRAN_WRAPPER(zpstf2)
extern void zpstf2(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *piv,
    ptrdiff_t *rank,
    const double *tol,
    double *work,
    ptrdiff_t *info
);

/* Source: zpstrf.f */
#define zpstrf FORTRAN_WRAPPER(zpstrf)
extern void zpstrf(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *piv,
    ptrdiff_t *rank,
    const double *tol,
    double *work,
    ptrdiff_t *info
);

/* Source: zptcon.f */
#define zptcon FORTRAN_WRAPPER(zptcon)
extern void zptcon(
    const ptrdiff_t *n,
    const double *d,
    const double *e,
    const double *anorm,
    double *rcond,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zpteqr.f */
#define zpteqr FORTRAN_WRAPPER(zpteqr)
extern void zpteqr(
    const char   *compz,
    const ptrdiff_t *n,
    double *d,
    double *e,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *info
);

/* Source: zptrfs.f */
#define zptrfs FORTRAN_WRAPPER(zptrfs)
extern void zptrfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *d,
    const double *e,
    const double *df,
    const double *ef,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zptsv.f */
#define zptsv FORTRAN_WRAPPER(zptsv)
extern void zptsv(
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *d,
    double *e,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zptsvx.f */
#define zptsvx FORTRAN_WRAPPER(zptsvx)
extern void zptsvx(
    const char   *fact,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *d,
    const double *e,
    double *df,
    double *ef,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zpttrf.f */
#define zpttrf FORTRAN_WRAPPER(zpttrf)
extern void zpttrf(
    const ptrdiff_t *n,
    double *d,
    double *e,
    ptrdiff_t *info
);

/* Source: zpttrs.f */
#define zpttrs FORTRAN_WRAPPER(zpttrs)
extern void zpttrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *d,
    const double *e,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zptts2.f */
#define zptts2 FORTRAN_WRAPPER(zptts2)
extern void zptts2(
    const ptrdiff_t *iuplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *d,
    const double *e,
    double *b,
    const ptrdiff_t *ldb
);

/* Source: zrot.f */
#define zrot FORTRAN_WRAPPER(zrot)
extern void zrot(
    const ptrdiff_t *n,
    double *cx,
    const ptrdiff_t *incx,
    double *cy,
    const ptrdiff_t *incy,
    const double *c,
    const double *s
);

/* Source: zspcon.f */
#define zspcon FORTRAN_WRAPPER(zspcon)
extern void zspcon(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    const ptrdiff_t *ipiv,
    const double *anorm,
    double *rcond,
    double *work,
    ptrdiff_t *info
);

/* Source: zspmv.f */
#define zspmv FORTRAN_WRAPPER(zspmv)
extern void zspmv(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *ap,
    const double *x,
    const ptrdiff_t *incx,
    const double *beta,
    double *y,
    const ptrdiff_t *incy
);

/* Source: zspr.f */
#define zspr FORTRAN_WRAPPER(zspr)
extern void zspr(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *x,
    const ptrdiff_t *incx,
    double *ap
);

/* Source: zsprfs.f */
#define zsprfs FORTRAN_WRAPPER(zsprfs)
extern void zsprfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    const double *afp,
    const ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zspsv.f */
#define zspsv FORTRAN_WRAPPER(zspsv)
extern void zspsv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *ap,
    ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zspsvx.f */
#define zspsvx FORTRAN_WRAPPER(zspsvx)
extern void zspsvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    double *afp,
    ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zsptrf.f */
#define zsptrf FORTRAN_WRAPPER(zsptrf)
extern void zsptrf(
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: zsptri.f */
#define zsptri FORTRAN_WRAPPER(zsptri)
extern void zsptri(
    const char   *uplo,
    const ptrdiff_t *n,
    double *ap,
    const ptrdiff_t *ipiv,
    double *work,
    ptrdiff_t *info
);

/* Source: zsptrs.f */
#define zsptrs FORTRAN_WRAPPER(zsptrs)
extern void zsptrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zstedc.f */
#define zstedc FORTRAN_WRAPPER(zstedc)
extern void zstedc(
    const char   *compz,
    const ptrdiff_t *n,
    double *d,
    double *e,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: zstegr.f */
#define zstegr FORTRAN_WRAPPER(zstegr)
extern void zstegr(
    const char   *jobz,
    const char   *range,
    const ptrdiff_t *n,
    double *d,
    double *e,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    const double *abstol,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *isuppz,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: zstein.f */
#define zstein FORTRAN_WRAPPER(zstein)
extern void zstein(
    const ptrdiff_t *n,
    const double *d,
    const double *e,
    const ptrdiff_t *m,
    const double *w,
    const ptrdiff_t *iblock,
    const ptrdiff_t *isplit,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *iwork,
    ptrdiff_t *ifail,
    ptrdiff_t *info
);

/* Source: zstemr.f */
#define zstemr FORTRAN_WRAPPER(zstemr)
extern void zstemr(
    const char   *jobz,
    const char   *range,
    const ptrdiff_t *n,
    double *d,
    double *e,
    const double *vl,
    const double *vu,
    const ptrdiff_t *il,
    const ptrdiff_t *iu,
    ptrdiff_t *m,
    double *w,
    double *z,
    const ptrdiff_t *ldz,
    const ptrdiff_t *nzc,
    ptrdiff_t *isuppz,
    ptrdiff_t *tryrac,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: zsteqr.f */
#define zsteqr FORTRAN_WRAPPER(zsteqr)
extern void zsteqr(
    const char   *compz,
    const ptrdiff_t *n,
    double *d,
    double *e,
    double *z,
    const ptrdiff_t *ldz,
    double *work,
    ptrdiff_t *info
);

/* Source: zsycon.f */
#define zsycon FORTRAN_WRAPPER(zsycon)
extern void zsycon(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    const double *anorm,
    double *rcond,
    double *work,
    ptrdiff_t *info
);

/* Source: zsyconv.f */
#define zsyconv FORTRAN_WRAPPER(zsyconv)
extern void zsyconv(
    const char   *uplo,
    const char   *way,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *work,
    ptrdiff_t *info
);

/* Source: zsyequb.f */
#define zsyequb FORTRAN_WRAPPER(zsyequb)
extern void zsyequb(
    char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *s,
    double *scond,
    double *amax,
    double *work,
    ptrdiff_t *info
);

/* Source: zsymv.f */
#define zsymv FORTRAN_WRAPPER(zsymv)
extern void zsymv(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *x,
    const ptrdiff_t *incx,
    const double *beta,
    double *y,
    const ptrdiff_t *incy
);

/* Source: zsyr.f */
#define zsyr FORTRAN_WRAPPER(zsyr)
extern void zsyr(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *x,
    const ptrdiff_t *incx,
    double *a,
    const ptrdiff_t *lda
);

/* Source: zsyrfs.f */
#define zsyrfs FORTRAN_WRAPPER(zsyrfs)
extern void zsyrfs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const double *af,
    const ptrdiff_t *ldaf,
    const ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zsysv.f */
#define zsysv FORTRAN_WRAPPER(zsysv)
extern void zsysv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zsysvx.f */
#define zsysvx FORTRAN_WRAPPER(zsysvx)
extern void zsysvx(
    const char   *fact,
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    double *af,
    const ptrdiff_t *ldaf,
    ptrdiff_t *ipiv,
    const double *b,
    const ptrdiff_t *ldb,
    double *x,
    const ptrdiff_t *ldx,
    double *rcond,
    double *ferr,
    double *berr,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    ptrdiff_t *info
);

/* Source: zsyswapr.f */
#define zsyswapr FORTRAN_WRAPPER(zsyswapr)
extern void zsyswapr(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *i1,
    const ptrdiff_t *i2
);

/* Source: zsytf2.f */
#define zsytf2 FORTRAN_WRAPPER(zsytf2)
extern void zsytf2(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    ptrdiff_t *info
);

/* Source: zsytrf.f */
#define zsytrf FORTRAN_WRAPPER(zsytrf)
extern void zsytrf(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *ipiv,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zsytri.f */
#define zsytri FORTRAN_WRAPPER(zsytri)
extern void zsytri(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *work,
    ptrdiff_t *info
);

/* Source: zsytri2.f */
#define zsytri2 FORTRAN_WRAPPER(zsytri2)
extern void zsytri2(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zsytri2x.f */
#define zsytri2x FORTRAN_WRAPPER(zsytri2x)
extern void zsytri2x(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *work,
    ptrdiff_t *nb,
    ptrdiff_t *info
);

/* Source: zsytrs.f */
#define zsytrs FORTRAN_WRAPPER(zsytrs)
extern void zsytrs(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: zsytrs2.f */
#define zsytrs2 FORTRAN_WRAPPER(zsytrs2)
extern void zsytrs2(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const ptrdiff_t *ipiv,
    double *b,
    const ptrdiff_t *ldb,
    double *work,
    ptrdiff_t *info
);

/* Source: ztbcon.f */
#define ztbcon FORTRAN_WRAPPER(ztbcon)
extern void ztbcon(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const double *ab,
    const ptrdiff_t *ldab,
    double *rcond,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: ztbrfs.f */
#define ztbrfs FORTRAN_WRAPPER(ztbrfs)
extern void ztbrfs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const double *ab,
    const ptrdiff_t *ldab,
    const double *b,
    const ptrdiff_t *ldb,
    const double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: ztbtrs.f */
#define ztbtrs FORTRAN_WRAPPER(ztbtrs)
extern void ztbtrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *kd,
    const ptrdiff_t *nrhs,
    const double *ab,
    const ptrdiff_t *ldab,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: ztfsm.f */
#define ztfsm FORTRAN_WRAPPER(ztfsm)
extern void ztfsm(
    const char   *transr,
    const char   *side,
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *a,
    double *b,
    const ptrdiff_t *ldb
);

/* Source: ztftri.f */
#define ztftri FORTRAN_WRAPPER(ztftri)
extern void ztftri(
    const char   *transr,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    double *a,
    ptrdiff_t *info
);

/* Source: ztfttp.f */
#define ztfttp FORTRAN_WRAPPER(ztfttp)
extern void ztfttp(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *arf,
    double *ap,
    ptrdiff_t *info
);

/* Source: ztfttr.f */
#define ztfttr FORTRAN_WRAPPER(ztfttr)
extern void ztfttr(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *arf,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: ztgevc.f */
#define ztgevc FORTRAN_WRAPPER(ztgevc)
extern void ztgevc(
    const char   *side,
    const char   *howmny,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    const double *s,
    const ptrdiff_t *lds,
    const double *p,
    const ptrdiff_t *ldp,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: ztgex2.f */
#define ztgex2 FORTRAN_WRAPPER(ztgex2)
extern void ztgex2(
    const ptrdiff_t *wantq,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *q,
    const ptrdiff_t *ldq,
    double *z,
    const ptrdiff_t *ldz,
    const ptrdiff_t *j1_,
    ptrdiff_t *info
);

/* Source: ztgexc.f */
#define ztgexc FORTRAN_WRAPPER(ztgexc)
extern void ztgexc(
    const ptrdiff_t *wantq,
    const ptrdiff_t *wantz,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *q,
    const ptrdiff_t *ldq,
    double *z,
    const ptrdiff_t *ldz,
    const ptrdiff_t *ifst,
    ptrdiff_t *ilst,
    ptrdiff_t *info
);

/* Source: ztgsen.f */
#define ztgsen FORTRAN_WRAPPER(ztgsen)
extern void ztgsen(
    const ptrdiff_t *ijob,
    const ptrdiff_t *wantq,
    const ptrdiff_t *wantz,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *alpha,
    double *beta,
    double *q,
    const ptrdiff_t *ldq,
    double *z,
    const ptrdiff_t *ldz,
    ptrdiff_t *m,
    double *pl,
    double *pr,
    double *dif,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    const ptrdiff_t *liwork,
    ptrdiff_t *info
);

/* Source: ztgsja.f */
#define ztgsja FORTRAN_WRAPPER(ztgsja)
extern void ztgsja(
    const char   *jobu,
    const char   *jobv,
    const char   *jobq,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    const double *tola,
    const double *tolb,
    double *alpha,
    double *beta,
    double *u,
    const ptrdiff_t *ldu,
    double *v,
    const ptrdiff_t *ldv,
    double *q,
    const ptrdiff_t *ldq,
    double *work,
    ptrdiff_t *ncycle,
    ptrdiff_t *info
);

/* Source: ztgsna.f */
#define ztgsna FORTRAN_WRAPPER(ztgsna)
extern void ztgsna(
    const char   *job,
    const char   *howmny,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *vl,
    const ptrdiff_t *ldvl,
    const double *vr,
    const ptrdiff_t *ldvr,
    double *s,
    double *dif,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: ztgsy2.f */
#define ztgsy2 FORTRAN_WRAPPER(ztgsy2)
extern void ztgsy2(
    const char   *trans,
    const ptrdiff_t *ijob,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    double *c,
    const ptrdiff_t *ldc,
    const double *d,
    const ptrdiff_t *ldd,
    const double *e,
    const ptrdiff_t *lde,
    double *f,
    const ptrdiff_t *ldf,
    double *scale,
    double *rdsum,
    double *rdscal,
    ptrdiff_t *info
);

/* Source: ztgsyl.f */
#define ztgsyl FORTRAN_WRAPPER(ztgsyl)
extern void ztgsyl(
    const char   *trans,
    const ptrdiff_t *ijob,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    double *c,
    const ptrdiff_t *ldc,
    const double *d,
    const ptrdiff_t *ldd,
    const double *e,
    const ptrdiff_t *lde,
    double *f,
    const ptrdiff_t *ldf,
    double *scale,
    double *dif,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: ztpcon.f */
#define ztpcon FORTRAN_WRAPPER(ztpcon)
extern void ztpcon(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const double *ap,
    double *rcond,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: ztpmqrt.f */
#define ztpmqrt FORTRAN_WRAPPER(ztpmqrt)
extern void ztpmqrt(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const ptrdiff_t *nb,
    const double *v,
    const ptrdiff_t *ldv,
    const double *t,
    const ptrdiff_t *ldt,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *work,
    ptrdiff_t *info
);

/* Source: ztpqrt.f */
#define ztpqrt FORTRAN_WRAPPER(ztpqrt)
extern void ztpqrt(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    const ptrdiff_t *nb,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *t,
    const ptrdiff_t *ldt,
    const double *work,
    ptrdiff_t *info
);

/* Source: ztpqrt2.f */
#define ztpqrt2 FORTRAN_WRAPPER(ztpqrt2)
extern void ztpqrt2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *l,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *t,
    const ptrdiff_t *ldt,
    ptrdiff_t *info
);

/* Source: ztprfb.f */
#define ztprfb FORTRAN_WRAPPER(ztprfb)
extern void ztprfb(
    const char   *side,
    const char   *trans,
    const char   *direct,
    const char   *storev,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const double *v,
    const ptrdiff_t *ldv,
    const double *t,
    const ptrdiff_t *ldt,
    double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    double *work,
    const ptrdiff_t *ldwork
);

/* Source: ztprfs.f */
#define ztprfs FORTRAN_WRAPPER(ztprfs)
extern void ztprfs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    const double *b,
    const ptrdiff_t *ldb,
    const double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: ztptri.f */
#define ztptri FORTRAN_WRAPPER(ztptri)
extern void ztptri(
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    double *ap,
    ptrdiff_t *info
);

/* Source: ztptrs.f */
#define ztptrs FORTRAN_WRAPPER(ztptrs)
extern void ztptrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *ap,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: ztpttf.f */
#define ztpttf FORTRAN_WRAPPER(ztpttf)
extern void ztpttf(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    double *arf,
    ptrdiff_t *info
);

/* Source: ztpttr.f */
#define ztpttr FORTRAN_WRAPPER(ztpttr)
extern void ztpttr(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: ztrcon.f */
#define ztrcon FORTRAN_WRAPPER(ztrcon)
extern void ztrcon(
    const char   *norm,
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *rcond,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: ztrevc.f */
#define ztrevc FORTRAN_WRAPPER(ztrevc)
extern void ztrevc(
    const char   *side,
    const char   *howmny,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    double *t,
    const ptrdiff_t *ldt,
    double *vl,
    const ptrdiff_t *ldvl,
    double *vr,
    const ptrdiff_t *ldvr,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: ztrexc.f */
#define ztrexc FORTRAN_WRAPPER(ztrexc)
extern void ztrexc(
    const char   *compq,
    const ptrdiff_t *n,
    double *t,
    const ptrdiff_t *ldt,
    double *q,
    const ptrdiff_t *ldq,
    const ptrdiff_t *ifst,
    const ptrdiff_t *ilst,
    ptrdiff_t *info
);

/* Source: ztrrfs.f */
#define ztrrfs FORTRAN_WRAPPER(ztrrfs)
extern void ztrrfs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *x,
    const ptrdiff_t *ldx,
    double *ferr,
    double *berr,
    double *work,
    double *rwork,
    ptrdiff_t *info
);

/* Source: ztrsen.f */
#define ztrsen FORTRAN_WRAPPER(ztrsen)
extern void ztrsen(
    const char   *job,
    const char   *compq,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    double *t,
    const ptrdiff_t *ldt,
    double *q,
    const ptrdiff_t *ldq,
    double *w,
    ptrdiff_t *m,
    double *s,
    double *sep,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: ztrsna.f */
#define ztrsna FORTRAN_WRAPPER(ztrsna)
extern void ztrsna(
    const char   *job,
    const char   *howmny,
    const ptrdiff_t *select,
    const ptrdiff_t *n,
    const double *t,
    const ptrdiff_t *ldt,
    const double *vl,
    const ptrdiff_t *ldvl,
    const double *vr,
    const ptrdiff_t *ldvr,
    double *s,
    double *sep,
    const ptrdiff_t *mm,
    ptrdiff_t *m,
    double *work,
    const ptrdiff_t *ldwork,
    double *rwork,
    ptrdiff_t *info
);

/* Source: ztrsyl.f */
#define ztrsyl FORTRAN_WRAPPER(ztrsyl)
extern void ztrsyl(
    const char   *trana,
    const char   *tranb,
    const ptrdiff_t *isgn,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    double *c,
    const ptrdiff_t *ldc,
    double *scale,
    ptrdiff_t *info
);

/* Source: ztrti2.f */
#define ztrti2 FORTRAN_WRAPPER(ztrti2)
extern void ztrti2(
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: ztrtri.f */
#define ztrtri FORTRAN_WRAPPER(ztrtri)
extern void ztrtri(
    const char   *uplo,
    const char   *diag,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    ptrdiff_t *info
);

/* Source: ztrtrs.f */
#define ztrtrs FORTRAN_WRAPPER(ztrtrs)
extern void ztrtrs(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *nrhs,
    const double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb,
    ptrdiff_t *info
);

/* Source: ztrttf.f */
#define ztrttf FORTRAN_WRAPPER(ztrttf)
extern void ztrttf(
    const char   *transr,
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *arf,
    ptrdiff_t *info
);

/* Source: ztrttp.f */
#define ztrttp FORTRAN_WRAPPER(ztrttp)
extern void ztrttp(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *ap,
    ptrdiff_t *info
);

/* Source: ztzrqf.f */
#define ztzrqf FORTRAN_WRAPPER(ztzrqf)
extern void ztzrqf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    ptrdiff_t *info
);

/* Source: ztzrzf.f */
#define ztzrzf FORTRAN_WRAPPER(ztzrzf)
extern void ztzrzf(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zunbdb.f */
#define zunbdb FORTRAN_WRAPPER(zunbdb)
extern void zunbdb(
    const char   *trans,
    const char   *signs,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *q,
    double *x11,
    const ptrdiff_t *ldx11,
    double *x12,
    const ptrdiff_t *ldx12,
    double *x21,
    const ptrdiff_t *ldx21,
    double *x22,
    const ptrdiff_t *ldx22,
    double *theta,
    double *phi,
    double *taup1,
    double *taup2,
    double *tauq1,
    double *tauq2,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zuncsd.f */
#define zuncsd FORTRAN_WRAPPER(zuncsd)
extern void zuncsd(
    const char   *jobu1,
    const char   *jobu2,
    const char   *jobv1t,
    const char   *jobv2t,
    const char   *trans,
    const char   *signs,
    const ptrdiff_t *m,
    const ptrdiff_t *p,
    const ptrdiff_t *q,
    double *x11,
    const ptrdiff_t *ldx11,
    double *x12,
    const ptrdiff_t *ldx12,
    double *x21,
    const ptrdiff_t *ldx21,
    double *x22,
    const ptrdiff_t *ldx22,
    double *theta,
    double *u1,
    const ptrdiff_t *ldu1,
    double *u2,
    const ptrdiff_t *ldu2,
    double *v1t,
    const ptrdiff_t *ldv1t,
    double *v2t,
    const ptrdiff_t *ldv2t,
    double *work,
    const ptrdiff_t *lwork,
    double *rwork,
    const ptrdiff_t *lrwork,
    ptrdiff_t *iwork,
    ptrdiff_t *info
);

/* Source: zung2l.f */
#define zung2l FORTRAN_WRAPPER(zung2l)
extern void zung2l(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: zung2r.f */
#define zung2r FORTRAN_WRAPPER(zung2r)
extern void zung2r(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: zungbr.f */
#define zungbr FORTRAN_WRAPPER(zungbr)
extern void zungbr(
    const char   *vect,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zunghr.f */
#define zunghr FORTRAN_WRAPPER(zunghr)
extern void zunghr(
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zungl2.f */
#define zungl2 FORTRAN_WRAPPER(zungl2)
extern void zungl2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: zunglq.f */
#define zunglq FORTRAN_WRAPPER(zunglq)
extern void zunglq(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zungql.f */
#define zungql FORTRAN_WRAPPER(zungql)
extern void zungql(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zungqr.f */
#define zungqr FORTRAN_WRAPPER(zungqr)
extern void zungqr(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zungr2.f */
#define zungr2 FORTRAN_WRAPPER(zungr2)
extern void zungr2(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    ptrdiff_t *info
);

/* Source: zungrq.f */
#define zungrq FORTRAN_WRAPPER(zungrq)
extern void zungrq(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zungtr.f */
#define zungtr FORTRAN_WRAPPER(zungtr)
extern void zungtr(
    const char   *uplo,
    const ptrdiff_t *n,
    double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zunm2l.f */
#define zunm2l FORTRAN_WRAPPER(zunm2l)
extern void zunm2l(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: zunm2r.f */
#define zunm2r FORTRAN_WRAPPER(zunm2r)
extern void zunm2r(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: zunmbr.f */
#define zunmbr FORTRAN_WRAPPER(zunmbr)
extern void zunmbr(
    const char   *vect,
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zunmhr.f */
#define zunmhr FORTRAN_WRAPPER(zunmhr)
extern void zunmhr(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *ilo,
    const ptrdiff_t *ihi,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zunml2.f */
#define zunml2 FORTRAN_WRAPPER(zunml2)
extern void zunml2(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: zunmlq.f */
#define zunmlq FORTRAN_WRAPPER(zunmlq)
extern void zunmlq(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zunmql.f */
#define zunmql FORTRAN_WRAPPER(zunmql)
extern void zunmql(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zunmqr.f */
#define zunmqr FORTRAN_WRAPPER(zunmqr)
extern void zunmqr(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zunmr2.f */
#define zunmr2 FORTRAN_WRAPPER(zunmr2)
extern void zunmr2(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: zunmr3.f */
#define zunmr3 FORTRAN_WRAPPER(zunmr3)
extern void zunmr3(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

/* Source: zunmrq.f */
#define zunmrq FORTRAN_WRAPPER(zunmrq)
extern void zunmrq(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zunmrz.f */
#define zunmrz FORTRAN_WRAPPER(zunmrz)
extern void zunmrz(
    const char   *side,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const ptrdiff_t *l,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zunmtr.f */
#define zunmtr FORTRAN_WRAPPER(zunmtr)
extern void zunmtr(
    const char   *side,
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    const ptrdiff_t *lwork,
    ptrdiff_t *info
);

/* Source: zupgtr.f */
#define zupgtr FORTRAN_WRAPPER(zupgtr)
extern void zupgtr(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *ap,
    const double *tau,
    double *q,
    const ptrdiff_t *ldq,
    double *work,
    ptrdiff_t *info
);

/* Source: zupmtr.f */
#define zupmtr FORTRAN_WRAPPER(zupmtr)
extern void zupmtr(
    const char   *side,
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *ap,
    const double *tau,
    double *c,
    const ptrdiff_t *ldc,
    double *work,
    ptrdiff_t *info
);

#endif /* !defined(MW_HAVE_LAPACK_DECLS) && defined(_LAPACKE_H_) %#ok */
#ifdef __cplusplus
    }   /* extern "C" */
#endif

#endif /* mllapack_h */
