/*
 * Copyright 1984-2012 The MathWorks, Inc.
 * All Rights Reserved.
 */

/*
 *  Header File include/refblas.h
 *  Auto generated by f2h.pl, do not modify by hand
 */

#if defined(_MSC_VER)
# pragma once
#endif
#if defined(__GNUC__) && (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ > 3))
# pragma once
#endif

#ifndef refblas_h
#define refblas_h

#if defined(_WIN32) || defined(__hpux)
#define FORTRAN_WRAPPER(x) x
#else
#define FORTRAN_WRAPPER(x) x ## _
#endif

#ifndef COMPLEX_TYPES
#define COMPLEX_TYPES
  typedef struct{float r,i;} complex;
  typedef struct{double r,i;} doublecomplex;
#endif

#ifdef __cplusplus
    extern "C" {
#endif


/* Source: caxpy.f */
#define caxpy FORTRAN_WRAPPER(caxpy)
extern void caxpy(
    const ptrdiff_t *n,
    const float  *ca,
    const float  *cx,
    const ptrdiff_t *incx,
    float  *cy,
    const ptrdiff_t *incy
);

/* Source: ccopy.f */
#define ccopy FORTRAN_WRAPPER(ccopy)
extern void ccopy(
    const ptrdiff_t *n,
    const float  *cx,
    const ptrdiff_t *incx,
    float  *cy,
    const ptrdiff_t *incy
);

/* Source: cdotc.f */
#define cdotc FORTRAN_WRAPPER(cdotc)
#ifndef FORTRAN_COMPLEX_FUNCTIONS_RETURN_VOID
extern complex cdotc(
#else
extern void cdotc(
    complex* retval,
#endif 
    const ptrdiff_t *n,
    const float  *cx,
    const ptrdiff_t *incx,
    const float  *cy,
    const ptrdiff_t *incy
);

/* Source: cdotu.f */
#define cdotu FORTRAN_WRAPPER(cdotu)
#ifndef FORTRAN_COMPLEX_FUNCTIONS_RETURN_VOID
extern complex cdotu(
#else
extern void cdotu(
    complex* retval,
#endif 
    const ptrdiff_t *n,
    const float  *cx,
    const ptrdiff_t *incx,
    const float  *cy,
    const ptrdiff_t *incy
);

/* Source: cgbmv.f */
#define cgbmv FORTRAN_WRAPPER(cgbmv)
extern void cgbmv(
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *beta,
    float  *y,
    const ptrdiff_t *incy
);

/* Source: cgemm.f */
#define cgemm FORTRAN_WRAPPER(cgemm)
extern void cgemm(
    const char   *transa,
    const char   *transb,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *beta,
    float  *c,
    const ptrdiff_t *ldc
);

/* Source: cgemv.f */
#define cgemv FORTRAN_WRAPPER(cgemv)
extern void cgemv(
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *beta,
    float  *y,
    const ptrdiff_t *incy
);

/* Source: cgerc.f */
#define cgerc FORTRAN_WRAPPER(cgerc)
extern void cgerc(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *y,
    const ptrdiff_t *incy,
    float  *a,
    const ptrdiff_t *lda
);

/* Source: cgeru.f */
#define cgeru FORTRAN_WRAPPER(cgeru)
extern void cgeru(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *y,
    const ptrdiff_t *incy,
    float  *a,
    const ptrdiff_t *lda
);

/* Source: chbmv.f */
#define chbmv FORTRAN_WRAPPER(chbmv)
extern void chbmv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *beta,
    float  *y,
    const ptrdiff_t *incy
);

/* Source: chemm.f */
#define chemm FORTRAN_WRAPPER(chemm)
extern void chemm(
    const char   *side,
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *beta,
    float  *c,
    const ptrdiff_t *ldc
);

/* Source: chemv.f */
#define chemv FORTRAN_WRAPPER(chemv)
extern void chemv(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *beta,
    float  *y,
    const ptrdiff_t *incy
);

/* Source: cher.f */
#define cher FORTRAN_WRAPPER(cher)
extern void cher(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *x,
    const ptrdiff_t *incx,
    float  *a,
    const ptrdiff_t *lda
);

/* Source: cher2.f */
#define cher2 FORTRAN_WRAPPER(cher2)
extern void cher2(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *y,
    const ptrdiff_t *incy,
    float  *a,
    const ptrdiff_t *lda
);

/* Source: cher2k.f */
#define cher2k FORTRAN_WRAPPER(cher2k)
extern void cher2k(
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *beta,
    float  *c,
    const ptrdiff_t *ldc
);

/* Source: cherk.f */
#define cherk FORTRAN_WRAPPER(cherk)
extern void cherk(
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *beta,
    float  *c,
    const ptrdiff_t *ldc
);

/* Source: chpmv.f */
#define chpmv FORTRAN_WRAPPER(chpmv)
extern void chpmv(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *ap,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *beta,
    float  *y,
    const ptrdiff_t *incy
);

/* Source: chpr.f */
#define chpr FORTRAN_WRAPPER(chpr)
extern void chpr(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *x,
    const ptrdiff_t *incx,
    float  *ap
);

/* Source: chpr2.f */
#define chpr2 FORTRAN_WRAPPER(chpr2)
extern void chpr2(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *y,
    const ptrdiff_t *incy,
    float  *ap
);

/* Source: crotg.f */
#define crotg FORTRAN_WRAPPER(crotg)
extern void crotg(
    float  *ca,
    const float  *cb,
    float  *c,
    float  *s
);

/* Source: cscal.f */
#define cscal FORTRAN_WRAPPER(cscal)
extern void cscal(
    const ptrdiff_t *n,
    const float  *ca,
    float  *cx,
    const ptrdiff_t *incx
);

/* Source: csrot.f */
#define csrot FORTRAN_WRAPPER(csrot)
extern void csrot(
    const ptrdiff_t *n,
    float  *cx,
    const ptrdiff_t *incx,
    float  *cy,
    const ptrdiff_t *incy,
    const float  *c,
    const float  *s
);

/* Source: csscal.f */
#define csscal FORTRAN_WRAPPER(csscal)
extern void csscal(
    const ptrdiff_t *n,
    const float  *sa,
    float  *cx,
    const ptrdiff_t *incx
);

/* Source: cswap.f */
#define cswap FORTRAN_WRAPPER(cswap)
extern void cswap(
    const ptrdiff_t *n,
    float  *cx,
    const ptrdiff_t *incx,
    float  *cy,
    const ptrdiff_t *incy
);

/* Source: csymm.f */
#define csymm FORTRAN_WRAPPER(csymm)
extern void csymm(
    const char   *side,
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *beta,
    float  *c,
    const ptrdiff_t *ldc
);

/* Source: csyr2k.f */
#define csyr2k FORTRAN_WRAPPER(csyr2k)
extern void csyr2k(
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *beta,
    float  *c,
    const ptrdiff_t *ldc
);

/* Source: csyrk.f */
#define csyrk FORTRAN_WRAPPER(csyrk)
extern void csyrk(
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *beta,
    float  *c,
    const ptrdiff_t *ldc
);

/* Source: ctbmv.f */
#define ctbmv FORTRAN_WRAPPER(ctbmv)
extern void ctbmv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    float  *x,
    const ptrdiff_t *incx
);

/* Source: ctbsv.f */
#define ctbsv FORTRAN_WRAPPER(ctbsv)
extern void ctbsv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    float  *x,
    const ptrdiff_t *incx
);

/* Source: ctpmv.f */
#define ctpmv FORTRAN_WRAPPER(ctpmv)
extern void ctpmv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const float  *ap,
    float  *x,
    const ptrdiff_t *incx
);

/* Source: ctpsv.f */
#define ctpsv FORTRAN_WRAPPER(ctpsv)
extern void ctpsv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const float  *ap,
    float  *x,
    const ptrdiff_t *incx
);

/* Source: ctrmm.f */
#define ctrmm FORTRAN_WRAPPER(ctrmm)
extern void ctrmm(
    const char   *side,
    const char   *uplo,
    const char   *transa,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb
);

/* Source: ctrmv.f */
#define ctrmv FORTRAN_WRAPPER(ctrmv)
extern void ctrmv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *x,
    const ptrdiff_t *incx
);

/* Source: ctrsm.f */
#define ctrsm FORTRAN_WRAPPER(ctrsm)
extern void ctrsm(
    const char   *side,
    const char   *uplo,
    const char   *transa,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb
);

/* Source: ctrsv.f */
#define ctrsv FORTRAN_WRAPPER(ctrsv)
extern void ctrsv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *x,
    const ptrdiff_t *incx
);

/* Source: dasum.f */
#define dasum FORTRAN_WRAPPER(dasum)
extern double dasum(
    const ptrdiff_t *n,
    const double *dx,
    const ptrdiff_t *incx
);

/* Source: daxpy.f */
#define daxpy FORTRAN_WRAPPER(daxpy)
extern void daxpy(
    const ptrdiff_t *n,
    const double *da,
    const double *dx,
    const ptrdiff_t *incx,
    double *dy,
    const ptrdiff_t *incy
);

/* Source: dcabs1.f */
#define dcabs1 FORTRAN_WRAPPER(dcabs1)
extern double dcabs1(
    const double *z
);

/* Source: dcopy.f */
#define dcopy FORTRAN_WRAPPER(dcopy)
extern void dcopy(
    const ptrdiff_t *n,
    const double *dx,
    const ptrdiff_t *incx,
    double *dy,
    const ptrdiff_t *incy
);

/* Source: ddot.f */
#define ddot FORTRAN_WRAPPER(ddot)
extern double ddot(
    const ptrdiff_t *n,
    const double *dx,
    const ptrdiff_t *incx,
    const double *dy,
    const ptrdiff_t *incy
);

/* Source: dgbmv.f */
#define dgbmv FORTRAN_WRAPPER(dgbmv)
extern void dgbmv(
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *x,
    const ptrdiff_t *incx,
    const double *beta,
    double *y,
    const ptrdiff_t *incy
);

/* Source: dgemm.f */
#define dgemm FORTRAN_WRAPPER(dgemm)
extern void dgemm(
    const char   *transa,
    const char   *transb,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *beta,
    double *c,
    const ptrdiff_t *ldc
);

/* Source: dgemv.f */
#define dgemv FORTRAN_WRAPPER(dgemv)
extern void dgemv(
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *x,
    const ptrdiff_t *incx,
    const double *beta,
    double *y,
    const ptrdiff_t *incy
);

/* Source: dger.f */
#define dger FORTRAN_WRAPPER(dger)
extern void dger(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *x,
    const ptrdiff_t *incx,
    const double *y,
    const ptrdiff_t *incy,
    double *a,
    const ptrdiff_t *lda
);

/* Source: dnrm2.f */
#define dnrm2 FORTRAN_WRAPPER(dnrm2)
extern double dnrm2(
    const ptrdiff_t *n,
    const double *x,
    const ptrdiff_t *incx
);

/* Source: drot.f */
#define drot FORTRAN_WRAPPER(drot)
extern void drot(
    const ptrdiff_t *n,
    double *dx,
    const ptrdiff_t *incx,
    double *dy,
    const ptrdiff_t *incy,
    const double *c,
    const double *s
);

/* Source: drotg.f */
#define drotg FORTRAN_WRAPPER(drotg)
extern void drotg(
    double *da,
    double *db,
    double *c,
    double *s
);

/* Source: drotm.f */
#define drotm FORTRAN_WRAPPER(drotm)
extern void drotm(
    const ptrdiff_t *n,
    double *dx,
    const ptrdiff_t *incx,
    double *dy,
    const ptrdiff_t *incy,
    const double *dparam
);

/* Source: drotmg.f */
#define drotmg FORTRAN_WRAPPER(drotmg)
extern void drotmg(
    double *dd1,
    double *dd2,
    double *dx1,
    const double *dy1,
    double *dparam
);

/* Source: dsbmv.f */
#define dsbmv FORTRAN_WRAPPER(dsbmv)
extern void dsbmv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *x,
    const ptrdiff_t *incx,
    const double *beta,
    double *y,
    const ptrdiff_t *incy
);

/* Source: dscal.f */
#define dscal FORTRAN_WRAPPER(dscal)
extern void dscal(
    const ptrdiff_t *n,
    const double *da,
    double *dx,
    const ptrdiff_t *incx
);

/* Source: dsdot.f */
#define dsdot FORTRAN_WRAPPER(dsdot)
extern double dsdot(
    const ptrdiff_t *n,
    const float  *sx,
    const ptrdiff_t *incx,
    const float  *sy,
    const ptrdiff_t *incy
);

/* Source: dspmv.f */
#define dspmv FORTRAN_WRAPPER(dspmv)
extern void dspmv(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *ap,
    const double *x,
    const ptrdiff_t *incx,
    const double *beta,
    double *y,
    const ptrdiff_t *incy
);

/* Source: dspr.f */
#define dspr FORTRAN_WRAPPER(dspr)
extern void dspr(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *x,
    const ptrdiff_t *incx,
    double *ap
);

/* Source: dspr2.f */
#define dspr2 FORTRAN_WRAPPER(dspr2)
extern void dspr2(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *x,
    const ptrdiff_t *incx,
    const double *y,
    const ptrdiff_t *incy,
    double *ap
);

/* Source: dswap.f */
#define dswap FORTRAN_WRAPPER(dswap)
extern void dswap(
    const ptrdiff_t *n,
    double *dx,
    const ptrdiff_t *incx,
    double *dy,
    const ptrdiff_t *incy
);

/* Source: dsymm.f */
#define dsymm FORTRAN_WRAPPER(dsymm)
extern void dsymm(
    const char   *side,
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *beta,
    double *c,
    const ptrdiff_t *ldc
);

/* Source: dsymv.f */
#define dsymv FORTRAN_WRAPPER(dsymv)
extern void dsymv(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *x,
    const ptrdiff_t *incx,
    const double *beta,
    double *y,
    const ptrdiff_t *incy
);

/* Source: dsyr.f */
#define dsyr FORTRAN_WRAPPER(dsyr)
extern void dsyr(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *x,
    const ptrdiff_t *incx,
    double *a,
    const ptrdiff_t *lda
);

/* Source: dsyr2.f */
#define dsyr2 FORTRAN_WRAPPER(dsyr2)
extern void dsyr2(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *x,
    const ptrdiff_t *incx,
    const double *y,
    const ptrdiff_t *incy,
    double *a,
    const ptrdiff_t *lda
);

/* Source: dsyr2k.f */
#define dsyr2k FORTRAN_WRAPPER(dsyr2k)
extern void dsyr2k(
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *beta,
    double *c,
    const ptrdiff_t *ldc
);

/* Source: dsyrk.f */
#define dsyrk FORTRAN_WRAPPER(dsyrk)
extern void dsyrk(
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *beta,
    double *c,
    const ptrdiff_t *ldc
);

/* Source: dtbmv.f */
#define dtbmv FORTRAN_WRAPPER(dtbmv)
extern void dtbmv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    double *x,
    const ptrdiff_t *incx
);

/* Source: dtbsv.f */
#define dtbsv FORTRAN_WRAPPER(dtbsv)
extern void dtbsv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    double *x,
    const ptrdiff_t *incx
);

/* Source: dtpmv.f */
#define dtpmv FORTRAN_WRAPPER(dtpmv)
extern void dtpmv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const double *ap,
    double *x,
    const ptrdiff_t *incx
);

/* Source: dtpsv.f */
#define dtpsv FORTRAN_WRAPPER(dtpsv)
extern void dtpsv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const double *ap,
    double *x,
    const ptrdiff_t *incx
);

/* Source: dtrmm.f */
#define dtrmm FORTRAN_WRAPPER(dtrmm)
extern void dtrmm(
    const char   *side,
    const char   *uplo,
    const char   *transa,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb
);

/* Source: dtrmv.f */
#define dtrmv FORTRAN_WRAPPER(dtrmv)
extern void dtrmv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *x,
    const ptrdiff_t *incx
);

/* Source: dtrsm.f */
#define dtrsm FORTRAN_WRAPPER(dtrsm)
extern void dtrsm(
    const char   *side,
    const char   *uplo,
    const char   *transa,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb
);

/* Source: dtrsv.f */
#define dtrsv FORTRAN_WRAPPER(dtrsv)
extern void dtrsv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *x,
    const ptrdiff_t *incx
);

/* Source: dzasum.f */
#define dzasum FORTRAN_WRAPPER(dzasum)
extern double dzasum(
    const ptrdiff_t *n,
    const double *zx,
    const ptrdiff_t *incx
);

/* Source: dznrm2.f */
#define dznrm2 FORTRAN_WRAPPER(dznrm2)
extern double dznrm2(
    const ptrdiff_t *n,
    const double *x,
    const ptrdiff_t *incx
);

/* Source: icamax.f */
#define icamax FORTRAN_WRAPPER(icamax)
extern ptrdiff_t icamax(
    const ptrdiff_t *n,
    const float  *cx,
    const ptrdiff_t *incx
);

/* Source: idamax.f */
#define idamax FORTRAN_WRAPPER(idamax)
extern ptrdiff_t idamax(
    const ptrdiff_t *n,
    const double *dx,
    const ptrdiff_t *incx
);

/* Source: isamax.f */
#define isamax FORTRAN_WRAPPER(isamax)
extern ptrdiff_t isamax(
    const ptrdiff_t *n,
    const float  *sx,
    const ptrdiff_t *incx
);

/* Source: izamax.f */
#define izamax FORTRAN_WRAPPER(izamax)
extern ptrdiff_t izamax(
    const ptrdiff_t *n,
    const double *zx,
    const ptrdiff_t *incx
);

/* Source: lsame.f */
#define lsame FORTRAN_WRAPPER(lsame)
extern ptrdiff_t lsame(
    const char   *ca,
    const char   *cb
);

/* Source: sasum.f */
#define sasum FORTRAN_WRAPPER(sasum)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double sasum(
#else
extern float sasum(
#endif 
    const ptrdiff_t *n,
    const float  *sx,
    const ptrdiff_t *incx
);

/* Source: saxpy.f */
#define saxpy FORTRAN_WRAPPER(saxpy)
extern void saxpy(
    const ptrdiff_t *n,
    const float  *sa,
    const float  *sx,
    const ptrdiff_t *incx,
    float  *sy,
    const ptrdiff_t *incy
);

/* Source: scasum.f */
#define scasum FORTRAN_WRAPPER(scasum)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double scasum(
#else
extern float scasum(
#endif 
    const ptrdiff_t *n,
    const float  *cx,
    const ptrdiff_t *incx
);

/* Source: scnrm2.f */
#define scnrm2 FORTRAN_WRAPPER(scnrm2)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double scnrm2(
#else
extern float scnrm2(
#endif 
    const ptrdiff_t *n,
    const float  *x,
    const ptrdiff_t *incx
);

/* Source: scopy.f */
#define scopy FORTRAN_WRAPPER(scopy)
extern void scopy(
    const ptrdiff_t *n,
    const float  *sx,
    const ptrdiff_t *incx,
    float  *sy,
    const ptrdiff_t *incy
);

/* Source: sdot.f */
#define sdot FORTRAN_WRAPPER(sdot)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double sdot(
#else
extern float sdot(
#endif 
    const ptrdiff_t *n,
    const float  *sx,
    const ptrdiff_t *incx,
    const float  *sy,
    const ptrdiff_t *incy
);

/* Source: sdsdot.f */
#define sdsdot FORTRAN_WRAPPER(sdsdot)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double sdsdot(
#else
extern float sdsdot(
#endif 
    const ptrdiff_t *n,
    const float  *sb,
    const float  *sx,
    const ptrdiff_t *incx,
    const float  *sy,
    const ptrdiff_t *incy
);

/* Source: sgbmv.f */
#define sgbmv FORTRAN_WRAPPER(sgbmv)
extern void sgbmv(
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *beta,
    float  *y,
    const ptrdiff_t *incy
);

/* Source: sgemm.f */
#define sgemm FORTRAN_WRAPPER(sgemm)
extern void sgemm(
    const char   *transa,
    const char   *transb,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *beta,
    float  *c,
    const ptrdiff_t *ldc
);

/* Source: sgemv.f */
#define sgemv FORTRAN_WRAPPER(sgemv)
extern void sgemv(
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *beta,
    float  *y,
    const ptrdiff_t *incy
);

/* Source: sger.f */
#define sger FORTRAN_WRAPPER(sger)
extern void sger(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *y,
    const ptrdiff_t *incy,
    float  *a,
    const ptrdiff_t *lda
);

/* Source: snrm2.f */
#define snrm2 FORTRAN_WRAPPER(snrm2)
#ifdef FORTRAN_FLOAT_FUNCTIONS_RETURN_DOUBLE
extern double snrm2(
#else
extern float snrm2(
#endif 
    const ptrdiff_t *n,
    const float  *x,
    const ptrdiff_t *incx
);

/* Source: srot.f */
#define srot FORTRAN_WRAPPER(srot)
extern void srot(
    const ptrdiff_t *n,
    float  *sx,
    const ptrdiff_t *incx,
    float  *sy,
    const ptrdiff_t *incy,
    const float  *c,
    const float  *s
);

/* Source: srotg.f */
#define srotg FORTRAN_WRAPPER(srotg)
extern void srotg(
    float  *sa,
    float  *sb,
    float  *c,
    float  *s
);

/* Source: srotm.f */
#define srotm FORTRAN_WRAPPER(srotm)
extern void srotm(
    const ptrdiff_t *n,
    float  *sx,
    const ptrdiff_t *incx,
    float  *sy,
    const ptrdiff_t *incy,
    const float  *sparam
);

/* Source: srotmg.f */
#define srotmg FORTRAN_WRAPPER(srotmg)
extern void srotmg(
    float  *sd1,
    float  *sd2,
    float  *sx1,
    const float  *sy1,
    float  *sparam
);

/* Source: ssbmv.f */
#define ssbmv FORTRAN_WRAPPER(ssbmv)
extern void ssbmv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *beta,
    float  *y,
    const ptrdiff_t *incy
);

/* Source: sscal.f */
#define sscal FORTRAN_WRAPPER(sscal)
extern void sscal(
    const ptrdiff_t *n,
    const float  *sa,
    float  *sx,
    const ptrdiff_t *incx
);

/* Source: sspmv.f */
#define sspmv FORTRAN_WRAPPER(sspmv)
extern void sspmv(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *ap,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *beta,
    float  *y,
    const ptrdiff_t *incy
);

/* Source: sspr.f */
#define sspr FORTRAN_WRAPPER(sspr)
extern void sspr(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *x,
    const ptrdiff_t *incx,
    float  *ap
);

/* Source: sspr2.f */
#define sspr2 FORTRAN_WRAPPER(sspr2)
extern void sspr2(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *y,
    const ptrdiff_t *incy,
    float  *ap
);

/* Source: sswap.f */
#define sswap FORTRAN_WRAPPER(sswap)
extern void sswap(
    const ptrdiff_t *n,
    float  *sx,
    const ptrdiff_t *incx,
    float  *sy,
    const ptrdiff_t *incy
);

/* Source: ssymm.f */
#define ssymm FORTRAN_WRAPPER(ssymm)
extern void ssymm(
    const char   *side,
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *beta,
    float  *c,
    const ptrdiff_t *ldc
);

/* Source: ssymv.f */
#define ssymv FORTRAN_WRAPPER(ssymv)
extern void ssymv(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *beta,
    float  *y,
    const ptrdiff_t *incy
);

/* Source: ssyr.f */
#define ssyr FORTRAN_WRAPPER(ssyr)
extern void ssyr(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *x,
    const ptrdiff_t *incx,
    float  *a,
    const ptrdiff_t *lda
);

/* Source: ssyr2.f */
#define ssyr2 FORTRAN_WRAPPER(ssyr2)
extern void ssyr2(
    const char   *uplo,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *x,
    const ptrdiff_t *incx,
    const float  *y,
    const ptrdiff_t *incy,
    float  *a,
    const ptrdiff_t *lda
);

/* Source: ssyr2k.f */
#define ssyr2k FORTRAN_WRAPPER(ssyr2k)
extern void ssyr2k(
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *b,
    const ptrdiff_t *ldb,
    const float  *beta,
    float  *c,
    const ptrdiff_t *ldc
);

/* Source: ssyrk.f */
#define ssyrk FORTRAN_WRAPPER(ssyrk)
extern void ssyrk(
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    const float  *beta,
    float  *c,
    const ptrdiff_t *ldc
);

/* Source: stbmv.f */
#define stbmv FORTRAN_WRAPPER(stbmv)
extern void stbmv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    float  *x,
    const ptrdiff_t *incx
);

/* Source: stbsv.f */
#define stbsv FORTRAN_WRAPPER(stbsv)
extern void stbsv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const float  *a,
    const ptrdiff_t *lda,
    float  *x,
    const ptrdiff_t *incx
);

/* Source: stpmv.f */
#define stpmv FORTRAN_WRAPPER(stpmv)
extern void stpmv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const float  *ap,
    float  *x,
    const ptrdiff_t *incx
);

/* Source: stpsv.f */
#define stpsv FORTRAN_WRAPPER(stpsv)
extern void stpsv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const float  *ap,
    float  *x,
    const ptrdiff_t *incx
);

/* Source: strmm.f */
#define strmm FORTRAN_WRAPPER(strmm)
extern void strmm(
    const char   *side,
    const char   *uplo,
    const char   *transa,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb
);

/* Source: strmv.f */
#define strmv FORTRAN_WRAPPER(strmv)
extern void strmv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *x,
    const ptrdiff_t *incx
);

/* Source: strsm.f */
#define strsm FORTRAN_WRAPPER(strsm)
extern void strsm(
    const char   *side,
    const char   *uplo,
    const char   *transa,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const float  *alpha,
    const float  *a,
    const ptrdiff_t *lda,
    float  *b,
    const ptrdiff_t *ldb
);

/* Source: strsv.f */
#define strsv FORTRAN_WRAPPER(strsv)
extern void strsv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const float  *a,
    const ptrdiff_t *lda,
    float  *x,
    const ptrdiff_t *incx
);

/* Source: xerbla.f */
#define xerbla FORTRAN_WRAPPER(xerbla)
extern void xerbla(
    const char   *srname,
    const ptrdiff_t *info
);

/* Source: zaxpy.f */
#define zaxpy FORTRAN_WRAPPER(zaxpy)
extern void zaxpy(
    const ptrdiff_t *n,
    const double *za,
    const double *zx,
    const ptrdiff_t *incx,
    double *zy,
    const ptrdiff_t *incy
);

/* Source: zcopy.f */
#define zcopy FORTRAN_WRAPPER(zcopy)
extern void zcopy(
    const ptrdiff_t *n,
    const double *zx,
    const ptrdiff_t *incx,
    double *zy,
    const ptrdiff_t *incy
);

/* Source: zdotc.f */
#define zdotc FORTRAN_WRAPPER(zdotc)
#ifndef FORTRAN_COMPLEX_FUNCTIONS_RETURN_VOID
extern doublecomplex zdotc(
#else
extern void zdotc(
    doublecomplex* retval,
#endif 
    const ptrdiff_t *n,
    const double *zx,
    const ptrdiff_t *incx,
    const double *zy,
    const ptrdiff_t *incy
);

/* Source: zdotu.f */
#define zdotu FORTRAN_WRAPPER(zdotu)
#ifndef FORTRAN_COMPLEX_FUNCTIONS_RETURN_VOID
extern doublecomplex zdotu(
#else
extern void zdotu(
    doublecomplex* retval,
#endif 
    const ptrdiff_t *n,
    const double *zx,
    const ptrdiff_t *incx,
    const double *zy,
    const ptrdiff_t *incy
);

/* Source: zdrot.f */
#define zdrot FORTRAN_WRAPPER(zdrot)
extern void zdrot(
    const ptrdiff_t *n,
    double *cx,
    const ptrdiff_t *incx,
    double *cy,
    const ptrdiff_t *incy,
    const double *c,
    const double *s
);

/* Source: zdscal.f */
#define zdscal FORTRAN_WRAPPER(zdscal)
extern void zdscal(
    const ptrdiff_t *n,
    const double *da,
    double *zx,
    const ptrdiff_t *incx
);

/* Source: zgbmv.f */
#define zgbmv FORTRAN_WRAPPER(zgbmv)
extern void zgbmv(
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *kl,
    const ptrdiff_t *ku,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *x,
    const ptrdiff_t *incx,
    const double *beta,
    double *y,
    const ptrdiff_t *incy
);

/* Source: zgemm.f */
#define zgemm FORTRAN_WRAPPER(zgemm)
extern void zgemm(
    const char   *transa,
    const char   *transb,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *beta,
    double *c,
    const ptrdiff_t *ldc
);

/* Source: zgemv.f */
#define zgemv FORTRAN_WRAPPER(zgemv)
extern void zgemv(
    const char   *trans,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *x,
    const ptrdiff_t *incx,
    const double *beta,
    double *y,
    const ptrdiff_t *incy
);

/* Source: zgerc.f */
#define zgerc FORTRAN_WRAPPER(zgerc)
extern void zgerc(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *x,
    const ptrdiff_t *incx,
    const double *y,
    const ptrdiff_t *incy,
    double *a,
    const ptrdiff_t *lda
);

/* Source: zgeru.f */
#define zgeru FORTRAN_WRAPPER(zgeru)
extern void zgeru(
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *x,
    const ptrdiff_t *incx,
    const double *y,
    const ptrdiff_t *incy,
    double *a,
    const ptrdiff_t *lda
);

/* Source: zhbmv.f */
#define zhbmv FORTRAN_WRAPPER(zhbmv)
extern void zhbmv(
    const char   *uplo,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *x,
    const ptrdiff_t *incx,
    const double *beta,
    double *y,
    const ptrdiff_t *incy
);

/* Source: zhemm.f */
#define zhemm FORTRAN_WRAPPER(zhemm)
extern void zhemm(
    const char   *side,
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *beta,
    double *c,
    const ptrdiff_t *ldc
);

/* Source: zhemv.f */
#define zhemv FORTRAN_WRAPPER(zhemv)
extern void zhemv(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *x,
    const ptrdiff_t *incx,
    const double *beta,
    double *y,
    const ptrdiff_t *incy
);

/* Source: zher.f */
#define zher FORTRAN_WRAPPER(zher)
extern void zher(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *x,
    const ptrdiff_t *incx,
    double *a,
    const ptrdiff_t *lda
);

/* Source: zher2.f */
#define zher2 FORTRAN_WRAPPER(zher2)
extern void zher2(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *x,
    const ptrdiff_t *incx,
    const double *y,
    const ptrdiff_t *incy,
    double *a,
    const ptrdiff_t *lda
);

/* Source: zher2k.f */
#define zher2k FORTRAN_WRAPPER(zher2k)
extern void zher2k(
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *beta,
    double *c,
    const ptrdiff_t *ldc
);

/* Source: zherk.f */
#define zherk FORTRAN_WRAPPER(zherk)
extern void zherk(
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *beta,
    double *c,
    const ptrdiff_t *ldc
);

/* Source: zhpmv.f */
#define zhpmv FORTRAN_WRAPPER(zhpmv)
extern void zhpmv(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *ap,
    const double *x,
    const ptrdiff_t *incx,
    const double *beta,
    double *y,
    const ptrdiff_t *incy
);

/* Source: zhpr.f */
#define zhpr FORTRAN_WRAPPER(zhpr)
extern void zhpr(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *x,
    const ptrdiff_t *incx,
    double *ap
);

/* Source: zhpr2.f */
#define zhpr2 FORTRAN_WRAPPER(zhpr2)
extern void zhpr2(
    const char   *uplo,
    const ptrdiff_t *n,
    const double *alpha,
    const double *x,
    const ptrdiff_t *incx,
    const double *y,
    const ptrdiff_t *incy,
    double *ap
);

/* Source: zrotg.f */
#define zrotg FORTRAN_WRAPPER(zrotg)
extern void zrotg(
    double *ca,
    const double *cb,
    double *c,
    double *s
);

/* Source: zscal.f */
#define zscal FORTRAN_WRAPPER(zscal)
extern void zscal(
    const ptrdiff_t *n,
    const double *za,
    double *zx,
    const ptrdiff_t *incx
);

/* Source: zswap.f */
#define zswap FORTRAN_WRAPPER(zswap)
extern void zswap(
    const ptrdiff_t *n,
    double *zx,
    const ptrdiff_t *incx,
    double *zy,
    const ptrdiff_t *incy
);

/* Source: zsymm.f */
#define zsymm FORTRAN_WRAPPER(zsymm)
extern void zsymm(
    const char   *side,
    const char   *uplo,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *beta,
    double *c,
    const ptrdiff_t *ldc
);

/* Source: zsyr2k.f */
#define zsyr2k FORTRAN_WRAPPER(zsyr2k)
extern void zsyr2k(
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *b,
    const ptrdiff_t *ldb,
    const double *beta,
    double *c,
    const ptrdiff_t *ldc
);

/* Source: zsyrk.f */
#define zsyrk FORTRAN_WRAPPER(zsyrk)
extern void zsyrk(
    const char   *uplo,
    const char   *trans,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    const double *beta,
    double *c,
    const ptrdiff_t *ldc
);

/* Source: ztbmv.f */
#define ztbmv FORTRAN_WRAPPER(ztbmv)
extern void ztbmv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    double *x,
    const ptrdiff_t *incx
);

/* Source: ztbsv.f */
#define ztbsv FORTRAN_WRAPPER(ztbsv)
extern void ztbsv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const ptrdiff_t *k,
    const double *a,
    const ptrdiff_t *lda,
    double *x,
    const ptrdiff_t *incx
);

/* Source: ztpmv.f */
#define ztpmv FORTRAN_WRAPPER(ztpmv)
extern void ztpmv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const double *ap,
    double *x,
    const ptrdiff_t *incx
);

/* Source: ztpsv.f */
#define ztpsv FORTRAN_WRAPPER(ztpsv)
extern void ztpsv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const double *ap,
    double *x,
    const ptrdiff_t *incx
);

/* Source: ztrmm.f */
#define ztrmm FORTRAN_WRAPPER(ztrmm)
extern void ztrmm(
    const char   *side,
    const char   *uplo,
    const char   *transa,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb
);

/* Source: ztrmv.f */
#define ztrmv FORTRAN_WRAPPER(ztrmv)
extern void ztrmv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *x,
    const ptrdiff_t *incx
);

/* Source: ztrsm.f */
#define ztrsm FORTRAN_WRAPPER(ztrsm)
extern void ztrsm(
    const char   *side,
    const char   *uplo,
    const char   *transa,
    const char   *diag,
    const ptrdiff_t *m,
    const ptrdiff_t *n,
    const double *alpha,
    const double *a,
    const ptrdiff_t *lda,
    double *b,
    const ptrdiff_t *ldb
);

/* Source: ztrsv.f */
#define ztrsv FORTRAN_WRAPPER(ztrsv)
extern void ztrsv(
    const char   *uplo,
    const char   *trans,
    const char   *diag,
    const ptrdiff_t *n,
    const double *a,
    const ptrdiff_t *lda,
    double *x,
    const ptrdiff_t *incx
);

#ifdef __cplusplus
    }   /* extern "C" */
#endif

#endif /* refblas_h */
