#pragma once
#include "mexToolbox.h"
#include "inputAnalyzer.h"
#include <list>
#include <algorithm> 

typedef struct field_address{
int struct_index;
const char* field_name;
int field_index;
};

class mexCellItem
{
private:
	list<field_address> * cellFieldNums;
	const mxArray * _ptr;
	int * offsets;
	void setOffsets();
	void setFieldNums();
	int getFieldNum(const char * name, int index);

public:
	mexCellItem(const mxArray *cell_array_ptr);

	double getDouble();
	double getDouble(int i);
	double getDouble(int i, int j);
	double getDouble(int i, int j, int k);
	double getDouble(int i, int j, int k, int l);
	double getDouble(int i, int j, int k, int l, int m);

	int getInt();
	int getInt(int i);
	int getInt(int i, int j);
	int getInt(int i, int j, int k);
	int getInt(int i, int j, int k, int l);
	int getInt(int i, int j, int k, int l, int m);

	mxLogical getBool();
	mxLogical getBool(int i);
	mxLogical getBool(int i, int j);
	mxLogical getBool(int i, int j, int k);
	mxLogical getBool(int i, int j, int k, int l);
	mxLogical getBool(int i, int j, int k, int l, int m);

	char * getString();

	mexCellItem * getCell();
	mexCellItem * getCell(int i);
	mexCellItem * getCell(int i, int j);
	mexCellItem * getCell(int i, int j, int k);
	mexCellItem * getCell(int i, int j, int k, int l);
	mexCellItem * getCell(int i, int j, int k, int l, int m);

	mexCellItem * getStructField(const char * fieldName);
	mexCellItem * getStructField(const char * fieldName, int i);
	mexCellItem * getStructField(const char * fieldName, int i, int j);
	mexCellItem * getStructField(const char * fieldName, int i, int j, int k);
	mexCellItem * getStructField(const char * fieldName, int i, int j, int k, int l);
	mexCellItem * getStructField(const char * fieldName, int i, int j, int k, int l, int m);

	bool checkStructFieldExists(const char * fieldName);
	bool checkStructFieldExists(const char * fieldName, int i);
	bool checkStructFieldExists(const char * fieldName, int i, int j);
	bool checkStructFieldExists(const char * fieldName, int i, int j, int k);
	bool checkStructFieldExists(const char * fieldName, int i, int j, int k, int l);
	bool checkStructFieldExists(const char * fieldName, int i, int j, int k, int l, int m);

	bool checkIndexWithinRange(int i);
	bool checkIndexWithinRange(int i, int j);
	bool checkIndexWithinRange(int i, int j, int k);
	bool checkIndexWithinRange(int i, int j, int k, int l);
	bool checkIndexWithinRange(int i, int j, int k, int l, int m);

	void analyze();
	const char* getCellClassName();
	const size_t getElemCount();
	void printOffset();

	~mexCellItem();
};

