function [] = IR_figure(dirname,shock_t,TT)

subdirname = strcat(dirname,'/t',num2str(shock_t));
load(strcat(subdirname,'/v1'));
wind=10;


%% Setting parameters
yrangeC  = [-0.06,0.01];
yrangeH = [-0.1,0.06];
yrangeL = [-0.06,0.06];
yrangeT = [-0.06,0.08];

minage = 25+shock_t - 5;
maxage = 25+shock_t + 10;
nkids  = 38;
shockt = 24+shock_t;
lwidth = 1;
msize  = 4;

lwidth_s = 2;
fontsize = 14;

%% Figure V1
C_elast  = -0.1*out(1,:)./out(wind,shock_t);
H1_elast = -0.1*out(2,:)./out(wind,shock_t);
E2_elast = -0.1*out(5,:)./out(wind,shock_t);
L1_elast = -0.1*out(6,:)./out(wind,shock_t);
L2_elast = -0.1*out(7,:)./out(wind,shock_t);
T1_elast = -0.1*out(8,:)./out(wind,shock_t);
T2_elast = -0.1*out(9,:)./out(wind,shock_t);
H2c_elast= -0.1*out(12,:)./out(wind,shock_t);

figure('visible','off');
subplot(2,2,1);
plot(linspace(25,25+TT-10,TT-10),C_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','o','markersize',msize); hold on;
plot([nkids nkids],yrangeC,'color','r','LineWidth',1);
plot([shockt shockt],yrangeC,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeC);
axis([minage maxage yrangeC]);
title('Consumption')

subplot(2,2,2);
plot(linspace(25,25+TT-10,TT-10),H1_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','x','linestyle','-.','markersize',msize); hold on;
plot(linspace(25,25+TT-10,TT-10),E2_elast(1:TT-10),'color','blue','LineWidth',lwidth,'marker','d','markersize',msize); 
plot(linspace(25,25+TT-10,TT-10),H2c_elast(1:TT-10),'color','red','LineWidth',lwidth,'marker','+','markersize',msize);
plot([nkids nkids],yrangeH,'color','r','LineWidth',1);
plot([shockt shockt],yrangeH,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeH);
axis([minage maxage yrangeH]);
title('Hours and employment')
legend('Husband','Extensive wife','Intensive wife','Location','southeast')

subplot(2,2,3);
plot(linspace(25,25+TT-10,TT-10),L2_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','o','markersize',msize); hold on;
plot(linspace(25,25+TT-10,TT-10),L1_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','x','linestyle','-.','markersize',msize); hold on;
plot([nkids nkids],yrangeL,'color','r','LineWidth',1);
plot([shockt shockt],yrangeL,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeL);
axis([minage maxage yrangeL]);
title('Leisure')
legend('Wife','Husband','Location','southeast')

subplot(2,2,4);
plot(linspace(25,25+TT-10,TT-10),T2_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','o','markersize',msize); hold on;
plot(linspace(25,25+TT-10,TT-10),T1_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','x','linestyle','-.','markersize',msize); hold on;
plot([nkids nkids],yrangeT,'color','r','LineWidth',1);
plot([shockt shockt],yrangeT,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeT);
axis([minage maxage yrangeT]);
title('Time with children')
legend('Wife','Husband','Location','southeast')

h=gcf;
set(h,'PaperOrientation','landscape');
set(h,'PaperUnits','normalized');
set(h,'PaperPosition', [0 0 1 1]);
print(gcf, '-depsc', strcat(subdirname,'/v1'));
print(gcf, '-dpdf', strcat(subdirname,'/v1_pdf'));

%% For u1
clear out
load(strcat(subdirname,'/u1'));
wind=10;

C_elast  = -0.1*out(1,:)./out(wind,shock_t);
H1_elast = -0.1*out(2,:)./out(wind,shock_t);
E2_elast = -0.1*out(5,:)./out(wind,shock_t);
L1_elast = -0.1*out(6,:)./out(wind,shock_t);
L2_elast = -0.1*out(7,:)./out(wind,shock_t);
T1_elast = -0.1*out(8,:)./out(wind,shock_t);
T2_elast = -0.1*out(9,:)./out(wind,shock_t);
H2c_elast= -0.1*out(12,:)./out(wind,shock_t);

figure('visible','off');
subplot(2,2,1);
plot(linspace(25,25+TT-10,TT-10),C_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','o','markersize',msize); hold on;
plot([nkids nkids],yrangeC,'color','r','LineWidth',1);
plot([shockt shockt],yrangeC,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeC);
axis([minage maxage yrangeC]);
title('Consumption')

subplot(2,2,2);
plot(linspace(25,25+TT-10,TT-10),H1_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','x','linestyle','-.','markersize',msize); hold on;
plot(linspace(25,25+TT-10,TT-10),E2_elast(1:TT-10),'color','blue','LineWidth',lwidth,'marker','d','markersize',msize); 
plot(linspace(25,25+TT-10,TT-10),H2c_elast(1:TT-10),'color','red','LineWidth',lwidth,'marker','+','markersize',msize);
plot([nkids nkids],yrangeH,'color','r','LineWidth',1);
plot([shockt shockt],yrangeH,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeH);
axis([minage maxage yrangeH]);
title('Hours and employment')
legend('Husband','Extensive wife','Intensive wife','Location','southeast')

subplot(2,2,3);
plot(linspace(25,25+TT-10,TT-10),L2_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','o','markersize',msize); hold on;
plot(linspace(25,25+TT-10,TT-10),L1_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','x','linestyle','-.','markersize',msize); hold on;
plot([nkids nkids],yrangeL,'color','r','LineWidth',1);
plot([shockt shockt],yrangeL,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeL);
axis([minage maxage yrangeL]);
title('Leisure')
legend('Wife','Husband','Location','southeast')

subplot(2,2,4);
plot(linspace(25,25+TT-10,TT-10),T2_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','o','markersize',msize); hold on;
plot(linspace(25,25+TT-10,TT-10),T1_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','x','linestyle','-.','markersize',msize); hold on;
plot([nkids nkids],yrangeT,'color','r','LineWidth',1);
plot([shockt shockt],yrangeT,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeT);
axis([minage maxage yrangeT]);
title('Time with children')
legend('Wife','Husband','Location','southeast')

h=gcf;
set(h,'PaperOrientation','landscape');
set(h,'PaperUnits','normalized');
set(h,'PaperPosition', [0 0 1 1]);
print(gcf, '-depsc', strcat(subdirname,'/u1'));
print(gcf, '-dpdf', strcat(subdirname,'/u1_pdf'));

%% For v2
clear out
load(strcat(subdirname,'/v2'));
wind=11;

C_elast  = -0.1*out(1,:)./out(wind,shock_t);
H1_elast = -0.1*out(2,:)./out(wind,shock_t);
E2_elast = -0.1*out(5,:)./out(wind,shock_t);
L1_elast = -0.1*out(6,:)./out(wind,shock_t);
L2_elast = -0.1*out(7,:)./out(wind,shock_t);
T1_elast = -0.1*out(8,:)./out(wind,shock_t);
T2_elast = -0.1*out(9,:)./out(wind,shock_t);
H2c_elast= -0.1*out(12,:)./out(wind,shock_t);

figure('visible','off');
subplot(2,2,1);
plot(linspace(25,25+TT-10,TT-10),C_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','o','markersize',msize); hold on;
plot([nkids nkids],yrangeC,'color','r','LineWidth',1);
plot([shockt shockt],yrangeC,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeC);
axis([minage maxage yrangeC]);
title('Consumption')

subplot(2,2,2);
plot(linspace(25,25+TT-10,TT-10),H1_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','x','linestyle','-.','markersize',msize); hold on;
plot(linspace(25,25+TT-10,TT-10),E2_elast(1:TT-10),'color','blue','LineWidth',lwidth,'marker','d','markersize',msize); 
plot(linspace(25,25+TT-10,TT-10),H2c_elast(1:TT-10),'color','red','LineWidth',lwidth,'marker','+','markersize',msize);
plot([nkids nkids],yrangeH,'color','r','LineWidth',1);
plot([shockt shockt],yrangeH,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeH);
axis([minage maxage yrangeH]);
title('Hours and employment')
legend('Husband','Extensive wife','Intensive wife','Location','southeast')

subplot(2,2,3);
plot(linspace(25,25+TT-10,TT-10),L2_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','o','markersize',msize); hold on;
plot(linspace(25,25+TT-10,TT-10),L1_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','x','linestyle','-.','markersize',msize); hold on;
plot([nkids nkids],yrangeL,'color','r','LineWidth',1);
plot([shockt shockt],yrangeL,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeL);
axis([minage maxage yrangeL]);
title('Leisure')
legend('Wife','Husband','Location','southeast')

subplot(2,2,4);
plot(linspace(25,25+TT-10,TT-10),T2_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','o','markersize',msize); hold on;
plot(linspace(25,25+TT-10,TT-10),T1_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','x','linestyle','-.','markersize',msize); hold on;
plot([nkids nkids],yrangeT,'color','r','LineWidth',1);
plot([shockt shockt],yrangeT,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeT);
axis([minage maxage yrangeT]);
title('Time with children')
legend('Wife','Husband','Location','southeast')

h=gcf;
set(h,'PaperOrientation','landscape');
set(h,'PaperUnits','normalized');
set(h,'PaperPosition', [0 0 1 1]);
print(gcf, '-depsc', strcat(subdirname,'/v2'));
print(gcf, '-dpdf', strcat(subdirname,'/v2_pdf'));

%% For u2
clear out
load(strcat(subdirname,'/u2'));
wind=11;

C_elast  = -0.1*out(1,:)./out(wind,shock_t);
H1_elast = -0.1*out(2,:)./out(wind,shock_t);
E2_elast = -0.1*out(5,:)./out(wind,shock_t);
L1_elast = -0.1*out(6,:)./out(wind,shock_t);
L2_elast = -0.1*out(7,:)./out(wind,shock_t);
T1_elast = -0.1*out(8,:)./out(wind,shock_t);
T2_elast = -0.1*out(9,:)./out(wind,shock_t);
H2c_elast= -0.1*out(12,:)./out(wind,shock_t);

figure('visible','off');
subplot(2,2,1);
plot(linspace(25,25+TT-10,TT-10),C_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','o','markersize',msize); hold on;
plot([nkids nkids],yrangeC,'color','r','LineWidth',1);
plot([shockt shockt],yrangeC,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeC);
axis([minage maxage yrangeC]);
title('Consumption')

subplot(2,2,2);
plot(linspace(25,25+TT-10,TT-10),H1_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','x','linestyle','-.','markersize',msize); hold on;
plot(linspace(25,25+TT-10,TT-10),E2_elast(1:TT-10),'color','blue','LineWidth',lwidth,'marker','d','markersize',msize); 
plot(linspace(25,25+TT-10,TT-10),H2c_elast(1:TT-10),'color','red','LineWidth',lwidth,'marker','+','markersize',msize);
plot([nkids nkids],yrangeH,'color','r','LineWidth',1);
plot([shockt shockt],yrangeH,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeH);
axis([minage maxage yrangeH]);
title('Hours and employment')
legend('Husband','Extensive wife','Intensive wife','Location','southeast')

subplot(2,2,3);
plot(linspace(25,25+TT-10,TT-10),L2_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','o','markersize',msize); hold on;
plot(linspace(25,25+TT-10,TT-10),L1_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','x','linestyle','-.','markersize',msize); hold on;
plot([nkids nkids],yrangeL,'color','r','LineWidth',1);
plot([shockt shockt],yrangeL,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeL);
axis([minage maxage yrangeL]);
title('Leisure')
legend('Wife','Husband','Location','southeast')

subplot(2,2,4);
plot(linspace(25,25+TT-10,TT-10),T2_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','o','markersize',msize); hold on;
plot(linspace(25,25+TT-10,TT-10),T1_elast(1:TT-10),'color','black','LineWidth',lwidth,'marker','x','linestyle','-.','markersize',msize); hold on;
plot([nkids nkids],yrangeT,'color','r','LineWidth',1);
plot([shockt shockt],yrangeT,'color','blue','LineWidth',1,'linestyle','--');
ylim(yrangeT);
axis([minage maxage yrangeT]);
title('Time with children')
legend('Wife','Husband','Location','southeast')

h=gcf;
set(h,'PaperOrientation','landscape');
set(h,'PaperUnits','normalized');
set(h,'PaperPosition', [0 0 1 1]);
print(gcf, '-depsc', strcat(subdirname,'/u2'));
print(gcf, '-dpdf', strcat(subdirname,'/u2_pdf'));

end