#include "global.h"

char subset_init(subset *s)
{
  s->indices = (int *)malloc(MEMORY_CHUNK*sizeof(int));
  if (!s->indices)
    return 0;
  s->size = 0;
  s->total_size = MEMORY_CHUNK;
  return 1;
}

char subset_add(subset *s, int index)
{
  int *tmp, i;
  
  if (s->size == s->total_size)
    {
      s->total_size *= 2;
      tmp = (int *)malloc(s->total_size*sizeof(int));
      if (!tmp)
	return 0;
      for (i=0; i<s->size; i++)
	tmp[i] = s->indices[i];
      
      free(s->indices);
      s->indices = tmp;
    }
  
  s->indices[s->size++] = index;  
  return 1;
}

void subset_zero(subset *s)
{
  s->size = 0;
}

void subset_free(subset *s)
{
  free(s->indices);
}

void subset_print(subset *s)
{
  int i;
  
  for (i=0; i<s->size; i++)
    printf("%d  ", s->indices[i]);
  printf("\n");
}

void subset_random(subset *s, int n)
{
  int count = 0, r;
  char *tmp;
  
  tmp = calloc(num_demand_points, 1);
  
  while (count < n)
    {
      r = random() % num_demand_points;
      if (!tmp[r])
	{
	  tmp[r] = 1;
	  subset_add(s, r);
	  count ++;
	}
    }
  
  free(tmp);
}
