#include "global.h"

/* returns 1 iff the circle is not obtuse */
char three_point_circle(int index1, int index2, int index3, circle *out)
{
  double x1 = point_array[index1].x;
  double x2 = point_array[index2].x;
  double x3 = point_array[index3].x;
  double y1 = point_array[index1].y;
  double y2 = point_array[index2].y;
  double y3 = point_array[index3].y;
  double ra = (x1-x2)*(x1-x2)+(y1-y2)*(y1-y2);
  double rb = (x1-x3)*(x1-x3)+(y1-y3)*(y1-y3);
  double rc = (x2-x3)*(x2-x3)+(y2-y3)*(y2-y3);
  double al1, al2, be1, be2, ga1, ga2, del;
  
  if ((ra >= rb+rc) || (rc >= ra+rb) || (rb >= ra+rc))
    return 0;
  
  al1 = x2 - x3;
  al2 = x1 - x3;
  be1 = y2 - y3;
  be2 = y1 - y3;
  ga1 = 0.5*(x2*x2-x3*x3+y2*y2-y3*y3);
  ga2 = 0.5*(x1*x1-x3*x3+y1*y1-y3*y3);
  del = al1*be2 - be1*al2;
  
  out->x = (ga1*be2-be1*ga2)/del;
  out->y = (al1*ga2-ga1*al2)/del;
  out->r = (out->x-x1)*(out->x-x1) + (out->y-y1)*(out->y-y1);
  return 1;
}

void two_point_circle(int index1, int index2, circle *out)
{
  out->x = (point_array[index1].x + point_array[index2].x)/2;
  out->y = (point_array[index1].y + point_array[index2].y)/2;
  out->r = (out->x-point_array[index1].x)*
    (out->x-point_array[index1].x) +
    (out->y-point_array[index1].y)*
    (out->y-point_array[index1].y);
}

char in_circle(circle *c, int index, double *dist)
{
  *dist = (point_array[index].x-c->x)*(point_array[index].x-c->x) +
    (point_array[index].y-c->y)*(point_array[index].y-c->y);
  return (*dist <= c->r * (1 + EPSILON));
}

void circle_copy(circle *c1, circle *c2)
{
  c1->x = c2->x;
  c1->y = c2->y;
  c1->r = c2->r;
}
